/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.autodetect;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.CachedFontInfo;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontCache;
import org.apache.fop.fonts.FontLoader;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontTriplet;

public class FontInfoFinder {
    private Log log = LogFactory.getLog(class$org$apache$fop$fonts$autodetect$FontInfoFinder == null ? (class$org$apache$fop$fonts$autodetect$FontInfoFinder = FontInfoFinder.class$("org.apache.fop.fonts.autodetect.FontInfoFinder")) : class$org$apache$fop$fonts$autodetect$FontInfoFinder);
    private static final String[] ITALIC_WORDS = new String[]{"italic", "oblique"};
    private static final String[] BOLD_WORDS = new String[]{"bold", "black", "heavy", "ultra", "super"};
    static /* synthetic */ Class class$org$apache$fop$fonts$autodetect$FontInfoFinder;

    private FontTriplet tripletFromFont(CustomFont customFont) {
        String name = customFont.getStrippedFontName();
        String subName = customFont.getFontSubName();
        String searchName = name.toLowerCase();
        if (subName != null) {
            searchName = searchName + subName.toLowerCase();
        }
        String style = "normal";
        if (customFont.getItalicAngle() > 0) {
            style = "italic";
        } else {
            int i2 = 0;
            while (i2 < ITALIC_WORDS.length) {
                if (searchName.indexOf(ITALIC_WORDS[i2]) != -1) {
                    style = "italic";
                    break;
                }
                ++i2;
            }
        }
        int weight = 400;
        int i3 = 0;
        while (i3 < BOLD_WORDS.length) {
            if (searchName.indexOf(BOLD_WORDS[i3]) != -1) {
                weight = 700;
                break;
            }
            ++i3;
        }
        return new FontTriplet(name, style, weight);
    }

    private EmbedFontInfo fontInfoFromCustomFont(File fontFile, CustomFont customFont, FontCache fontCache) {
        String embedUrl;
        FontTriplet fontTriplet = this.tripletFromFont(customFont);
        ArrayList<FontTriplet> fontTripletList = new ArrayList<FontTriplet>();
        fontTripletList.add(fontTriplet);
        try {
            embedUrl = fontFile.toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            embedUrl = fontFile.getAbsolutePath();
        }
        EmbedFontInfo fontInfo = new EmbedFontInfo(null, customFont.isKerningEnabled(), fontTripletList, embedUrl);
        if (fontCache != null) {
            fontCache.addFont(fontInfo);
        }
        return fontInfo;
    }

    public EmbedFontInfo find(File fontFile, FontResolver resolver, FontCache fontCache) {
        String embedUrl = null;
        try {
            embedUrl = fontFile.toURL().toExternalForm();
        }
        catch (MalformedURLException mfue) {
            this.log.error("Failed to convert '" + fontFile + "' to URL: " + mfue.getMessage());
        }
        long fileLastModified = -1L;
        if (fontCache != null) {
            fileLastModified = fontFile.lastModified();
            if (fontCache.containsFont(embedUrl)) {
                CachedFontInfo fontInfo = fontCache.getFont(embedUrl);
                if (fontInfo.lastModified() == fileLastModified) {
                    return fontInfo;
                }
                fontCache.removeFont(embedUrl);
            } else if (fontCache.isFailedFont(embedUrl, fileLastModified)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Skipping font file that failed to load previously: " + embedUrl);
                }
                return null;
            }
        }
        CustomFont customFont = null;
        try {
            customFont = FontLoader.loadFont(fontFile, resolver);
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Unable to load font file: " + embedUrl + ". Reason: " + e.getMessage());
            }
            if (fontCache != null) {
                fontCache.registerFailedFont(embedUrl, fileLastModified);
            }
            return null;
        }
        return this.fontInfoFromCustomFont(fontFile, customFont, fontCache);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

