/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.base14;

import java.util.Collections;
import java.util.Map;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.Typeface;

public class CourierOblique
extends Typeface {
    private static final String fontName = "Courier-Oblique";
    private static final String encoding = "WinAnsiEncoding";
    private static final int capHeight = 562;
    private static final int xHeight = 426;
    private static final int ascender = 629;
    private static final int descender = -157;
    private static final int firstChar = 32;
    private static final int lastChar = 255;
    private static final int[] width = new int[256];
    private final CodePointMapping mapping = CodePointMapping.getMapping("WinAnsiEncoding");
    private boolean enableKerning = false;

    public CourierOblique() {
        this(false);
    }

    public CourierOblique(boolean enableKerning) {
        this.enableKerning = enableKerning;
    }

    public String getEncoding() {
        return encoding;
    }

    public String getFontName() {
        return fontName;
    }

    public FontType getFontType() {
        return FontType.TYPE1;
    }

    public int getAscender(int size) {
        return size * 629;
    }

    public int getCapHeight(int size) {
        return size * 562;
    }

    public int getDescender(int size) {
        return size * -157;
    }

    public int getXHeight(int size) {
        return size * 426;
    }

    public int getFirstChar() {
        return 32;
    }

    public int getLastChar() {
        return 255;
    }

    public int getWidth(int i2, int size) {
        return size * width[i2];
    }

    public int[] getWidths() {
        int[] arr = new int[this.getLastChar() - this.getFirstChar() + 1];
        System.arraycopy(width, this.getFirstChar(), arr, 0, this.getLastChar() - this.getFirstChar() + 1);
        return arr;
    }

    public boolean hasKerningInfo() {
        return false;
    }

    public Map getKerningInfo() {
        return Collections.EMPTY_MAP;
    }

    public char mapChar(char c) {
        char d = this.mapping.mapChar(c);
        if (d != '\u0000') {
            return d;
        }
        return '#';
    }

    public boolean hasChar(char c) {
        return this.mapping.mapChar(c) > '\u0000';
    }

    static {
        CourierOblique.width[65] = 600;
        CourierOblique.width[198] = 600;
        CourierOblique.width[193] = 600;
        CourierOblique.width[194] = 600;
        CourierOblique.width[196] = 600;
        CourierOblique.width[192] = 600;
        CourierOblique.width[197] = 600;
        CourierOblique.width[195] = 600;
        CourierOblique.width[66] = 600;
        CourierOblique.width[67] = 600;
        CourierOblique.width[199] = 600;
        CourierOblique.width[68] = 600;
        CourierOblique.width[69] = 600;
        CourierOblique.width[201] = 600;
        CourierOblique.width[202] = 600;
        CourierOblique.width[203] = 600;
        CourierOblique.width[200] = 600;
        CourierOblique.width[208] = 600;
        CourierOblique.width[128] = 600;
        CourierOblique.width[70] = 600;
        CourierOblique.width[71] = 600;
        CourierOblique.width[72] = 600;
        CourierOblique.width[73] = 600;
        CourierOblique.width[205] = 600;
        CourierOblique.width[206] = 600;
        CourierOblique.width[207] = 600;
        CourierOblique.width[204] = 600;
        CourierOblique.width[74] = 600;
        CourierOblique.width[75] = 600;
        CourierOblique.width[76] = 600;
        CourierOblique.width[77] = 600;
        CourierOblique.width[78] = 600;
        CourierOblique.width[209] = 600;
        CourierOblique.width[79] = 600;
        CourierOblique.width[140] = 600;
        CourierOblique.width[211] = 600;
        CourierOblique.width[212] = 600;
        CourierOblique.width[214] = 600;
        CourierOblique.width[210] = 600;
        CourierOblique.width[216] = 600;
        CourierOblique.width[213] = 600;
        CourierOblique.width[80] = 600;
        CourierOblique.width[81] = 600;
        CourierOblique.width[82] = 600;
        CourierOblique.width[83] = 600;
        CourierOblique.width[138] = 600;
        CourierOblique.width[84] = 600;
        CourierOblique.width[222] = 600;
        CourierOblique.width[85] = 600;
        CourierOblique.width[218] = 600;
        CourierOblique.width[219] = 600;
        CourierOblique.width[220] = 600;
        CourierOblique.width[217] = 600;
        CourierOblique.width[86] = 600;
        CourierOblique.width[87] = 600;
        CourierOblique.width[88] = 600;
        CourierOblique.width[89] = 600;
        CourierOblique.width[221] = 600;
        CourierOblique.width[159] = 600;
        CourierOblique.width[90] = 600;
        CourierOblique.width[142] = 600;
        CourierOblique.width[97] = 600;
        CourierOblique.width[225] = 600;
        CourierOblique.width[226] = 600;
        CourierOblique.width[180] = 600;
        CourierOblique.width[228] = 600;
        CourierOblique.width[230] = 600;
        CourierOblique.width[224] = 600;
        CourierOblique.width[38] = 600;
        CourierOblique.width[229] = 600;
        CourierOblique.width[94] = 600;
        CourierOblique.width[126] = 600;
        CourierOblique.width[42] = 600;
        CourierOblique.width[64] = 600;
        CourierOblique.width[227] = 600;
        CourierOblique.width[98] = 600;
        CourierOblique.width[92] = 600;
        CourierOblique.width[124] = 600;
        CourierOblique.width[123] = 600;
        CourierOblique.width[125] = 600;
        CourierOblique.width[91] = 600;
        CourierOblique.width[93] = 600;
        CourierOblique.width[166] = 600;
        CourierOblique.width[149] = 600;
        CourierOblique.width[99] = 600;
        CourierOblique.width[231] = 600;
        CourierOblique.width[184] = 600;
        CourierOblique.width[162] = 600;
        CourierOblique.width[136] = 600;
        CourierOblique.width[58] = 600;
        CourierOblique.width[44] = 600;
        CourierOblique.width[169] = 600;
        CourierOblique.width[164] = 600;
        CourierOblique.width[100] = 600;
        CourierOblique.width[134] = 600;
        CourierOblique.width[135] = 600;
        CourierOblique.width[176] = 600;
        CourierOblique.width[168] = 600;
        CourierOblique.width[247] = 600;
        CourierOblique.width[36] = 600;
        CourierOblique.width[101] = 600;
        CourierOblique.width[233] = 600;
        CourierOblique.width[234] = 600;
        CourierOblique.width[235] = 600;
        CourierOblique.width[232] = 600;
        CourierOblique.width[56] = 600;
        CourierOblique.width[133] = 600;
        CourierOblique.width[151] = 600;
        CourierOblique.width[150] = 600;
        CourierOblique.width[61] = 600;
        CourierOblique.width[240] = 600;
        CourierOblique.width[33] = 600;
        CourierOblique.width[161] = 600;
        CourierOblique.width[102] = 600;
        CourierOblique.width[53] = 600;
        CourierOblique.width[131] = 600;
        CourierOblique.width[52] = 600;
        CourierOblique.width[103] = 600;
        CourierOblique.width[223] = 600;
        CourierOblique.width[96] = 600;
        CourierOblique.width[62] = 600;
        CourierOblique.width[171] = 600;
        CourierOblique.width[187] = 600;
        CourierOblique.width[139] = 600;
        CourierOblique.width[155] = 600;
        CourierOblique.width[104] = 600;
        CourierOblique.width[45] = 600;
        CourierOblique.width[105] = 600;
        CourierOblique.width[237] = 600;
        CourierOblique.width[238] = 600;
        CourierOblique.width[239] = 600;
        CourierOblique.width[236] = 600;
        CourierOblique.width[106] = 600;
        CourierOblique.width[107] = 600;
        CourierOblique.width[108] = 600;
        CourierOblique.width[60] = 600;
        CourierOblique.width[172] = 600;
        CourierOblique.width[109] = 600;
        CourierOblique.width[175] = 600;
        CourierOblique.width[181] = 600;
        CourierOblique.width[215] = 600;
        CourierOblique.width[110] = 600;
        CourierOblique.width[57] = 600;
        CourierOblique.width[241] = 600;
        CourierOblique.width[35] = 600;
        CourierOblique.width[111] = 600;
        CourierOblique.width[243] = 600;
        CourierOblique.width[244] = 600;
        CourierOblique.width[246] = 600;
        CourierOblique.width[156] = 600;
        CourierOblique.width[242] = 600;
        CourierOblique.width[49] = 600;
        CourierOblique.width[189] = 600;
        CourierOblique.width[188] = 600;
        CourierOblique.width[185] = 600;
        CourierOblique.width[170] = 600;
        CourierOblique.width[186] = 600;
        CourierOblique.width[248] = 600;
        CourierOblique.width[245] = 600;
        CourierOblique.width[112] = 600;
        CourierOblique.width[182] = 600;
        CourierOblique.width[40] = 600;
        CourierOblique.width[41] = 600;
        CourierOblique.width[37] = 600;
        CourierOblique.width[46] = 600;
        CourierOblique.width[183] = 600;
        CourierOblique.width[137] = 600;
        CourierOblique.width[43] = 600;
        CourierOblique.width[177] = 600;
        CourierOblique.width[113] = 600;
        CourierOblique.width[63] = 600;
        CourierOblique.width[191] = 600;
        CourierOblique.width[34] = 600;
        CourierOblique.width[132] = 600;
        CourierOblique.width[147] = 600;
        CourierOblique.width[148] = 600;
        CourierOblique.width[145] = 600;
        CourierOblique.width[146] = 600;
        CourierOblique.width[130] = 600;
        CourierOblique.width[39] = 600;
        CourierOblique.width[114] = 600;
        CourierOblique.width[174] = 600;
        CourierOblique.width[115] = 600;
        CourierOblique.width[154] = 600;
        CourierOblique.width[167] = 600;
        CourierOblique.width[59] = 600;
        CourierOblique.width[55] = 600;
        CourierOblique.width[54] = 600;
        CourierOblique.width[47] = 600;
        CourierOblique.width[32] = 600;
        CourierOblique.width[163] = 600;
        CourierOblique.width[116] = 600;
        CourierOblique.width[254] = 600;
        CourierOblique.width[51] = 600;
        CourierOblique.width[190] = 600;
        CourierOblique.width[179] = 600;
        CourierOblique.width[152] = 600;
        CourierOblique.width[153] = 600;
        CourierOblique.width[50] = 600;
        CourierOblique.width[178] = 600;
        CourierOblique.width[117] = 600;
        CourierOblique.width[250] = 600;
        CourierOblique.width[251] = 600;
        CourierOblique.width[252] = 600;
        CourierOblique.width[249] = 600;
        CourierOblique.width[95] = 600;
        CourierOblique.width[118] = 600;
        CourierOblique.width[119] = 600;
        CourierOblique.width[120] = 600;
        CourierOblique.width[121] = 600;
        CourierOblique.width[253] = 600;
        CourierOblique.width[255] = 600;
        CourierOblique.width[165] = 600;
        CourierOblique.width[122] = 600;
        CourierOblique.width[158] = 600;
        CourierOblique.width[48] = 600;
    }
}

