/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.fop.pdf.ASCII85Filter;
import org.apache.fop.pdf.ASCIIHexFilter;
import org.apache.fop.pdf.FlateFilter;
import org.apache.fop.pdf.NullFilter;
import org.apache.fop.pdf.PDFFilter;

public class PDFFilterList {
    public static final String DEFAULT_FILTER = "default";
    public static final String CONTENT_FILTER = "content";
    public static final String IMAGE_FILTER = "image";
    public static final String JPEG_FILTER = "jpeg";
    public static final String TIFF_FILTER = "tiff";
    public static final String FONT_FILTER = "font";
    public static final String METADATA_FILTER = "metadata";
    private List filters = new ArrayList();
    private boolean ignoreASCIIFilters = false;

    public PDFFilterList() {
    }

    public PDFFilterList(boolean ignoreASCIIFilters) {
        this.ignoreASCIIFilters = ignoreASCIIFilters;
    }

    public boolean isInitialized() {
        return this.filters.size() > 0;
    }

    public void addFilter(PDFFilter filter) {
        if (filter != null) {
            if (this.ignoreASCIIFilters && filter.isASCIIFilter()) {
                return;
            }
            this.filters.add(filter);
        }
    }

    public void addFilter(String filterType) {
        if (filterType == null) {
            return;
        }
        if (filterType.equals("flate")) {
            this.addFilter(new FlateFilter());
        } else if (filterType.equals("null")) {
            this.addFilter(new NullFilter());
        } else if (filterType.equals("ascii-85")) {
            if (this.ignoreASCIIFilters) {
                return;
            }
            this.addFilter(new ASCII85Filter());
        } else if (filterType.equals("ascii-hex")) {
            if (this.ignoreASCIIFilters) {
                return;
            }
            this.addFilter(new ASCIIHexFilter());
        } else {
            if (filterType.equals("")) {
                return;
            }
            throw new IllegalArgumentException("Unsupported filter type in stream-filter-list: " + filterType);
        }
    }

    public void ensureFilterInPlace(PDFFilter pdfFilter) {
        if (this.filters.size() == 0) {
            this.addFilter(pdfFilter);
        } else if (!this.filters.get(0).equals(pdfFilter)) {
            this.filters.add(0, pdfFilter);
        }
    }

    public void addDefaultFilters(Map filters, String type) {
        List filterset = null;
        if (filters != null && (filterset = (List)filters.get(type)) == null) {
            filterset = (List)filters.get(DEFAULT_FILTER);
        }
        if (filterset == null || filterset.size() == 0) {
            if (METADATA_FILTER.equals(type)) {
                this.addFilter(new NullFilter());
            } else if (JPEG_FILTER.equals(type)) {
                this.addFilter(new NullFilter());
            } else if (TIFF_FILTER.equals(type)) {
                this.addFilter(new NullFilter());
            } else {
                this.addFilter(new FlateFilter());
            }
        } else {
            int i2 = 0;
            while (i2 < filterset.size()) {
                String v = (String)filterset.get(i2);
                this.addFilter(v);
                ++i2;
            }
        }
    }

    protected String buildFilterDictEntries() {
        if (this.filters != null && this.filters.size() > 0) {
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<String> parms = new ArrayList<String>();
            int nonNullParams = 0;
            int count = 0;
            while (count < this.filters.size()) {
                PDFFilter filter = (PDFFilter)this.filters.get(count);
                if (filter.getName().length() > 0) {
                    names.add(0, filter.getName());
                    if (filter.getDecodeParms() != null) {
                        parms.add(0, filter.getDecodeParms());
                        ++nonNullParams;
                    } else {
                        parms.add(0, null);
                    }
                }
                ++count;
            }
            return this.buildFilterEntries(names) + (nonNullParams > 0 ? this.buildDecodeParms(parms) : "");
        }
        return "";
    }

    private String buildFilterEntries(List names) {
        int filterCount = 0;
        StringBuffer sb = new StringBuffer(64);
        int i2 = 0;
        while (i2 < names.size()) {
            String name = (String)names.get(i2);
            if (name.length() > 0) {
                ++filterCount;
                sb.append(name);
                sb.append(" ");
            }
            ++i2;
        }
        if (filterCount > 0) {
            if (filterCount > 1) {
                return "/Filter [ " + sb.toString() + "]";
            }
            return "/Filter " + sb.toString();
        }
        return "";
    }

    private String buildDecodeParms(List parms) {
        StringBuffer sb = new StringBuffer();
        boolean needParmsEntry = false;
        sb.append("\n/DecodeParms ");
        if (parms.size() > 1) {
            sb.append("[ ");
        }
        int count = 0;
        while (count < parms.size()) {
            String s = (String)parms.get(count);
            if (s != null) {
                sb.append(s);
                needParmsEntry = true;
            } else {
                sb.append("null");
            }
            sb.append(" ");
            ++count;
        }
        if (parms.size() > 1) {
            sb.append("]");
        }
        if (needParmsEntry) {
            return sb.toString();
        }
        return "";
    }

    public OutputStream applyFilters(OutputStream stream) throws IOException {
        OutputStream out = stream;
        if (this.filters != null) {
            int count = this.filters.size() - 1;
            while (count >= 0) {
                PDFFilter filter = (PDFFilter)this.filters.get(count);
                out = filter.applyFilter(out);
                --count;
            }
        }
        return out;
    }
}

