/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.fop.pdf.PDFObject;

public class PDFText
extends PDFObject {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private String text;

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    protected String toPDFString() {
        if (this.getText() == null) {
            throw new IllegalArgumentException("The text of this PDFText must not be empty");
        }
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getObjectID());
        sb.append("(");
        sb.append(PDFText.escapeText(this.getText()));
        sb.append(")");
        sb.append("\nendobj\n");
        return sb.toString();
    }

    public static final String escapeText(String text) {
        return PDFText.escapeText(text, false);
    }

    public static final String escapeText(String text, boolean forceHexMode) {
        if (text != null && text.length() > 0) {
            boolean unicode = false;
            boolean hexMode = false;
            if (forceHexMode) {
                hexMode = true;
            } else {
                int i2 = 0;
                int c = text.length();
                while (i2 < c) {
                    if (text.charAt(i2) >= '\u0080') {
                        unicode = true;
                        hexMode = true;
                        break;
                    }
                    ++i2;
                }
            }
            if (hexMode) {
                byte[] uniBytes;
                try {
                    uniBytes = text.getBytes("UTF-16");
                }
                catch (UnsupportedEncodingException uee) {
                    throw new CascadingRuntimeException("Incompatible VM", uee);
                }
                return PDFText.toHex(uniBytes);
            }
            StringBuffer result = new StringBuffer(text.length() * 2);
            result.append("(");
            int l = text.length();
            if (unicode) {
                result.append("\\376\\377");
                int i3 = 0;
                while (i3 < l) {
                    char ch = text.charAt(i3);
                    int high = (ch & 0xFF00) >>> 8;
                    int low = ch & 0xFF;
                    result.append("\\");
                    result.append(Integer.toOctalString(high));
                    result.append("\\");
                    result.append(Integer.toOctalString(low));
                    ++i3;
                }
            } else {
                int i4 = 0;
                while (i4 < l) {
                    char ch = text.charAt(i4);
                    if (ch >= '\u0100') {
                        throw new IllegalStateException("Can only treat text in 8-bit ASCII/PDFEncoding");
                    }
                    PDFText.escapeStringChar(ch, result);
                    ++i4;
                }
            }
            result.append(")");
            return result.toString();
        }
        return "()";
    }

    public static final String toHex(byte[] data) {
        StringBuffer sb = new StringBuffer(data.length * 2);
        sb.append("<");
        int i2 = 0;
        while (i2 < data.length) {
            sb.append(DIGITS[data[i2] >>> 4 & 0xF]);
            sb.append(DIGITS[data[i2] & 0xF]);
            ++i2;
        }
        sb.append(">");
        return sb.toString();
    }

    public static final byte[] toUTF16(String text) {
        try {
            return text.getBytes("UnicodeBig");
        }
        catch (UnsupportedEncodingException uee) {
            throw new CascadingRuntimeException("Incompatible VM", uee);
        }
    }

    public static final String toUnicodeHex(char c) {
        byte[] uniBytes;
        StringBuffer buf = new StringBuffer(4);
        try {
            char[] a = new char[]{c};
            uniBytes = new String(a).getBytes("UTF-16BE");
        }
        catch (UnsupportedEncodingException uee) {
            throw new CascadingRuntimeException("Incompatible VM", uee);
        }
        int i2 = 0;
        while (i2 < uniBytes.length) {
            buf.append(DIGITS[uniBytes[i2] >>> 4 & 0xF]);
            buf.append(DIGITS[uniBytes[i2] & 0xF]);
            ++i2;
        }
        return buf.toString();
    }

    public static final String escapeString(String s) {
        if (s == null || s.length() == 0) {
            return "()";
        }
        StringBuffer sb = new StringBuffer(64);
        sb.append("(");
        int i2 = 0;
        while (i2 < s.length()) {
            char c = s.charAt(i2);
            PDFText.escapeStringChar(c, sb);
            ++i2;
        }
        sb.append(")");
        return sb.toString();
    }

    public static final void escapeStringChar(char c, StringBuffer target) {
        if (c > '\u007f') {
            target.append("\\");
            target.append(Integer.toOctalString(c));
        } else {
            switch (c) {
                case '\n': {
                    target.append("\\n");
                    break;
                }
                case '\r': {
                    target.append("\\r");
                    break;
                }
                case '\t': {
                    target.append("\\t");
                    break;
                }
                case '\b': {
                    target.append("\\b");
                    break;
                }
                case '\f': {
                    target.append("\\f");
                    break;
                }
                case '\\': {
                    target.append("\\\\");
                    break;
                }
                case '(': {
                    target.append("\\(");
                    break;
                }
                case ')': {
                    target.append("\\)");
                    break;
                }
                default: {
                    target.append(c);
                }
            }
        }
    }

    public static final byte[] escapeByteArray(byte[] data) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(data.length);
        bout.write(40);
        int i2 = 0;
        while (i2 < data.length) {
            byte b = data[i2];
            switch (b) {
                case 10: {
                    bout.write(92);
                    bout.write(110);
                    break;
                }
                case 13: {
                    bout.write(92);
                    bout.write(114);
                    break;
                }
                case 9: {
                    bout.write(92);
                    bout.write(116);
                    break;
                }
                case 8: {
                    bout.write(92);
                    bout.write(98);
                    break;
                }
                case 12: {
                    bout.write(92);
                    bout.write(102);
                    break;
                }
                case 92: {
                    bout.write(92);
                    bout.write(92);
                    break;
                }
                case 40: {
                    bout.write(92);
                    bout.write(40);
                    break;
                }
                case 41: {
                    bout.write(92);
                    bout.write(41);
                    break;
                }
                default: {
                    bout.write(b);
                }
            }
            ++i2;
        }
        bout.write(41);
        return bout.toByteArray();
    }
}

