/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.fonts.CIDFont;
import org.apache.fop.pdf.PDFCIDSystemInfo;
import org.apache.fop.pdf.PDFCMap;

public class PDFToUnicodeCMap
extends PDFCMap {
    protected CIDFont cidFont;

    public PDFToUnicodeCMap(CIDFont cidMetrics, String name, PDFCIDSystemInfo sysInfo) {
        super(name, sysInfo);
        this.cidFont = cidMetrics;
    }

    public void fillInPDF(StringBuffer p) {
        this.writeCIDInit(p);
        this.writeCIDSystemInfo(p);
        this.writeVersionTypeName(p);
        this.writeCodeSpaceRange(p);
        this.writeBFEntries(p);
        this.writeWrapUp(p);
        this.add(p.toString());
    }

    protected void writeCIDSystemInfo(StringBuffer p) {
        p.append("/CIDSystemInfo\n");
        p.append("<< /Registry (Adobe)\n");
        p.append("/Ordering (UCS)\n");
        p.append("/Supplement 0\n");
        p.append(">> def\n");
    }

    protected void writeVersionTypeName(StringBuffer p) {
        p.append("/CMapName /Adobe-Identity-UCS def\n");
        p.append("/CMapType 2 def\n");
    }

    protected void writeBFEntries(StringBuffer p) {
        if (this.cidFont == null) {
            return;
        }
        char[] charArray = this.cidFont.getCharsUsed();
        if (charArray != null) {
            this.writeBFCharEntries(p, charArray);
            this.writeBFRangeEntries(p, charArray);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void writeBFCharEntries(StringBuffer p, char[] charArray) {
        totalEntries = 0;
        i = 0;
        while (i < charArray.length) {
            if (!this.partOfRange(charArray, i)) {
                ++totalEntries;
            }
            ++i;
        }
        if (totalEntries < 1) {
            return;
        }
        remainingEntries = totalEntries;
        charIndex = 0;
        do {
            entriesThisSection = Math.min(remainingEntries, 100);
            p.append(entriesThisSection + " beginbfchar\n");
            i = 0;
            ** GOTO lbl27
            {
                ++charIndex;
                do {
                    if (this.partOfRange(charArray, charIndex)) continue block2;
                    p.append("<" + PDFToUnicodeCMap.padHexString(Integer.toHexString(charIndex), 4) + "> ");
                    p.append("<" + PDFToUnicodeCMap.padHexString(Integer.toHexString(charArray[charIndex]), 4) + ">\n");
                    ++charIndex;
                    ++i;
lbl27:
                    // 2 sources

                } while (i < entriesThisSection);
            }
            p.append("endbfchar\n");
        } while ((remainingEntries -= entriesThisSection) > 0);
    }

    /*
     * Unable to fully structure code
     */
    protected void writeBFRangeEntries(StringBuffer p, char[] charArray) {
        totalEntries = 0;
        i = 0;
        while (i < charArray.length) {
            if (this.startOfRange(charArray, i)) {
                ++totalEntries;
            }
            ++i;
        }
        if (totalEntries < 1) {
            return;
        }
        remainingEntries = totalEntries;
        charIndex = 0;
        do {
            entriesThisSection = Math.min(remainingEntries, 100);
            p.append(entriesThisSection + " beginbfrange\n");
            i = 0;
            ** GOTO lbl29
            {
                ++charIndex;
                do {
                    if (!this.startOfRange(charArray, charIndex)) continue block2;
                    p.append("<" + PDFToUnicodeCMap.padHexString(Integer.toHexString(charIndex), 4) + "> ");
                    p.append("<" + PDFToUnicodeCMap.padHexString(Integer.toHexString(this.endOfRange(charArray, charIndex)), 4) + "> ");
                    p.append("<" + PDFToUnicodeCMap.padHexString(Integer.toHexString(charArray[charIndex]), 4) + ">\n");
                    ++charIndex;
                    ++i;
lbl29:
                    // 2 sources

                } while (i < entriesThisSection);
            }
            p.append("endbfrange\n");
        } while ((remainingEntries -= entriesThisSection) > 0);
    }

    private int endOfRange(char[] charArray, int startOfRange) {
        int i2 = startOfRange;
        while (i2 < charArray.length - 1 && this.sameRangeEntryAsNext(charArray, i2)) {
            ++i2;
        }
        return i2;
    }

    private boolean partOfRange(char[] charArray, int arrayIndex) {
        if (charArray.length < 2) {
            return false;
        }
        if (arrayIndex == 0) {
            return this.sameRangeEntryAsNext(charArray, 0);
        }
        if (arrayIndex == charArray.length - 1) {
            return this.sameRangeEntryAsNext(charArray, arrayIndex - 1);
        }
        if (this.sameRangeEntryAsNext(charArray, arrayIndex - 1)) {
            return true;
        }
        return this.sameRangeEntryAsNext(charArray, arrayIndex);
    }

    private boolean sameRangeEntryAsNext(char[] charArray, int firstItem) {
        if (charArray[firstItem] + '\u0001' != charArray[firstItem + 1]) {
            return false;
        }
        return firstItem / 256 == (firstItem + 1) / 256;
    }

    private boolean startOfRange(char[] charArray, int arrayIndex) {
        if (!this.partOfRange(charArray, arrayIndex)) {
            return false;
        }
        if (arrayIndex == 0) {
            return true;
        }
        if (arrayIndex == charArray.length - 1) {
            return false;
        }
        return !this.sameRangeEntryAsNext(charArray, arrayIndex - 1);
    }

    public static String padHexString(String input, int numChars) {
        int length = input.length();
        if (length >= numChars) {
            return input;
        }
        StringBuffer returnString = new StringBuffer();
        int i2 = 1;
        while (i2 <= numChars - length) {
            returnString.append("0");
            ++i2;
        }
        returnString.append(input);
        return returnString.toString();
    }
}

