/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.RadialGradientPaint;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.PatternPaint;
import org.apache.fop.fonts.CIDFont;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.image.JpegImage;
import org.apache.fop.pdf.BitmapImage;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFConformanceException;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFGState;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFState;
import org.apache.fop.pdf.PDFText;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.render.pdf.FopPDFImage;
import org.apache.fop.svg.PDFGraphicsConfiguration;
import org.apache.fop.util.ColorExt;
import org.apache.xmlgraphics.java2d.AbstractGraphics2D;
import org.apache.xmlgraphics.java2d.GraphicContext;

public class PDFGraphics2D
extends AbstractGraphics2D {
    private static final AffineTransform IDENTITY_TRANSFORM = new AffineTransform();
    private static final int DEC = 8;
    protected PDFDocument pdfDoc;
    protected PDFResourceContext resourceContext;
    protected String pageRef;
    protected PDFState graphicsState;
    protected int baseLevel = 0;
    protected int[] jpegCount = new int[]{0};
    protected FontInfo fontInfo;
    protected Font ovFontState = null;
    protected StringWriter currentStream = new StringWriter();
    protected String currentFontName;
    protected float currentFontSize;
    protected OutputStream outputStream = null;
    private Graphics2D fmg;

    public PDFGraphics2D(boolean textAsShapes, FontInfo fi, PDFDocument doc, PDFResourceContext page, String pref, String font, float size) {
        this(textAsShapes);
        this.pdfDoc = doc;
        this.resourceContext = page;
        this.currentFontName = font;
        this.currentFontSize = size;
        this.fontInfo = fi;
        this.pageRef = pref;
        this.graphicsState = new PDFState();
    }

    protected PDFGraphics2D(boolean textAsShapes) {
        super(textAsShapes);
        BufferedImage bi = new BufferedImage(1, 1, 2);
        this.fmg = bi.createGraphics();
    }

    public PDFGraphics2D(PDFGraphics2D g) {
        super(g);
        BufferedImage bi = new BufferedImage(1, 1, 2);
        this.fmg = bi.createGraphics();
        this.pdfDoc = g.pdfDoc;
        this.resourceContext = g.resourceContext;
        this.currentFontName = g.currentFontName;
        this.currentFontSize = g.currentFontSize;
        this.fontInfo = g.fontInfo;
        this.pageRef = g.pageRef;
        this.graphicsState = g.graphicsState;
        this.currentStream = g.currentStream;
        this.jpegCount = g.jpegCount;
        this.outputStream = g.outputStream;
        this.ovFontState = g.ovFontState;
    }

    public Graphics create() {
        return new PDFGraphics2D(this);
    }

    protected void handleIOException(IOException ioe) {
        ioe.printStackTrace();
    }

    protected void preparePainting() {
    }

    public void setPDFState(PDFState state) {
        this.graphicsState = state;
        this.baseLevel = this.graphicsState.getStackLevel();
    }

    public void setOutputStream(OutputStream os) {
        this.outputStream = os;
    }

    public String getString() {
        return this.currentStream.toString();
    }

    public StringBuffer getBuffer() {
        return this.currentStream.getBuffer();
    }

    public void setGraphicContext(GraphicContext c) {
        this.gc = c;
        this.setPrivateHints();
    }

    private void setPrivateHints() {
        this.setRenderingHint(RenderingHintsKeyExt.KEY_AVOID_TILE_PAINTING, RenderingHintsKeyExt.VALUE_AVOID_TILE_PAINTING_ON);
    }

    public void setOverrideFontState(Font infont) {
        this.ovFontState = infont;
    }

    private void concatMatrix(double[] matrix) {
        this.currentStream.write(PDFNumber.doubleOut(matrix[0], 8) + " " + PDFNumber.doubleOut(matrix[1], 8) + " " + PDFNumber.doubleOut(matrix[2], 8) + " " + PDFNumber.doubleOut(matrix[3], 8) + " " + PDFNumber.doubleOut(matrix[4], 8) + " " + PDFNumber.doubleOut(matrix[5], 8) + " cm\n");
    }

    protected AffineTransform getBaseTransform() {
        AffineTransform at = new AffineTransform(this.graphicsState.getTransform());
        return at;
    }

    public void addLink(Rectangle2D bounds, AffineTransform trans, String dest, int linkType) {
        if (!this.pdfDoc.getProfile().isAnnotationAllowed()) {
            return;
        }
        this.preparePainting();
        AffineTransform at = this.getTransform();
        Shape b = at.createTransformedShape(bounds);
        b = trans.createTransformedShape(b);
        if (b != null) {
            Rectangle rect = b.getBounds();
            if (linkType != 0) {
                String pdfdest = "/FitR " + dest;
                this.resourceContext.addAnnotation(this.pdfDoc.getFactory().makeLink(rect, this.pageRef, pdfdest));
            } else {
                this.resourceContext.addAnnotation(this.pdfDoc.getFactory().makeLink(rect, dest, linkType, 0.0f));
            }
        }
    }

    public void addJpegImage(JpegImage jpeg, float x, float y, float width, float height) {
        this.preparePainting();
        String key = "__AddJPEG_" + this.hashCode() + "_" + this.jpegCount[0];
        this.jpegCount[0] = this.jpegCount[0] + 1;
        FopPDFImage fopimage = new FopPDFImage(jpeg, key);
        int xObjectNum = this.pdfDoc.addImage(this.resourceContext, fopimage).getXNumber();
        AffineTransform at = this.getTransform();
        double[] matrix = new double[6];
        at.getMatrix(matrix);
        this.currentStream.write("q\n");
        if (!at.isIdentity()) {
            this.concatMatrix(matrix);
        }
        Shape imclip = this.getClip();
        this.writeClip(imclip);
        this.currentStream.write("" + width + " 0 0 " + -height + " " + x + " " + (y + height) + " cm\n" + "/Im" + xObjectNum + " Do\nQ\n");
        if (this.outputStream != null) {
            try {
                this.pdfDoc.output(this.outputStream);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        this.preparePainting();
        int width = img.getWidth(observer);
        int height = img.getHeight(observer);
        if (width == -1 || height == -1) {
            return false;
        }
        return this.drawImage(img, x, y, width, height, observer);
    }

    private BufferedImage buildBufferedImage(Dimension size) {
        return new BufferedImage(size.width, size.height, 2);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        this.preparePainting();
        PDFXObject imageInfo = this.pdfDoc.getImage("TempImage:" + img.toString());
        if (imageInfo == null) {
            BitmapImage fopimg;
            Dimension size = new Dimension(width, height);
            BufferedImage buf = this.buildBufferedImage(size);
            Graphics2D g = buf.createGraphics();
            g.setComposite(AlphaComposite.SrcOver);
            g.setBackground(new Color(1, 1, 1, 0));
            g.setPaint(new Color(1, 1, 1, 0));
            g.fillRect(0, 0, width, height);
            g.clip(new Rectangle(0, 0, buf.getWidth(), buf.getHeight()));
            g.setComposite(this.gc.getComposite());
            if (!g.drawImage(img, 0, 0, buf.getWidth(), buf.getHeight(), observer)) {
                return false;
            }
            g.dispose();
            byte[] result = new byte[buf.getWidth() * buf.getHeight() * 3];
            byte[] mask = new byte[buf.getWidth() * buf.getHeight()];
            boolean hasMask = false;
            Raster raster = buf.getData();
            DataBuffer bd = raster.getDataBuffer();
            int count = 0;
            int maskpos = 0;
            switch (bd.getDataType()) {
                case 3: {
                    int[][] idata = ((DataBufferInt)bd).getBankData();
                    int i2 = 0;
                    while (i2 < idata.length) {
                        int[] iarray = idata[i2];
                        int j = 0;
                        while (j < iarray.length) {
                            int val = iarray[j];
                            int alpha = val >>> 24;
                            mask[maskpos++] = (byte)(alpha & 0xFF);
                            if (alpha != 255) {
                                hasMask = true;
                            }
                            result[count++] = (byte)(val >> 16 & 0xFF);
                            result[count++] = (byte)(val >> 8 & 0xFF);
                            result[count++] = (byte)(val & 0xFF);
                            ++j;
                        }
                        ++i2;
                    }
                    break;
                }
            }
            String ref = null;
            if (hasMask) {
                fopimg = new BitmapImage("TempImageMask:" + img.toString(), buf.getWidth(), buf.getHeight(), mask, null);
                fopimg.setColorSpace(new PDFDeviceColorSpace(1));
                PDFXObject xobj = this.pdfDoc.addImage(this.resourceContext, fopimg);
                ref = xobj.referencePDF();
                if (this.outputStream != null) {
                    try {
                        this.pdfDoc.output(this.outputStream);
                    }
                    catch (IOException ioe) {}
                }
            } else {
                mask = null;
            }
            fopimg = new BitmapImage("TempImage:" + img.toString(), buf.getWidth(), buf.getHeight(), result, ref);
            imageInfo = this.pdfDoc.addImage(this.resourceContext, fopimg);
            if (this.outputStream != null) {
                try {
                    this.pdfDoc.output(this.outputStream);
                }
                catch (IOException ioe) {}
            }
        } else {
            this.resourceContext.getPDFResources().addXObject(imageInfo);
        }
        AffineTransform at = this.getTransform();
        double[] matrix = new double[6];
        at.getMatrix(matrix);
        this.currentStream.write("q\n");
        if (!at.isIdentity()) {
            this.concatMatrix(matrix);
        }
        Shape imclip = this.getClip();
        this.writeClip(imclip);
        this.currentStream.write("" + width + " 0 0 " + -height + " " + x + " " + (y + height) + " cm\n" + "/Im" + imageInfo.getXNumber() + " Do\nQ\n");
        return true;
    }

    public void dispose() {
        this.pdfDoc = null;
        this.fontInfo = null;
        this.currentStream = null;
        this.currentFontName = null;
    }

    public void draw(Shape s) {
        Paint paint;
        boolean newTransform;
        this.preparePainting();
        Color c = this.getColor();
        if (c.getAlpha() == 0) {
            return;
        }
        AffineTransform trans = this.getTransform();
        double[] tranvals = new double[6];
        trans.getMatrix(tranvals);
        Shape imclip = this.getClip();
        boolean newClip = this.graphicsState.checkClip(imclip);
        boolean bl = newTransform = this.graphicsState.checkTransform(trans) && !trans.isIdentity();
        if (newClip || newTransform) {
            this.currentStream.write("q\n");
            this.graphicsState.push();
            if (newTransform) {
                this.concatMatrix(tranvals);
            }
            if (newClip) {
                this.writeClip(imclip);
            }
        }
        if (c.getAlpha() != 255) {
            this.checkTransparencyAllowed();
            HashMap<String, Float> vals = new HashMap<String, Float>();
            vals.put("CA", new Float((float)c.getAlpha() / 255.0f));
            PDFGState gstate = this.pdfDoc.getFactory().makeGState(vals, this.graphicsState.getGState());
            this.resourceContext.addGState(gstate);
            this.currentStream.write("/" + gstate.getName() + " gs\n");
        }
        if (this.graphicsState.setColor(c = this.getColor())) {
            this.applyColor(c, false);
        }
        if (this.graphicsState.setBackColor(c = this.getBackground())) {
            this.applyColor(c, true);
        }
        if (this.graphicsState.setPaint(paint = this.getPaint()) && !this.applyPaint(paint, false)) {
            Shape ss = this.getStroke().createStrokedShape(s);
            this.applyUnknownPaint(paint, ss);
            if (newClip || newTransform) {
                this.currentStream.write("Q\n");
                this.graphicsState.pop();
            }
            return;
        }
        this.applyStroke(this.getStroke());
        PathIterator iter = s.getPathIterator(IDENTITY_TRANSFORM);
        this.processPathIterator(iter);
        this.doDrawing(false, true, false);
        if (newClip || newTransform) {
            this.currentStream.write("Q\n");
            this.graphicsState.pop();
        }
    }

    protected void writeClip(Shape s) {
        if (s == null) {
            return;
        }
        this.preparePainting();
        PathIterator iter = s.getPathIterator(IDENTITY_TRANSFORM);
        this.processPathIterator(iter);
        this.currentStream.write("W\n");
        this.currentStream.write("n\n");
    }

    protected void applyColor(Color col, boolean fill) {
        this.preparePainting();
        Color c = col;
        if (col instanceof ColorExt) {
            PDFColor currentColour = new PDFColor(this.pdfDoc, col);
            this.currentStream.write(currentColour.getColorSpaceOut(fill));
        } else if (c.getColorSpace().getType() == 5) {
            PDFColor currentColour = new PDFColor(c.getRed(), c.getGreen(), c.getBlue());
            this.currentStream.write(currentColour.getColorSpaceOut(fill));
        } else if (c.getColorSpace().getType() == 9) {
            if (this.pdfDoc.getProfile().getPDFAMode().isPDFA1LevelB()) {
                throw new PDFConformanceException("PDF/A-1 does not allow mixing DeviceRGB and DeviceCMYK.");
            }
            float[] cComps = c.getColorComponents(new float[3]);
            double[] cmyk = new double[3];
            int i2 = 0;
            while (i2 < 3) {
                cmyk[i2] = cComps[i2];
                ++i2;
            }
            PDFColor currentColour = new PDFColor(cmyk[0], cmyk[1], cmyk[2], cmyk[3]);
            this.currentStream.write(currentColour.getColorSpaceOut(fill));
        } else if (c.getColorSpace().getType() == 12) {
            float[] cComps = c.getColorComponents(new float[1]);
            double[] blackMagenta = new double[1];
            int i3 = 0;
            while (i3 < 1) {
                blackMagenta[i3] = cComps[i3];
                ++i3;
            }
        } else {
            throw new UnsupportedOperationException("Color Space not supported by PDFGraphics2D");
        }
    }

    protected boolean applyPaint(Paint paint, boolean fill) {
        this.preparePainting();
        if (paint instanceof Color) {
            return true;
        }
        if (paint instanceof GradientPaint) {
            GradientPaint gpaint = (GradientPaint)paint;
            paint = new LinearGradientPaint((float)gpaint.getPoint1().getX(), (float)gpaint.getPoint1().getY(), (float)gpaint.getPoint2().getX(), (float)gpaint.getPoint2().getY(), new float[]{0.0f, 1.0f}, new Color[]{gpaint.getColor1(), gpaint.getColor2()}, gpaint.isCyclic() ? LinearGradientPaint.REPEAT : LinearGradientPaint.NO_CYCLE);
        }
        if (paint instanceof LinearGradientPaint) {
            LinearGradientPaint gp = (LinearGradientPaint)paint;
            MultipleGradientPaint.CycleMethodEnum cycle = gp.getCycleMethod();
            if (cycle != MultipleGradientPaint.NO_CYCLE) {
                return false;
            }
            Color[] cols = gp.getColors();
            float[] fractions = gp.getFractions();
            AffineTransform transform = new AffineTransform(this.getBaseTransform());
            transform.concatenate(this.getTransform());
            transform.concatenate(gp.getTransform());
            ArrayList<Double> theMatrix = new ArrayList<Double>();
            double[] mat = new double[6];
            transform.getMatrix(mat);
            int idx = 0;
            while (idx < mat.length) {
                theMatrix.add(new Double(mat[idx]));
                ++idx;
            }
            Point2D p1 = gp.getStartPoint();
            Point2D p2 = gp.getEndPoint();
            ArrayList<Double> theCoords = new ArrayList<Double>();
            theCoords.add(new Double(p1.getX()));
            theCoords.add(new Double(p1.getY()));
            theCoords.add(new Double(p2.getX()));
            theCoords.add(new Double(p2.getY()));
            ArrayList<Boolean> theExtend = new ArrayList<Boolean>();
            theExtend.add(new Boolean(true));
            theExtend.add(new Boolean(true));
            ArrayList<Double> theDomain = new ArrayList<Double>();
            theDomain.add(new Double(0.0));
            theDomain.add(new Double(1.0));
            ArrayList<Double> theEncode = new ArrayList<Double>();
            theEncode.add(new Double(0.0));
            theEncode.add(new Double(1.0));
            theEncode.add(new Double(0.0));
            theEncode.add(new Double(1.0));
            ArrayList<Double> theBounds = new ArrayList<Double>();
            ArrayList<PDFColor> someColors = new ArrayList<PDFColor>();
            int count = 0;
            while (count < cols.length) {
                Color c1 = cols[count];
                if (c1.getAlpha() != 255) {
                    return false;
                }
                PDFColor color1 = new PDFColor(c1.getRed(), c1.getGreen(), c1.getBlue());
                someColors.add(color1);
                if (count > 0 && count < cols.length - 1) {
                    theBounds.add(new Double(fractions[count]));
                }
                ++count;
            }
            PDFDeviceColorSpace aColorSpace = new PDFDeviceColorSpace(2);
            PDFPattern myPat = this.pdfDoc.getFactory().makeGradient(this.resourceContext, false, aColorSpace, someColors, theBounds, theCoords, theMatrix);
            this.currentStream.write(myPat.getColorSpaceOut(fill));
            return true;
        }
        if (paint instanceof RadialGradientPaint) {
            double dy;
            RadialGradientPaint rgp = (RadialGradientPaint)paint;
            MultipleGradientPaint.CycleMethodEnum cycle = rgp.getCycleMethod();
            if (cycle != MultipleGradientPaint.NO_CYCLE) {
                return false;
            }
            AffineTransform transform = new AffineTransform(this.getBaseTransform());
            transform.concatenate(this.getTransform());
            transform.concatenate(rgp.getTransform());
            ArrayList<Double> theMatrix = new ArrayList<Double>();
            double[] mat = new double[6];
            transform.getMatrix(mat);
            int idx = 0;
            while (idx < mat.length) {
                theMatrix.add(new Double(mat[idx]));
                ++idx;
            }
            double ar = rgp.getRadius();
            Point2D ac = rgp.getCenterPoint();
            Point2D af = rgp.getFocusPoint();
            ArrayList<Double> theCoords = new ArrayList<Double>();
            double dx = af.getX() - ac.getX();
            double d = Math.sqrt(dx * dx + (dy = af.getY() - ac.getY()) * dy);
            if (d > ar) {
                double scale = ar * 0.9999 / d;
                dx *= scale;
                dy *= scale;
            }
            theCoords.add(new Double(ac.getX() + dx));
            theCoords.add(new Double(ac.getY() + dy));
            theCoords.add(new Double(0.0));
            theCoords.add(new Double(ac.getX()));
            theCoords.add(new Double(ac.getY()));
            theCoords.add(new Double(ar));
            Color[] cols = rgp.getColors();
            ArrayList<PDFColor> someColors = new ArrayList<PDFColor>();
            int count = 0;
            while (count < cols.length) {
                Color cc = cols[count];
                if (cc.getAlpha() != 255) {
                    return false;
                }
                someColors.add(new PDFColor(cc.getRed(), cc.getGreen(), cc.getBlue()));
                ++count;
            }
            float[] fractions = rgp.getFractions();
            ArrayList<Double> theBounds = new ArrayList<Double>();
            int count2 = 1;
            while (count2 < fractions.length - 1) {
                float offset = fractions[count2];
                theBounds.add(new Double(offset));
                ++count2;
            }
            PDFDeviceColorSpace colSpace = new PDFDeviceColorSpace(2);
            PDFPattern myPat = this.pdfDoc.getFactory().makeGradient(this.resourceContext, true, colSpace, someColors, theBounds, theCoords, theMatrix);
            this.currentStream.write(myPat.getColorSpaceOut(fill));
            return true;
        }
        if (paint instanceof PatternPaint) {
            PatternPaint pp = (PatternPaint)paint;
            return this.createPattern(pp, fill);
        }
        return false;
    }

    private boolean createPattern(PatternPaint pp, boolean fill) {
        this.preparePainting();
        FontInfo fontInfo = new FontInfo();
        FontSetup.setup(fontInfo, null, null);
        PDFResources res = this.pdfDoc.getFactory().makeResources();
        PDFResourceContext context = new PDFResourceContext(res);
        PDFGraphics2D pattGraphic = new PDFGraphics2D(this.textAsShapes, fontInfo, this.pdfDoc, context, this.pageRef, "", 0.0f);
        pattGraphic.setGraphicContext(new GraphicContext());
        pattGraphic.gc.validateTransformStack();
        pattGraphic.setRenderingHints((Map)this.getRenderingHints());
        pattGraphic.setOutputStream(this.outputStream);
        GraphicsNode gn = pp.getGraphicsNode();
        Rectangle2D gnBBox = gn.getBounds();
        Rectangle2D rect = pp.getPatternRect();
        gn.paint(pattGraphic);
        ArrayList<Double> bbox = new ArrayList<Double>();
        bbox.add(new Double(rect.getX()));
        bbox.add(new Double(rect.getHeight() + rect.getY()));
        bbox.add(new Double(rect.getWidth() + rect.getX()));
        bbox.add(new Double(rect.getY()));
        AffineTransform transform = new AffineTransform(this.getBaseTransform());
        transform.concatenate(this.getTransform());
        transform.concatenate(pp.getPatternTransform());
        ArrayList<Double> theMatrix = new ArrayList<Double>();
        double[] mat = new double[6];
        transform.getMatrix(mat);
        int idx = 0;
        while (idx < mat.length) {
            theMatrix.add(new Double(mat[idx]));
            ++idx;
        }
        res.addFonts(this.pdfDoc, fontInfo);
        PDFPattern myPat = this.pdfDoc.getFactory().makePattern(this.resourceContext, 1, res, 1, 1, bbox, rect.getWidth(), rect.getHeight(), theMatrix, null, pattGraphic.getBuffer());
        this.currentStream.write(myPat.getColorSpaceOut(fill));
        PDFAnnotList annots = context.getAnnotations();
        if (annots != null) {
            this.pdfDoc.addObject(annots);
        }
        if (this.outputStream != null) {
            try {
                this.pdfDoc.output(this.outputStream);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return true;
    }

    protected boolean applyUnknownPaint(Paint paint, Shape shape) {
        this.preparePainting();
        Shape clip = this.getClip();
        Rectangle2D usrBounds = shape.getBounds2D();
        Rectangle2D usrClipBounds = clip.getBounds2D();
        if (!usrClipBounds.intersects(usrBounds)) {
            return true;
        }
        Rectangle2D.intersect(usrBounds, usrClipBounds, usrBounds);
        double usrX = usrBounds.getX();
        double usrY = usrBounds.getY();
        double usrW = usrBounds.getWidth();
        double usrH = usrBounds.getHeight();
        AffineTransform at = this.getTransform();
        Rectangle devShapeBounds = at.createTransformedShape(shape).getBounds();
        Rectangle devClipBounds = at.createTransformedShape(clip).getBounds();
        if (!devClipBounds.intersects(devShapeBounds)) {
            return true;
        }
        Rectangle devBounds = devShapeBounds.intersection(devClipBounds);
        int devX = devBounds.x;
        int devY = devBounds.y;
        int devW = devBounds.width;
        int devH = devBounds.height;
        ColorSpace rgbCS = ColorSpace.getInstance(1000);
        DirectColorModel rgbCM = new DirectColorModel(rgbCS, 32, 0xFF0000, 65280, 255, -16777216, false, 0);
        PaintContext pctx = paint.createContext(rgbCM, devBounds, usrBounds, at, this.getRenderingHints());
        PDFXObject imageInfo = this.pdfDoc.getImage("TempImage:" + pctx.toString());
        if (imageInfo != null) {
            this.resourceContext.getPDFResources().addXObject(imageInfo);
        } else {
            BitmapImage fopimg;
            byte[] mask;
            Raster r = pctx.getRaster(devX, devY, devW, devH);
            WritableRaster wr = (WritableRaster)r;
            wr = wr.createWritableTranslatedChild(0, 0);
            ColorModel pcm = pctx.getColorModel();
            BufferedImage bi = new BufferedImage(pcm, wr, pcm.isAlphaPremultiplied(), null);
            byte[] rgb = new byte[devW * devH * 3];
            int[] line = new int[devW];
            int rgbIdx = 0;
            if (pcm.hasAlpha()) {
                mask = new byte[devW * devH];
                int maskIdx = 0;
                int y = 0;
                while (y < devH) {
                    bi.getRGB(0, y, devW, 1, line, 0, devW);
                    int x = 0;
                    while (x < devW) {
                        int val = line[x];
                        mask[maskIdx++] = (byte)(val >>> 24);
                        rgb[rgbIdx++] = (byte)(val >> 16 & 0xFF);
                        rgb[rgbIdx++] = (byte)(val >> 8 & 0xFF);
                        rgb[rgbIdx++] = (byte)(val & 0xFF);
                        ++x;
                    }
                    ++y;
                }
            } else {
                mask = null;
                int y = 0;
                while (y < devH) {
                    bi.getRGB(0, y, devW, 1, line, 0, devW);
                    int x = 0;
                    while (x < devW) {
                        int val = line[x];
                        rgb[rgbIdx++] = (byte)(val >> 16 & 0xFF);
                        rgb[rgbIdx++] = (byte)(val >> 8 & 0xFF);
                        rgb[rgbIdx++] = (byte)(val & 0xFF);
                        ++x;
                    }
                    ++y;
                }
            }
            String maskRef = null;
            if (mask != null) {
                fopimg = new BitmapImage("TempImageMask:" + pctx.toString(), devW, devH, mask, null);
                fopimg.setColorSpace(new PDFDeviceColorSpace(1));
                PDFXObject xobj = this.pdfDoc.addImage(this.resourceContext, fopimg);
                maskRef = xobj.referencePDF();
                if (this.outputStream != null) {
                    try {
                        this.pdfDoc.output(this.outputStream);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
            }
            fopimg = new BitmapImage("TempImage:" + pctx.toString(), devW, devH, rgb, maskRef);
            fopimg.setTransparent(new PDFColor(255, 255, 255));
            imageInfo = this.pdfDoc.addImage(this.resourceContext, fopimg);
            if (this.outputStream != null) {
                try {
                    this.pdfDoc.output(this.outputStream);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
        this.currentStream.write("q\n");
        this.writeClip(shape);
        this.currentStream.write("" + usrW + " 0 0 " + -usrH + " " + usrX + " " + (usrY + usrH) + " cm\n" + "/Im" + imageInfo.getXNumber() + " Do\nQ\n");
        return true;
    }

    protected void applyStroke(Stroke stroke) {
        this.preparePainting();
        if (stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)stroke;
            float[] da = bs.getDashArray();
            if (da != null) {
                this.currentStream.write("[");
                int count = 0;
                while (count < da.length) {
                    this.currentStream.write(PDFNumber.doubleOut(da[count]));
                    if (count < da.length - 1) {
                        this.currentStream.write(" ");
                    }
                    ++count;
                }
                this.currentStream.write("] ");
                float offset = bs.getDashPhase();
                this.currentStream.write(PDFNumber.doubleOut(offset) + " d\n");
            }
            int ec = bs.getEndCap();
            switch (ec) {
                case 0: {
                    this.currentStream.write("0 J\n");
                    break;
                }
                case 1: {
                    this.currentStream.write("1 J\n");
                    break;
                }
                case 2: {
                    this.currentStream.write("2 J\n");
                }
            }
            int lj = bs.getLineJoin();
            switch (lj) {
                case 0: {
                    this.currentStream.write("0 j\n");
                    break;
                }
                case 1: {
                    this.currentStream.write("1 j\n");
                    break;
                }
                case 2: {
                    this.currentStream.write("2 j\n");
                }
            }
            float lw = bs.getLineWidth();
            this.currentStream.write(PDFNumber.doubleOut(lw) + " w\n");
            float ml = bs.getMiterLimit();
            this.currentStream.write(PDFNumber.doubleOut(ml) + " M\n");
        }
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
    }

    public void drawString(String s, float x, float y) {
        Font fontState;
        this.preparePainting();
        AffineTransform fontTransform = null;
        if (this.ovFontState == null) {
            java.awt.Font gFont = this.getFont();
            fontTransform = gFont.getTransform();
            String n = gFont.getFamily();
            if (n.equals("sanserif")) {
                n = "sans-serif";
            }
            float siz = gFont.getSize2D();
            String style = gFont.isItalic() ? "italic" : "normal";
            int weight = gFont.isBold() ? 700 : 400;
            FontTriplet triplet = this.fontInfo.fontLookup(n, style, weight);
            fontState = this.fontInfo.getFontInstance(triplet, (int)((double)(siz * 1000.0f) + 0.5));
        } else {
            fontState = this.fontInfo.getFontInstance(this.ovFontState.getFontTriplet(), this.ovFontState.getFontSize());
            this.ovFontState = null;
        }
        String name = fontState.getFontName();
        float size = (float)fontState.getFontSize() / 1000.0f;
        if (!name.equals(this.currentFontName) || size != this.currentFontSize) {
            this.currentFontName = name;
            this.currentFontSize = size;
            this.currentStream.write("/" + name + " " + size + " Tf\n");
        }
        this.currentStream.write("q\n");
        Color c = this.getColor();
        this.applyColor(c, true);
        this.applyPaint(this.getPaint(), true);
        int salpha = c.getAlpha();
        if (salpha != 255) {
            this.checkTransparencyAllowed();
            HashMap<String, Float> vals = new HashMap<String, Float>();
            vals.put("ca", new Float((float)salpha / 255.0f));
            PDFGState gstate = this.pdfDoc.getFactory().makeGState(vals, this.graphicsState.getGState());
            this.resourceContext.addGState(gstate);
            this.currentStream.write("/" + gstate.getName() + " gs\n");
        }
        Map kerning = null;
        boolean kerningAvailable = false;
        kerning = fontState.getKerning();
        if (kerning != null && !kerning.isEmpty()) {
            kerningAvailable = true;
        }
        boolean useMultiByte = false;
        Typeface f = (Typeface)this.fontInfo.getFonts().get(name);
        if (f instanceof LazyFont) {
            if (((LazyFont)f).getRealFont() instanceof CIDFont) {
                useMultiByte = true;
            }
        } else if (f instanceof CIDFont) {
            useMultiByte = true;
        }
        String startText = useMultiByte ? "<" : "(";
        String endText = useMultiByte ? "> " : ") ";
        AffineTransform trans = this.getTransform();
        double[] vals = new double[6];
        trans.getMatrix(vals);
        this.concatMatrix(vals);
        Shape imclip = this.getClip();
        this.writeClip(imclip);
        this.currentStream.write("BT\n");
        AffineTransform localTransform = new AffineTransform();
        localTransform.translate(x, y);
        if (fontTransform != null) {
            localTransform.concatenate(fontTransform);
        }
        localTransform.scale(1.0, -1.0);
        double[] lt = new double[6];
        localTransform.getMatrix(lt);
        this.currentStream.write(PDFNumber.doubleOut(lt[0]) + " " + PDFNumber.doubleOut(lt[1]) + " " + PDFNumber.doubleOut(lt[2]) + " " + PDFNumber.doubleOut(lt[3]) + " " + PDFNumber.doubleOut(lt[4]) + " " + PDFNumber.doubleOut(lt[5]) + " Tm [" + startText);
        int l = s.length();
        int i2 = 0;
        while (i2 < l) {
            char ch = fontState.mapChar(s.charAt(i2));
            if (!useMultiByte) {
                if (ch > '\u007f') {
                    this.currentStream.write("\\");
                    this.currentStream.write(Integer.toOctalString(ch));
                } else {
                    switch (ch) {
                        case '(': 
                        case ')': 
                        case '\\': {
                            this.currentStream.write("\\");
                        }
                    }
                    this.currentStream.write(ch);
                }
            } else {
                this.currentStream.write(PDFText.toUnicodeHex(ch));
            }
            if (kerningAvailable && i2 + 1 < l) {
                this.addKerning(this.currentStream, new Integer(ch), new Integer(fontState.mapChar(s.charAt(i2 + 1))), kerning, startText, endText);
            }
            ++i2;
        }
        this.currentStream.write(endText);
        this.currentStream.write("] TJ\n");
        this.currentStream.write("ET\n");
        this.currentStream.write("Q\n");
    }

    private void addKerning(StringWriter buf, Integer ch1, Integer ch2, Map kerning, String startText, String endText) {
        Integer width;
        this.preparePainting();
        Map kernPair = (Map)kerning.get(ch1);
        if (kernPair != null && (width = (Integer)kernPair.get(ch2)) != null) {
            this.currentStream.write(endText + -width.intValue() + " " + startText);
        }
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.preparePainting();
        Font fontState = null;
        Shape imclip = this.getClip();
        this.writeClip(imclip);
        Color c = this.getColor();
        this.applyColor(c, true);
        this.applyPaint(this.getPaint(), true);
        boolean fill = true;
        boolean stroke = false;
        Stroke currentStroke = this.getStroke();
        stroke = true;
        this.applyStroke(currentStroke);
        this.applyColor(c, false);
        this.applyPaint(this.getPaint(), false);
        this.currentStream.write("BT\n");
        int textr = 0;
        if (fill && stroke) {
            textr = 2;
        } else if (stroke) {
            textr = 1;
        }
        this.currentStream.write(textr + " Tr\n");
        AffineTransform trans = this.getTransform();
        trans.translate(x, y);
        double[] vals = new double[6];
        trans.getMatrix(vals);
        char ch = iterator.first();
        while (ch != '\uffff') {
            String name = fontState.getFontName();
            int size = fontState.getFontSize();
            if (!name.equals(this.currentFontName) || (float)size != this.currentFontSize) {
                this.currentFontName = name;
                this.currentFontSize = size;
                this.currentStream.write("/" + name + " " + size / 1000 + " Tf\n");
            }
            this.currentStream.write(PDFNumber.doubleOut(vals[0], 8) + " " + PDFNumber.doubleOut(vals[1], 8) + " " + PDFNumber.doubleOut(vals[2], 8) + " " + PDFNumber.doubleOut(vals[3], 8) + " " + PDFNumber.doubleOut(vals[4], 8) + " " + PDFNumber.doubleOut(vals[5], 8) + " Tm (" + ch + ") Tj\n");
            ch = iterator.next();
        }
        this.currentStream.write("ET\n");
    }

    public void fill(Shape s) {
        Paint paint;
        boolean newTransform;
        this.preparePainting();
        Color c = this.getBackground();
        if (c.getAlpha() == 0 && (c = this.getColor()).getAlpha() == 0) {
            return;
        }
        AffineTransform trans = this.getTransform();
        double[] tranvals = new double[6];
        trans.getMatrix(tranvals);
        Shape imclip = this.getClip();
        boolean newClip = this.graphicsState.checkClip(imclip);
        boolean bl = newTransform = this.graphicsState.checkTransform(trans) && !trans.isIdentity();
        if (newClip || newTransform) {
            this.currentStream.write("q\n");
            this.graphicsState.push();
            if (newTransform) {
                this.concatMatrix(tranvals);
            }
            if (newClip) {
                this.writeClip(imclip);
            }
        }
        if (c.getAlpha() != 255) {
            this.checkTransparencyAllowed();
            HashMap<String, Float> vals = new HashMap<String, Float>();
            vals.put("ca", new Float((float)c.getAlpha() / 255.0f));
            PDFGState gstate = this.pdfDoc.getFactory().makeGState(vals, this.graphicsState.getGState());
            this.resourceContext.addGState(gstate);
            this.currentStream.write("/" + gstate.getName() + " gs\n");
        }
        if (this.graphicsState.setColor(c = this.getColor())) {
            this.applyColor(c, true);
        }
        if (this.graphicsState.setBackColor(c = this.getBackground())) {
            this.applyColor(c, false);
        }
        if (this.graphicsState.setPaint(paint = this.getPaint()) && !this.applyPaint(paint, true)) {
            this.applyUnknownPaint(paint, s);
            if (newClip || newTransform) {
                this.currentStream.write("Q\n");
                this.graphicsState.pop();
            }
            return;
        }
        PathIterator iter = s.getPathIterator(IDENTITY_TRANSFORM);
        this.processPathIterator(iter);
        this.doDrawing(true, false, iter.getWindingRule() == 0);
        if (newClip || newTransform) {
            this.currentStream.write("Q\n");
            this.graphicsState.pop();
        }
    }

    protected void checkTransparencyAllowed() {
        this.pdfDoc.getProfile().verifyTransparencyAllowed("Java2D graphics");
    }

    public void processPathIterator(PathIterator iter) {
        while (!iter.isDone()) {
            double[] vals = new double[6];
            int type = iter.currentSegment(vals);
            switch (type) {
                case 3: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0], 8) + " " + PDFNumber.doubleOut(vals[1], 8) + " " + PDFNumber.doubleOut(vals[2], 8) + " " + PDFNumber.doubleOut(vals[3], 8) + " " + PDFNumber.doubleOut(vals[4], 8) + " " + PDFNumber.doubleOut(vals[5], 8) + " c\n");
                    break;
                }
                case 1: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0], 8) + " " + PDFNumber.doubleOut(vals[1], 8) + " l\n");
                    break;
                }
                case 0: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0], 8) + " " + PDFNumber.doubleOut(vals[1], 8) + " m\n");
                    break;
                }
                case 2: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0], 8) + " " + PDFNumber.doubleOut(vals[1], 8) + " " + PDFNumber.doubleOut(vals[2], 8) + " " + PDFNumber.doubleOut(vals[3], 8) + " y\n");
                    break;
                }
                case 4: {
                    this.currentStream.write("h\n");
                    break;
                }
            }
            iter.next();
        }
    }

    protected void doDrawing(boolean fill, boolean stroke, boolean nonzero) {
        this.preparePainting();
        if (fill) {
            if (stroke) {
                if (nonzero) {
                    this.currentStream.write("B*\n");
                } else {
                    this.currentStream.write("B\n");
                }
            } else if (nonzero) {
                this.currentStream.write("f*\n");
            } else {
                this.currentStream.write("f\n");
            }
        } else {
            this.currentStream.write("S\n");
        }
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return new PDFGraphicsConfiguration();
    }

    public FontMetrics getFontMetrics(java.awt.Font f) {
        return this.fmg.getFontMetrics(f);
    }

    public void setXORMode(Color c1) {
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }
}

