/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.processor;

import java.util.Vector;
import org.apache.xalan.processor.StylesheetHandler;
import org.apache.xalan.processor.XSLTAttributeDef;
import org.apache.xalan.processor.XSLTElementDef;
import org.apache.xalan.processor.XSLTElementProcessor;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.KeyDeclaration;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class ProcessorKey
extends XSLTElementProcessor {
    ProcessorKey() {
    }

    public void startElement(StylesheetHandler handler, String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        KeyDeclaration kd = new KeyDeclaration(handler.getStylesheet(), handler.nextUid());
        kd.setDOMBackPointer(handler.getOriginatingNode());
        kd.setLocaterInfo(handler.getLocator());
        this.setPropertiesFromAttributes(handler, rawName, attributes, kd);
        handler.getStylesheet().setKey(kd);
    }

    void setPropertiesFromAttributes(StylesheetHandler handler, String rawName, Attributes attributes, ElemTemplateElement target) throws SAXException {
        XSLTElementDef def = this.getElemDef();
        Vector<XSLTAttributeDef> processedDefs = new Vector<XSLTAttributeDef>();
        int nAttrs = attributes.getLength();
        int i2 = 0;
        while (i2 < nAttrs) {
            String attrLocalName;
            String attrUri = attributes.getURI(i2);
            XSLTAttributeDef attrDef = def.getAttributeDef(attrUri, attrLocalName = attributes.getLocalName(i2));
            if (null == attrDef) {
                handler.error(attributes.getQName(i2) + "attribute is not allowed on the " + rawName + " element!", null);
            } else {
                String valueString = attributes.getValue(i2);
                if (valueString.indexOf("key(") >= 0) {
                    handler.error(XSLMessages.createMessage("ER_INVALID_KEY_CALL", null), null);
                }
                processedDefs.addElement(attrDef);
                attrDef.setAttrValue(handler, attrUri, attrLocalName, attributes.getQName(i2), attributes.getValue(i2), target);
            }
            ++i2;
        }
        XSLTAttributeDef[] attrDefs = def.getAttributes();
        int nAttrDefs = attrDefs.length;
        int i3 = 0;
        while (i3 < nAttrDefs) {
            XSLTAttributeDef attrDef = attrDefs[i3];
            String defVal = attrDef.getDefault();
            if (null != defVal && !processedDefs.contains(attrDef)) {
                attrDef.setDefAttrValue(handler, target);
            }
            if (attrDef.getRequired() && !processedDefs.contains(attrDef)) {
                handler.error(XSLMessages.createMessage("ER_REQUIRES_ATTRIB", new Object[]{rawName, attrDef.getName()}), null);
            }
            ++i3;
        }
    }
}

