/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.KeyDeclaration;
import org.apache.xalan.transformer.KeyIterator;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xml.utils.XMLString;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.ChildTestIterator;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;

public class KeyRefIterator
extends ChildTestIterator {
    DTMIterator m_keysNodes;
    protected XMLString m_ref;
    protected QName m_name;
    protected Vector m_keyDeclarations;

    public KeyRefIterator(QName name, XMLString ref, Vector keyDecls, DTMIterator ki) {
        super((DTMAxisTraverser)null);
        this.m_name = name;
        this.m_ref = ref;
        this.m_keyDeclarations = keyDecls;
        this.m_keysNodes = ki;
        this.setWhatToShow(-1);
    }

    /*
     * WARNING - void declaration
     */
    protected int getNextNode() {
        int next;
        while (-1 != (next = this.m_keysNodes.nextNode())) {
            void var1_1;
            if (1 == this.filterNode((int)var1_1)) break;
        }
        this.m_lastFetched = next;
        return next;
    }

    /*
     * WARNING - void declaration
     */
    public short filterNode(int testNode) {
        boolean foundKey = false;
        Vector keys = this.m_keyDeclarations;
        QName name = this.m_name;
        KeyIterator ki = (KeyIterator)((XNodeSet)this.m_keysNodes).getContainedIter();
        XPathContext xctxt = ki.getXPathContext();
        if (null == xctxt) {
            this.assertion(false, "xctxt can not be null here!");
        }
        try {
            XMLString lookupKey = this.m_ref;
            int nDeclarations = keys.size();
            int i2 = 0;
            while (i2 < nDeclarations) {
                KeyDeclaration kd = (KeyDeclaration)keys.elementAt(i2);
                if (kd.getName().equals(name)) {
                    foundKey = true;
                    XObject xuse = kd.getUse().execute(xctxt, testNode, ki.getPrefixResolver());
                    if (xuse.getType() != 4) {
                        XMLString exprResult = xuse.xstr();
                        if (lookupKey.equals(exprResult)) {
                            return 1;
                        }
                    } else {
                        int useNode;
                        DTMIterator nl = ((XNodeSet)xuse).iterRaw();
                        while (-1 != (useNode = nl.nextNode())) {
                            void var13_14;
                            DTM dtm = this.getDTM((int)var13_14);
                            XMLString exprResult = dtm.getStringValue((int)var13_14);
                            if (null == exprResult || !lookupKey.equals(exprResult)) continue;
                            return 1;
                        }
                    }
                }
                ++i2;
            }
        }
        catch (TransformerException te) {
            throw new WrappedRuntimeException(te);
        }
        if (!foundKey) {
            throw new RuntimeException(XSLMessages.createMessage("ER_NO_XSLKEY_DECLARATION", new Object[]{name.getLocalName()}));
        }
        return 2;
    }
}

