/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.xml.serializer.EncodingInfo;
import org.apache.xml.serializer.ObjectFactory;
import org.apache.xml.serializer.SecuritySupport;
import org.apache.xml.utils.WrappedRuntimeException;

public class Encodings {
    static final int m_defaultLastPrintable = 127;
    static final String ENCODINGS_FILE = "org/apache/xml/serializer/Encodings.properties";
    static final String ENCODINGS_PROP = "org.apache.xalan.serialize.encodings";
    private static final Method SUN_CHAR2BYTE_CONVERTER_METHOD = Encodings.findCharToByteConverterMethod();
    public static final String DEFAULT_MIME_ENCODING = "UTF-8";
    private static final Hashtable _encodingTableKeyJava = new Hashtable();
    private static final Hashtable _encodingTableKeyMime = new Hashtable();
    private static final EncodingInfo[] _encodings = Encodings.loadEncodingInfo();

    private static Method findCharToByteConverterMethod() {
        try {
            AccessController.doPrivileged(new PrivilegedAction(){
                static /* synthetic */ Class class$java$lang$String;

                public Object run() {
                    try {
                        Class<?> charToByteConverterClass = Class.forName("sun.io.CharToByteConverter");
                        Class[] argTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = 1.class$("java.lang.String")) : class$java$lang$String};
                        return charToByteConverterClass.getMethod("getConverter", argTypes);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.toString());
                    }
                }

                static /* synthetic */ Class class$(String x0) {
                    try {
                        return Class.forName(x0);
                    }
                    catch (ClassNotFoundException x1) {
                        throw new NoClassDefFoundError(x1.getMessage());
                    }
                }
            });
        }
        catch (Exception e) {
            System.err.println("Warning: Could not get charToByteConverterClass!");
        }
        return null;
    }

    public static Writer getWriter(OutputStream output, String encoding) throws UnsupportedEncodingException {
        int i2 = 0;
        while (i2 < _encodings.length) {
            if (Encodings._encodings[i2].name.equalsIgnoreCase(encoding)) {
                try {
                    return new OutputStreamWriter(output, Encodings._encodings[i2].javaName);
                }
                catch (IllegalArgumentException iae) {
                }
                catch (UnsupportedEncodingException usee) {
                    // empty catch block
                }
            }
            ++i2;
        }
        try {
            return new OutputStreamWriter(output, encoding);
        }
        catch (IllegalArgumentException iae) {
            throw new UnsupportedEncodingException(encoding);
        }
    }

    public static Object getCharToByteConverter(String encoding) {
        if (SUN_CHAR2BYTE_CONVERTER_METHOD == null) {
            return null;
        }
        Object[] args = new Object[1];
        int i2 = 0;
        while (i2 < _encodings.length) {
            if (Encodings._encodings[i2].name.equalsIgnoreCase(encoding)) {
                try {
                    args[0] = Encodings._encodings[i2].javaName;
                    Object converter = SUN_CHAR2BYTE_CONVERTER_METHOD.invoke(null, args);
                    if (null != converter) {
                        return converter;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i2;
        }
        return null;
    }

    public static int getLastPrintable(String encoding) {
        String normalizedEncoding = encoding.toUpperCase();
        EncodingInfo ei = (EncodingInfo)_encodingTableKeyJava.get(normalizedEncoding);
        if (ei == null) {
            ei = (EncodingInfo)_encodingTableKeyMime.get(normalizedEncoding);
        }
        if (ei != null) {
            return ei.lastPrintable;
        }
        return 127;
    }

    public static int getLastPrintable() {
        return 127;
    }

    public static String getMimeEncoding(String encoding) {
        block5: {
            if (null == encoding) {
                try {
                    encoding = System.getProperty("file.encoding", "UTF8");
                    if (null != encoding) {
                        String jencoding = encoding.equalsIgnoreCase("Cp1252") || encoding.equalsIgnoreCase("ISO8859_1") || encoding.equalsIgnoreCase("8859_1") || encoding.equalsIgnoreCase("UTF8") ? DEFAULT_MIME_ENCODING : Encodings.convertJava2MimeEncoding(encoding);
                        encoding = null != jencoding ? jencoding : DEFAULT_MIME_ENCODING;
                        break block5;
                    }
                    encoding = DEFAULT_MIME_ENCODING;
                }
                catch (SecurityException se) {
                    encoding = DEFAULT_MIME_ENCODING;
                }
            } else {
                encoding = Encodings.convertJava2MimeEncoding(encoding);
            }
        }
        return encoding;
    }

    public static String convertJava2MimeEncoding(String encoding) {
        EncodingInfo enc = (EncodingInfo)_encodingTableKeyJava.get(encoding.toUpperCase());
        if (null != enc) {
            return enc.name;
        }
        return encoding;
    }

    public static String convertMime2JavaEncoding(String encoding) {
        int i2 = 0;
        while (i2 < _encodings.length) {
            if (Encodings._encodings[i2].name.equalsIgnoreCase(encoding)) {
                return Encodings._encodings[i2].javaName;
            }
            ++i2;
        }
        return encoding;
    }

    private static EncodingInfo[] loadEncodingInfo() {
        URL url = null;
        try {
            String urlString = null;
            InputStream is = null;
            try {
                urlString = System.getProperty(ENCODINGS_PROP, "");
            }
            catch (SecurityException e) {
                // empty catch block
            }
            if (urlString != null && urlString.length() > 0) {
                url = new URL(urlString);
                is = url.openStream();
            }
            if (is == null) {
                SecuritySupport ss = SecuritySupport.getInstance();
                is = ss.getResourceAsStream(ObjectFactory.findClassLoader(), ENCODINGS_FILE);
            }
            Properties props = new Properties();
            if (is != null) {
                props.load(is);
                is.close();
            }
            int totalEntries = ((Hashtable)props).size();
            int totalMimeNames = 0;
            Enumeration keys = ((Hashtable)props).keys();
            int i2 = 0;
            while (i2 < totalEntries) {
                String javaName = (String)keys.nextElement();
                String val = props.getProperty(javaName);
                ++totalMimeNames;
                int pos = val.indexOf(32);
                int j = 0;
                while (j < pos) {
                    if (val.charAt(j) == ',') {
                        ++totalMimeNames;
                    }
                    ++j;
                }
                ++i2;
            }
            EncodingInfo[] ret = new EncodingInfo[totalMimeNames];
            int j = 0;
            keys = ((Hashtable)props).keys();
            int i3 = 0;
            while (i3 < totalEntries) {
                int lastPrintable;
                String mimeName;
                String javaName = (String)keys.nextElement();
                String val = props.getProperty(javaName);
                int pos = val.indexOf(32);
                if (pos < 0) {
                    mimeName = val;
                    lastPrintable = 255;
                } else {
                    lastPrintable = Integer.decode(val.substring(pos).trim());
                    StringTokenizer st = new StringTokenizer(val.substring(0, pos), ",");
                    boolean first = true;
                    while (st.hasMoreTokens()) {
                        mimeName = st.nextToken();
                        ret[j] = new EncodingInfo(mimeName, javaName, lastPrintable);
                        _encodingTableKeyMime.put(mimeName.toUpperCase(), ret[j]);
                        if (first) {
                            _encodingTableKeyJava.put(javaName.toUpperCase(), ret[j]);
                        }
                        ++j;
                        first = false;
                    }
                }
                ++i3;
            }
            return ret;
        }
        catch (MalformedURLException mue) {
            throw new WrappedRuntimeException(mue);
        }
        catch (IOException ioe) {
            throw new WrappedRuntimeException(ioe);
        }
    }
}

