/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

public class ObjectVector
implements Cloneable {
    protected int m_blocksize;
    protected Object[] m_map;
    protected int m_firstFree = 0;
    protected int m_mapSize;

    public ObjectVector() {
        this.m_mapSize = this.m_blocksize = 32;
        this.m_map = new Object[this.m_blocksize];
    }

    public ObjectVector(int blocksize) {
        this.m_blocksize = blocksize;
        this.m_mapSize = blocksize;
        this.m_map = new Object[blocksize];
    }

    public ObjectVector(int blocksize, int increaseSize) {
        this.m_blocksize = increaseSize;
        this.m_mapSize = blocksize;
        this.m_map = new Object[blocksize];
    }

    public ObjectVector(ObjectVector v) {
        this.m_map = new Object[v.m_mapSize];
        this.m_mapSize = v.m_mapSize;
        this.m_firstFree = v.m_firstFree;
        this.m_blocksize = v.m_blocksize;
        System.arraycopy(v.m_map, 0, this.m_map, 0, this.m_firstFree);
    }

    public final int size() {
        return this.m_firstFree;
    }

    public final void setSize(int sz) {
        this.m_firstFree = sz;
    }

    public final void addElement(Object value) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Object[] newMap = new Object[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + 1);
            this.m_map = newMap;
        }
        this.m_map[this.m_firstFree] = value;
        ++this.m_firstFree;
    }

    public final void addElements(Object value, int numberOfElements) {
        if (this.m_firstFree + numberOfElements >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize + numberOfElements;
            Object[] newMap = new Object[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + 1);
            this.m_map = newMap;
        }
        int i2 = 0;
        while (i2 < numberOfElements) {
            this.m_map[this.m_firstFree] = value;
            ++this.m_firstFree;
            ++i2;
        }
    }

    public final void addElements(int numberOfElements) {
        if (this.m_firstFree + numberOfElements >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize + numberOfElements;
            Object[] newMap = new Object[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + 1);
            this.m_map = newMap;
        }
        this.m_firstFree += numberOfElements;
    }

    public final void insertElementAt(Object value, int at) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Object[] newMap = new Object[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + 1);
            this.m_map = newMap;
        }
        if (at <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, at, this.m_map, at + 1, this.m_firstFree - at);
        }
        this.m_map[at] = value;
        ++this.m_firstFree;
    }

    public final void removeAllElements() {
        int i2 = 0;
        while (i2 < this.m_firstFree) {
            this.m_map[i2] = null;
            ++i2;
        }
        this.m_firstFree = 0;
    }

    public final boolean removeElement(Object s) {
        int i2 = 0;
        while (i2 < this.m_firstFree) {
            if (this.m_map[i2] == s) {
                if (i2 + 1 < this.m_firstFree) {
                    System.arraycopy(this.m_map, i2 + 1, this.m_map, i2 - 1, this.m_firstFree - i2);
                } else {
                    this.m_map[i2] = null;
                }
                --this.m_firstFree;
                return true;
            }
            ++i2;
        }
        return false;
    }

    public final void removeElementAt(int i2) {
        if (i2 > this.m_firstFree) {
            System.arraycopy(this.m_map, i2 + 1, this.m_map, i2, this.m_firstFree);
        } else {
            this.m_map[i2] = null;
        }
        --this.m_firstFree;
    }

    public final void setElementAt(Object value, int index) {
        this.m_map[index] = value;
    }

    public final Object elementAt(int i2) {
        return this.m_map[i2];
    }

    public final boolean contains(Object s) {
        int i2 = 0;
        while (i2 < this.m_firstFree) {
            if (this.m_map[i2] == s) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public final int indexOf(Object elem, int index) {
        int i2 = index;
        while (i2 < this.m_firstFree) {
            if (this.m_map[i2] == elem) {
                return i2;
            }
            ++i2;
        }
        return Integer.MIN_VALUE;
    }

    public final int indexOf(Object elem) {
        int i2 = 0;
        while (i2 < this.m_firstFree) {
            if (this.m_map[i2] == elem) {
                return i2;
            }
            ++i2;
        }
        return Integer.MIN_VALUE;
    }

    public final int lastIndexOf(Object elem) {
        int i2 = this.m_firstFree - 1;
        while (i2 >= 0) {
            if (this.m_map[i2] == elem) {
                return i2;
            }
            --i2;
        }
        return Integer.MIN_VALUE;
    }

    public final void setToSize(int size) {
        Object[] newMap = new Object[size];
        System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree);
        this.m_mapSize = size;
        this.m_map = newMap;
    }

    public Object clone() throws CloneNotSupportedException {
        return new ObjectVector(this);
    }
}

