/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.axes.FilterExprWalker;
import org.apache.xpath.axes.HasPositionalPredChecker;
import org.apache.xpath.axes.IteratorPool;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.PathComponent;
import org.apache.xpath.axes.UnionChildIterator;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.axes.WalkingIterator;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;

public class UnionPathIterator
extends LocPathIterator
implements Cloneable,
DTMIterator,
Serializable,
PathComponent {
    protected LocPathIterator[] m_exprs;
    protected DTMIterator[] m_iterators;

    public UnionPathIterator() {
        this.m_iterators = null;
        this.m_exprs = null;
    }

    public void setRoot(int context, Object environment) {
        super.setRoot(context, environment);
        try {
            if (null != this.m_exprs) {
                int n = this.m_exprs.length;
                DTMIterator[] newIters = new DTMIterator[n];
                int i2 = 0;
                while (i2 < n) {
                    DTMIterator iter;
                    newIters[i2] = iter = this.m_exprs[i2].asIterator(this.m_execContext, context);
                    iter.nextNode();
                    ++i2;
                }
                this.m_iterators = newIters;
            }
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public void addIterator(DTMIterator expr) {
        if (null == this.m_iterators) {
            this.m_iterators = new DTMIterator[1];
            this.m_iterators[0] = expr;
        } else {
            DTMIterator[] exprs = this.m_iterators;
            int len = this.m_iterators.length;
            this.m_iterators = new DTMIterator[len + 1];
            System.arraycopy(exprs, 0, this.m_iterators, 0, len);
            this.m_iterators[len] = expr;
        }
        expr.nextNode();
        if (expr instanceof Expression) {
            ((Expression)((Object)expr)).exprSetParent(this);
        }
    }

    public void detach() {
        if (this.m_allowDetach && null != this.m_iterators) {
            int n = this.m_iterators.length;
            int i2 = 0;
            while (i2 < n) {
                this.m_iterators[i2].detach();
                ++i2;
            }
            this.m_iterators = null;
        }
    }

    public UnionPathIterator(Compiler compiler, int opPos) throws TransformerException {
        opPos = OpMap.getFirstChildPos(opPos);
        this.loadLocationPaths(compiler, opPos, 0);
    }

    public static LocPathIterator createUnionIterator(Compiler compiler, int opPos) throws TransformerException {
        UnionPathIterator upi = new UnionPathIterator(compiler, opPos);
        int nPaths = upi.m_exprs.length;
        boolean isAllChildIterators = true;
        int i2 = 0;
        while (i2 < nPaths) {
            LocPathIterator lpi = upi.m_exprs[i2];
            if (lpi.getAxis() != 3) {
                isAllChildIterators = false;
                break;
            }
            if (HasPositionalPredChecker.check(lpi)) {
                isAllChildIterators = false;
                break;
            }
            ++i2;
        }
        if (isAllChildIterators) {
            UnionChildIterator uci = new UnionChildIterator();
            int i3 = 0;
            while (i3 < nPaths) {
                LocPathIterator lpi = upi.m_exprs[i3];
                uci.addNodeTest(lpi);
                ++i3;
            }
            return uci;
        }
        return upi;
    }

    public int getAnalysisBits() {
        int bits = 0;
        if (this.m_exprs != null) {
            int n = this.m_exprs.length;
            int i2 = 0;
            while (i2 < n) {
                int bit = this.m_exprs[i2].getAnalysisBits();
                bits |= bit;
                ++i2;
            }
        }
        return bits;
    }

    private void readObject(ObjectInputStream stream) throws IOException, TransformerException {
        try {
            stream.defaultReadObject();
            this.m_clones = new IteratorPool(this);
        }
        catch (ClassNotFoundException cnfe) {
            throw new TransformerException(cnfe);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        UnionPathIterator clone = (UnionPathIterator)super.clone();
        return clone;
    }

    protected LocPathIterator createDTMIterator(Compiler compiler, int opPos) throws TransformerException {
        LocPathIterator lpi = (LocPathIterator)WalkerFactory.newDTMIterator(compiler, opPos, compiler.getLocationPathDepth() <= 0);
        return lpi;
    }

    protected void loadLocationPaths(Compiler compiler, int opPos, int count) throws TransformerException {
        int steptype = compiler.getOp(opPos);
        if (steptype == 28) {
            this.loadLocationPaths(compiler, compiler.getNextOpPos(opPos), count + 1);
            this.m_exprs[count] = this.createDTMIterator(compiler, opPos);
            this.m_exprs[count].exprSetParent(this);
        } else {
            switch (steptype) {
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    this.loadLocationPaths(compiler, compiler.getNextOpPos(opPos), count + 1);
                    WalkingIterator iter = new WalkingIterator(compiler.getNamespaceContext());
                    iter.exprSetParent(this);
                    if (compiler.getLocationPathDepth() <= 0) {
                        iter.setIsTopLevel(true);
                    }
                    iter.m_firstWalker = new FilterExprWalker(iter);
                    iter.m_firstWalker.init(compiler, opPos, steptype);
                    this.m_exprs[count] = iter;
                    break;
                }
                default: {
                    this.m_exprs = new LocPathIterator[count];
                }
            }
        }
    }

    public int nextNode() {
        if (this.m_foundLast) {
            return -1;
        }
        int earliestNode = -1;
        if (null != this.m_iterators) {
            int n = this.m_iterators.length;
            int iteratorUsed = -1;
            int i2 = 0;
            while (i2 < n) {
                int node = this.m_iterators[i2].getCurrentNode();
                if (-1 != node) {
                    if (-1 == earliestNode) {
                        iteratorUsed = i2;
                        earliestNode = node;
                    } else if (node == earliestNode) {
                        this.m_iterators[i2].nextNode();
                    } else {
                        DTM dtm = this.getDTM(node);
                        if (dtm.isNodeAfter(node, earliestNode)) {
                            iteratorUsed = i2;
                            earliestNode = node;
                        }
                    }
                }
                ++i2;
            }
            if (-1 != earliestNode) {
                this.m_iterators[iteratorUsed].nextNode();
                this.incrementCurrentPos();
            } else {
                this.m_foundLast = true;
            }
        }
        this.m_lastFetched = earliestNode;
        return earliestNode;
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        int i2 = 0;
        while (i2 < this.m_exprs.length) {
            this.m_exprs[i2].fixupVariables(vars, globalsSize);
            ++i2;
        }
    }

    public int getAxis() {
        return -1;
    }

    public void callVisitors(ExpressionOwner owner, XPathVisitor visitor) {
        if (visitor.visitUnionPath(owner, this) && null != this.m_exprs) {
            int n = this.m_exprs.length;
            int i2 = 0;
            while (i2 < n) {
                this.m_exprs[i2].callVisitors(new iterOwner(i2), visitor);
                ++i2;
            }
        }
    }

    public boolean deepEquals(Expression expr) {
        if (!super.deepEquals(expr)) {
            return false;
        }
        UnionPathIterator upi = (UnionPathIterator)expr;
        if (null != this.m_exprs) {
            int n = this.m_exprs.length;
            if (null == upi.m_exprs || upi.m_exprs.length != n) {
                return false;
            }
            int i2 = 0;
            while (i2 < n) {
                if (!this.m_exprs[i2].deepEquals(upi.m_exprs[i2])) {
                    return false;
                }
                ++i2;
            }
        } else if (null != upi.m_exprs) {
            return false;
        }
        return true;
    }

    class iterOwner
    implements ExpressionOwner {
        int m_index;

        iterOwner(int index) {
            this.m_index = index;
        }

        public Expression getExpression() {
            return UnionPathIterator.this.m_exprs[this.m_index];
        }

        public void setExpression(Expression exp) {
            if (!(exp instanceof LocPathIterator)) {
                WalkingIterator wi = new WalkingIterator(UnionPathIterator.this.getPrefixResolver());
                FilterExprWalker few = new FilterExprWalker(wi);
                wi.setFirstWalker(few);
                few.setInnerExpression(exp);
                wi.exprSetParent(UnionPathIterator.this);
                few.exprSetParent(wi);
                exp.exprSetParent(few);
                exp = wi;
            } else {
                exp.exprSetParent(UnionPathIterator.this);
            }
            UnionPathIterator.this.m_exprs[this.m_index] = (LocPathIterator)exp;
        }
    }
}

