/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.functions;

import java.util.Vector;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.functions.Function3Args;
import org.apache.xpath.functions.WrongNumberArgsException;
import org.apache.xpath.res.XPATHMessages;

public class FunctionMultiArgs
extends Function3Args {
    Expression[] m_args;

    public Expression[] getArgs() {
        return this.m_args;
    }

    public void setArg(Expression arg, int argNum) throws WrongNumberArgsException {
        if (argNum < 3) {
            super.setArg(arg, argNum);
        } else {
            if (null == this.m_args) {
                this.m_args = new Expression[1];
                this.m_args[0] = arg;
            } else {
                Expression[] args = new Expression[this.m_args.length + 1];
                System.arraycopy(this.m_args, 0, args, 0, this.m_args.length);
                args[this.m_args.length] = arg;
                this.m_args = args;
            }
            arg.exprSetParent(this);
        }
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        super.fixupVariables(vars, globalsSize);
        if (null != this.m_args) {
            int i2 = 0;
            while (i2 < this.m_args.length) {
                this.m_args[i2].fixupVariables(vars, globalsSize);
                ++i2;
            }
        }
    }

    public void checkNumberArgs(int argNum) throws WrongNumberArgsException {
    }

    protected void reportWrongNumberArgs() throws WrongNumberArgsException {
        String fMsg = XPATHMessages.createXPATHMessage("ER_INCORRECT_PROGRAMMER_ASSERTION", new Object[]{"Programmer's assertion:  the method FunctionMultiArgs.reportWrongNumberArgs() should never be called."});
        throw new RuntimeException(fMsg);
    }

    public boolean canTraverseOutsideSubtree() {
        if (super.canTraverseOutsideSubtree()) {
            return true;
        }
        int n = this.m_args.length;
        int i2 = 0;
        while (i2 < n) {
            if (this.m_args[i2].canTraverseOutsideSubtree()) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public void callArgVisitors(XPathVisitor visitor) {
        super.callArgVisitors(visitor);
        if (null != this.m_args) {
            int n = this.m_args.length;
            int i2 = 0;
            while (i2 < n) {
                this.m_args[i2].callVisitors(new ArgMultiOwner(i2), visitor);
                ++i2;
            }
        }
    }

    public boolean deepEquals(Expression expr) {
        if (!super.deepEquals(expr)) {
            return false;
        }
        FunctionMultiArgs fma = (FunctionMultiArgs)expr;
        if (null != this.m_args) {
            int n = this.m_args.length;
            if (null == fma || fma.m_args.length != n) {
                return false;
            }
            int i2 = 0;
            while (i2 < n) {
                if (!this.m_args[i2].deepEquals(fma.m_args[i2])) {
                    return false;
                }
                ++i2;
            }
        } else if (null != fma.m_args) {
            return false;
        }
        return true;
    }

    class ArgMultiOwner
    implements ExpressionOwner {
        int m_argIndex;

        ArgMultiOwner(int index) {
            this.m_argIndex = index;
        }

        public Expression getExpression() {
            return FunctionMultiArgs.this.m_args[this.m_argIndex];
        }

        public void setExpression(Expression exp) {
            exp.exprSetParent(FunctionMultiArgs.this);
            FunctionMultiArgs.this.m_args[this.m_argIndex] = exp;
        }
    }
}

