/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;
import org.apache.xpath.patterns.StepPattern;

public class UnionPattern
extends Expression {
    private StepPattern[] m_patterns;

    public void fixupVariables(Vector vars, int globalsSize) {
        int i2 = 0;
        while (i2 < this.m_patterns.length) {
            this.m_patterns[i2].fixupVariables(vars, globalsSize);
            ++i2;
        }
    }

    public boolean canTraverseOutsideSubtree() {
        if (null != this.m_patterns) {
            int n = this.m_patterns.length;
            int i2 = 0;
            while (i2 < n) {
                if (this.m_patterns[i2].canTraverseOutsideSubtree()) {
                    return true;
                }
                ++i2;
            }
        }
        return false;
    }

    public void setPatterns(StepPattern[] patterns) {
        this.m_patterns = patterns;
        if (null != patterns) {
            int i2 = 0;
            while (i2 < patterns.length) {
                patterns[i2].exprSetParent(this);
                ++i2;
            }
        }
    }

    public StepPattern[] getPatterns() {
        return this.m_patterns;
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        XObject bestScore = null;
        int n = this.m_patterns.length;
        int i2 = 0;
        while (i2 < n) {
            XObject score = this.m_patterns[i2].execute(xctxt);
            if (score != NodeTest.SCORE_NONE) {
                if (null == bestScore) {
                    bestScore = score;
                } else if (score.num() > bestScore.num()) {
                    bestScore = score;
                }
            }
            ++i2;
        }
        if (null == bestScore) {
            bestScore = NodeTest.SCORE_NONE;
        }
        return bestScore;
    }

    public void callVisitors(ExpressionOwner owner, XPathVisitor visitor) {
        visitor.visitUnionPattern(owner, this);
        if (null != this.m_patterns) {
            int n = this.m_patterns.length;
            int i2 = 0;
            while (i2 < n) {
                this.m_patterns[i2].callVisitors(new UnionPathPartOwner(i2), visitor);
                ++i2;
            }
        }
    }

    public boolean deepEquals(Expression expr) {
        if (!this.isSameClass(expr)) {
            return false;
        }
        UnionPattern up = (UnionPattern)expr;
        if (null != this.m_patterns) {
            int n = this.m_patterns.length;
            if (null == up.m_patterns || up.m_patterns.length != n) {
                return false;
            }
            int i2 = 0;
            while (i2 < n) {
                if (!this.m_patterns[i2].deepEquals(up.m_patterns[i2])) {
                    return false;
                }
                ++i2;
            }
        } else if (up.m_patterns != null) {
            return false;
        }
        return true;
    }

    class UnionPathPartOwner
    implements ExpressionOwner {
        int m_index;

        UnionPathPartOwner(int index) {
            this.m_index = index;
        }

        public Expression getExpression() {
            return UnionPattern.this.m_patterns[this.m_index];
        }

        public void setExpression(Expression exp) {
            exp.exprSetParent(UnionPattern.this);
            ((UnionPattern)UnionPattern.this).m_patterns[this.m_index] = (StepPattern)exp;
        }
    }
}

