/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.files;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import org.ctom.hulis.files.ReadSectionException;
import org.ctom.hulis.util.io.HuckelIO;

public class SectionReader {
    private LineNumberReader lnr = null;
    private int lineNumber = 0;

    public SectionReader(LineNumberReader lnr) {
        this.lnr = lnr;
        this.lineNumber = 0;
    }

    public SectionReader(String s) {
        this(new LineNumberReader(new StringReader(s)));
    }

    public String[] getLine() throws ReadSectionException {
        String[] words = new String[]{};
        String ligne = this.getWholeLine();
        if (ligne == null) {
            return null;
        }
        words = ligne.trim().split("[\\r\\n\\s]+");
        int i2 = 0;
        while (i2 < words.length) {
            String word = words[i2];
            if (word.length() > 0 && word.toCharArray()[0] == '!') {
                String[] nocomment = new String[i2];
                int j = 0;
                while (j < i2) {
                    nocomment[j] = words[j];
                    ++j;
                }
                return this.clean(nocomment);
            }
            ++i2;
        }
        return this.clean(words);
    }

    public String getWholeLine(boolean toLowerCase) throws ReadSectionException {
        try {
            String line = this.lnr.readLine();
            ++this.lineNumber;
            HuckelIO.PrintIfln(String.valueOf(this.lineNumber) + " : " + line);
            if (toLowerCase && line != null) {
                line = line.toLowerCase();
            }
            return line;
        }
        catch (IOException e) {
            throw new ReadSectionException("end of file not expecteded at line " + this.lineNumber);
        }
    }

    public String getWholeLine() throws ReadSectionException {
        return this.getWholeLine(false);
    }

    public String[] readSectionUntilEnd(String end) throws ReadSectionException {
        LinkedList<String> section = new LinkedList<String>();
        block0: while (true) {
            String[] line;
            if ((line = this.getLine()) == null) {
                throw new ReadSectionException("Keyword \"" + end + "\" not found. end of file not expected at line " + this.lineNumber);
            }
            int i2 = 0;
            while (true) {
                if (i2 >= line.length) continue block0;
                section.add(line[i2]);
                if (line[i2].toLowerCase().equals(end)) {
                    return section.toArray(new String[section.size()]);
                }
                ++i2;
            }
            break;
        }
    }

    private String[] clean(String[] stringArrayToclean) {
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = stringArrayToclean;
        int n = stringArrayToclean.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string.length() != 0) {
                result.add(string);
            }
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getNextKeyword() throws ReadSectionException {
        String[] keywords = null;
        while ((keywords = this.getLine()) != null && keywords.length == 0) {
        }
        if (keywords == null) {
            throw new ReadSectionException("End of file not expected at line " + this.lineNumber);
        }
        return keywords[0];
    }
}

