/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.files.gamess;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import org.ctom.hulis.files.xyz.GeometryReader;
import org.ctom.hulis.files.xyz.ReadxyzException;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.PeriodicTable;
import org.ctom.hulis.util.geometry.Geometry;
import org.ctom.hulis.util.io.HuckelIO;

public class GamessReadXYZ
extends GeometryReader {
    public static final double BOHR_TO_ANGSTROM = 0.529177211;
    Geometry geomXYZ;
    StreamTokenizer donnees;
    private int lineNumber;
    int token;

    public GamessReadXYZ(String string) {
        this.donnees = new StreamTokenizer(new StringReader(string));
        this.lineNumber = 0;
        this.token = 0;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public void readAll(Geometry geometry) throws ReadxyzException {
        this.geomXYZ = geometry;
        this.donnees.eolIsSignificant(true);
        this.readHeader(this.donnees);
        this.readxyzDatas(this.donnees);
        this.geomXYZ.flatGeom();
    }

    protected void readHeader(StreamTokenizer donnees) {
        try {
            while ((this.token = donnees.nextToken()) == 10) {
                ++this.lineNumber;
            }
            ++this.lineNumber;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void readxyzDatas(StreamTokenizer donnees) throws ReadxyzException {
        int flag = 0;
        boolean emptyLine = true;
        int nbAtomLus = 0;
        Atom atom = null;
        try {
            while (true) {
                if (this.token == -1) {
                    if (atom != null) {
                        if (flag < 4) {
                            throw new ReadxyzException("a coordinate is missing at line " + this.lineNumber);
                        }
                        this.geomXYZ.add(atom);
                    }
                    throw new ReadxyzException("EOF reached");
                }
                if (this.token == 10) {
                    if (emptyLine) {
                        throw new ReadxyzException("Empty line found at line " + this.lineNumber);
                    }
                    emptyLine = true;
                    if (atom == null) {
                        throw new ReadxyzException("atom not found at line " + this.lineNumber);
                    }
                    if (flag < 4) {
                        throw new ReadxyzException("a coordinate is missing at line " + this.lineNumber);
                    }
                    this.geomXYZ.add(atom);
                    ++nbAtomLus;
                    atom = null;
                    flag = 0;
                    ++this.lineNumber;
                } else if (this.token == -3) {
                    emptyLine = false;
                    if (flag == 2) {
                        throw new ReadxyzException("atomic number must be a number at the line " + this.lineNumber + " instead of " + donnees.sval);
                    }
                    if (flag >= 3 && flag <= 5) {
                        throw new ReadxyzException("coordinate must be a number at the line " + this.lineNumber + " instead of " + donnees.sval);
                    }
                } else if (this.token == -2) {
                    emptyLine = false;
                    switch (++flag) {
                        case 1: {
                            int atomicNumber = (int)donnees.nval;
                            PeriodicTable.Element element = PeriodicTable.getElementByAtomicNumber(atomicNumber);
                            if (element == null) {
                                throw new ReadxyzException("Atom not recongized for the atomic number = " + atomicNumber + " at the line " + this.lineNumber);
                            }
                            atom = new Atom(0, null, element, element.toString(), element.toString(), 0, 0);
                            break;
                        }
                        case 2: {
                            this.setX(atom, donnees.nval * 0.529177211);
                            break;
                        }
                        case 3: {
                            this.setY(atom, donnees.nval * 0.529177211);
                            break;
                        }
                        case 4: {
                            this.setZ(atom, donnees.nval * 0.529177211);
                            break;
                        }
                        default: {
                            atom.addConnect((int)donnees.nval);
                        }
                    }
                }
                this.token = donnees.nextToken();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e.getMessage() == null || !e.getMessage().equals("EOF reached") && !e.getMessage().startsWith("Empty line found")) {
                HuckelIO.error(this.getClass().getName(), "readxyzDatas", e.getMessage(), e);
                throw new ReadxyzException(e.getMessage());
            }
            this.geomXYZ.print();
            this.geomXYZ.generateConnectivity();
            return;
        }
    }

    protected Geometry getGeometry() {
        return this.geomXYZ;
    }
}

