/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.files.gaussian;

import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import org.ctom.hulis.files.ReadSectionException;
import org.ctom.hulis.files.SectionReader;
import org.ctom.hulis.files.gaussian.ReadGaussianException;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.BlocDelocalized;
import org.ctom.hulis.huckel.Bond;
import org.ctom.hulis.huckel.HuckelAtom;
import org.ctom.hulis.huckel.HuckelBond;
import org.ctom.hulis.huckel.IHuckelObject;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.PeriodicTable;
import org.ctom.hulis.huckel.exception.BlocDelocalizedException;
import org.ctom.hulis.huckel.exception.BondException;
import org.ctom.hulis.huckel.exception.CoupleException;
import org.ctom.hulis.huckel.exception.GeometryException;
import org.ctom.hulis.huckel.exception.HuckelAtomException;
import org.ctom.hulis.huckel.exception.HuckelBondException;
import org.ctom.hulis.huckel.exception.IMethodException;
import org.ctom.hulis.huckel.exception.MesomeryDelocalizedStructureNotExistsException;
import org.ctom.hulis.huckel.exception.MesomeryNoStructureLocalizedException;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import org.ctom.hulis.util.geometry.VirtualBond;

public class NRTSTRreader {
    private SectionReader sectionReader;
    private Mesomery mesomery;

    public NRTSTRreader(String string) {
        this(new LineNumberReader(new StringReader(string)));
    }

    public NRTSTRreader(LineNumberReader lnr) {
        this.sectionReader = new SectionReader(lnr);
        this.mesomery = null;
    }

    public NRTSTRreader(Mesomery mesomery, SectionReader sectionReader) {
        this.sectionReader = sectionReader;
        this.mesomery = mesomery;
    }

    public void setMesomery(Mesomery mesomery) {
        this.mesomery = mesomery;
    }

    public void readAll() throws HuckelBondException, ReadGaussianException, MesomeryDelocalizedStructureNotExistsException, CoupleException, IMethodException, MesomeryNoStructureLocalizedException, HuckelAtomException {
        if (this.mesomery == null) {
            throw new ReadGaussianException("cannnot start to read NRTSTR : Mesomery is null");
        }
        this.readNRTSTR_Namelist();
    }

    /*
     * Unable to fully structure code
     */
    private void readBOND(StructureLocalized structure) throws ReadGaussianException, HuckelBondException, HuckelAtomException {
        rememberLine = this.sectionReader.getLineNumber();
        try {
            bonds = this.sectionReader.readSectionUntilEnd("end");
        }
        catch (ReadSectionException e1) {
            throw new ReadGaussianException(e1);
        }
        i = 0;
        iat = 0;
        jat = 0;
        tmp = "";
        geom = null;
        try {
            geom = structure.getGeometry();
        }
        catch (GeometryException e) {
            throw new ReadGaussianException(e);
        }
        if (bonds[0].toLowerCase().equals("bond")) ** GOTO lbl58
        throw new ReadGaussianException("Error in Bond section between lines " + rememberLine + " and " + this.sectionReader.getLineNumber() + " : the section must begin with the keyword \"" + "bond" + "\"");
lbl-1000:
        // 1 sources

        {
            try {
                tmp = bonds[++i];
                iat = Integer.parseInt(tmp);
                tmp = bonds[++i];
                jat = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e) {
                throw new ReadGaussianException("Error in reading the Bond section between lines " + rememberLine + " and " + this.sectionReader.getLineNumber() + " : atom number expected instead of \"" + tmp + "\" word for structure " + structure.getName());
            }
            bondType = 0;
            atom1 = geom.getAtomBySuperSymbol(iat);
            atom2 = geom.getAtomBySuperSymbol(jat);
            if (atom1 == null) {
                throw new ReadGaussianException("Error in reading the Bond section between lines " + rememberLine + " and " + this.sectionReader.getLineNumber() + " : atom " + iat + " not found in the structure " + structure.getName() + " that contains " + structure.countAtoms() + " atom(s)");
            }
            if (atom2 == null) {
                throw new ReadGaussianException("Error in reading the Bond section between lines " + rememberLine + " and " + this.sectionReader.getLineNumber() + " : atom " + jat + " not found in the structure " + structure.getName() + " that contains " + structure.countAtoms() + " atom(s)");
            }
            if (type.toLowerCase().equals("s")) {
                bondType = 1;
            } else if (type.toLowerCase().equals("d")) {
                bondType = 2;
            } else {
                throw new ReadGaussianException("Error in reading the Bond section between lines " + rememberLine + " and " + this.sectionReader.getLineNumber() + " : no such bondType : \"" + bondType + "\" between atom " + iat + " and " + jat + " in the structure " + structure.getName() + "\"s\" or \"d\" keywords expected");
            }
            l = geom.getBond(atom1, atom2);
            if (l == null) {
                if (!(atom1 instanceof HuckelAtom) || !(atom2 instanceof HuckelAtom)) continue;
                ((HuckelAtom)atom1).setRadR(1);
                ((HuckelAtom)atom2).setRadR(1);
                continue;
            }
            if (l instanceof HuckelBond) {
                ((HuckelBond)l).setBondType(bondType);
                continue;
            }
            if (l instanceof VirtualBond) {
                vb = (VirtualBond)l;
                vb.setBondType(bondType);
                b = structure.getBond(vb.getSubistutuedME(), vb.getSubistutuedME().getNeighbours().get(0));
                ((HuckelBond)b).setBondType(bondType);
                continue;
            }
            if (bondType == 1) continue;
            throw new ReadGaussianException("Error in reading the Bond section between lines " + rememberLine + " and " + this.sectionReader.getLineNumber() + " : S expected for the bond " + l + " betwwen atoms " + iat + " and " + jat + " in the structure " + structure.getName());
lbl58:
            // 6 sources

            ** while (!(type = bonds[++i]).toLowerCase().equals((Object)"end"))
        }
lbl59:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    private void readLONE(StructureLocalized structure) throws ReadGaussianException, HuckelAtomException {
        rememberLine = this.sectionReader.getLineNumber();
        try {
            pairs = this.sectionReader.readSectionUntilEnd("end");
        }
        catch (ReadSectionException e1) {
            throw new ReadGaussianException(e1);
        }
        i = 0;
        iat = 0;
        npair = 0;
        tmp = "";
        try {
            geom = structure.getGeometry();
        }
        catch (GeometryException e) {
            throw new ReadGaussianException(e);
        }
        if (pairs[0].toLowerCase().equals("lone")) ** GOTO lbl39
        throw new ReadGaussianException("Error in Lone section between lines " + rememberLine + " and " + this.sectionReader.getLineNumber() + " : the section must begin with the keyword \"" + "lone" + "\"");
lbl-1000:
        // 1 sources

        {
            try {
                tmp = pairs[++i];
                iat = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e) {
                throw new ReadGaussianException("Error in reading the Lone section between lines " + rememberLine + " and " + this.sectionReader.getLineNumber() + " : atom number expected instead of \"" + tmp + "\" word for structure " + structure.getName());
            }
            try {
                tmp = pairs[++i];
                npair = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e) {
                throw new ReadGaussianException("Error in reading the Lone section between lines " + rememberLine + " and " + this.sectionReader.getLineNumber() + " : number of pair electrons expected instead of \"" + tmp + "\" word for structure " + structure.getName());
            }
            atom = geom.getAtomBySuperSymbol(iat);
            if (atom == null) {
                throw new ReadGaussianException("Error in reading the Lone section between lines " + rememberLine + " and " + this.sectionReader.getLineNumber() + " : atom " + iat + " not found in structure " + structure.getName() + " that contains " + structure.countAtoms() + " atom(s)");
            }
            if (atom instanceof HuckelAtom) {
                this.setRadR((HuckelAtom)atom, npair);
                if (atom.getElement() != PeriodicTable.Element.C || structure.getAtomBySuperSymbol(atom.getSuperSymbol()).getElement() != PeriodicTable.Element.Me) continue;
                this.setRadR((HuckelAtom)structure.getAtomBySuperSymbol(atom.getSuperSymbol()), npair);
                continue;
            }
            throw new ReadGaussianException("Error in reading the Lone section between lines " + rememberLine + " and " + this.sectionReader.getLineNumber() + " : cannot put " + npair + " pairs on the atom " + iat + " in structure " + structure.getName() + " because it is of element " + (Object)atom.getElement());
lbl39:
            // 3 sources

            ** while (!pairs[i + 1].toLowerCase().equals((Object)"end"))
        }
lbl40:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    private void readNRTSTR_Namelist() throws ReadGaussianException, HuckelBondException, MesomeryDelocalizedStructureNotExistsException, CoupleException, IMethodException, MesomeryNoStructureLocalizedException, HuckelAtomException {
        if (this.mesomery.getDelocalizedStructure() == null) {
            throw new MesomeryDelocalizedStructureNotExistsException("Cannot create mesomery : delocalized structure does not exist.");
        }
        keyword = "";
        try {
            keyword = this.sectionReader.getNextKeyword();
        }
        catch (ReadSectionException e) {
            throw new ReadGaussianException(e);
        }
        if (!keyword.toLowerCase().equals("$nrtstr")) {
            throw new ReadGaussianException("Keyword \"$nrtstr\" expected line " + this.sectionReader.getLineNumber() + " in namelist NRTSTR instead of \"" + keyword + "\"");
        }
        try {
            keyword = this.sectionReader.getNextKeyword();
        }
        catch (ReadSectionException e) {
            throw new ReadGaussianException(e);
        }
        if (keyword.toLowerCase().equals("str") || keyword.toLowerCase().equals("$end")) ** GOTO lbl31
        throw new ReadGaussianException("Keywords \"str\" or \"$end\" expected at line " + this.sectionReader.getLineNumber() + " instead of \"" + keyword + "\"");
lbl-1000:
        // 1 sources

        {
            isBLWSection = this.readSTR();
            try {
                keyword = !isBLWSection ? "end" : this.sectionReader.getNextKeyword();
            }
            catch (ReadSectionException e) {
                throw new ReadGaussianException(e);
            }
            if (!keyword.toLowerCase().equals("end")) {
                throw new ReadGaussianException("Keyword \"end\" expected at line " + this.sectionReader.getLineNumber() + " in namelist NRTSTR instead of \"" + keyword + "\"");
            }
            try {
                keyword = this.sectionReader.getNextKeyword();
                continue;
            }
            catch (ReadSectionException e) {
                throw new ReadGaussianException(e);
            }
lbl31:
            // 2 sources

            ** while (keyword.toLowerCase().equals((Object)"str"))
        }
lbl32:
        // 1 sources

    }

    protected boolean readSTR() throws MesomeryDelocalizedStructureNotExistsException, CoupleException, IMethodException, MesomeryNoStructureLocalizedException, ReadGaussianException, HuckelAtomException, HuckelBondException {
        StructureLocalized structure = this.mesomery.createLocalizedStructure();
        this.readLONE(structure);
        this.readBOND(structure);
        boolean isBLWSection = this.readBLW(structure);
        return isBLWSection;
    }

    private boolean readBLW(StructureLocalized structure) throws ReadGaussianException {
        String[] line;
        String keyword = "";
        try {
            keyword = this.sectionReader.getNextKeyword();
        }
        catch (ReadSectionException e) {
            throw new ReadGaussianException(e);
        }
        if (keyword.toLowerCase().equals("end")) {
            return false;
        }
        if (!keyword.toLowerCase().equals("$blw") && !keyword.toLowerCase().equals("end")) {
            throw new ReadGaussianException("Keyword \"$blw\" expected line " + this.sectionReader.getLineNumber() + " in namelist NRTSTR instead of \"" + keyword + "\"");
        }
        int nBlocksDeclares = 0;
        try {
            line = this.sectionReader.getLine();
        }
        catch (ReadSectionException e) {
            throw new ReadGaussianException("number of blocks expected at " + this.sectionReader.getLineNumber() + " " + e.getMessage());
        }
        if (line.length != 1) {
            throw new ReadGaussianException("number of blocks expected at " + this.sectionReader.getLineNumber() + " instead of " + line);
        }
        nBlocksDeclares = Integer.valueOf(line[0]);
        try {
            keyword = this.sectionReader.getNextKeyword();
        }
        catch (ReadSectionException e) {
            throw new ReadGaussianException(e);
        }
        if (!keyword.toLowerCase().equals("$end")) {
            throw new ReadGaussianException("Keyword \"$end\" expected line " + this.sectionReader.getLineNumber() + " in namelist NRTSTR instead of \"" + keyword + "\"");
        }
        try {
            keyword = this.sectionReader.getNextKeyword();
        }
        catch (ReadSectionException e) {
            throw new ReadGaussianException(e);
        }
        if (!keyword.toLowerCase().equals("$blwdat")) {
            throw new ReadGaussianException("Keyword \"$blwdat\" expected line " + this.sectionReader.getLineNumber() + " in namelist NRTSTR instead of \"" + keyword + "\"");
        }
        int iterations = 0;
        int nbElecLu = 0;
        int nbAtomLu = 0;
        while (iterations < nBlocksDeclares) {
            Atom a2;
            int i2;
            try {
                line = this.sectionReader.getLine();
            }
            catch (ReadSectionException e) {
                throw new ReadGaussianException("NbElec NbAtom expected at " + this.sectionReader.getLineNumber() + " " + e.getMessage());
            }
            if (line.length == 1 && line[0].equals("$end") && iterations != nBlocksDeclares) {
                throw new ReadGaussianException("$end reached but " + iterations + "blocks read instead of  " + nBlocksDeclares + " expected at line " + this.sectionReader.getLineNumber());
            }
            if (line.length != 2) {
                throw new ReadGaussianException("NbElec NbAtom expected at " + this.sectionReader.getLineNumber() + " instead of " + line);
            }
            nbElecLu = Integer.valueOf(line[0]);
            nbAtomLu = Integer.valueOf(line[1]);
            ArrayList<IHuckelObject> huckelObjects = new ArrayList<IHuckelObject>();
            try {
                line = this.sectionReader.getLine();
            }
            catch (ReadSectionException e) {
                throw new ReadGaussianException("atom1 atom2 atom3... expected at " + this.sectionReader.getLineNumber() + " " + e.getMessage());
            }
            if (line.length != nbAtomLu) {
                throw new ReadGaussianException(String.valueOf(line.length) + " atoms read, instead of " + nbAtomLu + " expected at " + this.sectionReader.getLineNumber());
            }
            if (nbElecLu >= 0 && nbAtomLu > 0) {
                i2 = 0;
                while (i2 < line.length) {
                    Atom a1 = structure.getAtomByIndex(Integer.valueOf(line[i2]));
                    if (!(a1 instanceof HuckelAtom)) {
                        throw new ReadGaussianException(String.valueOf(line.length) + "cannot create block - atom index =" + i2 + " " + a1 + " huckel atom expected" + this.sectionReader.getLineNumber());
                    }
                    HuckelAtom hA1 = (HuckelAtom)a1;
                    if (hA1.countRadR() == 0 && !huckelObjects.contains(hA1)) {
                        huckelObjects.add(hA1);
                    }
                    int j = i2 + 1;
                    while (j < line.length) {
                        if (i2 != j) {
                            Bond b;
                            a2 = structure.getAtomByIndex(Integer.valueOf(line[j]));
                            if (!(a2 instanceof HuckelAtom)) {
                                throw new ReadGaussianException(String.valueOf(line.length) + "cannot create block - atom index =" + j + " " + a2 + " huckel atom expected" + this.sectionReader.getLineNumber());
                            }
                            HuckelAtom hA2 = (HuckelAtom)a2;
                            if (hA2.countRadR() == 0 && !huckelObjects.contains(hA2)) {
                                huckelObjects.add(hA2);
                            }
                            if ((b = structure.getBond(hA1, hA2)) != null) {
                                if (!(b instanceof HuckelBond)) {
                                    throw new ReadGaussianException("atoms (" + i2 + ", " + j + ") : huckel bond expected at " + this.sectionReader.getLineNumber());
                                }
                                HuckelBond huckelBond = (HuckelBond)b;
                                if (huckelBond.getBondType() < 2 && !huckelObjects.contains(huckelBond) && huckelObjects.contains(hA1) && huckelObjects.contains(hA2)) {
                                    huckelObjects.add(huckelBond);
                                }
                            }
                        }
                        ++j;
                    }
                    ++i2;
                }
            }
            try {
                line = this.sectionReader.getLine();
            }
            catch (ReadSectionException e) {
                throw new ReadGaussianException("exepected pair of atom exclusion, block" + iterations + " at line " + this.sectionReader.getLineNumber() + " " + e.getMessage());
            }
            if (line.length == 0 || !line[0].equals("0")) {
                throw new ReadGaussianException("the line must start with 0, block " + iterations + " at line " + this.sectionReader.getLineNumber());
            }
            if ((line.length - 1) % 2 != 0) {
                throw new ReadGaussianException("expected even number, block " + iterations + " at line " + this.sectionReader.getLineNumber());
            }
            i2 = 1;
            while (i2 < line.length) {
                int iA1 = Integer.parseInt(line[i2++]);
                Atom a1 = structure.getAtomByIndex(iA1);
                int iA2 = Integer.parseInt(line[i2++]);
                a2 = structure.getAtomByIndex(iA2);
                try {
                    huckelObjects.remove(new HuckelBond((HuckelAtom)a1, (HuckelAtom)a2));
                }
                catch (BondException e1) {
                    throw new ReadGaussianException("expected huckel Bond " + iA1 + "-" + iA2 + " block " + iterations + " at line " + this.sectionReader.getLineNumber());
                }
            }
            if (huckelObjects.size() > 0) {
                try {
                    structure.addBlocDelocalized(new BlocDelocalized(huckelObjects, nbElecLu));
                }
                catch (BlocDelocalizedException e) {
                    throw new ReadGaussianException("error in creating block " + iterations + " at line " + this.sectionReader.getLineNumber() + " " + e.getMessage());
                }
            }
            ++iterations;
        }
        try {
            keyword = this.sectionReader.getNextKeyword();
        }
        catch (ReadSectionException e) {
            throw new ReadGaussianException(e);
        }
        if (!keyword.toLowerCase().equals("$end")) {
            throw new ReadGaussianException("Keyword \"$end\" expected at line " + this.sectionReader.getLineNumber() + " in namelist NRTSTR instead of \"" + keyword + "\"");
        }
        return true;
    }

    protected void setRadR(HuckelAtom a, int npair) throws HuckelAtomException {
        a.setRadR((npair - a.getNbElecSigma() / 2) * 2);
    }
}

