/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.files.gaussian;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import org.ctom.hulis.files.ReadSectionException;
import org.ctom.hulis.files.SectionReader;
import org.ctom.hulis.files.gaussian.GaussianReadXYZ;
import org.ctom.hulis.files.gaussian.IGaussianConstants;
import org.ctom.hulis.files.gaussian.NRTSTRreader;
import org.ctom.hulis.files.gaussian.ReadGaussianException;
import org.ctom.hulis.files.xyz.ReadxyzException;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.exception.BondException;
import org.ctom.hulis.huckel.exception.CoupleException;
import org.ctom.hulis.huckel.exception.HuckelAtomException;
import org.ctom.hulis.huckel.exception.HuckelBondException;
import org.ctom.hulis.huckel.exception.HulisException;
import org.ctom.hulis.huckel.exception.IMethodException;
import org.ctom.hulis.huckel.exception.MesomeryDelocalizedStructureExistsException;
import org.ctom.hulis.huckel.exception.MesomeryDelocalizedStructureNotExistsException;
import org.ctom.hulis.huckel.exception.MesomeryNoStructureLocalizedException;
import org.ctom.hulis.huckel.exception.MoleculeBondExistsException;
import org.ctom.hulis.huckel.exception.MoleculeCoherenceException;
import org.ctom.hulis.huckel.exception.MoleculeTooManyNeighboursException;
import org.ctom.hulis.huckel.structures.StructureDelocalized;

public class ReadGaussian
implements IGaussianConstants {
    int charge;
    private ArrayList<String> header = null;
    protected Mesomery mesomery;
    int multiplicity;
    protected boolean SWITCH_NRT = false;
    StringBuffer xyz;
    StreamTokenizer tokenizer;
    protected SectionReader sectionReader;

    public ReadGaussian(File file) throws FileNotFoundException {
        FileReader fileReader = new FileReader(file);
        this.tokenizer = new StreamTokenizer(fileReader);
        this.sectionReader = new SectionReader(new LineNumberReader(fileReader));
    }

    public ReadGaussian(String str) {
        StringReader stringReader = new StringReader(str);
        this.tokenizer = new StreamTokenizer(stringReader);
        this.sectionReader = new SectionReader(new LineNumberReader(stringReader));
    }

    private void bufferizeXYZ() throws ReadGaussianException {
        try {
            while (true) {
                String line;
                if ((line = this.sectionReader.getWholeLine()) == null || line.length() == 0) {
                    return;
                }
                this.xyz.append(String.valueOf(line) + "\n");
            }
        }
        catch (ReadSectionException e) {
            throw new ReadGaussianException(e);
        }
    }

    public void readAll(Mesomery mesomery) throws ReadGaussianException {
        this.header = new ArrayList();
        this.mesomery = mesomery;
        this.xyz = new StringBuffer();
        try {
            this.readAll();
        }
        catch (HuckelBondException e) {
            throw new ReadGaussianException(e);
        }
        catch (BondException e) {
            throw new ReadGaussianException(e);
        }
        catch (MesomeryDelocalizedStructureExistsException e) {
            throw new ReadGaussianException(e);
        }
        catch (MoleculeTooManyNeighboursException e) {
            throw new ReadGaussianException(e);
        }
        catch (MoleculeBondExistsException e) {
            throw new ReadGaussianException(e);
        }
        catch (MoleculeCoherenceException e) {
            throw new ReadGaussianException(e);
        }
        catch (ReadxyzException e) {
            throw new ReadGaussianException(e);
        }
        catch (MesomeryDelocalizedStructureNotExistsException e) {
            throw new ReadGaussianException(e);
        }
        catch (CoupleException e) {
            throw new ReadGaussianException(e);
        }
        catch (IMethodException e) {
            throw new ReadGaussianException(e);
        }
        catch (MesomeryNoStructureLocalizedException e) {
            throw new ReadGaussianException(e);
        }
        catch (HuckelAtomException e) {
            throw new ReadGaussianException(e);
        }
        catch (NumberFormatException e) {
            throw new ReadGaussianException(e);
        }
        catch (HulisException e) {
            throw new ReadGaussianException(e);
        }
    }

    protected void readAll() throws ReadGaussianException, HuckelBondException, BondException, MesomeryDelocalizedStructureExistsException, MoleculeTooManyNeighboursException, MoleculeBondExistsException, MoleculeCoherenceException, ReadxyzException, MesomeryDelocalizedStructureNotExistsException, CoupleException, IMethodException, MesomeryNoStructureLocalizedException, HuckelAtomException, NumberFormatException, HulisException {
        this.readHeader();
        this.readChargeMultiplicity();
        this.readXYZ();
        this.readNRT();
    }

    protected void readXYZ() throws HuckelBondException, BondException, MesomeryDelocalizedStructureExistsException, MoleculeTooManyNeighboursException, MoleculeBondExistsException, MoleculeCoherenceException, ReadGaussianException, ReadxyzException {
        this.bufferizeXYZ();
        this.tokenizer = new StreamTokenizer(new StringReader(this.xyz.toString()));
        GaussianReadXYZ gaussianReadXYZ = new GaussianReadXYZ(this.tokenizer);
        this.mesomery.addDelocalizedStruct(new StructureDelocalized(gaussianReadXYZ));
        this.mesomery.getDelocalizedStructure().setNbElecCharge(-this.charge);
    }

    protected void readChargeMultiplicity() throws ReadGaussianException {
        String line;
        try {
            line = this.sectionReader.getWholeLine();
        }
        catch (ReadSectionException e) {
            throw new ReadGaussianException(e);
        }
        String error = "The line " + this.sectionReader.getLineNumber() + " must contains two numbers (charge and multiplicity) delimited by a space";
        if (line == null) {
            throw new ReadGaussianException(error);
        }
        String[] s = line.split(" ");
        if (s.length != 2) {
            throw new ReadGaussianException(error);
        }
        this.charge = Integer.valueOf(s[0]);
        this.multiplicity = Integer.valueOf(s[1]);
    }

    protected ArrayList<String> readHeader() throws ReadGaussianException {
        int nEmptyLine = 0;
        while (nEmptyLine < 2) {
            String line = null;
            try {
                line = this.sectionReader.getWholeLine();
            }
            catch (ReadSectionException e) {
                throw new ReadGaussianException(e);
            }
            if (line != null) {
                line = line.trim();
            }
            this.header.add(line);
            if (line != null && line.length() != 0) continue;
            ++nEmptyLine;
        }
        return this.header;
    }

    protected Mesomery getMesomery() {
        return this.mesomery;
    }

    protected void readNRT() throws ReadGaussianException, HuckelBondException, MesomeryDelocalizedStructureNotExistsException, CoupleException, IMethodException, MesomeryNoStructureLocalizedException, HuckelAtomException {
        this.SWITCH_NRT = this.readNBO_Namelist();
        if (!this.SWITCH_NRT) {
            return;
        }
        new NRTSTRreader(this.mesomery, this.sectionReader).readAll();
    }

    protected boolean readNBO_Namelist() throws ReadGaussianException {
        String[] words = null;
        try {
            words = this.sectionReader.readSectionUntilEnd("$end");
        }
        catch (ReadSectionException e) {
            return false;
        }
        if (!words[0].toLowerCase().equals("$nbo")) {
            return false;
        }
        boolean nrt = false;
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (word.toLowerCase().toLowerCase().equals("nrt")) {
                nrt = true;
                break;
            }
            ++n2;
        }
        if (!words[words.length - 1].equals("$end")) {
            throw new ReadGaussianException("Keyword \"$end\" expected at line " + this.sectionReader.getLineNumber() + " in namelist NRTSTR  instead of  \"" + words[words.length - 1] + "\"");
        }
        return nrt;
    }
}

