/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.files.gaussian;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import org.ctom.hulis.files.gaussian.BondNRT;
import org.ctom.hulis.files.gaussian.GaussianWriteXYZ;
import org.ctom.hulis.files.gaussian.IGaussianConstants;
import org.ctom.hulis.files.gaussian.LonePairNRT;
import org.ctom.hulis.files.xyz.WritexyzException;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.BlocDelocalized;
import org.ctom.hulis.huckel.Bond;
import org.ctom.hulis.huckel.HuckelAtom;
import org.ctom.hulis.huckel.HuckelBond;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.PeriodicTable;
import org.ctom.hulis.huckel.exception.GeometryException;
import org.ctom.hulis.huckel.exception.HuckelBondException;
import org.ctom.hulis.huckel.methods.IMethod;
import org.ctom.hulis.huckel.structures.StructureDelocalized;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import org.ctom.hulis.util.geometry.Geometry;
import org.ctom.hulis.util.geometry.VirtualBond;
import org.ctom.hulis.util.io.HuckelIO;
import org.ctom.util.format.DefaultNumberFormater;
import org.ctom.util.format.NumberFormater;

public class WriteGaussian
implements IGaussianConstants {
    Mesomery mesomery;
    NumberFormater numberFormater;
    private boolean isWriteInitialOrientation;
    private String messageHeader;
    private boolean isWriteConnectivity;

    public WriteGaussian(Mesomery m) {
        this.mesomery = m;
        this.numberFormater = new DefaultNumberFormater();
        this.isWriteInitialOrientation = false;
        this.messageHeader = "";
        this.isWriteConnectivity = false;
    }

    public void writeAll(PrintWriter out) throws WritexyzException {
        this.writeAll(this.mesomery, out);
    }

    public void setNumberFormater(NumberFormater numberFormater) {
        this.numberFormater = numberFormater;
    }

    public void setMessageHeader(String messageHeader) {
        this.messageHeader = messageHeader;
    }

    public String getMessageHeader() {
        return this.messageHeader;
    }

    protected void writeAll(Mesomery m, PrintWriter out) throws WritexyzException {
        this.writeXYZ(m.getDelocalizedStructure(), out);
        this.writeNBOList(out);
        this.writeNRTList(m, out);
    }

    protected void writeHX(StructureDelocalized s, PrintWriter out) {
        out.print(" ! " + "hx".toUpperCase());
        for (HuckelAtom a : s.getHuckelAtoms()) {
            if (a.getHx() == ((HuckelAtom)PeriodicTable.getNewAtom(a.getEntry())).getHx()) continue;
            out.print(" " + a.getSuperSymbol() + " " + a.getHx());
        }
        out.print(" " + "end".toUpperCase() + "\n");
    }

    protected void writeHXY(StructureDelocalized s, PrintWriter out) {
        out.print(" ! " + "hxy".toUpperCase());
        for (HuckelBond b : s.getHuckelBonds()) {
            try {
                if (b.getAtom1().getEntry() == null || b.getAtom2().getEntry() == null || b.getHxy() == HuckelBond.getHxy(b.getAtom1().getEntry(), b.getAtom2().getEntry())) continue;
                out.print(" " + b.getHxy() + " " + b.getAtom1().getSuperSymbol() + " " + b.getAtom2().getSuperSymbol());
            }
            catch (HuckelBondException e) {
                HuckelIO.error(this.getClass().getName(), "writeHXY", e.getMessage(), e);
                e.printStackTrace();
            }
        }
        out.print(" " + "end".toUpperCase() + "\n");
    }

    public void setWriteInitialOrientation(boolean isWriteInitialOrientation) {
        this.isWriteInitialOrientation = isWriteInitialOrientation;
    }

    public boolean isWriteInitialOrientation() {
        return this.isWriteInitialOrientation;
    }

    protected void writeXYZ(StructureDelocalized s, PrintWriter out) throws WritexyzException {
        GaussianWriteXYZ gaussianWriteXYZ = new GaussianWriteXYZ(s);
        String header = this.getMessageHeader();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printwriter = new PrintWriter(stringWriter);
        printwriter.println(header);
        this.writeHX(s, printwriter);
        this.writeHXY(s, printwriter);
        gaussianWriteXYZ.setMessageHeader(header);
        gaussianWriteXYZ.setWriteInitialOrientation(this.isWriteInitialOrientation());
        gaussianWriteXYZ.setWriteConnectivity(this.isWriteConnectivity());
        gaussianWriteXYZ.writeAll(out);
        out.println();
    }

    public boolean isWriteConnectivity() {
        return this.isWriteConnectivity;
    }

    public void setWriteConnectivity(boolean isWriteConnectivity) {
        this.isWriteConnectivity = isWriteConnectivity;
    }

    protected void writeNBOList(PrintWriter out) {
        if (this.mesomery.countSelectedLocalizedStructs() > 0) {
            out.print("$nbo ");
            out.print("nrt ");
            out.print("$end\n");
        }
    }

    protected void writeNRTList(Mesomery m, PrintWriter out) {
        if (this.mesomery.countSelectedLocalizedStructs() > 0) {
            String trustFactor = "";
            IMethod[] iMethodArray = this.mesomery.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (method.isImplementedTau()) {
                    trustFactor = String.valueOf(trustFactor) + this.numberFormater.formatNumber(method.getTau() * 100.0) + "% (" + method.getName() + ") ";
                }
                ++n2;
            }
            out.println(String.valueOf("$nrtstr".toUpperCase()) + " ! Trust factor = " + trustFactor);
            for (StructureLocalized s : m.getSelectedLocalizedStructures()) {
                this.writeNRT(s, out, 2);
            }
            out.println("$end".toUpperCase());
            out.println();
        }
    }

    protected void writeNRT(StructureLocalized s, PrintWriter out, int nbCarIndent) {
        String indent = "";
        int i2 = 0;
        while (i2 < nbCarIndent) {
            indent = String.valueOf(indent) + " ";
            ++i2;
        }
        double weight = 0.0;
        String weights = "";
        Geometry geom = null;
        try {
            geom = s.getGeometry();
        }
        catch (GeometryException e) {
            out.println("Error getting the structure geometry of Psi" + s.getName() + " : error : " + e.getMessage());
            e.printStackTrace();
            return;
        }
        IMethod[] iMethodArray = this.mesomery.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            weight = s.getWeight(method.getName());
            weights = String.valueOf(weights) + this.numberFormater.formatNumber(weight * 100.0) + "% (" + method.getName() + ") ";
            ++n2;
        }
        out.print(String.valueOf(indent) + "str".toUpperCase() + "        ! HuLiS Wgt = " + weights + " S" + s.getName() + "\n" + indent + "  " + "lone".toUpperCase());
        ArrayList<LonePairNRT> lones = new ArrayList<LonePairNRT>();
        for (Atom a : geom.getGeom3D()) {
            HuckelAtom huckelAtom;
            int nPairs;
            if (!(a instanceof HuckelAtom) || (nPairs = this.getNbPairs(huckelAtom = (HuckelAtom)a)) <= 0) continue;
            lones.add(new LonePairNRT(huckelAtom.getSuperSymbol(), nPairs));
        }
        Collections.sort(lones);
        for (LonePairNRT lone : lones) {
            out.print(" " + lone.toString());
        }
        out.print(" " + "end".toUpperCase() + "\n" + indent + "  " + "bond".toUpperCase());
        ArrayList<BondNRT> bondsNRT = new ArrayList<BondNRT>();
        HuckelAtom[] couple = s.guessCouple();
        if (couple != null) {
            bondsNRT.add(new BondNRT(couple[0].getSuperSymbol(), couple[1].getSuperSymbol(), "S"));
        }
        for (Bond b : geom.getBonds3D()) {
            VirtualBond vb;
            HuckelBond hb;
            String type = b instanceof HuckelBond ? ((hb = (HuckelBond)b).getBondType() == 2 ? "D" : "S") : (b instanceof VirtualBond ? ((vb = (VirtualBond)b).getBondType() == 2 ? "D" : "S") : "S");
            bondsNRT.add(new BondNRT(b.getAtom1().getSuperSymbol(), b.getAtom2().getSuperSymbol(), type));
        }
        Collections.sort(bondsNRT);
        for (BondNRT bondNRT : bondsNRT) {
            out.print(" " + bondNRT.toString());
        }
        out.println(" " + "end".toUpperCase());
        this.writeBLW(s, out, 4);
        out.println(String.valueOf(indent) + "end".toUpperCase());
    }

    protected void writeBLW(StructureLocalized s, PrintWriter out, int nbCarIndent) {
        ArrayList<BlocDelocalized> blocks = s.getListBlocDelocalized();
        if (blocks.isEmpty()) {
            return;
        }
        String indent = "";
        int i2 = 0;
        while (i2 < nbCarIndent) {
            indent = String.valueOf(indent) + " ";
            ++i2;
        }
        out.print(String.valueOf(indent) + "$blw".toUpperCase() + "\n");
        out.print(String.valueOf(indent) + "  " + blocks.size() + "\n");
        out.print(String.valueOf(indent) + "$end".toUpperCase() + "\n");
        out.print(String.valueOf(indent) + "$blwdat".toUpperCase() + "\n");
        for (BlocDelocalized block : blocks) {
            out.print(String.valueOf(indent) + "  " + block.getNbElectron() + " " + block.getListHuckelAtom().size() + "\n");
            out.print(String.valueOf(indent) + " ");
            ArrayList<HuckelBond> excludes = new ArrayList<HuckelBond>();
            for (HuckelAtom a : block.getListHuckelAtom()) {
                out.print(" " + a.getSuperSymbol());
                for (Bond b : a.getBonds()) {
                    HuckelBond huckelBond;
                    if (!(b instanceof HuckelBond) || excludes.contains(huckelBond = (HuckelBond)b) || !block.containsHuckelObject(a) || !block.containsHuckelObject((HuckelAtom)b.getAtomLinkedWith(a)) || block.containsHuckelObject(huckelBond)) continue;
                    excludes.add(huckelBond);
                }
            }
            out.print("\n");
            String sExcludes = "";
            for (HuckelBond b : excludes) {
                sExcludes = String.valueOf(sExcludes) + "  " + b.getAtom1().getSuperSymbol() + " " + b.getAtom2().getSuperSymbol();
            }
            out.println(String.valueOf(indent) + "  0" + sExcludes);
        }
        out.println(String.valueOf(indent) + "$end".toUpperCase());
    }

    protected int getNbPairs(HuckelAtom a) {
        return (a.getNbRadR() + a.getNbElecSigma()) / 2;
    }
}

