/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.files.gaussian.test;

import java.io.PrintWriter;
import org.ctom.hulis.files.gaussian.WriteGaussian;
import org.ctom.hulis.files.gaussian.WriteGaussianException;
import org.ctom.hulis.files.xyz.WritexyzException;
import org.ctom.hulis.huckel.HuckelAtom;
import org.ctom.hulis.huckel.HuckelBond;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.PeriodicTable;
import org.ctom.hulis.huckel.exception.HuckelBondException;
import org.ctom.hulis.huckel.structures.StructureDelocalized;
import org.ctom.hulis.util.io.HuckelIO;

public class WriteGaussianTest
extends WriteGaussian {
    public static final String KEYWORD_HX = "hx";
    public static final String KEYWORD_HXY = "hxy";

    @Override
    protected int getNbPairs(HuckelAtom a) {
        return a.getNbRadR();
    }

    public WriteGaussianTest(Mesomery m) throws WriteGaussianException {
        super(m);
        this.setWriteConnectivity(true);
    }

    @Override
    protected void writeAll(Mesomery m, PrintWriter out) throws WritexyzException {
        this.writeXYZ(m.getDelocalizedStructure(), out);
        this.writeHX(m.getDelocalizedStructure(), out);
        this.writeHXY(m.getDelocalizedStructure(), out);
        this.writeNBOList(out);
        this.writeNRTList(m, out);
    }

    @Override
    protected void writeHX(StructureDelocalized s, PrintWriter out) {
        out.print(KEYWORD_HX.toUpperCase());
        for (HuckelAtom a : s.getHuckelAtoms()) {
            if (a.getHx() == ((HuckelAtom)PeriodicTable.getNewAtom(a.getEntry())).getHx()) continue;
            out.print(" " + a.getSuperSymbol() + " " + a.getHx());
        }
        out.print(" " + "end".toUpperCase() + "\n");
    }

    @Override
    protected void writeHXY(StructureDelocalized s, PrintWriter out) {
        out.print(KEYWORD_HXY.toUpperCase());
        for (HuckelBond b : s.getHuckelBonds()) {
            try {
                if (b.getAtom1().getEntry() == null || b.getAtom2().getEntry() == null || b.getHxy() == HuckelBond.getHxy(b.getAtom1().getEntry(), b.getAtom2().getEntry())) continue;
                out.print(" " + b.getHxy() + " " + b.getAtom1().getSuperSymbol() + " " + b.getAtom2().getSuperSymbol());
            }
            catch (HuckelBondException e) {
                HuckelIO.error(this.getClass().getName(), "writeHXY", e.getMessage(), e);
                e.printStackTrace();
            }
        }
        out.print(" " + "end".toUpperCase() + "\n");
    }
}

