/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.files.xml;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ctom.hulis.files.xml.XMLElements;
import org.ctom.hulis.files.xyz.GeometryReader;
import org.ctom.hulis.files.xyz.ReadxyzException;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.PeriodicTable;
import org.ctom.hulis.util.geometry.Geometry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Readxml
extends GeometryReader {
    Document dom;
    private Geometry geom;
    File file;

    public Readxml(File file) {
        this.file = file;
        this.geom = new Geometry();
        this.parseXmlFile();
        this.parseDocument();
        this.geom.generateConnectivity();
    }

    @Override
    public void readAll(Geometry geometry) throws ReadxyzException {
        geometry = this.geom;
    }

    private void parseXmlFile() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.dom = db.parse(this.file);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void parseDocument() {
        Element docEle = this.dom.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName(XMLElements.Atom.toString());
        if (nl != null && nl.getLength() > 0) {
            int i2 = 0;
            while (i2 < nl.getLength()) {
                Element el = (Element)nl.item(i2);
                Atom at = this.getAtom(el);
                this.geom.add(at);
                ++i2;
            }
        }
    }

    private Atom getAtom(Element atEl) {
        String name = this.getTextValue(atEl, XMLElements.Atom.toString());
        double x = this.getDoubleValue(atEl, XMLElements.X.toString());
        double y = this.getDoubleValue(atEl, XMLElements.Y.toString());
        double z = this.getDoubleValue(atEl, XMLElements.Z.toString());
        Atom at = new Atom(0, PeriodicTable.Entry.valueOf(name), PeriodicTable.Element.valueOf(name), name, name, 1, 0);
        this.setX(at, x);
        this.setY(at, y);
        this.setZ(at, z);
        return at;
    }

    private double getDoubleValue(Element ele, String tagName) {
        return Double.parseDouble(this.getTextValue(ele, tagName));
    }

    private String getTextValue(Element ele, String tagName) {
        String textVal = null;
        NodeList nl = ele.getElementsByTagName(tagName);
        if (nl != null && nl.getLength() > 0) {
            Element el = (Element)nl.item(0);
            textVal = el.getFirstChild().getNodeValue();
        }
        return textVal;
    }

    public Geometry getGeometry() {
        return this.geom;
    }
}

