/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.files.xml;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.File;
import java.io.FileOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ctom.hulis.files.xml.XMLElements;
import org.ctom.hulis.files.xml.XMLTypes;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.HuckelAtom;
import org.ctom.hulis.huckel.Molecule;
import org.ctom.hulis.huckel.PeriodicTable;
import org.ctom.hulis.huckel.exception.BondException;
import org.ctom.hulis.huckel.exception.HuckelBondException;
import org.ctom.hulis.huckel.exception.MoleculeBondExistsException;
import org.ctom.hulis.huckel.exception.MoleculeCoherenceException;
import org.ctom.hulis.huckel.exception.MoleculeTooManyNeighboursException;
import org.ctom.hulis.util.geometry.Geometry;
import org.ctom.hulis.util.io.HuckelIO;
import org.ctom.util.maths.Point3D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Writexml {
    Document dom;
    private Geometry geom;
    File file;
    Molecule molecule;

    public Writexml(Molecule molecule, File file) {
        this.file = file;
        this.molecule = molecule;
        this.createDocument();
        this.createDOMTree();
        this.printToFile();
    }

    private void createDocument() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.dom = db.newDocument();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            HuckelIO.error(this.getClass().toString(), "createDocument", "Error creating the dom");
        }
    }

    private void createDOMTree() {
        Element rootEle = this.dom.createElement(XMLElements.Geometry.toString());
        this.dom.appendChild(rootEle);
        for (Atom at : this.molecule.getAtoms()) {
            Element atomEle = this.createAtomElement(at);
            rootEle.appendChild(atomEle);
        }
    }

    private Element createAtomElement(Atom at) {
        Element AtomEle = this.dom.createElement(XMLElements.Atom.toString());
        if (at instanceof HuckelAtom) {
            AtomEle.setAttribute(XMLElements.Type.toString(), XMLTypes.HuckelAtom.toString());
        } else {
            AtomEle.setAttribute(XMLElements.Type.toString(), XMLTypes.NonHuckelAtom.toString());
        }
        Element nameEle = this.dom.createElement(XMLElements.Name.toString());
        nameEle.appendChild(this.dom.createTextNode(at.getSigle()));
        Element xEle = this.dom.createElement(XMLElements.X.toString());
        xEle.appendChild(this.dom.createTextNode("" + at.getX()));
        Element yEle = this.dom.createElement(XMLElements.Y.toString());
        yEle.appendChild(this.dom.createTextNode("" + at.getY()));
        Element zEle = this.dom.createElement(XMLElements.Z.toString());
        zEle.appendChild(this.dom.createTextNode("" + at.getZ()));
        AtomEle.appendChild(nameEle);
        AtomEle.appendChild(xEle);
        AtomEle.appendChild(yEle);
        AtomEle.appendChild(zEle);
        return AtomEle;
    }

    private void printToFile() {
        try {
            OutputFormat format = new OutputFormat(this.dom);
            format.setIndenting(true);
            FileOutputStream fos = new FileOutputStream(this.file);
            XMLSerializer serializer = new XMLSerializer(fos, format);
            serializer.serialize(this.dom);
        }
        catch (Exception e) {
            e.printStackTrace();
            HuckelIO.error(this.getClass().toString(), "printToFile", "Error while writing xml file");
        }
    }

    public static void main(String[] args) {
        Molecule mol = new Molecule();
        try {
            mol.createNewAtom(PeriodicTable.Entry.C, new Point3D(1.0, 0.0, 0.0));
            mol.createNewAtom(PeriodicTable.Entry.C, new Point3D(0.0, 1.0, 0.0));
            mol.createNewAtom(PeriodicTable.Entry.C, new Point3D(1.0, 1.0, 0.0));
        }
        catch (HuckelBondException e) {
            e.printStackTrace();
        }
        catch (BondException e) {
            e.printStackTrace();
        }
        catch (MoleculeTooManyNeighboursException e) {
            e.printStackTrace();
        }
        catch (MoleculeCoherenceException e) {
            e.printStackTrace();
        }
        catch (MoleculeBondExistsException e) {
            e.printStackTrace();
        }
        Writexml wxml = new Writexml(mol, new File("newXML.xml"));
    }
}

