/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.files.xyz;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import org.ctom.hulis.files.xyz.GeometryReader;
import org.ctom.hulis.files.xyz.ReadxyzException;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.PeriodicTable;
import org.ctom.hulis.util.geometry.Geometry;
import org.ctom.hulis.util.io.HuckelIO;

public class ReadCoordinatesxyz
extends GeometryReader {
    Geometry geomXYZ;
    StreamTokenizer donnees;
    protected int lineNumber;
    protected int token;
    int nbAtomLus = 0;

    public ReadCoordinatesxyz(StreamTokenizer donnees) {
        this.donnees = donnees;
        this.lineNumber = 0;
        this.token = 0;
        this.nbAtomLus = 0;
    }

    public ReadCoordinatesxyz(String string) {
        this(new StreamTokenizer(new StringReader(string)));
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public void readAll(Geometry geometry) throws ReadxyzException {
        this.geomXYZ = geometry;
        this.donnees.eolIsSignificant(true);
        this.readHeader(this.donnees);
        this.readxyzDatas(this.donnees);
        this.geomXYZ.generateConnectivity();
        this.geomXYZ.flatGeom();
    }

    protected void readHeader(StreamTokenizer donnees) throws ReadxyzException {
        try {
            while ((this.token = donnees.nextToken()) == 10) {
                ++this.lineNumber;
            }
            ++this.lineNumber;
        }
        catch (IOException e) {
            throw new ReadxyzException(e.getMessage());
        }
    }

    protected void readxyzDatas(StreamTokenizer donnees) throws ReadxyzException {
        int flag = 0;
        this.nbAtomLus = 0;
        boolean emptyLine = true;
        Atom atom = null;
        try {
            while (true) {
                if (this.token == -1) {
                    if (atom != null) {
                        if (flag < 3) {
                            throw new ReadxyzException("a coordinate is missing at line " + this.lineNumber);
                        }
                        this.geomXYZ.add(atom);
                    }
                    throw new ReadxyzException("EOF reached");
                }
                if (this.token == 10) {
                    if (emptyLine) {
                        throw new ReadxyzException("Empty line found at line " + this.lineNumber);
                    }
                    emptyLine = true;
                    if (atom == null) {
                        throw new ReadxyzException("atom not found at line " + this.lineNumber);
                    }
                    if (flag < 3) {
                        throw new ReadxyzException("a coordinate is missing at line " + this.lineNumber);
                    }
                    this.geomXYZ.add(atom);
                    ++this.nbAtomLus;
                    atom = null;
                    flag = 0;
                    ++this.lineNumber;
                } else if (this.token == -3) {
                    emptyLine = false;
                    if (atom != null) {
                        throw new ReadxyzException("string number format expected to define atom coordinates at line " + this.lineNumber);
                    }
                    String symbol = donnees.sval;
                    try {
                        atom = new Atom(0, null, PeriodicTable.Element.valueOf(symbol), symbol, symbol, 0, 0);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ReadxyzException(String.valueOf(symbol) + " is not a recognized atomic element, at the line " + this.lineNumber);
                    }
                } else if (this.token == -2) {
                    emptyLine = false;
                    if (atom == null) {
                        throw new ReadxyzException("Atom symbol expected at the beginning of the line " + this.lineNumber);
                    }
                    switch (++flag) {
                        case 1: {
                            this.setX(atom, donnees.nval);
                            break;
                        }
                        case 2: {
                            this.setY(atom, donnees.nval);
                            break;
                        }
                        case 3: {
                            this.setZ(atom, donnees.nval);
                            break;
                        }
                        default: {
                            atom.addConnect((int)donnees.nval);
                        }
                    }
                }
                this.token = donnees.nextToken();
            }
        }
        catch (Exception e) {
            if (e.getMessage() == null || !e.getMessage().equals("EOF reached") && !e.getMessage().startsWith("Empty line found")) {
                HuckelIO.error(this.getClass().getName(), "readxyzDatas", e.getMessage(), e);
                throw new ReadxyzException(e.getMessage());
            }
            this.geomXYZ.print();
            return;
        }
    }

    protected Geometry getGeometry() {
        return this.geomXYZ;
    }
}

