/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.files.xyz;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import org.ctom.hulis.files.xyz.ReadCoordinatesxyz;
import org.ctom.hulis.files.xyz.ReadxyzException;
import org.ctom.hulis.files.xyz.XYZErreurLigne1;
import org.ctom.hulis.files.xyz.XYZErreurLigne2;
import org.ctom.hulis.util.geometry.Geometry;
import org.ctom.hulis.util.io.HuckelIO;

public class Readxyz
extends ReadCoordinatesxyz {
    private int nAtoms = 0;
    private boolean isStrict = true;

    public Readxyz(String donnees) {
        super(new StreamTokenizer(new StringReader(donnees)));
    }

    public Readxyz(File file) throws FileNotFoundException {
        super(new StreamTokenizer(new FileReader(file)));
    }

    public Readxyz(StreamTokenizer donnees) {
        super(donnees);
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    protected void strictNumberAtoms(boolean isStrict) {
        this.isStrict = isStrict;
    }

    @Override
    protected void readHeader(StreamTokenizer donnees) throws ReadxyzException {
        try {
            this.token = donnees.nextToken();
            if (this.token != -2) {
                throw new XYZErreurLigne1();
            }
            this.nAtoms = (int)donnees.nval;
            HuckelIO.PrintIf("nAtoms read = " + this.nAtoms + "\n");
            ++this.lineNumber;
            this.token = donnees.nextToken();
            if (this.token != 10) {
                HuckelIO.PrintIf(donnees + "\n");
                throw new XYZErreurLigne2();
            }
            ++this.lineNumber;
            while ((this.token = donnees.nextToken()) != 10) {
            }
            ++this.lineNumber;
            this.token = donnees.nextToken();
        }
        catch (XYZErreurLigne1 e) {
            throw new ReadxyzException(e.getMessage());
        }
        catch (XYZErreurLigne2 e) {
            throw new ReadxyzException(e.getMessage());
        }
        catch (IOException e) {
            throw new ReadxyzException(e.getMessage());
        }
    }

    @Override
    protected void readxyzDatas(StreamTokenizer donnees) throws ReadxyzException {
        super.readxyzDatas(donnees);
        if (this.isStrict && this.nbAtomLus != this.nAtoms) {
            throw new ReadxyzException(String.valueOf(this.nAtoms) + " expected atoms, specified at the beginning of the file, but " + this.nbAtomLus + " have been read ");
        }
    }

    @Override
    protected Geometry getGeometry() {
        return this.geomXYZ;
    }
}

