/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.files.xyz;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.ctom.hulis.files.xyz.WritexyzException;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.exception.GeometryException;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureDelocalized;
import org.ctom.hulis.util.geometry.Geometry;
import org.ctom.hulis.util.geometry.InitialOrientation;
import org.ctom.hulis.util.geometry.SuperSymbolComparator;

public class Writexyz {
    public static final String MESSAGE_CREE_PAR = "File generated by the HuliS code";
    Geometry geom;
    Structure s;
    PrintWriter out;
    private boolean isWriteInitialOrientation;
    private boolean writeConnectivity;
    private String messageHeader;

    public Writexyz(StructureDelocalized s) {
        this.s = s;
        this.isWriteInitialOrientation = false;
        this.writeConnectivity = false;
        this.messageHeader = "";
    }

    public Structure getStructure() {
        return this.s;
    }

    public void writeAll(PrintWriter out) throws WritexyzException {
        try {
            this.geom = this.s.getGeometry();
            this.out = out;
        }
        catch (GeometryException e) {
            throw new WritexyzException(e);
        }
        this.write(out);
    }

    public void setWriteInitialOrientation(boolean isWriteInitialOrientation) {
        this.isWriteInitialOrientation = isWriteInitialOrientation;
    }

    public boolean isWriteInitialOrientation() {
        return this.isWriteInitialOrientation;
    }

    private void write(PrintWriter out) {
        this.writeHeader(out);
        int scale = this.geom.getscale();
        InitialOrientation initialOrientation = this.geom.getInitialOrientation();
        ArrayList<Atom> sortedGeom3D = new ArrayList<Atom>();
        sortedGeom3D.addAll(this.geom.getGeom3D());
        Collections.sort(sortedGeom3D, new SuperSymbolComparator());
        for (Atom atom : sortedGeom3D) {
            String symbol = "";
            symbol = atom.getElement() == null ? atom.getSigle() : atom.getElement().toString();
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            if (this.isWriteInitialOrientation) {
                x = atom.getLocationGeom3D().getX();
                y = atom.getLocationGeom3D().getY();
                z = atom.getLocationGeom3D().getZ();
            } else {
                x = atom.getLocation().getX();
                y = atom.getLocation().getY();
                z = atom.getLocation().getZ();
            }
            out.printf(Locale.US, "%s   %10.5f   %10.5f   %10.5f", symbol, x / (double)scale, y / (double)scale, z / (double)scale);
            if (this.writeConnectivity && atom.getConnect().size() != 0) {
                for (int i2 : atom.getConnect()) {
                    out.printf("  %5d", i2);
                }
            }
            out.println();
        }
    }

    public void writeHeader(PrintWriter out) {
        out.println(this.geom.countAtoms());
        if (this.messageHeader == "") {
            out.println(MESSAGE_CREE_PAR);
        } else {
            out.println(this.getMessageHeader());
        }
    }

    public void setMessageHeader(String messageHeader) {
        this.messageHeader = messageHeader;
    }

    public String getMessageHeader() {
        return this.messageHeader;
    }

    public boolean isWriteConnectivity() {
        return this.writeConnectivity;
    }

    public void setWriteConnectivity(boolean writeConnectivity) {
        this.writeConnectivity = writeConnectivity;
    }
}

