/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.huckel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.ctom.hulis.huckel.Bond;
import org.ctom.hulis.huckel.HuckelBond;
import org.ctom.hulis.huckel.IMoleculeComponent;
import org.ctom.hulis.huckel.Molecule;
import org.ctom.hulis.huckel.PeriodicTable;
import org.ctom.hulis.huckel.events.GeometryEvent;
import org.ctom.hulis.huckel.exception.AtomException;
import org.ctom.hulis.huckel.exception.BondException;
import org.ctom.hulis.huckel.exception.GeometryException;
import org.ctom.hulis.huckel.exception.HuckelBondException;
import org.ctom.hulis.huckel.exception.MoleculeBondExistsException;
import org.ctom.hulis.huckel.exception.MoleculeCoherenceException;
import org.ctom.hulis.huckel.exception.MoleculeTooManyNeighboursException;
import org.ctom.hulis.huckel.listeners.IAtomGeometryListener;
import org.ctom.hulis.huckel.listeners.IAtomValueListener;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import org.ctom.hulis.util.geometry.CovalentRadii;
import org.ctom.hulis.util.io.HuckelIO;
import org.ctom.util.maths.Point3D;
import org.ctom.util.maths.Rotation;
import org.ctom.util.maths.VecteurCTOM;

public class Atom
implements IMoleculeComponent,
Cloneable,
Serializable {
    private static final long serialVersionUID = 2359193961861225653L;
    protected String sigle;
    public PeriodicTable.Element element;
    PeriodicTable.Entry entry;
    protected String name;
    protected int nbElecVal;
    protected int nbNeighboursMax;
    protected double valence;
    public int charge;
    private ArrayList<Integer> connect = null;
    private int superSymbol;
    public Molecule moleculeParentContainer;
    protected int index;
    Point3D p2D;
    Point3D pGeom3D;
    protected final ArrayList<IAtomValueListener> atomValuelisteners;
    protected final ArrayList<IAtomGeometryListener> geometryListeners;
    private int atomicNumber;
    protected volatile int hashCode = 0;

    public Atom(Atom a) {
        this.atomicNumber = a.atomicNumber;
        this.element = a.element;
        this.entry = a.entry;
        this.sigle = a.sigle;
        this.name = a.name;
        this.nbElecVal = a.nbElecVal;
        this.valence = a.valence;
        this.index = a.index;
        this.charge = a.charge;
        this.p2D = null;
        if (a.p2D != null) {
            this.p2D = (Point3D)a.p2D.clone();
        }
        this.pGeom3D = null;
        if (a.pGeom3D != null) {
            this.pGeom3D = (Point3D)a.pGeom3D.clone();
        }
        this.nbNeighboursMax = a.nbNeighboursMax;
        this.superSymbol = a.superSymbol;
        if (a.connect != null) {
            this.connect = new ArrayList();
            for (Integer i2 : a.connect) {
                this.connect.add(i2);
            }
        }
        this.atomValuelisteners = new ArrayList();
        this.geometryListeners = new ArrayList();
    }

    protected void fireAtomLocationChanged(Atom source, Object oldValue, Object newValue) {
        GeometryEvent event = null;
        for (IAtomGeometryListener listener : this.getGeometryListeners()) {
            if (event == null) {
                event = new GeometryEvent(source, oldValue, newValue);
            }
            listener.atomLocationChanged(event);
        }
    }

    public Atom(int atomicNumber, PeriodicTable.Entry entry, PeriodicTable.Element element, String sigle, String name, int nbElecVal, int nbNeighboursMax) {
        this.atomicNumber = atomicNumber;
        this.entry = entry;
        this.element = element;
        this.sigle = sigle;
        this.name = name;
        this.nbElecVal = nbElecVal;
        this.nbNeighboursMax = nbNeighboursMax;
        this.index = 0;
        this.charge = 0;
        this.moleculeParentContainer = null;
        this.superSymbol = 0;
        this.atomValuelisteners = new ArrayList();
        this.geometryListeners = new ArrayList();
        this.p2D = null;
        this.pGeom3D = null;
    }

    public void rotate(Rotation mRot) {
        this.p2D.rotateEquals(mRot);
        this.setLocationNotNotify(this.p2D);
    }

    public void rotate(Point3D around, Rotation mRot) {
        this.p2D = this.p2D.rotate(around, mRot);
        this.setLocationNotNotify(this.p2D);
    }

    public void translate(VecteurCTOM v) {
        this.p2D.translateEquals(v);
        this.setLocationNotNotify(this.p2D);
    }

    public double getDistance(Atom other) {
        return this.p2D.getDistance(other.p2D);
    }

    protected void addCharge(int charge) {
        this.setCharge(this.charge + charge);
    }

    public void addConnect(int i2) {
        if (i2 == 0) {
            try {
                throw new GeometryException("atom.addConnect(i) : cannot connect atom because supersymbol parameter i==0. Atoms supersymbols must be greater than zero.");
            }
            catch (GeometryException e) {
                e.printStackTrace();
                return;
            }
        }
        this.checkConnect();
        this.connect.add(i2);
    }

    public void checkConnect() {
        if (this.connect == null) {
            this.connect = new ArrayList();
        }
    }

    public void clearConnect() {
        if (this.connect != null) {
            this.connect.clear();
        }
    }

    public Object clone() {
        return new Atom(this);
    }

    public int countDBondAtom() {
        int nDB = 0;
        for (HuckelBond bond : this.moleculeParentContainer.getHuckelBonds()) {
            if (bond.getBondType() != 2 || bond.getAtom1() != this && bond.getAtom2() != this) continue;
            ++nDB;
        }
        return nDB;
    }

    public int countNeighbours() {
        if (this.getMoleculeContainer() == null) {
            return 0;
        }
        return this.getMoleculeContainer().countNeighbours(this);
    }

    public int countNeighboursExcludingH() {
        if (this.getMoleculeContainer() == null) {
            return 0;
        }
        return this.getMoleculeContainer().countNeighboursExcludingH(this);
    }

    public List<Atom> getNeighbours() {
        if (this.getMoleculeContainer() == null) {
            return null;
        }
        return this.getMoleculeContainer().getNeighbours(this);
    }

    public int countSBondAtom() {
        int nSB = 0;
        for (Bond b : this.moleculeParentContainer.getBonds()) {
            if (b instanceof HuckelBond) {
                HuckelBond bond = (HuckelBond)b;
                if (bond.getBondType() != 1 || bond.getAtom1() != this && bond.getAtom2() != this) continue;
                ++nSB;
                continue;
            }
            if (b.getAtom1() != this && b.getAtom2() != this) continue;
            ++nSB;
        }
        return nSB;
    }

    public int countTBondAtom() {
        int nTB = 0;
        for (HuckelBond bond : this.moleculeParentContainer.getHuckelBonds()) {
            if (bond.getBondType() != 3 || bond.getAtom1() != this && bond.getAtom2() != this) continue;
            ++nTB;
        }
        return nTB;
    }

    public void debug() {
        String res = "";
        res = String.valueOf(res) + "ATOM\n";
        res = this.getMoleculeContainer() != null ? String.valueOf(res) + "molecule hascode = " + this.getMoleculeContainer().hashCode() + "\n" : String.valueOf(res) + "molecule : null !!!\n";
        res = String.valueOf(res) + "index : " + this.getIndex() + "\n";
        res = String.valueOf(res) + "type :  " + this.getSigle() + "\n";
        res = String.valueOf(res) + "name : " + this.getName() + "\n";
        res = String.valueOf(res) + "charge : " + this.getCharge() + "\n";
        res = String.valueOf(res) + "nbElecVal :" + this.getNbElecVal() + "\n";
        res = String.valueOf(res) + "valence :  " + this.getValence() + "\n";
        res = String.valueOf(res) + "max neighbourgs :  " + this.getNbNeighboursMax() + "\n";
        res = String.valueOf(res) + "location : ";
        res = String.valueOf(res) + "x= " + this.getX() + ", y= " + this.getY() + "\n";
        HuckelIO.PrintIf(res);
    }

    @Override
    public void remove() throws MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException, HuckelBondException, BondException {
        if (this.getMoleculeContainer() != null) {
            this.getMoleculeContainer().removeAtom(this);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Atom)) {
            throw new ClassCastException();
        }
        Atom a = (Atom)o;
        return a.atomicNumber == this.atomicNumber && a.index == this.index && a.getElement() == this.getElement() && a.sigle == this.sigle && a.name == this.name && a.valence == this.valence && a.nbElecVal == this.nbElecVal && a.charge == this.charge;
    }

    public int hashCode() {
        int multiplier = 23;
        if (this.hashCode == 0) {
            int code = 133;
            if (this.connect != null) {
                code = 23 * code + this.connect.hashCode();
            }
            code = 23 * code + this.atomicNumber;
            code = 23 * code + this.index;
            if (this.getElement() != null) {
                code = 23 * code + this.getElement().hashCode();
            }
            code = 23 * code + this.sigle.hashCode();
            code = 23 * code + this.name.hashCode();
            code = 23 * code + new Double(this.valence).hashCode();
            code = 23 * code + this.nbElecVal;
            this.hashCode = code = 23 * code + this.charge;
        }
        return this.hashCode;
    }

    public List<Bond> getBonds() {
        Molecule molecule = this.getMoleculeContainer();
        if (molecule == null) {
            return null;
        }
        ArrayList<Bond> lstBond = new ArrayList<Bond>();
        for (Bond b : molecule.getBonds()) {
            if (!b.contains(this)) continue;
            lstBond.add(b);
        }
        return lstBond;
    }

    public int getCharge() {
        return this.charge;
    }

    public ArrayList<Integer> getConnect() {
        this.checkConnect();
        return this.connect;
    }

    @Deprecated
    public double[] getCoord3D() {
        double[] coord = new double[]{this.getX(), this.getY(), this.getZ()};
        return coord;
    }

    public double getCovalentRadius() {
        if (this.getElement() == null) {
            return CovalentRadii.C.getCovRad();
        }
        double radius = CovalentRadii.valueOf(this.getElement().toString()).getCovRad();
        return radius;
    }

    public double getDist3D(Atom that, double scale) {
        double dist = 0.0;
        dist += Math.pow((this.getX() - that.getX()) / scale, 2.0);
        dist += Math.pow((this.getY() - that.getY()) / scale, 2.0);
        dist += Math.pow((this.getZ() - that.getZ()) / scale, 2.0);
        dist = Math.sqrt(dist);
        return dist;
    }

    public PeriodicTable.Element getElement() {
        return this.element;
    }

    public PeriodicTable.Entry getEntry() {
        return this.entry;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public Molecule getMoleculeContainer() {
        return this.moleculeParentContainer;
    }

    public String getName() {
        return this.name;
    }

    public int getNbElecVal() {
        return this.nbElecVal;
    }

    public int getNbNeighboursMax() {
        return this.nbNeighboursMax;
    }

    public void setNbNeighboursMax(int nbNeighboursMax) {
        this.nbNeighboursMax = nbNeighboursMax;
    }

    public String getSigle() {
        return this.sigle;
    }

    public int getSuperSymbol() {
        return this.superSymbol;
    }

    public double getValence() {
        return this.valence;
    }

    @Override
    public double getX() {
        return this.p2D.getX();
    }

    @Override
    public double getY() {
        return this.p2D.getY();
    }

    public double getZ() {
        return this.p2D.getZ();
    }

    public void print() {
        System.out.printf("%s", this.getSigle());
    }

    public void setCharge(int charge) {
        this.charge = charge;
    }

    protected void setElement(PeriodicTable.Element element) {
        this.element = element;
    }

    protected void setIndex(int index) {
        this.index = index;
    }

    public void setLocation(Point3D p) {
        if (this.p2D != null && this.moleculeParentContainer instanceof StructureLocalized) {
            try {
                throw new AtomException("Cannot change atom location on a localized structure");
            }
            catch (AtomException e) {
                e.printStackTrace();
                return;
            }
        }
        if (this.moleculeParentContainer instanceof Structure && ((Structure)this.moleculeParentContainer).getMesomeryParent() != null && ((Structure)this.moleculeParentContainer).getMesomeryParent().countLocalizedStructs() > 0) {
            throw new RuntimeException("Cannot move the atom. There are localized structures in the mesomery");
        }
        Point3D old = null;
        if (this.p2D != null) {
            old = (Point3D)this.p2D.clone();
        }
        this.setLocationNotNotify(p);
        if (!p.equals(old)) {
            this.fireAtomLocationChanged(this, old, p);
        }
    }

    public void setLocationNotNotify(Point3D p) {
        this.p2D = p;
    }

    public Point3D setLocationGeom3D(Point3D pXYZ) {
        this.pGeom3D = pXYZ;
        return this.pGeom3D;
    }

    @Override
    public Point3D getLocation() {
        return this.p2D;
    }

    public Point3D getLocationGeom3D() {
        return this.pGeom3D;
    }

    protected void setMoleculeContainer(Molecule moleculeParentContainer) {
        this.moleculeParentContainer = moleculeParentContainer;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public void setNbElecVal(int nbValElec) throws AtomException {
        if (nbValElec < 0) {
            throw new AtomException("number of Pi electrons must be positive or null");
        }
        this.nbElecVal = nbValElec;
    }

    public void setSigle(String atomType) {
        this.sigle = atomType;
    }

    public void setSuperSymbol(int nombre) {
        this.superSymbol = nombre;
    }

    protected void setValence(double valence) throws AtomException {
        if (valence < 0.0) {
            throw new AtomException("valence must be positive or null");
        }
        this.valence = valence;
    }

    public void setXAndXGeom3D(double x) {
        if (this.moleculeParentContainer instanceof StructureLocalized) {
            try {
                throw new AtomException("Cannot change x on a localized structure");
            }
            catch (AtomException e) {
                e.printStackTrace();
                return;
            }
        }
        if (this.moleculeParentContainer instanceof Structure && ((Structure)this.moleculeParentContainer).getMesomeryParent() != null && ((Structure)this.moleculeParentContainer).getMesomeryParent().countLocalizedStructs() > 0) {
            throw new RuntimeException("Cannot move the atom. There are localized structures in the mesomery");
        }
        Point3D old = null;
        if (this.p2D != null) {
            old = (Point3D)this.p2D.clone();
        } else {
            this.p2D = new Point3D();
        }
        this.p2D.setX(x);
        if (this.pGeom3D == null) {
            this.pGeom3D = new Point3D();
        }
        this.pGeom3D.setX(x);
        if (!this.p2D.equals(old)) {
            this.fireAtomLocationChanged(this, old, this.p2D);
        }
    }

    public void setYAndYGeom3D(double y) {
        if (this.moleculeParentContainer instanceof StructureLocalized) {
            try {
                throw new AtomException("Cannot change y on a localized structure");
            }
            catch (AtomException e) {
                e.printStackTrace();
                return;
            }
        }
        if (this.moleculeParentContainer instanceof Structure && ((Structure)this.moleculeParentContainer).getMesomeryParent() != null && ((Structure)this.moleculeParentContainer).getMesomeryParent().countLocalizedStructs() > 0) {
            throw new RuntimeException("Cannot move the atom. There are localized structures in the mesomery");
        }
        Point3D old = null;
        if (this.p2D != null) {
            old = (Point3D)this.p2D.clone();
        } else {
            this.p2D = new Point3D();
        }
        this.p2D.setY(y);
        if (this.pGeom3D == null) {
            this.pGeom3D = new Point3D();
        }
        this.pGeom3D.setY(y);
        if (!this.p2D.equals(old)) {
            this.fireAtomLocationChanged(this, old, this.p2D);
        }
    }

    public void setZAndZGeom3D(double z) {
        if (this.moleculeParentContainer instanceof StructureLocalized) {
            try {
                throw new AtomException("Cannot change z on a localized structure");
            }
            catch (AtomException e) {
                e.printStackTrace();
                return;
            }
        }
        if (this.moleculeParentContainer instanceof Structure && ((Structure)this.moleculeParentContainer).getMesomeryParent() != null && ((Structure)this.moleculeParentContainer).getMesomeryParent().countLocalizedStructs() > 0) {
            throw new RuntimeException("Cannot move the atom. There are localized structures in the mesomery");
        }
        Point3D old = null;
        if (this.p2D != null) {
            old = (Point3D)this.p2D.clone();
        } else {
            this.p2D = new Point3D();
        }
        this.p2D.setZ(z);
        if (this.pGeom3D == null) {
            this.pGeom3D = new Point3D();
        }
        this.pGeom3D.setZ(z);
        if (!this.p2D.equals(old)) {
            this.fireAtomLocationChanged(this, old, this.p2D);
        }
    }

    public String toString() {
        return this.getSigle();
    }

    public void addListener(IAtomValueListener listener) {
        this.atomValuelisteners.add(listener);
    }

    public void removeListener(IAtomValueListener listener) {
        this.atomValuelisteners.remove(listener);
    }

    public void addListener(IAtomGeometryListener listener) {
        this.geometryListeners.add(listener);
    }

    public void removeListener(IAtomGeometryListener listener) {
        this.geometryListeners.remove(listener);
    }

    protected ArrayList<IAtomGeometryListener> getGeometryListeners() {
        return (ArrayList)this.geometryListeners.clone();
    }

    protected ArrayList<IAtomValueListener> getValueListeners() {
        return (ArrayList)this.atomValuelisteners.clone();
    }
}

