/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.huckel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.Bond;
import org.ctom.hulis.huckel.HuckelAtom;
import org.ctom.hulis.huckel.HuckelBlock;
import org.ctom.hulis.huckel.HuckelBond;
import org.ctom.hulis.huckel.IHuckelObject;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.Molecule;
import org.ctom.hulis.huckel.events.BlocDelocalizedEvent;
import org.ctom.hulis.huckel.exception.BlocDelocalizedException;
import org.ctom.hulis.huckel.listeners.IBlocDelocalizedListener;
import org.ctom.hulis.huckel.structures.StructureDelocalized;
import org.ctom.hulis.huckel.structures.StructureLocalized;

public class BlocDelocalized
extends HuckelBlock
implements Serializable {
    private static final long serialVersionUID = 2866139443601131754L;
    Molecule moleculeParent;
    protected final List<IBlocDelocalizedListener> listeners;

    public BlocDelocalized() {
        this.moleculeParent = null;
        this.listeners = new ArrayList<IBlocDelocalizedListener>();
    }

    public BlocDelocalized(List<IHuckelObject> huckelObjects, int nElectrons) throws BlocDelocalizedException {
        this();
        for (IHuckelObject o : huckelObjects) {
            this.addHuckelObject(o);
        }
        this.setNbElectron(nElectrons);
    }

    private BlocDelocalized(BlocDelocalized bloc, StructureLocalized target) {
        this.lstHuckelObject = new ArrayList();
        this.listeners = new ArrayList<IBlocDelocalizedListener>();
        this.moleculeParent = null;
        for (IHuckelObject o : bloc.getListHuckelObject()) {
            IHuckelObject otarget = target.getHuckelObjectByIndex(o.getClass(), o.getIndex());
            this.lstHuckelObject.add(otarget);
            otarget.setBlocDelocalizedParent(this);
        }
        this.nbElectrons = bloc.nbElectrons;
    }

    public BlocDelocalized getCopy(StructureLocalized target) {
        return new BlocDelocalized(this, target);
    }

    public void addHuckelObject(IHuckelObject o) throws BlocDelocalizedException {
        if (o == null) {
            throw new BlocDelocalizedException("cannot add a null object in a block");
        }
        if (o.getBlocDelocalizedParent() != null) {
            throw new BlocDelocalizedException(o + " is already in a block");
        }
        if (o instanceof HuckelBond) {
            HuckelBond b = (HuckelBond)o;
            if (b.getBondType() > 1) {
                throw new BlocDelocalizedException("b " + b + " has more than 1 electron");
            }
            HuckelAtom a1 = b.getAtom1();
            HuckelAtom a2 = b.getAtom2();
            if (a1.getNbElectrons() > 0) {
                throw new BlocDelocalizedException("cannot create bloc on " + a1 + " : " + a1.getNbElectrons() + " electrons instead of 0");
            }
            if (a1.countDBondAtom() > 0) {
                throw new BlocDelocalizedException("cannot create bloc on " + a1 + " : " + a1.countDBondAtom() + " : double bonds detected");
            }
            if (a1.getBlocDelocalizedParent() == null) {
                this.lstHuckelObject.add(a1);
                a1.setBlocDelocalizedParent(this);
            } else if (a1.getBlocDelocalizedParent() != this) {
                throw new BlocDelocalizedException("atom " + a1 + " is already in a block");
            }
            if (a2.getNbElectrons() > 0) {
                throw new BlocDelocalizedException("cannot create bloc on " + a2 + " : " + a2.getNbElectrons() + " electrons instead of 0");
            }
            if (a2.countDBondAtom() > 0) {
                throw new BlocDelocalizedException("cannot create bloc on " + a2 + " : " + a2.countDBondAtom() + " : double bonds detected");
            }
            if (a2.getBlocDelocalizedParent() == null) {
                this.lstHuckelObject.add(a2);
                a2.setBlocDelocalizedParent(this);
            } else if (a2.getBlocDelocalizedParent() != this) {
                throw new BlocDelocalizedException("atom " + a2 + " is already in a block");
            }
        } else {
            if (o.getNbElectrons() > 0) {
                throw new BlocDelocalizedException("cannot create bloc on " + o + " : " + o.getNbElectrons() + " electrons instead of 0");
            }
            if (((Atom)((Object)o)).countDBondAtom() > 0) {
                throw new BlocDelocalizedException("cannot create bloc on " + o + " : " + ((Atom)((Object)o)).countDBondAtom() + " double bonds detected");
            }
        }
        this.lstHuckelObject.add(o);
        o.setBlocDelocalizedParent(this);
        this.nbElectrons = this.getSumAtomsNbElecPi();
        this.fireHuckelObjectAdded(this, null, o);
    }

    public void removeHuckelObject(IHuckelObject o) {
        this.do_removeHuckelObject(o);
        this.nbElectrons = this.getSumAtomsNbElecPi();
        this.fireHuckelObjectRemoved(this, o, null);
    }

    protected void do_removeHuckelObject(IHuckelObject o) {
        if (o instanceof Atom) {
            Atom a = (Atom)((Object)o);
            for (Bond b : a.getBonds()) {
                if (!(b instanceof HuckelBond)) continue;
                HuckelBond hb = (HuckelBond)b;
                for (IHuckelObject huckelObject : this.getListHuckelObject()) {
                    if (huckelObject != hb) continue;
                    this.lstHuckelObject.remove(hb);
                    hb.setBlocDelocalizedParent(null);
                }
            }
        } else if (o instanceof HuckelBond) {
            HuckelBond current;
            HuckelBond b = (HuckelBond)o;
            HuckelAtom a1 = b.getAtom1();
            HuckelAtom a2 = b.getAtom2();
            List<HuckelBond> lstHuckelBonds = this.getListHuckelBond();
            Iterator<HuckelBond> it = lstHuckelBonds.iterator();
            boolean found = false;
            while (it.hasNext() && !found) {
                current = it.next();
                if (current == b || !b.contains(a1)) continue;
                found = true;
            }
            if (!found) {
                this.lstHuckelObject.remove(a1);
                a1.setBlocDelocalizedParent(null);
            }
            found = false;
            while (it.hasNext() && !found) {
                current = it.next();
                if (current == b || !b.contains(a2)) continue;
                found = true;
            }
            if (!found) {
                this.lstHuckelObject.remove(a2);
                a2.setBlocDelocalizedParent(null);
            }
        }
        this.lstHuckelObject.remove(o);
        o.setBlocDelocalizedParent(null);
    }

    @Override
    public void setNbElectron(int nbElectrons) {
        Mesomery mesomery;
        if (this.getMoleculeParent() instanceof StructureDelocalized && (mesomery = ((StructureDelocalized)this.getMoleculeParent()).getMesomeryParent()) != null && mesomery.countLocalizedStructs() > 0) {
            throw new RuntimeException("cannot change electrons of the bloc there are localized structures in the mesomery");
        }
        int old = this.getNbElectron();
        super.setNbElectron(nbElectrons);
        if (old != this.nbElectrons) {
            this.fireNbElectronsChanged(this, old, this.nbElectrons);
        }
    }

    public void clear() {
        Mesomery mesomery;
        if (this.getMoleculeParent() instanceof StructureDelocalized && (mesomery = ((StructureDelocalized)this.getMoleculeParent()).getMesomeryParent()) != null && mesomery.countLocalizedStructs() > 0) {
            throw new RuntimeException("cannot clear the bloc because there are localized structures in the mesomery");
        }
        for (IHuckelObject huckelObject : this.lstHuckelObject) {
            huckelObject.setBlocDelocalizedParent(null);
        }
        this.lstHuckelObject.clear();
        this.moleculeParent = null;
    }

    public void empty() {
        for (IHuckelObject huckelObject : this.lstHuckelObject) {
            huckelObject.setBlocDelocalizedParent(null);
        }
        this.lstHuckelObject.clear();
    }

    public int getSumAtomsNbElecPi() {
        int nbElecPi = 0;
        for (IHuckelObject o : this.lstHuckelObject) {
            if (!(o instanceof HuckelAtom)) continue;
            nbElecPi += ((HuckelAtom)o).getNbElecPi();
        }
        return nbElecPi;
    }

    public void setMoleculeParent(Molecule moleculeParent) {
        this.moleculeParent = moleculeParent;
    }

    public Molecule getMoleculeParent() {
        return this.moleculeParent;
    }

    protected void fireHuckelObjectAdded(BlocDelocalized source, Object oldValue, Object newValue) {
        BlocDelocalizedEvent event = null;
        for (IBlocDelocalizedListener listener : this.listeners) {
            if (event == null) {
                event = new BlocDelocalizedEvent(source, oldValue, newValue);
            }
            listener.blocDelocalizedHuckelObjectAdded(event);
        }
    }

    protected void fireHuckelObjectRemoved(BlocDelocalized source, Object oldValue, Object newValue) {
        BlocDelocalizedEvent event = null;
        for (IBlocDelocalizedListener listener : this.listeners) {
            if (event == null) {
                event = new BlocDelocalizedEvent(source, oldValue, newValue);
            }
            listener.blocDelocalizedHuckelObjectRemoved(event);
        }
    }

    protected void fireNbElectronsChanged(BlocDelocalized source, Object oldValue, Object newValue) {
        BlocDelocalizedEvent event = null;
        for (IBlocDelocalizedListener listener : this.listeners) {
            if (event == null) {
                event = new BlocDelocalizedEvent(source, oldValue, newValue);
            }
            listener.blocDelocalizedNbElectronsChanged(event);
        }
    }

    public void addListener(IBlocDelocalizedListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IBlocDelocalizedListener listener) {
        this.listeners.remove(listener);
    }
}

