/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.huckel;

import java.io.Serializable;
import java.util.ArrayList;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.IMoleculeComponent;
import org.ctom.hulis.huckel.Molecule;
import org.ctom.hulis.huckel.PeriodicTable;
import org.ctom.hulis.huckel.exception.BondException;
import org.ctom.hulis.huckel.exception.HuckelBondException;
import org.ctom.hulis.huckel.exception.MoleculeBondExistsException;
import org.ctom.hulis.huckel.exception.MoleculeCoherenceException;
import org.ctom.hulis.huckel.exception.MoleculeTooManyNeighboursException;
import org.ctom.hulis.huckel.listeners.IBondListener;
import org.ctom.hulis.util.io.HuckelIO;
import org.ctom.util.maths.Point3D;

public class Bond
implements IMoleculeComponent,
Cloneable,
Serializable {
    private static final long serialVersionUID = 3015290635133264373L;
    protected Atom atom1;
    protected Atom atom2;
    protected int index;
    protected Molecule moleculeParentContainer;
    protected final ArrayList<IBondListener> listeners;
    protected volatile int hashCode = 0;

    public Bond(Atom atom1, Atom atom2) throws BondException {
        this.checkCoherence(atom1, atom2);
        this.atom1 = atom1;
        this.atom2 = atom2;
        this.listeners = new ArrayList();
    }

    protected void checkCoherence(Atom atom1, Atom atom2) throws BondException {
        if (atom1 == null || atom2 == null) {
            throw new BondException("atom must be intialized");
        }
        if (atom1 == atom2) {
            throw new BondException("atom must be different");
        }
        if (atom1 == null || atom2 == null) {
            throw new BondException("atom must be in a molecule");
        }
        if (atom1.getMoleculeContainer() != atom2.getMoleculeContainer()) {
            throw new BondException("atoms are not in the same molecule");
        }
    }

    public Bond(Bond bond) {
        this.atom1 = bond.getAtom1();
        this.atom2 = bond.getAtom2();
        this.setIndex(bond.getIndex());
        this.listeners = new ArrayList();
    }

    public Object clone() {
        return new Bond(this);
    }

    public boolean contains(Atom a) {
        return this.atom1 == a || this.atom2 == a;
    }

    public boolean contains(Atom atom1, Atom atom2) {
        if (atom1 == null || atom2 == null) {
            return false;
        }
        return this.atom1 == atom1 && this.atom2 == atom2 || this.atom1 == atom2 && this.atom2 == atom1;
    }

    public boolean contains(PeriodicTable.Element element) {
        return this.atom1.getElement() == element || this.atom2.getElement() == element;
    }

    public void debug() {
        String res = "";
        res = String.valueOf(res) + "BOND : \n";
        if (this.getMoleculeContainer() != null) {
            res = String.valueOf(res) + "molecule hascode = " + this.getMoleculeContainer().hashCode() + "\n";
        }
        res = String.valueOf(res) + "seqNum : " + this.index + "\n";
        res = String.valueOf(res) + "atom1 :     " + this.atom1.toString() + "\n";
        res = String.valueOf(res) + "atom2 :     " + this.atom2.toString() + "\n";
        HuckelIO.PrintIf(res);
    }

    @Override
    public void remove() throws MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException, HuckelBondException, BondException {
        if (this.getMoleculeContainer() != null) {
            this.getMoleculeContainer().removeBond(this);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Bond)) {
            throw new ClassCastException();
        }
        Bond b = (Bond)o;
        return b.atom1.equals(this.atom1) && b.atom2.equals(this.atom2) || b.atom1.equals(this.atom2) && b.atom2.equals(this.atom1);
    }

    public int hashCode() {
        int multiplier = 23;
        if (this.hashCode == 0) {
            int code = 133;
            code = 23 * code + this.index;
            code = 23 * code + this.atom1.hashCode();
            this.hashCode = code = 23 * code + this.atom2.hashCode();
        }
        return this.hashCode;
    }

    public Atom getAtom(PeriodicTable.Element element) {
        if (this.atom1.getElement() == element) {
            return this.atom1;
        }
        if (this.atom2.getElement() == element) {
            return this.atom2;
        }
        return null;
    }

    public Atom getAtom1() {
        return this.atom1;
    }

    public Atom getAtom2() {
        return this.atom2;
    }

    public Atom getAtomLinkedWith(Atom a) {
        if (this.atom1 == a) {
            return this.atom2;
        }
        if (this.atom2 == a) {
            return this.atom1;
        }
        return null;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public Double getLength() {
        return this.getAtom1().getDistance(this.getAtom2());
    }

    @Override
    public Molecule getMoleculeContainer() {
        return this.moleculeParentContainer;
    }

    @Override
    public Point3D getLocation() {
        return new Point3D(this.getX(), this.getY(), this.getZ());
    }

    public ArrayList<IBondListener> getListeners() {
        return (ArrayList)this.listeners.clone();
    }

    @Override
    public double getX() {
        return (this.atom1.getX() + this.atom2.getX()) / 2.0;
    }

    @Override
    public double getY() {
        return (this.atom1.getY() + this.atom2.getY()) / 2.0;
    }

    public double getZ() {
        return (this.atom1.getZ() + this.atom2.getZ()) / 2.0;
    }

    protected void replaceAtom(Atom old, Atom newAtom) throws BondException {
        if (old.getMoleculeContainer() != newAtom.getMoleculeContainer()) {
            throw new BondException("both atoms must be in the same molecule");
        }
        if (old.getMoleculeContainer() != this.getMoleculeContainer()) {
            throw new BondException("atom must be in the same molecule as he bond");
        }
        if (this.getAtom1() == old) {
            this.atom1 = newAtom;
        } else if (this.getAtom2() == old) {
            this.atom2 = newAtom;
        } else {
            throw new BondException("atom does not exist");
        }
    }

    protected void setIndex(int index) {
        this.index = index;
    }

    protected void setMoleculeContainer(Molecule moleculeParentContainer) {
        this.moleculeParentContainer = moleculeParentContainer;
    }

    public String toString() {
        String res = "";
        res = String.valueOf(res) + this.getAtom1().toString() + "-";
        res = String.valueOf(res) + this.getAtom2().toString();
        return res;
    }

    public void addListener(IBondListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IBondListener listener) {
        this.listeners.remove(listener);
    }

    public double getOptimalValue() {
        return this.atom1.getCovalentRadius() + this.atom2.getCovalentRadius();
    }
}

