/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.huckel;

import java.io.Serializable;
import org.ctom.hulis.huckel.Couple;
import org.ctom.hulis.huckel.HuckelAtom;
import org.ctom.hulis.huckel.exception.CoupleException;
import org.ctom.hulis.huckel.structures.StructureLocalized;

public class CoupleLocal
extends Couple
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7357221910006124200L;
    private volatile int hashCode = 0;

    public CoupleLocal(CoupleLocal couple) {
        super(couple);
    }

    public CoupleLocal(HuckelAtom a1, HuckelAtom a2) throws CoupleException {
        super(a1, a2);
        if (a1.getNbRadR() != 1 || a2.getNbRadR() != 1) {
            throw new CoupleException("number of rad R is incorrect for couple");
        }
        this.setObj1(a1);
        this.setObj2(a2);
    }

    public Object clone() {
        return new CoupleLocal(this);
    }

    public int hashCode() {
        int multiplier = 23;
        if (this.hashCode == 0) {
            int code = 133;
            code = 23 * code + this.getHuckelAtom1().hashCode();
            this.hashCode = code = 23 * code + this.getHuckelAtom2().hashCode();
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Couple)) {
            throw new ClassCastException();
        }
        Couple c = (Couple)o;
        if (!(c instanceof CoupleLocal)) {
            return false;
        }
        CoupleLocal cLocal = (CoupleLocal)c;
        return this.getHuckelAtom1().equals(cLocal.getHuckelAtom1()) && this.getHuckelAtom2().equals(cLocal.getHuckelAtom2()) || this.getHuckelAtom1().equals(cLocal.getHuckelAtom2()) && this.getHuckelAtom2().equals(cLocal.getHuckelAtom1());
    }

    public CoupleLocal getCopy(StructureLocalized target) {
        try {
            return new CoupleLocal((HuckelAtom)target.getAtomByIndex(this.getHuckelAtom1().getIndex()), (HuckelAtom)target.getAtomByIndex(this.getHuckelAtom2().getIndex()));
        }
        catch (CoupleException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean contains(Object obj1, Object obj2) {
        if (!(obj1 instanceof HuckelAtom)) {
            return false;
        }
        if (!(obj2 instanceof HuckelAtom)) {
            return false;
        }
        HuckelAtom Atom1 = (HuckelAtom)this.getObj1();
        HuckelAtom Atom2 = (HuckelAtom)this.getObj2();
        HuckelAtom Atom3 = (HuckelAtom)obj1;
        HuckelAtom Atom4 = (HuckelAtom)obj1;
        return Atom1 == Atom3 && Atom2 == Atom4 || Atom1 == Atom4 && Atom2 == Atom3;
    }

    public HuckelAtom getHuckelAtom1() {
        return (HuckelAtom)this.getObj1();
    }

    public HuckelAtom getHuckelAtom2() {
        return (HuckelAtom)this.getObj2();
    }

    @Override
    public String toString() {
        return "(" + this.getHuckelAtom1() + ", " + this.getHuckelAtom2() + ")";
    }
}

