/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.huckel;

import java.io.Serializable;
import org.ctom.hulis.huckel.Orbitale;
import org.ctom.hulis.huckel.exception.HulisException;
import org.ctom.util.maths.Maths;

public class Energy
implements Comparable,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7474770522893765317L;
    public static EnergyFormater DEFAULT_ENERGY_FORMATER = new DefaultEnergyFormater();
    public static final String ALPHA = "\u03b1";
    public static final String BETA = "\u03b2";
    public static final String EPSILON_SYMBOL = "\u025b";
    private double alpha;
    private double beta;
    EnergyFormater energyFormater;
    private volatile int hashCode = 0;

    public static void setDefaultEnergyFormater(EnergyFormater energyFormater) {
        DEFAULT_ENERGY_FORMATER = energyFormater;
    }

    public static String format(Energy e, EnergyFormater energyFormater) {
        double alpha = e.getAlpha();
        double beta = e.getBeta();
        EnergyFormater tmpEnergyFormater = energyFormater == null ? DEFAULT_ENERGY_FORMATER : energyFormater;
        String sAlpha = "";
        String sBeta = "";
        switch (tmpEnergyFormater.getFormatLetters()) {
            case UTF8: {
                sAlpha = ALPHA;
                sBeta = BETA;
                break;
            }
            case ASCII: {
                sAlpha = "alpha";
                sBeta = "beta";
                break;
            }
            default: {
                sAlpha = "alpha";
                sBeta = "beta";
            }
        }
        String resultat = "";
        if (alpha == 0.0 && beta == 0.0) {
            return String.valueOf(tmpEnergyFormater.formatBeta(beta)) + sBeta;
        }
        if (alpha == 1.0) {
            resultat = sAlpha;
        } else if (alpha == -1.0) {
            resultat = "-" + sAlpha;
        } else if (alpha != 0.0) {
            resultat = String.valueOf(tmpEnergyFormater.formatAlpha(alpha)) + sAlpha;
        }
        if (beta < 0.0) {
            resultat = alpha == 0.0 ? String.valueOf(resultat) + tmpEnergyFormater.formatBeta(beta) + sBeta : String.valueOf(resultat) + " - " + tmpEnergyFormater.formatBeta(-beta) + sBeta;
        } else if (beta >= 0.0) {
            resultat = alpha != 0.0 ? String.valueOf(resultat) + " + " + tmpEnergyFormater.formatBeta(beta) + sBeta : String.valueOf(resultat) + tmpEnergyFormater.formatBeta(beta) + sBeta;
        }
        tmpEnergyFormater = null;
        return resultat;
    }

    public Energy(double alpha, double beta) {
        this.alpha = alpha;
        this.beta = beta;
        this.energyFormater = null;
    }

    public Energy(double alpha, double beta, EnergyFormater energyFormater) {
        this.alpha = alpha;
        this.beta = beta;
        this.energyFormater = energyFormater;
    }

    public Energy(Energy e) {
        this.alpha = e.getAlpha();
        this.beta = e.getBeta();
        this.energyFormater = e.energyFormater;
    }

    public void add(double alpha, double beta) {
        this.alpha += alpha;
        this.beta += beta;
    }

    public void add(Energy e) {
        this.alpha += e.getAlpha();
        this.beta += e.getBeta();
    }

    public Object clone() {
        return new Energy(this);
    }

    public int compareTo(Object o) {
        if (!(o instanceof Energy)) {
            throw new ClassCastException("object to compare is not an instance of Energy class");
        }
        Energy e = (Energy)o;
        if (this.alpha != e.alpha) {
            throw new ClassCastException("alpha must be identic for the both compared energies");
        }
        return new Double(this.beta).compareTo(new Double(e.beta));
    }

    public Energy conjugation() {
        return new Energy(this.alpha, -this.beta);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Energy)) {
            throw new ClassCastException();
        }
        Energy e = (Energy)o;
        return this.alpha == e.getAlpha() && this.beta == e.getBeta();
    }

    public int hashCode() {
        int multiplier = 23;
        if (this.hashCode == 0) {
            int code = 133;
            code = 23 * code + new Double(this.alpha).hashCode();
            this.hashCode = code = 23 * code + new Double(this.beta).hashCode();
        }
        return this.hashCode;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public boolean isGreaterThan(Energy e) throws HulisException {
        if (e.getAlpha() != this.getAlpha()) {
            throw new HulisException("alpha must be identical to compare energies");
        }
        return -this.beta > -e.getBeta();
    }

    public void mult(double n) {
        this.alpha *= n;
        this.beta *= n;
    }

    public void set(double alpha, double beta) {
        this.alpha = alpha;
        this.beta = beta;
    }

    public void setEnergyFormater(EnergyFormater sformat) {
        this.energyFormater = sformat;
    }

    public void sub(double alpha, double beta) {
        this.alpha -= alpha;
        this.beta -= beta;
    }

    public void sub(Energy e) {
        this.alpha -= e.getAlpha();
        this.beta -= e.getBeta();
    }

    public String toString() {
        return Energy.format(this, this.energyFormater);
    }

    public String toString(EnergyFormater energyFormater) {
        return Energy.format(this, energyFormater);
    }

    public String alphaToString() {
        if (this.energyFormater == null) {
            return String.valueOf(this.alpha) + ALPHA;
        }
        return String.valueOf(this.energyFormater.formatAlpha(this.alpha)) + ALPHA;
    }

    public String betaToString() {
        if (this.energyFormater == null) {
            return String.valueOf(this.beta) + BETA;
        }
        return String.valueOf(this.energyFormater.formatBeta(this.beta)) + BETA;
    }

    public static Energy MIN(Orbitale orb) {
        Energy e = new Energy(orb.getEnergy().getAlpha(), 2.147483647E9);
        return e;
    }

    public static Energy MAX(Orbitale orb) {
        Energy e = new Energy(orb.getEnergy().getAlpha(), -2.147483647E9);
        return e;
    }

    public boolean isGreaterThan(Energy energy, int precision) {
        if (energy.getAlpha() != this.getAlpha()) {
            return false;
        }
        return Maths.round(-this.beta, precision) > -Maths.round(energy.getBeta(), precision);
    }

    public static class DefaultEnergyFormater
    implements EnergyFormater {
        @Override
        public LetterFormat getFormatLetters() {
            return LetterFormat.UTF8;
        }

        @Override
        public String formatAlpha(double number) {
            return Double.toString(number);
        }

        @Override
        public String formatBeta(double number) {
            return Double.toString(number);
        }
    }

    public static interface EnergyFormater {
        public LetterFormat getFormatLetters();

        public String formatAlpha(double var1);

        public String formatBeta(double var1);
    }

    public static enum LetterFormat {
        UTF8,
        ASCII;

    }
}

