/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.huckel;

import java.io.Serializable;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.BlocDelocalized;
import org.ctom.hulis.huckel.HuckelBond;
import org.ctom.hulis.huckel.IHuckelObject;
import org.ctom.hulis.huckel.PeriodicTable;
import org.ctom.hulis.huckel.events.HuckelAtomEvent;
import org.ctom.hulis.huckel.exception.HuckelAtomException;
import org.ctom.hulis.huckel.listeners.IAtomValueListener;
import org.ctom.hulis.huckel.listeners.IHuckelAtomListener;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureDelocalized;
import org.ctom.hulis.huckel.structures.StructureLocalized;

public class HuckelAtom
extends Atom
implements IHuckelObject,
Cloneable,
Serializable {
    private static final long serialVersionUID = 655377641393938248L;
    public static final int MAX_RAD_R = 2;
    protected double hx;
    protected int nbElecPi;
    protected int nbElecSigma;
    protected int seqNum;
    protected int nbRadR;
    protected double density;
    private BlocDelocalized blocDelocalizedParent;

    public HuckelAtom(HuckelAtom a) {
        super(a);
        this.density = a.density;
        this.hx = a.hx;
        this.nbRadR = a.nbRadR;
        this.seqNum = a.seqNum;
        this.nbElecPi = a.nbElecPi;
        this.nbElecSigma = a.nbElecSigma;
    }

    public HuckelAtom(int atomicNumber, PeriodicTable.Entry entry, PeriodicTable.Element element, String type, String name, int nbElecSigma, int nbElecPi, int nbElecVal, double hx, int nbNeighbours) {
        super(atomicNumber, entry, element, type, name, nbElecVal, nbNeighbours);
        this.hx = hx;
        this.nbElecSigma = nbElecSigma;
        this.nbElecPi = nbElecPi;
        this.nbRadR = 0;
    }

    protected void fireHxChanged(HuckelAtom source, Object oldValue, Object newValue) {
        HuckelAtomEvent event = null;
        for (IAtomValueListener listener : this.getValueListeners()) {
            if (event == null) {
                event = new HuckelAtomEvent(source, oldValue, newValue);
            }
            ((IHuckelAtomListener)listener).huckelAtomHxChanged(event);
        }
    }

    protected void fireSeqNumChanged(HuckelAtom source, Object oldValue, Object newValue) {
        HuckelAtomEvent event = null;
        for (IAtomValueListener listener : this.getValueListeners()) {
            if (event == null) {
                event = new HuckelAtomEvent(source, oldValue, newValue);
            }
            ((IHuckelAtomListener)listener).huckelAtomSeqNumChanged(event);
        }
    }

    protected void fireRadRChanged(HuckelAtom source, Object oldValue, Object newValue) {
        HuckelAtomEvent event = null;
        for (IAtomValueListener listener : this.getValueListeners()) {
            if (event == null) {
                event = new HuckelAtomEvent(source, oldValue, newValue);
            }
            ((IHuckelAtomListener)listener).huckelAtomRadRChanged(event);
        }
    }

    public void autoSeqNum() {
        int old = this.getSeqNum();
        if (this.seqNum == 0) {
            this.seqNum = this.getMoleculeContainer().getMaxAtomSeqNum() + 1;
        }
        if (old != this.seqNum) {
            this.fireSeqNumChanged(this, old, this.getSeqNum());
        }
    }

    @Override
    public Object clone() {
        return new HuckelAtom(this);
    }

    public int countRadR() {
        return this.nbRadR;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HuckelAtom)) {
            return false;
        }
        HuckelAtom hA = (HuckelAtom)o;
        return super.equals(hA) && hA.nbRadR == this.nbRadR && hA.getSeqNum() == this.getSeqNum() && hA.getHx() == this.hx && hA.nbElecPi == this.nbElecPi;
    }

    @Override
    public int hashCode() {
        int multiplier = 23;
        if (this.hashCode == 0) {
            int code = 133;
            code = 23 * code + super.hashCode();
            code = 23 * code + this.nbRadR;
            code = 23 * code + this.seqNum;
            code = 23 * code + new Double(this.hx).hashCode();
            this.hashCode = code = 23 * code + this.nbElecPi;
        }
        return this.hashCode;
    }

    @Override
    public double getDensity() {
        return this.density;
    }

    public double getHx() {
        return this.hx;
    }

    @Override
    public String getNameParamHuckel() {
        return "hX";
    }

    @Override
    public String getNameParamHuckelHTML() {
        return "h<sub>X</sub>";
    }

    public int getNbElecPi() {
        return this.nbElecPi;
    }

    public void setNbElecPi(int nbElecPi) {
        this.nbElecPi = nbElecPi;
    }

    public int getNbElecSigma() {
        return this.nbElecSigma;
    }

    @Override
    public int getNbRadR() {
        return this.nbRadR;
    }

    @Override
    public double getParamHuckel() {
        return this.hx;
    }

    public int getSeqNum() {
        return this.seqNum;
    }

    public void setDensity(double density) {
        this.density = density;
    }

    public void setHx(double hx) {
        if (this.moleculeParentContainer instanceof StructureLocalized) {
            try {
                throw new HuckelAtomException("Cannot set Hx on a localized structure");
            }
            catch (HuckelAtomException e) {
                e.printStackTrace();
            }
        }
        if (this.moleculeParentContainer instanceof Structure && ((Structure)this.moleculeParentContainer).getMesomeryParent() != null && ((Structure)this.moleculeParentContainer).getMesomeryParent().countLocalizedStructs() > 0) {
            try {
                throw new HuckelAtomException("Cannot set Hx. There are localized structures in the mesomery");
            }
            catch (HuckelAtomException e) {
                e.printStackTrace();
            }
        }
        double old = this.getHx();
        this.hx = hx;
        if (this.hx != old) {
            this.fireHxChanged(this, old, this.getHx());
        }
    }

    public void setRadR(int nbRadR) throws HuckelAtomException {
        if (this.moleculeParentContainer instanceof StructureDelocalized) {
            throw new HuckelAtomException("Cannot put electrons on an atom in a delocalized structure");
        }
        if (nbRadR < 0 || nbRadR > 2) {
            throw new HuckelAtomException("incorrect number of radical R : cannot put : " + nbRadR);
        }
        if (this.blocDelocalizedParent != null) {
            throw new HuckelAtomException("Cannot change the number of electrons : this atom owns to a delocalized block");
        }
        int old = this.getNbRadR();
        this.do_setRadR(nbRadR);
        if (this.nbRadR != old) {
            this.fireRadRChanged(this, old, this.getNbRadR());
        }
    }

    public void do_setRadR(int nbRadR) {
        this.nbRadR = nbRadR;
        if (this.moleculeParentContainer != null) {
            this.moleculeParentContainer.updateCharges();
        }
    }

    public void setSeqNum(int seqNum) throws HuckelAtomException {
        if (this.moleculeParentContainer instanceof StructureLocalized) {
            try {
                throw new HuckelAtomException("Cannot number atom on a localized structure");
            }
            catch (HuckelAtomException e) {
                e.printStackTrace();
            }
        }
        if (this.moleculeParentContainer instanceof Structure && ((Structure)this.moleculeParentContainer).getMesomeryParent() != null && ((Structure)this.moleculeParentContainer).getMesomeryParent().countLocalizedStructs() > 0) {
            throw new RuntimeException("Cannot number the atom. There are localized structures in the mesomery");
        }
        if (seqNum < 0) {
            throw new HuckelAtomException("incorrect sequence number");
        }
        int old = this.getSeqNum();
        this.seqNum = seqNum;
        if (this.seqNum != old) {
            this.fireSeqNumChanged(this, old, this.getSeqNum());
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.getSeqNum()) + " " + this.getSigle();
    }

    public int countBondAtomInBloc() {
        int nDB = 0;
        for (HuckelBond bond : this.moleculeParentContainer.getHuckelBonds()) {
            if (bond.getBlocDelocalizedParent() == null || bond.getAtom1() != this && bond.getAtom2() != this) continue;
            ++nDB;
        }
        return nDB;
    }

    @Override
    public BlocDelocalized getBlocDelocalizedParent() {
        return this.blocDelocalizedParent;
    }

    @Override
    public void setBlocDelocalizedParent(BlocDelocalized blocDelocalized) {
        this.blocDelocalizedParent = blocDelocalized;
    }

    public void addListener(IHuckelAtomListener listener) {
        super.addListener(listener);
    }

    public void removeListener(IHuckelAtomListener listener) {
        super.removeListener(listener);
    }

    @Override
    public int getNbElectrons() {
        return this.getNbRadR();
    }
}

