/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.huckel;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.ctom.hulis.huckel.HuckelAtom;
import org.ctom.hulis.huckel.HuckelBond;
import org.ctom.hulis.huckel.IHuckelObject;
import org.ctom.hulis.util.VectorssHuckel;
import org.ctom.hulis.util.io.HuckelIO;
import org.ctom.util.maths.Maths;

public abstract class HuckelBlock
implements Serializable {
    private static final long serialVersionUID = -6648719278422253428L;
    ArrayList<IHuckelObject> lstHuckelObject = new ArrayList();
    int nbElectrons = 0;

    public int hashCode() {
        return Objects.hash(this.lstHuckelObject, this.nbElectrons);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HuckelBlock other = (HuckelBlock)obj;
        List<IHuckelObject> lstHuckelObjectsA = this.getListHuckelObject();
        List<IHuckelObject> lstHuckelObjectsB = other.getListHuckelObject();
        if (lstHuckelObjectsA.size() != lstHuckelObjectsB.size()) {
            return false;
        }
        for (IHuckelObject a : lstHuckelObjectsA) {
            boolean ok = false;
            for (IHuckelObject a2 : lstHuckelObjectsB) {
                if (!a.equals(a2)) continue;
                ok = true;
                break;
            }
            if (ok) continue;
            return false;
        }
        return this.nbElectrons == other.nbElectrons;
    }

    public boolean isEmpty() {
        return this.getListHuckelObject().isEmpty();
    }

    public int getNbElectron() {
        return this.nbElectrons;
    }

    public void setNbElectron(int nbElectrons) {
        this.nbElectrons = nbElectrons;
    }

    public Map<Integer, HuckelAtom> generateTableCorrespondanceMatrixIndexToAtom() {
        Comparator<HuckelAtom> comparator = new Comparator<HuckelAtom>(){

            @Override
            public int compare(HuckelAtom o1, HuckelAtom o2) {
                return o1.getSeqNum() - o2.getSeqNum();
            }
        };
        List<HuckelAtom> lstHuckelAtoms = this.getListHuckelAtom();
        Collections.sort(lstHuckelAtoms, comparator);
        HashMap<Integer, HuckelAtom> tableCorrespondance = new HashMap<Integer, HuckelAtom>();
        int i2 = 0;
        while (i2 < lstHuckelAtoms.size()) {
            tableCorrespondance.put(i2, lstHuckelAtoms.get(i2));
            ++i2;
        }
        return tableCorrespondance;
    }

    public Map<HuckelAtom, Integer> generateTableCorrespondanceAtomToMatrixIndex() {
        Comparator<HuckelAtom> comparator = new Comparator<HuckelAtom>(){

            @Override
            public int compare(HuckelAtom o1, HuckelAtom o2) {
                return o1.getSeqNum() - o2.getSeqNum();
            }
        };
        List<HuckelAtom> lstHuckelAtoms = this.getListHuckelAtom();
        Collections.sort(lstHuckelAtoms, comparator);
        HashMap<HuckelAtom, Integer> tableCorrespondance = new HashMap<HuckelAtom, Integer>();
        int i2 = 0;
        while (i2 < lstHuckelAtoms.size()) {
            tableCorrespondance.put(lstHuckelAtoms.get(i2), i2);
            ++i2;
        }
        return tableCorrespondance;
    }

    public double[] calcDistributionElecArray() {
        int nbHuckelAtoms = this.getListHuckelAtom().size();
        double[] repartitionElec = new double[nbHuckelAtoms];
        int i2 = 0;
        while (i2 < repartitionElec.length) {
            repartitionElec[i2] = 0.0;
            ++i2;
        }
        int nbElecArepartir = this.getNbElectron();
        double[] energies = this.calcOrbitalsEnergies();
        int i3 = 0;
        int fin = 0;
        int d = 0;
        while (nbElecArepartir > 0) {
            int current;
            d = 1;
            while (i3 + d < energies.length && Maths.round(energies[i3], 2) == Maths.round(energies[i3 + d], 2)) {
                ++d;
            }
            fin = i3 + d - 1;
            if (nbElecArepartir >= 2 * d) {
                current = i3;
                while (current < fin + 1) {
                    System.out.println(String.valueOf(current) + "    " + repartitionElec.length);
                    if (current >= repartitionElec.length) {
                        HuckelIO.error(this.getClass().getName(), "calcDistributionElecArray", "impossible de repartir les electrons");
                        break;
                    }
                    repartitionElec[current] = 2.0;
                    ++current;
                }
                nbElecArepartir -= 2 * d;
            } else if (nbElecArepartir < 2 * d) {
                current = i3;
                while (current < fin + 1) {
                    if (current >= repartitionElec.length) {
                        HuckelIO.error(this.getClass().getName(), "calcDistributionElecArray", "impossible de repartir les electrons");
                        break;
                    }
                    repartitionElec[current] = (double)nbElecArepartir / (double)d;
                    ++current;
                }
                nbElecArepartir = 0;
            }
            i3 = fin + 1;
        }
        HuckelIO.PrintVector(repartitionElec, "distrib elec array petit bloc");
        return repartitionElec;
    }

    public Matrix calcMatrixHamiltonian() {
        Map<HuckelAtom, Integer> tableCorrespondance = this.generateTableCorrespondanceAtomToMatrixIndex();
        int nbAtomes = this.getListHuckelAtom().size();
        Matrix hamiltonien = new Matrix(nbAtomes, nbAtomes);
        for (HuckelAtom a : this.getListHuckelAtom()) {
            if (a.getSeqNum() <= 0) {
                return null;
            }
            hamiltonien.set(tableCorrespondance.get(a), tableCorrespondance.get(a), a.getHx());
        }
        for (HuckelBond l : this.getListHuckelBond()) {
            int x = tableCorrespondance.get(l.getAtom1());
            int y = tableCorrespondance.get(l.getAtom2());
            double hxy = l.getHxy();
            if (x < 0 || y < 0) continue;
            hamiltonien.set(x, y, hxy);
            hamiltonien.set(y, x, hxy);
        }
        HuckelIO.PrintMatrix(hamiltonien, "hamiltonien petit bloc");
        return hamiltonien;
    }

    public double[][] calcOrbitalsCoeffArray() {
        Matrix hamiltionianBlock = this.calcMatrixHamiltonian();
        EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(hamiltionianBlock);
        HuckelIO.PrintMatrix(new Matrix(VectorssHuckel.sort(eigenvalueDecomposition.getV().getArray())), "orbitales petit bloc");
        return VectorssHuckel.sort(eigenvalueDecomposition.getV().getArray());
    }

    public double[] calcOrbitalsEnergies() {
        Matrix hamiltionianBlock = this.calcMatrixHamiltonian();
        EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(hamiltionianBlock);
        HuckelIO.PrintVector(VectorssHuckel.sort(eigenvalueDecomposition.getRealEigenvalues()), "calcOrbitalsEnergies petit bloc");
        return VectorssHuckel.sort(eigenvalueDecomposition.getRealEigenvalues());
    }

    public double[] calcChargeDensitiesArray() {
        Map<Integer, HuckelAtom> tableCorrespondance = this.generateTableCorrespondanceMatrixIndexToAtom();
        double[] tblCharges = new double[this.getListHuckelAtom().size()];
        double somme = 0.0;
        double Ci = 0.0;
        double[] repartitionElec = this.calcDistributionElecArray();
        double[][] orbitalsCoeffsArray = this.calcOrbitalsCoeffArray();
        int i2 = 0;
        while (i2 < orbitalsCoeffsArray.length) {
            somme = 0.0;
            int j = 0;
            while (j < orbitalsCoeffsArray[i2].length) {
                Ci = orbitalsCoeffsArray[i2][j];
                somme += Ci * Ci * repartitionElec[j];
                ++j;
            }
            HuckelAtom a = tableCorrespondance.get(i2);
            tblCharges[i2] = (double)a.getNbElecPi() - somme;
            a.setDensity(tblCharges[i2]);
            ++i2;
        }
        return tblCharges;
    }

    public double[][] calcBondOrdersArray() {
        Map<HuckelAtom, Integer> tableCorrespondance = this.generateTableCorrespondanceAtomToMatrixIndex();
        double somme = 0.0;
        double CA = 0.0;
        double CB = 0.0;
        double[] repartitionElec = this.calcDistributionElecArray();
        double[][] orbitalsCoeffsArray = this.calcOrbitalsCoeffArray();
        double[][] ordresLiaison = new double[orbitalsCoeffsArray.length][orbitalsCoeffsArray.length];
        int i2 = 0;
        while (i2 < ordresLiaison.length) {
            int j = 0;
            while (j < ordresLiaison[i2].length) {
                somme = 0.0;
                int l = 0;
                while (l < orbitalsCoeffsArray.length) {
                    CA = orbitalsCoeffsArray[i2][l];
                    CB = orbitalsCoeffsArray[j][l];
                    somme += CA * CB * repartitionElec[l];
                    ++l;
                }
                ordresLiaison[i2][j] = somme;
                ++j;
            }
            ++i2;
        }
        for (HuckelBond b : this.getListHuckelBond()) {
            b.setBondOrder(ordresLiaison[tableCorrespondance.get(b.getAtom1())][tableCorrespondance.get(b.getAtom2())]);
        }
        return ordresLiaison;
    }

    public List<HuckelAtom> getListHuckelAtom() {
        ArrayList<HuckelAtom> lstHuckelAtom = new ArrayList<HuckelAtom>();
        for (IHuckelObject o : this.getListHuckelObject()) {
            if (!(o instanceof HuckelAtom)) continue;
            lstHuckelAtom.add((HuckelAtom)o);
        }
        return lstHuckelAtom;
    }

    public List<HuckelBond> getListHuckelBond() {
        ArrayList<HuckelBond> lstHuckelBond = new ArrayList<HuckelBond>();
        for (IHuckelObject o : this.getListHuckelObject()) {
            if (!(o instanceof HuckelBond)) continue;
            lstHuckelBond.add((HuckelBond)o);
        }
        return lstHuckelBond;
    }

    public List<IHuckelObject> getListHuckelObject() {
        return (List)this.lstHuckelObject.clone();
    }

    public boolean containsHuckelObject(IHuckelObject o) {
        return this.getListHuckelObject().contains(o);
    }

    public int countHuckelObjects() {
        return this.getListHuckelObject().size();
    }

    public String toString() {
        List<HuckelBond> bonds = this.getListHuckelBond();
        int nbonds = bonds.size();
        int nAtomsAlone = 0;
        int nLinkedAtoms = 0;
        for (HuckelAtom atom : this.getListHuckelAtom()) {
            boolean found = false;
            Iterator<HuckelBond> it = bonds.iterator();
            while (it.hasNext() && !found) {
                HuckelBond b = it.next();
                if (!b.contains(atom)) continue;
                found = true;
            }
            if (found) {
                ++nLinkedAtoms;
                continue;
            }
            ++nAtomsAlone;
        }
        this.getListHuckelAtom().size();
        return "block : " + nbonds + " bonds, " + nLinkedAtoms + " linked atoms, " + nAtomsAlone + " atoms not linked, " + this.getNbElectron() + " electrons";
    }
}

