/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.huckel;

import java.io.Serializable;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.BlocDelocalized;
import org.ctom.hulis.huckel.Bond;
import org.ctom.hulis.huckel.HuckelAtom;
import org.ctom.hulis.huckel.IHuckelObject;
import org.ctom.hulis.huckel.PeriodicTable;
import org.ctom.hulis.huckel.events.HuckelBondEvent;
import org.ctom.hulis.huckel.exception.BondException;
import org.ctom.hulis.huckel.exception.HuckelBondException;
import org.ctom.hulis.huckel.listeners.IBondListener;
import org.ctom.hulis.huckel.listeners.IHuckelBondListener;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureDelocalized;
import org.ctom.hulis.huckel.structures.StructureLocalized;

public class HuckelBond
extends Bond
implements IHuckelObject,
Cloneable,
Serializable {
    private static final long serialVersionUID = 2118885093223851933L;
    public static final int MAX_TYPE_BOND = 2;
    public static double[][] tblHxy = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.73, 0.87, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.02, 0.66, 1.09, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.89, 0.53, 0.99, 0.98, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.06, 0.6, 1.14, 1.13, 1.26, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.66, 0.35, 0.8, 0.89, 1.02, 0.95, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.52, 0.26, 0.65, 0.77, 0.92, 0.94, 1.04, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.75, 0.57, 0.72, 0.43, 0.65, 0.24, 0.17, 0.64, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.77, 0.53, 0.78, 0.55, 0.75, 0.31, 0.21, 0.62, 0.63, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.76, 0.54, 0.81, 0.64, 0.82, 0.39, 0.22, 0.52, 0.58, 0.62, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.81, 0.51, 0.83, 0.68, 0.84, 0.43, 0.28, 0.61, 0.65, 0.65, 0.66, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.69, 0.44, 0.78, 0.73, 0.85, 0.54, 0.32, 0.4, 0.48, 0.6, 0.58, 0.63, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.62, 0.41, 0.77, 0.8, 0.88, 0.7, 0.51, 0.34, 0.35, 0.55, 0.52, 0.59, 0.68, 0.0, 0.0, 0.0, 0.0}, {0.707, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0}, {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}};
    protected double bondOrder;
    protected int bondType;
    public BlocDelocalized blocDelocalizedParent;
    protected double hxy;

    public static double getHxy(PeriodicTable.Entry entry1, PeriodicTable.Entry entry2) throws HuckelBondException {
        if (entry1 == null || entry2 == null) {
            throw new HuckelBondException("atom must be initalized");
        }
        HuckelBond.initHxy();
        int index1 = HuckelBond.getIndex(entry1);
        int index2 = HuckelBond.getIndex(entry2);
        return tblHxy[index1][index2];
    }

    private static int getIndex(PeriodicTable.Entry entry) {
        int i2 = 0;
        PeriodicTable.Entry[] entryArray = PeriodicTable.Entry.values();
        int n = entryArray.length;
        int n2 = 0;
        while (n2 < n) {
            PeriodicTable.Entry a = entryArray[n2];
            if (a == entry) break;
            ++i2;
            ++n2;
        }
        return i2;
    }

    private static void initHxy() {
        int i2 = 0;
        while (i2 < tblHxy.length) {
            int j = 0;
            while (j < tblHxy[i2].length) {
                if (tblHxy[i2][j] == 0.0) {
                    HuckelBond.tblHxy[i2][j] = tblHxy[j][i2];
                }
                ++j;
            }
            ++i2;
        }
    }

    public HuckelBond(HuckelAtom atom1, HuckelAtom atom2) throws BondException, HuckelBondException {
        super(atom1, atom2);
        this.bondType = 1;
        this.hxy = 0.0;
        if (atom1.getEntry() != null && atom2.getEntry() != null) {
            this.hxy = HuckelBond.getHxy(atom1.getEntry(), atom2.getEntry());
        }
        this.blocDelocalizedParent = null;
    }

    public HuckelBond(HuckelAtom atom1, HuckelAtom atom2, int bondType) throws BondException, HuckelBondException {
        super(atom1, atom2);
        this.bondType = bondType;
        this.hxy = 0.0;
        if (atom1.getEntry() != null && atom2.getEntry() != null) {
            this.hxy = HuckelBond.getHxy(atom1.getEntry(), atom2.getEntry());
        }
        this.blocDelocalizedParent = null;
        this.checkCoherence();
    }

    public HuckelBond(HuckelBond bond) {
        super(bond);
        this.bondOrder = bond.bondOrder;
        this.bondType = bond.bondType;
        this.hxy = bond.hxy;
        this.blocDelocalizedParent = null;
    }

    @Override
    public Object clone() {
        return new HuckelBond(this);
    }

    @Override
    public int hashCode() {
        int multiplier = 23;
        if (this.hashCode == 0) {
            int code = 133;
            code = 23 * code + super.hashCode();
            code = 23 * code + this.bondType;
            this.hashCode = code = 23 * code + new Double(this.hxy).hashCode();
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HuckelBond)) {
            return false;
        }
        HuckelBond hB = (HuckelBond)o;
        return super.equals(hB) && hB.bondType == this.bondType && hB.hxy == this.hxy;
    }

    public void checkCoherence() throws HuckelBondException {
        if (this.bondType < 1 || this.bondType > 2) {
            throw new HuckelBondException("set unavailable valye type of bond : " + this.bondType + " for " + this);
        }
        if (this.bondType > 1 && this.blocDelocalizedParent != null || this.getAtom1().getBlocDelocalizedParent() != null || this.getAtom2().getBlocDelocalizedParent() != null) {
            throw new HuckelBondException("Cannot change bond type : the bond " + this + " owns to a  delocalized block");
        }
    }

    @Override
    public BlocDelocalized getBlocDelocalizedParent() {
        return this.blocDelocalizedParent;
    }

    @Override
    public void setBlocDelocalizedParent(BlocDelocalized blocDelocalizedParent) {
        this.blocDelocalizedParent = blocDelocalizedParent;
    }

    @Override
    public HuckelAtom getAtom1() {
        return (HuckelAtom)this.atom1;
    }

    @Override
    public HuckelAtom getAtom2() {
        return (HuckelAtom)this.atom2;
    }

    public double getBondOrder() {
        return this.bondOrder;
    }

    public int getBondType() {
        return this.bondType;
    }

    @Override
    public int getNbRadR() {
        if (this.getBondType() == 2) {
            return 2;
        }
        return 0;
    }

    @Override
    public double getDensity() {
        return this.bondOrder;
    }

    public double getHxy() {
        return this.hxy;
    }

    @Override
    public String getNameParamHuckel() {
        return "hXY";
    }

    @Override
    public String getNameParamHuckelHTML() {
        return "h<sub>XY</sub>";
    }

    @Override
    public double getParamHuckel() {
        return this.hxy;
    }

    @Override
    protected void replaceAtom(Atom old, Atom newAtom) throws BondException {
        super.replaceAtom(old, newAtom);
        if (old instanceof HuckelAtom && newAtom instanceof HuckelAtom && this.atom1 != null && this.atom2 != null && this.atom1.getEntry() != null && this.atom2.getEntry() != null) {
            this.hxy = HuckelBond.getHxy(((HuckelAtom)this.atom1).getEntry(), ((HuckelAtom)this.atom2).getEntry());
        }
    }

    public void setBondOrder(double bondOrder) {
        this.bondOrder = bondOrder;
    }

    public void setBondType(int bondType) throws HuckelBondException {
        if (this.moleculeParentContainer instanceof StructureDelocalized) {
            throw new HuckelBondException("Cannot change bond type delocalized structure");
        }
        if (bondType < 1 || bondType > 2) {
            throw new HuckelBondException("incorrect type of bond");
        }
        int old = this.getBondType();
        this.do_setBondType(bondType);
        this.checkCoherence();
        if (old != this.bondType) {
            this.fireBondTypeChanged(this, old, this.getBondType());
        }
    }

    protected void do_setBondType(int bondType) {
        this.bondType = bondType;
        this.moleculeParentContainer.updateCharges();
    }

    public void setHxy(double hxy) throws HuckelBondException {
        if (this.moleculeParentContainer instanceof StructureLocalized) {
            throw new HuckelBondException("Cannot set Hxy on a localized structure");
        }
        if (this.moleculeParentContainer instanceof Structure && ((Structure)this.moleculeParentContainer).getMesomeryParent() != null && ((Structure)this.moleculeParentContainer).getMesomeryParent().countLocalizedStructs() > 0) {
            throw new HuckelBondException("Cannot set Hxy. There are localized structures in the mesomery");
        }
        if (hxy == this.hxy) {
            return;
        }
        double old = this.getHxy();
        this.hxy = hxy;
        if (this.hxy != old) {
            this.fireHxyChanged(this, old, this.getHxy());
        }
    }

    @Override
    public String toString() {
        String res = "";
        res = String.valueOf(res) + this.getAtom1().toString();
        res = this.getBondType() == 1 ? String.valueOf(res) + "-" : (this.getBondType() == 2 ? String.valueOf(res) + "=" : String.valueOf(res) + "-(*" + this.getBondType() + ")-");
        res = String.valueOf(res) + this.getAtom2().toString();
        return res;
    }

    protected void fireHxyChanged(HuckelBond source, Object oldValue, Object newValue) {
        HuckelBondEvent event = null;
        for (IBondListener listener : this.getListeners()) {
            if (event == null) {
                event = new HuckelBondEvent(source, oldValue, newValue);
            }
            ((IHuckelBondListener)listener).huckelBondHxyChanged(event);
        }
    }

    protected void fireBondTypeChanged(HuckelBond source, Object oldValue, Object newValue) {
        HuckelBondEvent event = null;
        for (IBondListener listener : this.getListeners()) {
            if (event == null) {
                event = new HuckelBondEvent(source, oldValue, newValue);
            }
            ((IHuckelBondListener)listener).huckelBondBondTypeChanged(event);
        }
    }

    public void addListener(IHuckelBondListener listener) {
        super.addListener(listener);
    }

    public void removeListener(IHuckelBondListener listener) {
        super.removeListener(listener);
    }

    @Override
    public int getNbElectrons() {
        return this.getNbRadR();
    }
}

