/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.huckel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.ctom.hulis.files.gaussian.ReadGaussian;
import org.ctom.hulis.files.gaussian.ReadGaussianException;
import org.ctom.hulis.huckel.Input;
import org.ctom.hulis.huckel.comparators.OverlapComparator;
import org.ctom.hulis.huckel.events.BlocDelocalizedEvent;
import org.ctom.hulis.huckel.events.HuckelAtomEvent;
import org.ctom.hulis.huckel.events.HuckelBondEvent;
import org.ctom.hulis.huckel.events.MesomeryEvent;
import org.ctom.hulis.huckel.events.MoleculeEvent;
import org.ctom.hulis.huckel.events.MonoExcitationEvent;
import org.ctom.hulis.huckel.events.StructureDelocalizedEvent;
import org.ctom.hulis.huckel.events.StructureEvent;
import org.ctom.hulis.huckel.events.StructureLocalizedEvent;
import org.ctom.hulis.huckel.exception.AutoGenerateConditionException;
import org.ctom.hulis.huckel.exception.CoupleException;
import org.ctom.hulis.huckel.exception.DressStructureLocalizedException;
import org.ctom.hulis.huckel.exception.IMethodException;
import org.ctom.hulis.huckel.exception.IncorrectNumberPiElectronsException;
import org.ctom.hulis.huckel.exception.MesomeryDelocalizedStructureExistsException;
import org.ctom.hulis.huckel.exception.MesomeryDelocalizedStructureNotExistsException;
import org.ctom.hulis.huckel.exception.MesomeryLocalizedStructureExistsException;
import org.ctom.hulis.huckel.exception.MesomeryMethodExistsException;
import org.ctom.hulis.huckel.exception.MesomeryNoStructureLocalizedException;
import org.ctom.hulis.huckel.exception.MesomeryRemoveMethodException;
import org.ctom.hulis.huckel.exception.SelectionException;
import org.ctom.hulis.huckel.listeners.IMesomeryListener;
import org.ctom.hulis.huckel.listeners.IStructureDelocalizedListener;
import org.ctom.hulis.huckel.listeners.IStructureLocalizedListener;
import org.ctom.hulis.huckel.methods.IMethod;
import org.ctom.hulis.huckel.methods.IMethodHasOptimizableMatrix;
import org.ctom.hulis.huckel.selectors.IStructuresSelector;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureDelocalized;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import org.ctom.hulis.prefs.Preferences;
import org.ctom.hulis.util.configS.Conf;
import org.ctom.hulis.util.io.HuckelIO;
import org.ctom.util.time.CTOMProfiler;

public class Mesomery
extends Input
implements Cloneable,
IStructureLocalizedListener,
IStructureDelocalizedListener,
Serializable {
    private static final long serialVersionUID = -9098113981147780386L;
    protected static final int nMaxIter = 1000;
    private static POLICY_STRUCTURE_CHANGED policyStructureChanged = POLICY_STRUCTURE_CHANGED.CHANGE_TRESHOLD_TO_STRUCTURE_VALUE_IF_LOWER;
    private boolean isCloneResultsCacheWhenCloneMesomery;
    public boolean isEnabledFlyCalculate;
    private ArrayList<IMesomeryListener> listeners;
    private HashMap<String, IMethod> lstMethods;
    private ArrayList<Structure> lstSelectedStructs;
    private ArrayList<Structure> lstStructs;
    Conf myconfig = null;
    private int precision = 2;
    private volatile boolean isStopConsumingProcess;
    private volatile boolean isAutoGenerating;
    private volatile boolean isCalculatingWeights;
    private IStructuresSelector structuresSelector;

    public Mesomery() {
        this.isCloneResultsCacheWhenCloneMesomery = true;
        this.isEnabledFlyCalculate = true;
        this.lstSelectedStructs = new ArrayList();
        this.lstStructs = new ArrayList();
        this.listeners = new ArrayList();
        this.lstMethods = new HashMap();
        this.structuresSelector = null;
    }

    public Mesomery(Mesomery mesomery) {
        this.isCloneResultsCacheWhenCloneMesomery = mesomery.isCloneResultsCacheWhenCloneMesomery();
        this.isEnabledFlyCalculate = mesomery.isEnabledFlyCalculate();
        this.lstSelectedStructs = new ArrayList();
        this.lstStructs = new ArrayList();
        this.listeners = new ArrayList();
        if (this.myconfig != null) {
            this.myconfig.erase();
        }
        this.lstMethods = new HashMap();
        for (Map.Entry<String, IMethod> entry : mesomery.lstMethods.entrySet()) {
            IMethod methodClone = null;
            if (mesomery.isCloneResultsCacheWhenCloneMesomery()) {
                methodClone = (IMethod)entry.getValue().clone();
            } else {
                try {
                    methodClone = (IMethod)entry.getValue().getClass().newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            }
            methodClone.setMesomery(this);
            this.lstMethods.put(entry.getKey(), methodClone);
        }
        try {
            this.deleteAllStructures();
        }
        catch (CoupleException | IMethodException | MesomeryNoStructureLocalizedException e) {
            e.printStackTrace();
        }
        if (mesomery.getDelocalizedStructure() != null) {
            try {
                this.do_addDelocalizedStruct((StructureDelocalized)mesomery.getDelocalizedStructure().clone());
            }
            catch (MesomeryDelocalizedStructureExistsException e) {
                e.printStackTrace();
            }
        }
        for (StructureLocalized s : mesomery.getLocalizedStructures()) {
            this.do_addLocalizedStruct((StructureLocalized)s.clone());
        }
        try {
            this.do_afterAddLocalizedStructures();
        }
        catch (CoupleException | IMethodException | MesomeryNoStructureLocalizedException e) {
            e.printStackTrace();
        }
        if (mesomery.structuresSelector != null) {
            this.structuresSelector = (IStructuresSelector)mesomery.structuresSelector.clone();
            this.structuresSelector.setMesomery(this);
        } else {
            HuckelIO.warning(this.getClass().getName(), "copy", "Mesomery copied without structure selector !");
        }
        this.precision = mesomery.precision;
        this.updateSelectedStructs();
    }

    public Object clone() {
        return new Mesomery(this);
    }

    public List<Structure> getStructuresHaveDemiElectrons() {
        ArrayList<Structure> lstStructureHaveDemiElectrons = new ArrayList<Structure>();
        for (Structure s : this.getAllStructures()) {
            if (!s.hasDemiElectrons()) continue;
            lstStructureHaveDemiElectrons.add(s);
        }
        return lstStructureHaveDemiElectrons;
    }

    public void setStructureSelector(IStructuresSelector structuresSelector) {
        IStructuresSelector old = structuresSelector;
        this.structuresSelector = structuresSelector;
        this.structuresSelector.setMesomery(this);
        this.fireStructuresSelectorChanged(this, old, structuresSelector);
    }

    public IStructuresSelector getStructureSelector() {
        return this.structuresSelector;
    }

    public Mesomery(ReadGaussian readGaussian) throws ReadGaussianException {
        this();
        readGaussian.readAll(this);
    }

    public void addDelocalizedStruct(StructureDelocalized delocalizedStructure) throws MesomeryDelocalizedStructureExistsException {
        this.do_addDelocalizedStruct(delocalizedStructure);
        this.fireStructureAdded(this, null, delocalizedStructure);
        if (this.structuresSelector != null) {
            Object old = this.structuresSelector.getSelectionTreshold();
            this.structuresSelector.setSelectionTreshold(this.structuresSelector.getCurrentValue(delocalizedStructure));
            this.updateSelectedStructs();
            if (!this.structuresSelector.getSelectionTreshold().equals(old)) {
                this.fireStructuresSelectionTresholdChanged(this, old, this.structuresSelector.getSelectionTreshold());
            }
        }
    }

    public Structure getStructureByIndex(int index) {
        for (Structure s : this.getAllStructures()) {
            if (s.getIndex() != index) continue;
            return s;
        }
        return null;
    }

    private void do_addDelocalizedStruct(StructureDelocalized delocalizedStructure) throws MesomeryDelocalizedStructureExistsException {
        if (this.getDelocalizedStructure() != null) {
            throw new MesomeryDelocalizedStructureExistsException("the delocalized structure already exists");
        }
        delocalizedStructure.setCloneResultsCacheWhenCloneStructure(this.isCloneResultsCacheWhenCloneMesomery());
        delocalizedStructure.setMesomeryParent(this);
        delocalizedStructure.addListener(this);
        delocalizedStructure.setIndex(1);
        this.lstStructs.add(delocalizedStructure);
        this.lstSelectedStructs.add(delocalizedStructure);
        if (delocalizedStructure.isEnabledFlyCalculate()) {
            delocalizedStructure.calculate();
        }
    }

    public void addLocalizedStruct(StructureLocalized structure) throws CoupleException, IMethodException, MesomeryNoStructureLocalizedException {
        String routine = "addLocalizedStruct";
        CTOMProfiler.getInstance().debut(routine);
        this.do_addLocalizedStruct(structure);
        this.do_afterAddLocalizedStructures();
        this.fireStructureAdded(this, null, structure);
        CTOMProfiler.getInstance().fin(routine);
    }

    protected void do_addLocalizedStruct(StructureLocalized structure) {
        structure.setCloneResultsCacheWhenCloneStructure(this.isCloneResultsCacheWhenCloneMesomery());
        structure.addListener(this);
        structure.setMesomeryParent(this);
        structure.setName(Integer.toString(this.countLocalizedStructs() + 1));
        structure.setIndex(this.getMaxStructureIndex() + 1);
        this.lstStructs.add(structure);
    }

    protected void do_afterAddLocalizedStructures() throws CoupleException, IMethodException, MesomeryNoStructureLocalizedException {
        this.updateSelectedStructs();
        this.checkMesomery();
        if (this.isEnabledFlyCalculate && this.countSelectedLocalizedStructs() > 0) {
            Map<String, IMethod> sortedMap = this.getSortedMethodsByPriority();
            for (Map.Entry<String, IMethod> entry : sortedMap.entrySet()) {
                IMethod method = entry.getValue();
                if (!(method instanceof IMethodHasOptimizableMatrix)) continue;
                ((IMethodHasOptimizableMatrix)((Object)method)).extendOptimizableMatrix();
            }
            try {
                this.do_calculate();
            }
            catch (IncorrectNumberPiElectronsException e) {
                e.printStackTrace();
            }
            this.fireListWeightCalculated(this, null, null);
        }
    }

    public void addListener(IMesomeryListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void addMethod(IMethod method) throws MesomeryMethodExistsException, IncorrectNumberPiElectronsException, CoupleException, IMethodException, MesomeryNoStructureLocalizedException {
        if (this.lstMethods.get(method.getName()) != null) {
            throw new MesomeryMethodExistsException("mesomery already contains this method");
        }
        method.setMesomery(this);
        this.lstMethods.put(method.getName(), method);
        if (this.isEnabledFlyCalculate() && this.countLocalizedStructs() > 0) {
            if (method instanceof IMethodHasOptimizableMatrix) {
                ((IMethodHasOptimizableMatrix)((Object)method)).computeAllOptimizableMatrix();
            }
            this.calculate(method.getName());
        }
        this.fireMethodAdded(this, null, method);
    }

    public boolean containsMethod(IMethod method) {
        return this.lstMethods.get(method.getName()) != null;
    }

    /*
     * Unable to fully structure code
     */
    private void afterRemove(Structure struct, int idxToRemove, boolean notifyDeleted) throws IMethodException, MesomeryNoStructureLocalizedException {
        block16: {
            block15: {
                this.updateSelectedStructs();
                try {
                    try {
                        if (this.isEnabledFlyCalculate && this.countSelectedLocalizedStructs() > 0) {
                            sortedMap = this.getSortedMethodsByPriority();
                            for (Map.Entry<String, IMethod> entry : sortedMap.entrySet()) {
                                method = entry.getValue();
                                if (!(method instanceof IMethodHasOptimizableMatrix)) continue;
                                ((IMethodHasOptimizableMatrix)method).removeInOptimizableMatrix(idxToRemove);
                            }
                            this.do_calculate();
                            this.fireListWeightCalculated(this, null, null);
                        }
                        break block15;
                    }
                    catch (IncorrectNumberPiElectronsException e1) {
                        HuckelIO.warning(this.getClass().getName(), "remove", e1.getMessage(), e1);
                        i = 0;
                        ** while (i < this.countLocalizedStructs())
                    }
                }
                catch (Throwable var8_18) {
                    i = 0;
                    ** while (i < this.countLocalizedStructs())
                }
lbl-1000:
                // 1 sources

                {
                    this.getLocalizedStruct(i).setName(Integer.toString(i + 1));
                    ++i;
                    continue;
                }
lbl21:
                // 3 sources

                for (Structure s : this.getAllStructures()) {
                    if (s.getIndex() <= struct.getIndex()) continue;
                    s.setIndex(s.getIndex() - 1);
                }
                if (notifyDeleted) {
                    this.fireStructureRemoved(this, struct, null);
                }
                struct.removeListener(this);
                break block16;
lbl-1000:
                // 1 sources

                {
                    this.getLocalizedStruct(i).setName(Integer.toString(i + 1));
                    ++i;
                    continue;
                }
lbl35:
                // 3 sources

                for (Structure s : this.getAllStructures()) {
                    if (s.getIndex() <= struct.getIndex()) continue;
                    s.setIndex(s.getIndex() - 1);
                }
                if (notifyDeleted) {
                    this.fireStructureRemoved(this, struct, null);
                }
                struct.removeListener(this);
                throw var8_18;
            }
            i = 0;
            while (i < this.countLocalizedStructs()) {
                this.getLocalizedStruct(i).setName(Integer.toString(i + 1));
                ++i;
            }
            for (Structure s : this.getAllStructures()) {
                if (s.getIndex() <= struct.getIndex()) continue;
                s.setIndex(s.getIndex() - 1);
            }
            if (notifyDeleted) {
                this.fireStructureRemoved(this, struct, null);
            }
            struct.removeListener(this);
        }
    }

    protected int getMaxStructureIndex() {
        int maxIndex = 0;
        int currentIndex = 0;
        for (Structure a : this.getAllStructures()) {
            currentIndex = a.getIndex();
            if (currentIndex <= maxIndex) continue;
            maxIndex = currentIndex;
        }
        return maxIndex;
    }

    /*
     * Unable to fully structure code
     */
    public int autoGenLewisStructures() throws AutoGenerateConditionException, DressStructureLocalizedException, CoupleException, IMethodException, MesomeryNoStructureLocalizedException, IncorrectNumberPiElectronsException {
        block35: {
            block32: {
                block34: {
                    block33: {
                        routine = "autoGenLewisStructures";
                        CTOMProfiler.getInstance().debut(routine);
                        this.isAutoGenerating = true;
                        this.setStopConsumingProcess(false);
                        this.eraseConf();
                        skeleton = this.getDelocalizedStructure();
                        if (skeleton == null) {
                            this.isAutoGenerating = false;
                            throw new AutoGenerateConditionException("Invalid Skeleton ! value == null ");
                        }
                        if (skeleton.countAtoms() == 0) {
                            this.isAutoGenerating = false;
                            return -1;
                        }
                        if (!skeleton.areCorrectAtomsSeqNum()) {
                            this.isAutoGenerating = false;
                            throw new AutoGenerateConditionException("An atom has an incorrect sequence number");
                        }
                        sav = this.isEnabledFlyCalculate();
                        this.stopFlyCalculate();
                        if (this.myconfig != null) {
                            this.myconfig.stopFlyCalculate(this);
                        }
                        lstConfiguration = null;
                        lstConfiguration = new ArrayList<Conf>();
                        Conf.setMesomery(this);
                        t0 = System.currentTimeMillis();
                        this.myconfig = new Conf(skeleton);
                        imask = 1;
                        while (imask <= Conf.nMasque()) {
                            if (this.isStopConsumingProccess()) break;
                            if (this.myconfig.applyMasque(imask)) {
                                nMaxRadical = 2;
                                if (!Preferences.isCOUPLE_AUTOGEN()) {
                                    nMaxRadical = 1;
                                }
                                nRadical = 0;
                                while (nRadical <= nMaxRadical) {
                                    if (this.isStopConsumingProccess()) break;
                                    this.myconfig.generate(nRadical);
                                    ++nRadical;
                                }
                            }
                            ++imask;
                        }
                        t1 = System.currentTimeMillis();
                        System.out.println("time:" + (t1 - t0) + " ms");
                        for (Conf conf : Conf.getList()) {
                            if (this.isStopConsumingProccess()) break;
                            struct = skeleton.cloneToLocalized();
                            savCalculateFly = struct.isEnabledFlyCalculate();
                            struct.stopFlyCalculate();
                            try {
                                conf.dressStructureLocalized(struct);
                            }
                            catch (Exception e) {
                                this.isAutoGenerating = false;
                                e.printStackTrace();
                                throw new DressStructureLocalizedException(e.getMessage());
                            }
                            struct.setMethodCreation(StructureLocalized.CreationMethod.AUTO_GENERATED);
                            if (savCalculateFly) {
                                struct.startFlyCalculate();
                                struct.calculate();
                            }
                            this.do_addLocalizedStruct(struct);
                        }
                        this.do_afterAddLocalizedStructures();
                        i = 0;
                        while (i < this.lstStructs.size()) {
                            this.lstStructs.get(i).setIndex(i + 1);
                            struct = this.getAllStructures().get(i);
                            struct.calculateOverlapHLP();
                            ++i;
                        }
                        this.sortStructures(new OverlapComparator());
                        if (this.structuresSelector != null) {
                            oldValue = this.structuresSelector.getSelectionTreshold();
                            this.structuresSelector.setTresholdToLocalizedStructureMinimalValue();
                            if (!this.structuresSelector.getSelectionTreshold().equals(oldValue)) {
                                this.updateSelectedStructs();
                                this.fireStructuresSelectionTresholdChanged(this, oldValue, this.structuresSelector.getSelectionTreshold());
                            }
                        }
                        t2 = System.currentTimeMillis();
                        System.out.println("time dressing:" + (t2 - t1) + " ms");
                        size = 0;
                        try {
                            lstConfiguration.addAll(Conf.getList());
                            HuckelIO.PrintIf("\nNumber of generated structures : " + lstConfiguration.size() + "\n");
                            size = lstConfiguration.size();
                            break block32;
                        }
                        catch (Exception e) {
                            HuckelIO.warning(this.getClass().getName(), "autoGenLewisStructures", e.getMessage(), e);
                            if (sav) {
                                this.startFlyCalculate();
                            }
                            this.checkMesomery();
                            if (!this.isEnabledFlyCalculate || this.countSelectedLocalizedStructs() <= 0 || this.listIncorrectStructPiElecNumber().size() != 0) break block33;
                            sortedMap = this.getSortedMethodsByPriority();
                            ** for (entry : sortedMap.entrySet())
                        }
lbl-1000:
                        // 1 sources

                        {
                            method = entry.getValue();
                            if (!(method instanceof IMethodHasOptimizableMatrix)) continue;
                            ((IMethodHasOptimizableMatrix)method).computeAllOptimizableMatrix();
                            continue;
                        }
lbl99:
                        // 1 sources

                        try {
                            this.do_calculate();
                        }
                        catch (IncorrectNumberPiElectronsException e) {
                            this.isAutoGenerating = false;
                            throw e;
                        }
                        this.fireListWeightCalculated(this, null, null);
                    }
                    this.isAutoGenerating = false;
                    break block35;
                    catch (Throwable var13_21) {
                        if (sav) {
                            this.startFlyCalculate();
                        }
                        this.checkMesomery();
                        if (!this.isEnabledFlyCalculate || this.countSelectedLocalizedStructs() <= 0 || this.listIncorrectStructPiElecNumber().size() != 0) break block34;
                        sortedMap = this.getSortedMethodsByPriority();
                        ** for (entry : sortedMap.entrySet())
                    }
lbl-1000:
                    // 1 sources

                    {
                        method = entry.getValue();
                        if (!(method instanceof IMethodHasOptimizableMatrix)) continue;
                        ((IMethodHasOptimizableMatrix)method).computeAllOptimizableMatrix();
                        continue;
                    }
lbl121:
                    // 1 sources

                    try {
                        this.do_calculate();
                    }
                    catch (IncorrectNumberPiElectronsException e) {
                        this.isAutoGenerating = false;
                        throw e;
                    }
                    this.fireListWeightCalculated(this, null, null);
                }
                this.isAutoGenerating = false;
                throw var13_21;
            }
            if (sav) {
                this.startFlyCalculate();
            }
            this.checkMesomery();
            if (this.isEnabledFlyCalculate && this.countSelectedLocalizedStructs() > 0 && this.listIncorrectStructPiElecNumber().size() == 0) {
                sortedMap = this.getSortedMethodsByPriority();
                for (Map.Entry<String, IMethod> entry : sortedMap.entrySet()) {
                    method = entry.getValue();
                    if (!(method instanceof IMethodHasOptimizableMatrix)) continue;
                    ((IMethodHasOptimizableMatrix)method).computeAllOptimizableMatrix();
                }
                try {
                    this.do_calculate();
                }
                catch (IncorrectNumberPiElectronsException e) {
                    this.isAutoGenerating = false;
                    throw e;
                }
                this.fireListWeightCalculated(this, null, null);
            }
            this.isAutoGenerating = false;
        }
        this.isAutoGenerating = false;
        CTOMProfiler.getInstance().fin(routine);
        return size;
    }

    public void sortStructures(Comparator comparator) {
        Collections.sort(this.lstStructs, comparator);
        Collections.sort(this.lstSelectedStructs, comparator);
    }

    public void stopConsumingProcess() {
        this.isStopConsumingProcess = true;
    }

    public void setStopConsumingProcess(boolean isStopConsumingProcess) {
        this.isStopConsumingProcess = isStopConsumingProcess;
    }

    private List<StructureLocalized> calcListIncorrectStructPiElecNumber() {
        ArrayList<StructureLocalized> l = new ArrayList<StructureLocalized>();
        for (StructureLocalized struct : this.getLocalizedStructures()) {
            if (!struct.hasCorrectNbPiElec()) {
                l.add(struct);
                struct.setError(StructureLocalized.Error.ERROR_INCORRECT_NB_PI_ELEC);
                continue;
            }
            if (!struct.hasTooManyElectrons()) continue;
            l.add(struct);
            struct.setError(StructureLocalized.Error.ERROR_TOO_MUCH_SINGLE_ELECTRONS);
        }
        return l;
    }

    public List<StructureLocalized> getListIncorrectStructPiElectNumber() {
        ArrayList<StructureLocalized> l = new ArrayList<StructureLocalized>();
        int correctNbPiElec = this.getDelocalizedStructure().getSumOfPiElec();
        for (StructureLocalized struct : this.getSelectedLocalizedStructures()) {
            if (struct.getSumOfPiElec() != correctNbPiElec) {
                l.add(struct);
                continue;
            }
            if (struct.countSingleElectronsOnAtoms() <= 2) continue;
            l.add(struct);
        }
        return l;
    }

    public void calculate() throws IncorrectNumberPiElectronsException, IMethodException, MesomeryNoStructureLocalizedException, CoupleException {
        this.checkMesomery();
        if (this.countSelectedLocalizedStructs() > 0) {
            Map<String, IMethod> sortedMap = this.getSortedMethodsByPriority();
            for (Map.Entry<String, IMethod> entry : sortedMap.entrySet()) {
                IMethod method = entry.getValue();
                if (!(method instanceof IMethodHasOptimizableMatrix)) continue;
                ((IMethodHasOptimizableMatrix)((Object)method)).computeAllOptimizableMatrix();
            }
            this.do_calculate();
            this.fireListWeightCalculated(this, null, null);
        }
    }

    public void calculate(String methodName) throws CoupleException, IncorrectNumberPiElectronsException, IMethodException, MesomeryNoStructureLocalizedException {
        this.checkMesomery();
        if (this.countSelectedLocalizedStructs() > 0) {
            this.checkConditionsBeforeCalculate();
            this.setStopConsumingProcess(false);
            this.do_calculateWeights(this.getMethod(methodName));
            this.fireListWeightCalculated(this, null, null);
        }
    }

    private void do_calculateWeights(IMethod method) {
        try {
            if (method instanceof IMethodHasOptimizableMatrix) {
                ((IMethodHasOptimizableMatrix)((Object)method)).computeAllOptimizableMatrix();
            }
            method.calculate();
        }
        catch (IMethodException e) {
            this.fireExceptionOccured(this, null, null, e);
        }
    }

    public Map<String, IMethod> getSortedMethodsByPriority() {
        final HashMap<String, IMethod> lstMethods = this.lstMethods;
        TreeMap<String, IMethod> sortedMap = new TreeMap<String, IMethod>(new Comparator(){

            public int compare(Object o1, Object o2) {
                IMethod m1 = (IMethod)lstMethods.get((String)o1);
                IMethod m2 = (IMethod)lstMethods.get((String)o2);
                return Integer.valueOf(m1.getPriority()).compareTo(m2.getPriority());
            }
        });
        sortedMap.putAll(this.lstMethods);
        return sortedMap;
    }

    private void do_calculate() throws IncorrectNumberPiElectronsException, IMethodException, MesomeryNoStructureLocalizedException {
        this.checkConditionsBeforeCalculate();
        this.isCalculatingWeights = true;
        this.setStopConsumingProcess(false);
        this.fireStartComputeWeights(this, null, null);
        Map<String, IMethod> sortedMap = this.getSortedMethodsByPriority();
        for (Map.Entry<String, IMethod> entry : sortedMap.entrySet()) {
            if (this.isStopConsumingProccess()) break;
            this.do_calculateWeights(entry.getValue());
        }
        this.isCalculatingWeights = false;
    }

    public boolean isCalculatingWeights() {
        return this.isCalculatingWeights;
    }

    public void forceCalculatingWeights(boolean isCalculatingWeights) {
        this.isCalculatingWeights = isCalculatingWeights;
    }

    public void forceAutoGenerating(boolean isAutoGenerating) {
        this.isAutoGenerating = isAutoGenerating;
    }

    private void checkConditionsBeforeCalculate() throws IMethodException, IncorrectNumberPiElectronsException, MesomeryNoStructureLocalizedException {
        int nbSelLocalizedStructs = this.countSelectedLocalizedStructs();
        if (nbSelLocalizedStructs == 0) {
            throw new MesomeryNoStructureLocalizedException("coeff B param matrix must be intialized");
        }
        if (this.listIncorrectStructPiElecNumber() != null && this.listIncorrectStructPiElecNumber().size() > 0) {
            throw new IncorrectNumberPiElectronsException("incorrect number of pi electrons in one structure or more");
        }
        boolean ok = true;
        Map<String, IMethod> sortedMap = this.getSortedMethodsByPriority();
        for (Map.Entry<String, IMethod> entry : sortedMap.entrySet()) {
            IMethod method = entry.getValue();
            if (!(method instanceof IMethodHasOptimizableMatrix) || (ok = ((IMethodHasOptimizableMatrix)((Object)method)).checkOptimizableMatrix())) continue;
            throw method.getError();
        }
    }

    public int countAllSructs() {
        if (this.lstStructs == null || this.lstStructs.isEmpty()) {
            return 0;
        }
        return this.lstStructs.size();
    }

    public int countLocalizedStructs() {
        if (this.lstStructs == null || this.lstStructs.isEmpty()) {
            return 0;
        }
        return this.lstStructs.size() - 1;
    }

    public int countSelectedLocalizedStructs() {
        if (this.lstSelectedStructs == null || this.lstSelectedStructs.isEmpty()) {
            return 0;
        }
        return this.lstSelectedStructs.size() - 1;
    }

    public int countSelectedStructs() {
        if (this.lstSelectedStructs == null || this.lstSelectedStructs.isEmpty()) {
            return 0;
        }
        return this.lstSelectedStructs.size();
    }

    public synchronized StructureLocalized createLocalizedStructure() throws MesomeryDelocalizedStructureNotExistsException, CoupleException, IMethodException, MesomeryNoStructureLocalizedException {
        if (this.getDelocalizedStructure() == null) {
            throw new MesomeryDelocalizedStructureNotExistsException("cannot create localized structure because delocalized structure does not exist in mesomery");
        }
        StructureLocalized s = this.getDelocalizedStructure().cloneToLocalized();
        this.addLocalizedStruct(s);
        return s;
    }

    public void deleteAllStructures(boolean notifyEachStructureDeleted) throws CoupleException, IMethodException, MesomeryNoStructureLocalizedException {
        StructureDelocalized structureDelocalized = this.getDelocalizedStructure();
        if (structureDelocalized != null) {
            boolean sav = this.isEnabledFlyCalculate();
            this.stopFlyCalculate();
            this.deleteLocalizedStructures(notifyEachStructureDeleted);
            this.do_deleteStructure(structureDelocalized, notifyEachStructureDeleted);
            if (sav) {
                this.startFlyCalculate();
            }
        }
    }

    public void deleteAllStructures() throws CoupleException, IMethodException, MesomeryNoStructureLocalizedException {
        this.deleteAllStructures(true);
    }

    protected void eraseConf() {
        if (this.myconfig != null) {
            this.myconfig.erase();
        }
    }

    public boolean exists(Structure structure) {
        if (structure == null) {
            return false;
        }
        for (Structure s : this.lstStructs) {
            if (s != structure) continue;
            return true;
        }
        return false;
    }

    protected void fireListWeightCalculated(Mesomery source, Object oldValue, Object newValue) {
        MesomeryEvent event = null;
        for (IMesomeryListener listener : this.getListeners()) {
            if (event == null) {
                event = new MesomeryEvent(source, oldValue, newValue);
            }
            listener.mesomeryListWeightCalculated(event);
        }
    }

    protected void fireStartComputeWeights(Mesomery source, Object oldValue, Object newValue) {
        MesomeryEvent event = null;
        for (IMesomeryListener listener : this.getListeners()) {
            if (event == null) {
                event = new MesomeryEvent(source, oldValue, newValue);
            }
            listener.mesomeryStartComputeWeights(event);
        }
    }

    protected void fireStructuresSelectionTresholdChanged(Mesomery source, Object oldValue, Object newValue) {
        MesomeryEvent event = null;
        for (IMesomeryListener listener : this.getListeners()) {
            if (event == null) {
                event = new MesomeryEvent(source, oldValue, newValue);
            }
            listener.mesomeryStructuresSelectionTresholdChanged(event);
        }
    }

    private void fireStructuresSelectorChanged(Mesomery source, Object oldValue, Object newValue) {
        MesomeryEvent event = null;
        for (IMesomeryListener listener : this.getListeners()) {
            if (event == null) {
                event = new MesomeryEvent(source, oldValue, newValue);
            }
            listener.mesomeryStructuresSelectorChanged(event);
        }
    }

    protected void fireMethodRemoved(Mesomery source, Object oldValue, Object newValue) {
        MesomeryEvent event = null;
        for (IMesomeryListener listener : this.getListeners()) {
            if (event == null) {
                event = new MesomeryEvent(source, oldValue, newValue);
            }
            listener.mesomeryMethodRemoved(event);
        }
    }

    protected void fireMethodAdded(Mesomery source, Object oldValue, Object newValue) {
        MesomeryEvent event = null;
        for (IMesomeryListener listener : this.getListeners()) {
            if (event == null) {
                event = new MesomeryEvent(source, oldValue, newValue);
            }
            listener.mesomeryMethodAdded(event);
        }
    }

    protected void fireStructureAdded(Mesomery source, Object oldValue, Object newValue) {
        MesomeryEvent event = null;
        for (IMesomeryListener listener : this.getListeners()) {
            if (event == null) {
                event = new MesomeryEvent(source, oldValue, newValue);
            }
            listener.mesomeryStructureAdded(event);
        }
    }

    protected void fireStructureRemoved(Mesomery source, Object oldValue, Object newValue) {
        MesomeryEvent event = null;
        for (IMesomeryListener listener : this.getListeners()) {
            if (event == null) {
                event = new MesomeryEvent(source, oldValue, newValue);
            }
            listener.mesomeryStructureRemoved(event);
        }
    }

    protected void fireExceptionOccured(Mesomery source, Object oldValue, Object newValue, Exception e) {
        MesomeryEvent event = null;
        for (IMesomeryListener listener : this.getListeners()) {
            if (event == null) {
                event = new MesomeryEvent(source, oldValue, newValue);
            }
            listener.mesomeryExceptionOccured(event, e);
        }
    }

    public synchronized List<Structure> getAllStructures() {
        return (List)this.lstStructs.clone();
    }

    public StructureDelocalized getDelocalizedStructure() {
        if (this.lstStructs.isEmpty()) {
            return null;
        }
        return (StructureDelocalized)this.lstStructs.get(0);
    }

    public ArrayList<IMesomeryListener> getListeners() {
        return (ArrayList)this.listeners.clone();
    }

    public StructureLocalized getLocalizedStruct(int idx) {
        return (StructureLocalized)this.lstStructs.get(idx + 1);
    }

    public synchronized List<StructureLocalized> getLocalizedStructures() {
        ArrayList lst = (ArrayList)this.lstStructs.clone();
        if (lst.size() == 0) {
            return new ArrayList<StructureLocalized>();
        }
        List<StructureLocalized> lstStructureToCast = lst.subList(1, lst.size());
        return lstStructureToCast;
    }

    public IMethod getMethod(String methodName) {
        return this.lstMethods.get(methodName);
    }

    public IMethod[] getMethods() {
        return this.lstMethods.values().toArray(new IMethod[this.lstMethods.size()]);
    }

    public StructureLocalized getSelectedLocalizedStruct(int idx) {
        if (idx >= this.lstSelectedStructs.size() - 1) {
            return null;
        }
        return (StructureLocalized)this.lstSelectedStructs.get(idx + 1);
    }

    public synchronized List<StructureLocalized> getSelectedLocalizedStructures() {
        if (this.lstSelectedStructs.size() == 0) {
            return new ArrayList<StructureLocalized>();
        }
        List<Structure> lstStructureToCast = this.lstSelectedStructs.subList(1, this.lstSelectedStructs.size());
        return lstStructureToCast;
    }

    public synchronized List<Structure> getSelectedStructures() {
        if (this.lstSelectedStructs.size() == 0) {
            return new ArrayList<Structure>();
        }
        return (List)this.lstSelectedStructs.clone();
    }

    public synchronized void addSelectedStructure(Structure s) {
        this.lstSelectedStructs.add(s);
    }

    public Structure getStructureByName(String name) {
        for (Structure s : this.lstStructs) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public boolean isEnabledFlyCalculate() {
        return this.isEnabledFlyCalculate;
    }

    public synchronized List<StructureLocalized> listIncorrectStructPiElecNumber() {
        ArrayList<StructureLocalized> lst = new ArrayList<StructureLocalized>();
        for (StructureLocalized s : this.getLocalizedStructures()) {
            if (s.getError() == null || !s.getError().equals((Object)StructureLocalized.Error.ERROR_TOO_MUCH_SINGLE_ELECTRONS) && !s.getError().equals((Object)StructureLocalized.Error.ERROR_INCORRECT_NB_PI_ELEC)) continue;
            lst.add(s);
        }
        return lst;
    }

    private List<StructureLocalized> markDoublons() {
        ArrayList<StructureLocalized> lstDoublons = new ArrayList<StructureLocalized>();
        for (StructureLocalized s : this.getLocalizedStructures()) {
            for (StructureLocalized s2 : this.getLocalizedStructures()) {
                if (s == s2 || s2.getError() != null && s2.getError() != StructureLocalized.Error.NOT_ERROR || !s.geometryEquals(s2)) continue;
                s2.setError(StructureLocalized.Error.ERROR_ALREADY_EXIST);
                s2.setIdenticalStruct(s);
                lstDoublons.add(s);
            }
        }
        return lstDoublons;
    }

    @Override
    public void moleculeAtomAdded(MoleculeEvent e) {
        this.fireMoleculeAtomAdded(e);
        this.handleStructureChanged((Structure)e.getSource());
    }

    @Override
    public void moleculeAtomRemoved(MoleculeEvent e) {
        this.fireMoleculeAtomRemoved(e);
        this.handleStructureChanged((Structure)e.getSource());
    }

    @Override
    public void moleculeAtomReplaced(MoleculeEvent e) {
        this.fireMoleculeAtomReplaced(e);
        this.handleStructureChanged((Structure)e.getSource());
    }

    @Override
    public void moleculeBondAdded(MoleculeEvent e) {
        this.fireMoleculeBondAdded(e);
        this.handleStructureChanged((Structure)e.getSource());
    }

    @Override
    public void moleculeBondRemoved(MoleculeEvent e) {
        this.fireMoleculeBondRemoved(e);
        this.handleStructureChanged((Structure)e.getSource());
    }

    @Override
    public void moleculeChargeChanged(MoleculeEvent e) {
        this.fireMoleculeChargeChanged(e);
        this.handleStructureChanged((Structure)e.getSource());
    }

    @Override
    public void moleculeListHuckelAtomSeqNumAutoSetted(MoleculeEvent e) {
        this.fireMoleculeListHuckelAtomSeqNumAutoSetted(e);
        this.handleStructureChanged((Structure)e.getSource());
    }

    @Override
    public void moleculeListHuckelAtomSeqNumReset(MoleculeEvent e) {
        this.fireMoleculeListHuckelAtomSeqNumReset(e);
        this.handleStructureChanged((Structure)e.getSource());
    }

    @Override
    public void huckelAtomHxChanged(HuckelAtomEvent e) {
        this.fireHuckelAtomHxChanged(e);
        this.handleStructureChanged((Structure)e.getSource().getMoleculeContainer());
    }

    @Override
    public void huckelAtomRadRChanged(HuckelAtomEvent e) {
        this.fireHuckelAtomRadRChanged(e);
        this.handleStructureChanged((Structure)e.getSource().getMoleculeContainer());
    }

    @Override
    public void huckelAtomSeqNumChanged(HuckelAtomEvent e) {
        this.fireHuckelAtomSeqNumChanged(e);
        this.handleStructureChanged((Structure)e.getSource().getMoleculeContainer());
    }

    @Override
    public void huckelBondBondTypeChanged(HuckelBondEvent e) {
        this.fireHuckelBondBondTypeChanged(e);
        this.handleStructureChanged((Structure)e.getSource().getMoleculeContainer());
    }

    @Override
    public void huckelBondHxyChanged(HuckelBondEvent e) {
        this.fireHuckelBondHxyChanged(e);
        this.handleStructureChanged((Structure)e.getSource().getMoleculeContainer());
    }

    @Override
    public void structureLocalizedCoupleRemoved(StructureLocalizedEvent e) {
        this.fireStructureLocalizedCoupleRemoved(e);
        this.handleStructureChanged(e.getSource());
    }

    @Override
    public void structureLocalizedWeightChanged(StructureLocalizedEvent e) {
        this.fireStructureLocalizedWeightChanged(e);
    }

    @Override
    public void structureLocalizedCoupleChanged(StructureLocalizedEvent e) {
        this.fireStructureLocalizedCoupleChanged(e);
        this.handleStructureChanged(e.getSource());
    }

    @Override
    public void structureNameChanged(StructureEvent e) {
        this.fireStructureNameChanged(e);
    }

    @Override
    public void monoExcitationTriggered(MonoExcitationEvent e) {
        this.fireMonoExcitationTriggered(e);
        this.handleStructureChanged(e.getSource().getStructure());
    }

    @Override
    public void structureDelocalizedSpinChanged(StructureDelocalizedEvent e) {
        this.fireStructureDelocalizedSpinChanged(e);
    }

    protected void handleStructureChanged(Structure s) {
        if (this.structuresSelector != null) {
            if (Mesomery.getPolicyStructureChanged() == POLICY_STRUCTURE_CHANGED.CHANGE_TRESHOLD_TO_STRUCTURE_VALUE_IF_LOWER) {
                if (this.structuresSelector.isCurrentValueLowerThanTreshold(s)) {
                    Object oldValue = this.structuresSelector.getSelectionTreshold();
                    this.structuresSelector.setSelectionTreshold(this.structuresSelector.getCurrentValue(s));
                    this.updateSelectedStructs();
                    if (!oldValue.equals(this.structuresSelector.getSelectionTreshold())) {
                        this.fireStructuresSelectionTresholdChanged(this, oldValue, this.structuresSelector.getSelectionTreshold());
                    }
                }
            } else if (Mesomery.getPolicyStructureChanged() == POLICY_STRUCTURE_CHANGED.UNSELECT_STRUCTURE_IF_VALUE_IS_LOWER_TAN_TRESHOLD) {
                if (this.structuresSelector.isCurrentValueLowerThanTreshold(s) && this.lstSelectedStructs.contains(s)) {
                    this.lstSelectedStructs.remove(s);
                    this.updateSelectedStructs();
                } else if (!this.structuresSelector.isCurrentValueLowerThanTreshold(s) && !this.lstSelectedStructs.contains(s)) {
                    this.lstSelectedStructs.add(s);
                    this.updateSelectedStructs();
                }
            }
        }
        try {
            this.checkMesomery();
        }
        catch (CoupleException e) {
            this.fireExceptionOccured(this, null, null, e);
            return;
        }
        if (this.isEnabledFlyCalculate && this.countSelectedLocalizedStructs() > 0) {
            int i2 = this.getNumOrderSelectedLocalizedStructure(s);
            Map<String, IMethod> sortedMap = this.getSortedMethodsByPriority();
            for (Map.Entry<String, IMethod> entry : sortedMap.entrySet()) {
                IMethod method = entry.getValue();
                if (!(method instanceof IMethodHasOptimizableMatrix)) continue;
                ((IMethodHasOptimizableMatrix)((Object)method)).computeOptimizableMatrix(i2);
            }
            try {
                this.do_calculate();
                this.fireListWeightCalculated(this, null, null);
            }
            catch (IncorrectNumberPiElectronsException e) {
                HuckelIO.log(this.getClass().getName(), "handleStructureChanged", "catch incorrect number of pi electrons");
            }
            catch (IMethodException e) {
                e.printStackTrace();
            }
            catch (MesomeryNoStructureLocalizedException e) {
                e.printStackTrace();
            }
        }
    }

    public static POLICY_STRUCTURE_CHANGED getPolicyStructureChanged() {
        return policyStructureChanged;
    }

    public static void setPolicyStructureChanged(POLICY_STRUCTURE_CHANGED policyStructureChanged) {
        Mesomery.policyStructureChanged = policyStructureChanged;
    }

    @Override
    public void moleculeDeleted(MoleculeEvent e) {
        this.fireMoleculeDeleted(e);
    }

    public void deleteStructure(Structure structure) throws CoupleException, IMethodException, MesomeryNoStructureLocalizedException, MesomeryLocalizedStructureExistsException {
        if (structure == this.getDelocalizedStructure() && this.countLocalizedStructs() > 0) {
            throw new MesomeryLocalizedStructureExistsException("The mesomery is not empty");
        }
        int indexToRemove = -1;
        if (structure instanceof StructureLocalized) {
            indexToRemove = this.getNumOrderSelectedLocalizedStructure((StructureLocalized)structure);
        }
        this.lstStructs.remove(structure);
        this.lstSelectedStructs.remove(structure);
        this.checkMesomery();
        this.afterRemove(structure, indexToRemove, true);
        structure.delete();
        structure.setMesomeryParent(null);
        structure = null;
        if (this.countLocalizedStructs() == 0) {
            this.eraseConf();
            if (this.structuresSelector != null) {
                Object oldValue = this.structuresSelector.getSelectionTreshold();
                this.structuresSelector.setTresholdValueWhenNoStructure();
                this.updateSelectedStructs();
                if (!oldValue.equals(this.structuresSelector.getSelectionTreshold())) {
                    this.fireStructuresSelectionTresholdChanged(this, oldValue, this.structuresSelector.getSelectionTreshold());
                }
            }
        }
    }

    public void deleteLocalizedStructures(boolean notifyAfterEachStructureDeleted) throws IMethodException, MesomeryNoStructureLocalizedException, CoupleException {
        boolean sav = this.isEnabledFlyCalculate();
        this.stopFlyCalculate();
        int i2 = this.countLocalizedStructs() - 1;
        while (i2 >= 0) {
            StructureLocalized StructToDelete = this.getLocalizedStruct(i2);
            this.do_deleteStructure(StructToDelete, notifyAfterEachStructureDeleted);
            --i2;
        }
        this.isEnabledFlyCalculate = sav;
        this.eraseConf();
        if (this.structuresSelector != null) {
            Object oldValue = this.structuresSelector.getSelectionTreshold();
            this.structuresSelector.setTresholdValueWhenNoStructure();
            this.updateSelectedStructs();
            if (!oldValue.equals(this.structuresSelector.getSelectionTreshold())) {
                this.fireStructuresSelectionTresholdChanged(this, oldValue, this.structuresSelector.getSelectionTreshold());
            }
        }
    }

    public void deleteLocalizedStructures() throws IMethodException, MesomeryNoStructureLocalizedException, CoupleException {
        this.deleteLocalizedStructures(true);
    }

    private void do_deleteStructure(Structure structToDelete, boolean notifyDeleted) throws IMethodException, MesomeryNoStructureLocalizedException, CoupleException {
        this.lstStructs.remove(structToDelete);
        int indexToRemove = this.getNumOrderSelectedLocalizedStructure(structToDelete);
        this.afterRemove(structToDelete, indexToRemove, notifyDeleted);
        this.checkMesomery();
        structToDelete.delete(notifyDeleted);
        structToDelete.setMesomeryParent(null);
        structToDelete = null;
    }

    public void removeListener(IMesomeryListener listener) {
        this.listeners.remove(listener);
    }

    public void removeMethod(String methodName) throws MesomeryRemoveMethodException, CoupleException {
        IMethod old = this.lstMethods.get(methodName);
        if (old == null) {
            throw new MesomeryRemoveMethodException("mesomery does not contains this method");
        }
        this.lstMethods.remove(methodName);
        this.checkMesomery();
        this.fireMethodRemoved(this, old, null);
    }

    public Object getSelectionTreshold() {
        if (this.structuresSelector == null) {
            HuckelIO.warning(this.getClass().getName(), "getSelectionTreshold", "selector is not set in the the mesomery !!");
            return null;
        }
        return this.structuresSelector.getSelectionTreshold();
    }

    public void setSelectionTreshold(Object o) throws SelectionException, CoupleException, IMethodException, MesomeryNoStructureLocalizedException {
        if (this.structuresSelector == null) {
            HuckelIO.warning(this.getClass().getName(), "setMaxValueForStructureSelection", "selector is not set in the the mesomery !!");
            throw new SelectionException("mesomery structureSelector is null. First, set a selector to the mesomery");
        }
        Object oldValue = this.structuresSelector.getSelectionTreshold();
        this.structuresSelector.setSelectionTreshold(o);
        int oldNbSelectedStructs = this.countSelectedStructs();
        this.updateSelectedStructs();
        if (!oldValue.equals(this.structuresSelector.getSelectionTreshold()) && this.countSelectedStructs() != oldNbSelectedStructs) {
            this.fireStructuresSelectionTresholdChanged(this, oldValue, this.structuresSelector.getSelectionTreshold());
            try {
                this.checkMesomery();
                if (this.isEnabledFlyCalculate && this.countSelectedLocalizedStructs() > 0) {
                    Map<String, IMethod> sortedMap = this.getSortedMethodsByPriority();
                    for (Map.Entry<String, IMethod> entry : sortedMap.entrySet()) {
                        IMethod method = entry.getValue();
                        if (!(method instanceof IMethodHasOptimizableMatrix)) continue;
                        ((IMethodHasOptimizableMatrix)((Object)method)).computeAllOptimizableMatrix();
                    }
                    this.do_calculate();
                    this.fireListWeightCalculated(this, null, null);
                }
            }
            catch (IncorrectNumberPiElectronsException e1) {
                HuckelIO.warning(this.getClass().getName(), "setMaxValueForStructureSelection", e1.getMessage(), e1);
            }
        }
    }

    private int getNumOrderSelectedLocalizedStructure(Structure s) {
        int nbStruct = this.countSelectedLocalizedStructs();
        int n = 0;
        while (n < nbStruct) {
            if (s == this.getSelectedLocalizedStructures().get(n)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private boolean checkMesomery() throws CoupleException {
        if (this.countLocalizedStructs() == 0) {
            return true;
        }
        for (StructureLocalized sl : this.getLocalizedStructures()) {
            sl.setError(StructureLocalized.Error.NOT_ERROR);
        }
        List<StructureLocalized> errors = this.calcListIncorrectStructPiElecNumber();
        this.correctCouplage();
        List<StructureLocalized> doublons = this.markDoublons();
        return errors.size() > 0 || doublons.size() > 0;
    }

    private void correctCouplage() throws CoupleException {
        int delocalisedSpin = this.getDelocalizedStructure().getTotalSpin();
        Iterator<StructureLocalized> iterator = this.getSelectedLocalizedStructures().iterator();
        StructureLocalized struct = null;
        while (iterator.hasNext()) {
            struct = iterator.next();
            if (struct.getError() != StructureLocalized.Error.NOT_ERROR || struct.getTotalSpin() == delocalisedSpin || struct.aUnCouplage()) continue;
            switch (Preferences.COUPLAGE_TYPE_DEFAULT) {
                case ORBITALS: {
                    struct.autoCouplageSOM();
                }
                case ATOMS: {
                    struct.autoCouplage();
                    break;
                }
            }
            if (struct.isEnabledFlyCalculate()) {
                struct.calculateOverlapHLP();
            }
            if (struct.getTotalSpin() == delocalisedSpin) continue;
            struct.setError(StructureLocalized.Error.ERROR_CORRECT_SPIN_IMPOSSIBLE);
        }
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public void startFlyCalculate() {
        this.isEnabledFlyCalculate = true;
    }

    public void stopFlyCalculate() {
        this.isEnabledFlyCalculate = false;
    }

    public void updateSelectedStructs() {
        if (this.structuresSelector != null) {
            this.structuresSelector.selectStructures();
        } else {
            HuckelIO.warning(this.getClass().getName(), "updateSelectedStructs", "cannot select structures because structuresSelector is null");
        }
        int i2 = 0;
        while (i2 < this.countSelectedStructs()) {
            this.getSelectedStructures().get(i2).setIndexSelection(i2 + 1);
            ++i2;
        }
    }

    public void clearListSelectedStructures() {
        for (Structure s : this.getAllStructures()) {
            s.setIndexSelection(0);
        }
        this.lstSelectedStructs.clear();
    }

    protected void fireHuckelAtomHxChanged(HuckelAtomEvent e) {
        for (IMesomeryListener listener : this.getListeners()) {
            listener.huckelAtomHxChanged(e);
        }
    }

    protected void fireHuckelAtomRadRChanged(HuckelAtomEvent e) {
        for (IMesomeryListener listener : this.getListeners()) {
            listener.huckelAtomRadRChanged(e);
        }
    }

    protected void fireHuckelAtomSeqNumChanged(HuckelAtomEvent e) {
        for (IMesomeryListener listener : this.getListeners()) {
            listener.huckelAtomSeqNumChanged(e);
        }
    }

    protected void fireHuckelBondBondTypeChanged(HuckelBondEvent e) {
        for (IMesomeryListener listener : this.getListeners()) {
            listener.huckelBondBondTypeChanged(e);
        }
    }

    protected void fireHuckelBondHxyChanged(HuckelBondEvent e) {
        for (IMesomeryListener listener : this.getListeners()) {
            listener.huckelBondHxyChanged(e);
        }
    }

    protected void fireMoleculeAtomAdded(MoleculeEvent e) {
        for (IMesomeryListener listener : this.getListeners()) {
            listener.moleculeAtomAdded(e);
        }
    }

    protected void firemoleculeBlocDelocalizedAdded(MoleculeEvent e) {
        for (IMesomeryListener listener : this.getListeners()) {
            listener.moleculeBlocDelocalizedAdded(e);
        }
    }

    protected void firemoleculeBlocDelocalizedRemoved(MoleculeEvent e) {
        for (IMesomeryListener listener : this.getListeners()) {
            listener.moleculeBlocDelocalizedRemoved(e);
        }
    }

    protected void fireMoleculeAtomRemoved(MoleculeEvent e) {
        for (IMesomeryListener listener : this.getListeners()) {
            listener.moleculeAtomRemoved(e);
        }
    }

    protected void fireMoleculeAtomReplaced(MoleculeEvent e) {
        for (IMesomeryListener listener : this.getListeners()) {
            listener.moleculeAtomReplaced(e);
        }
    }

    protected void fireMoleculeBondAdded(MoleculeEvent e) {
        for (IMesomeryListener listener : this.getListeners()) {
            listener.moleculeBondAdded(e);
        }
    }

    protected void fireMoleculeBondRemoved(MoleculeEvent e) {
        for (IMesomeryListener listener : this.getListeners()) {
            listener.moleculeBondAdded(e);
        }
    }

    protected void fireMoleculeChargeChanged(MoleculeEvent e) {
        for (IMesomeryListener listener : this.getListeners()) {
            listener.moleculeChargeChanged(e);
        }
    }

    protected void fireMoleculeDeleted(MoleculeEvent e) {
        for (IMesomeryListener listener : this.getListeners()) {
            listener.moleculeDeleted(e);
        }
    }

    protected void fireMoleculeListHuckelAtomSeqNumAutoSetted(MoleculeEvent e) {
        for (IMesomeryListener listener : this.getListeners()) {
            listener.moleculeListHuckelAtomSeqNumAutoSetted(e);
        }
    }

    protected void fireMoleculeListHuckelAtomSeqNumReset(MoleculeEvent e) {
        for (IMesomeryListener listener : this.getListeners()) {
            listener.moleculeListHuckelAtomSeqNumReset(e);
        }
    }

    protected void fireMonoExcitationTriggered(MonoExcitationEvent e) {
        for (IMesomeryListener listener : this.getListeners()) {
            listener.monoExcitationTriggered(e);
        }
    }

    protected void fireStructureDelocalizedSpinChanged(StructureDelocalizedEvent e) {
        for (IMesomeryListener listener : this.getListeners()) {
            listener.structureDelocalizedSpinChanged(e);
        }
    }

    protected void fireStructureLocalizedCoupleRemoved(StructureLocalizedEvent e) {
        for (IMesomeryListener listener : this.getListeners()) {
            listener.structureLocalizedCoupleRemoved(e);
        }
    }

    protected void fireStructureLocalizedWeightChanged(StructureLocalizedEvent e) {
        for (IMesomeryListener listener : this.getListeners()) {
            listener.structureLocalizedWeightChanged(e);
        }
    }

    protected void fireStructureLocalizedCoupleChanged(StructureLocalizedEvent e) {
        for (IMesomeryListener listener : this.getListeners()) {
            listener.structureLocalizedCoupleChanged(e);
        }
    }

    protected void fireStructureNameChanged(StructureEvent e) {
        for (IMesomeryListener listener : this.getListeners()) {
            listener.structureNameChanged(e);
        }
    }

    protected void fireBlocDelocalizedHuckelObjectAdded(BlocDelocalizedEvent e) {
        for (IMesomeryListener listener : this.getListeners()) {
            listener.blocDelocalizedHuckelObjectAdded(e);
        }
    }

    protected void fireBlocDelocalizedHuckelObjectRemoved(BlocDelocalizedEvent e) {
        for (IMesomeryListener listener : this.getListeners()) {
            listener.blocDelocalizedHuckelObjectRemoved(e);
        }
    }

    protected void fireBlocDelocalizedNbElectronsChanged(BlocDelocalizedEvent e) {
        for (IMesomeryListener listener : this.getListeners()) {
            listener.blocDelocalizedNbElectronsChanged(e);
        }
    }

    @Override
    public void moleculeBlocDelocalizedAdded(MoleculeEvent e) {
        this.firemoleculeBlocDelocalizedAdded(e);
        this.handleStructureChanged((Structure)e.getSource());
    }

    @Override
    public void moleculeBlocDelocalizedRemoved(MoleculeEvent e) {
        this.firemoleculeBlocDelocalizedRemoved(e);
        this.handleStructureChanged((Structure)e.getSource());
    }

    @Override
    public void blocDelocalizedHuckelObjectAdded(BlocDelocalizedEvent e) {
        this.fireBlocDelocalizedHuckelObjectAdded(e);
        if (e.getSource().getNbElectron() > 0) {
            this.handleStructureChanged((Structure)e.getSource().getMoleculeParent());
        }
    }

    @Override
    public void blocDelocalizedHuckelObjectRemoved(BlocDelocalizedEvent e) {
        this.fireBlocDelocalizedHuckelObjectRemoved(e);
        if (e.getSource().getNbElectron() > 0) {
            this.handleStructureChanged((Structure)e.getSource().getMoleculeParent());
        }
    }

    @Override
    public void blocDelocalizedNbElectronsChanged(BlocDelocalizedEvent e) {
        this.fireBlocDelocalizedNbElectronsChanged(e);
        this.handleStructureChanged((Structure)e.getSource().getMoleculeParent());
    }

    public boolean isAutoGenerating() {
        return this.isAutoGenerating;
    }

    public boolean isStopConsumingProccess() {
        return this.isStopConsumingProcess;
    }

    public boolean isCloneResultsCacheWhenCloneMesomery() {
        return this.isCloneResultsCacheWhenCloneMesomery;
    }

    public void setCloneResultsCacheWhenCloneMesomery(boolean isCloneResultsCacheWhenCloneMesomery) {
        this.isCloneResultsCacheWhenCloneMesomery = isCloneResultsCacheWhenCloneMesomery;
        for (Structure s : this.getAllStructures()) {
            s.setCloneResultsCacheWhenCloneStructure(isCloneResultsCacheWhenCloneMesomery);
        }
    }

    public int getPrecision() {
        return this.precision;
    }

    public static enum POLICY_STRUCTURE_CHANGED {
        CHANGE_TRESHOLD_TO_STRUCTURE_VALUE_IF_LOWER,
        UNSELECT_STRUCTURE_IF_VALUE_IS_LOWER_TAN_TRESHOLD;

    }
}

