/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.huckel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.Bond;
import org.ctom.hulis.huckel.Energy;
import org.ctom.hulis.huckel.HuckelAtom;
import org.ctom.hulis.huckel.HuckelBond;
import org.ctom.hulis.huckel.IDebuggable;
import org.ctom.hulis.huckel.IHuckelObject;
import org.ctom.hulis.huckel.IMoleculeComponent;
import org.ctom.hulis.huckel.OrbitaleAtomique;
import org.ctom.hulis.huckel.PeriodicTable;
import org.ctom.hulis.huckel.comparators.SeqNumComparator;
import org.ctom.hulis.huckel.events.GeometryEvent;
import org.ctom.hulis.huckel.events.HuckelAtomEvent;
import org.ctom.hulis.huckel.events.HuckelBondEvent;
import org.ctom.hulis.huckel.events.MoleculeEvent;
import org.ctom.hulis.huckel.exception.BondException;
import org.ctom.hulis.huckel.exception.GeometryException;
import org.ctom.hulis.huckel.exception.HuckelBondException;
import org.ctom.hulis.huckel.exception.MoleculeAtomNullException;
import org.ctom.hulis.huckel.exception.MoleculeBondExistsException;
import org.ctom.hulis.huckel.exception.MoleculeCoherenceException;
import org.ctom.hulis.huckel.exception.MoleculeNotSupportedComponentException;
import org.ctom.hulis.huckel.exception.MoleculeTooManyNeighboursException;
import org.ctom.hulis.huckel.listeners.IAtomGeometryListener;
import org.ctom.hulis.huckel.listeners.IHuckelAtomListener;
import org.ctom.hulis.huckel.listeners.IHuckelBondListener;
import org.ctom.hulis.huckel.listeners.IMoleculeGeometryListener;
import org.ctom.hulis.huckel.listeners.IMoleculeListener;
import org.ctom.hulis.huckel.listeners.IMoleculeValueListener;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import org.ctom.hulis.util.geometry.CovalentRadii;
import org.ctom.hulis.util.geometry.Geometry;
import org.ctom.hulis.util.geometry.optimizer.Geom2DOptimizer;
import org.ctom.hulis.util.io.HuckelIO;
import org.ctom.util.maths.Point3D;
import org.ctom.util.maths.Rotation;
import org.ctom.util.maths.VecteurCTOM;

public class Molecule
implements Cloneable,
IDebuggable,
IHuckelBondListener,
IAtomGeometryListener,
IHuckelAtomListener,
Serializable {
    private static final long serialVersionUID = -2403133786018141877L;
    public static final double ATOM_ZONE = 12.0;
    public static final double deuxPI = Math.PI * 2;
    public static final double LENGTH_H_BOND = (CovalentRadii.C.getCovRad() + CovalentRadii.H.getCovRad()) * 50.0;
    private boolean autoCorrectH;
    private boolean enabledNotify;
    protected Geometry geometry;
    protected final ArrayList<IMoleculeGeometryListener> geometryListeners;
    protected final ArrayList<IMoleculeValueListener> valueListeners;
    private ArrayList<Atom> lstAtoms;
    private ArrayList<Bond> lstBonds;
    private int nbElecCharge;
    protected volatile int hashCode = 0;
    private int[][] topology = null;

    public Molecule() {
        this.lstAtoms = new ArrayList();
        this.lstBonds = new ArrayList();
        this.nbElecCharge = 0;
        this.valueListeners = new ArrayList();
        this.geometryListeners = new ArrayList();
        this.enabledNotify = true;
        this.autoCorrectH = true;
        this.geometry = null;
    }

    public Molecule(Molecule molecule) {
        this.nbElecCharge = molecule.getNbElecCharge();
        this.lstAtoms = new ArrayList();
        this.lstBonds = new ArrayList();
        this.valueListeners = new ArrayList();
        this.geometryListeners = new ArrayList();
        this.enabledNotify = molecule.enabledNotify;
        this.autoCorrectH = molecule.autoCorrectH;
        this.geometry = null;
        for (Atom a : molecule.getAtoms()) {
            Atom aClone = (Atom)a.clone();
            aClone.setMoleculeContainer(this);
            aClone.addListener(this);
            aClone.addListener(this);
            this.lstAtoms.add(aClone);
        }
        for (Bond l : molecule.getBonds()) {
            Bond lClone = (Bond)l.clone();
            lClone.setMoleculeContainer(this);
            lClone.addListener(this);
            lClone.atom1 = this.getAtomByIndex(l.getAtom1().getIndex());
            lClone.atom2 = this.getAtomByIndex(l.getAtom2().getIndex());
            this.lstBonds.add(lClone);
        }
        this.updateTopology();
    }

    public Object clone() {
        return new Molecule(this);
    }

    public int hashCode() {
        int multiplier = 23;
        if (this.hashCode == 0) {
            int code = 133;
            code = 23 * code + this.getNbElecCharge();
            if (this.lstAtoms != null) {
                code = 23 * code + this.lstAtoms.hashCode();
            }
            if (this.lstBonds != null) {
                code = 23 * code + this.lstBonds.hashCode();
            }
            this.hashCode = code;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Molecule)) {
            return false;
        }
        return this.geometryEquals((Molecule)o);
    }

    public boolean geometryEquals(Molecule molecule) {
        if (this.getNbElecCharge() != molecule.getNbElecCharge()) {
            return false;
        }
        if (molecule.countAtoms() != this.countAtoms()) {
            return false;
        }
        if (molecule.countBonds() != this.countBonds()) {
            return false;
        }
        for (Atom a : this.getAtoms()) {
            if (a.equals(molecule.getAtomByIndex(a.getIndex()))) continue;
            return false;
        }
        for (Bond b : this.getBonds()) {
            if (b.equals(molecule.getBondByIndex(b.getIndex()))) continue;
            return false;
        }
        return true;
    }

    public void notifyValueChanged() {
        this.fireMoleculeAtomAdded(this, null, null);
    }

    public void notifyGeometryChanged() {
        this.fireAtomLocationChanged(new GeometryEvent(this, null, null));
    }

    public void optimizeGeometry() {
        if (this instanceof StructureLocalized) {
            try {
                throw new MoleculeCoherenceException("Cannot optimize a localized structure");
            }
            catch (MoleculeCoherenceException e) {
                e.printStackTrace();
                return;
            }
        }
        Geom2DOptimizer opt = new Geom2DOptimizer(this);
        opt.setOptimize(true);
        opt.setVerbose(false);
        this.fireMoleculeAtomAdded(this, this, null);
        opt.setOptimize(false);
    }

    @Deprecated
    public void add(IMoleculeComponent component) throws HuckelBondException, BondException, MoleculeNotSupportedComponentException, MoleculeCoherenceException, MoleculeTooManyNeighboursException, MoleculeBondExistsException {
        if (component instanceof Atom) {
            this.addAtom((Atom)component);
        } else if (component instanceof Bond) {
            this.addBond((Bond)component);
        } else {
            throw new MoleculeNotSupportedComponentException("moleculecomponent not supported by this class");
        }
    }

    public void addAtom(Atom a) throws HuckelBondException, BondException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        this.addAtomNotNotify(a);
        this.updateCharges();
        this.updateTopology();
        this.fireMoleculeAtomAdded(this, null, a);
    }

    protected void addAtomNotNotify(Atom a) throws HuckelBondException, BondException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        a.setMoleculeContainer(this);
        a.addListener(this);
        a.addListener(this);
        a.setIndex(this.getMaxAtomIndex() + 1);
        if (a instanceof HuckelAtom) {
            HuckelAtom a2 = (HuckelAtom)a;
            a2.seqNum = this.getMaxAtomSeqNum() + 1;
        }
        this.lstAtoms.add(a);
        if (a.getElement() != PeriodicTable.Element.H && this.isAutoCorrectH()) {
            this.correctHBondAround(a);
            this.reindexAtoms();
            this.reindexBonds();
        }
    }

    public void addBond(Bond b) throws MoleculeCoherenceException, HuckelBondException, BondException, MoleculeBondExistsException, MoleculeTooManyNeighboursException {
        if (this.isNbNeighboursMaxReachedExcludingH(b.getAtom1())) {
            throw new MoleculeTooManyNeighboursException("too many neighbours");
        }
        if (this.isNbNeighboursMaxReachedExcludingH(b.getAtom2())) {
            throw new MoleculeTooManyNeighboursException("too many neighbours");
        }
        this.addBondNotNotify(b);
        if (this.isAutoCorrectH()) {
            this.correctHBondRelativeTo(b);
        }
        this.updateCharges();
        this.updateTopology();
        this.fireMoleculeBondAdded(this, null, b);
    }

    protected void addBondNotNotify(Bond b) throws MoleculeCoherenceException, MoleculeBondExistsException {
        if (!this.areLinked(b.getAtom1(), b.getAtom2())) {
            if (b.getAtom1().getMoleculeContainer() != this || b.getAtom2().getMoleculeContainer() != this) {
                throw new MoleculeCoherenceException("the bond to add must be composed of atoms that belong to the molecule");
            }
        } else {
            throw new MoleculeBondExistsException("atoms already linked");
        }
        b.setMoleculeContainer(this);
        b.addListener(this);
        this.lstBonds.add(b);
        this.reindexBonds();
    }

    public void addNbElecCharge(int nbElec) throws MoleculeCoherenceException {
        this.setNbElecCharge(this.nbElecCharge + nbElec);
    }

    public Bond areAdjacentAtoms(int iat, int jat) {
        for (HuckelBond bond : this.getHuckelBonds()) {
            int at1 = bond.getAtom1().getIndex();
            int at2 = bond.getAtom2().getIndex();
            if ((iat != at1 || jat != at2) && (iat != at2 || jat != at1)) continue;
            return bond;
        }
        return null;
    }

    protected boolean areAdjacentBonds(int ibond, int jbond) {
        boolean rc = false;
        if (this.getHuckelBond(ibond).getAtom1().getSeqNum() == this.getHuckelBond(jbond).getAtom1().getSeqNum() && this.getHuckelBond(ibond).getAtom2().getSeqNum() == this.getHuckelBond(jbond).getAtom2().getSeqNum()) {
            return false;
        }
        rc = rc || this.getHuckelBond(ibond).getAtom1().getSeqNum() == this.getHuckelBond(jbond).getAtom1().getSeqNum();
        rc = rc || this.getHuckelBond(ibond).getAtom1().getSeqNum() == this.getHuckelBond(jbond).getAtom2().getSeqNum();
        rc = rc || this.getHuckelBond(ibond).getAtom2().getSeqNum() == this.getHuckelBond(jbond).getAtom1().getSeqNum();
        rc = rc || this.getHuckelBond(ibond).getAtom2().getSeqNum() == this.getHuckelBond(jbond).getAtom2().getSeqNum();
        return rc;
    }

    public boolean areCorrectAtomsSeqNum() {
        for (HuckelAtom a : this.getHuckelAtoms()) {
            if (a.getSeqNum() != 0) continue;
            return false;
        }
        return true;
    }

    public boolean areLinked(Atom atom1, Atom atom2) {
        if (atom1 == null || atom2 == null) {
            return false;
        }
        for (Bond l : this.lstBonds) {
            if (!l.contains(atom1, atom2)) continue;
            return true;
        }
        return false;
    }

    protected boolean areSecondNeighbour(int ibond, int jbond) {
        boolean rc = false;
        int kbond = 0;
        while (kbond < this.countBonds()) {
            if (kbond != ibond && kbond != jbond) {
                boolean bl = rc = this.areAdjacentBonds(ibond, kbond) && this.areAdjacentBonds(kbond, jbond);
                if (rc) break;
            }
            ++kbond;
        }
        return rc;
    }

    public boolean changeBondType(int ibond, int type) throws MoleculeCoherenceException, HuckelBondException {
        if (!(this.getBond(ibond) instanceof HuckelBond)) {
            throw new MoleculeCoherenceException("the bond " + ibond + " is not a HuckelBond");
        }
        int ibondtype = ((HuckelBond)this.getBond(ibond)).getBondType();
        if (type == ibondtype) {
            return false;
        }
        this.setBondType(ibond, type);
        return true;
    }

    public int changeBondType(int iat, int jat, int type) throws HuckelBondException, MoleculeCoherenceException {
        int ibond = -1;
        for (HuckelBond bond : this.getHuckelBonds()) {
            if ((iat != bond.getAtom1().getSeqNum() || jat != bond.getAtom2().getSeqNum()) && (jat != bond.getAtom1().getSeqNum() || iat != bond.getAtom2().getSeqNum())) continue;
            ibond = bond.getIndex() - 1;
            break;
        }
        if (!this.changeBondType(ibond, type)) {
            return 1;
        }
        return 0;
    }

    public boolean checkPath(ArrayList<HuckelBond> path) {
        boolean rc = true;
        for (HuckelBond currbond : path) {
            if (currbond.getAtom1().getNbElecPi() - currbond.getAtom1().getCharge() < 0) {
                return true;
            }
            if (currbond.getAtom2().getNbElecPi() - currbond.getAtom2().getCharge() >= 0) continue;
            return true;
        }
        return rc;
    }

    protected void correctElecCharge() {
        int nbPiElec = this.getSumAtomsNbElecPi();
        int maxElecPossible = 2 * this.countHuckelAtoms();
        if (nbPiElec + this.getNbElecCharge() > maxElecPossible) {
            this.nbElecCharge = maxElecPossible - nbPiElec;
        }
        if (nbPiElec + this.getNbElecCharge() < 0) {
            this.nbElecCharge = nbPiElec - maxElecPossible;
        }
    }

    public void correctHBonds() {
        for (HuckelAtom a : this.getHuckelAtoms()) {
            try {
                this.correctHBondAround(a);
                this.reindexAtoms();
                this.reindexBonds();
            }
            catch (HuckelBondException e) {
                e.printStackTrace();
            }
            catch (BondException e) {
                e.printStackTrace();
            }
            catch (MoleculeTooManyNeighboursException e) {
                e.printStackTrace();
            }
            catch (MoleculeCoherenceException e) {
                e.printStackTrace();
            }
            catch (MoleculeBondExistsException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean contains(Atom atom, double x, double y, double tolerance) {
        double width = tolerance;
        double normx = (x - atom.getX()) / width;
        double height = tolerance;
        double normy = (y - atom.getY()) / height;
        return normx * normx + normy * normy < 1.0;
    }

    private Point3D getLocationHOnBisector(Atom a, Bond reference, double angle) {
        double oppositeAngle = (Math.PI * 2 - angle) / 2.0;
        Point3D pRepere = reference.getAtomLinkedWith(a).getLocation();
        Point3D p = pRepere.rotateAndRenorm(a.getLocation(), Rotation.getRotationZ(oppositeAngle), LENGTH_H_BOND);
        return p;
    }

    public boolean isOccupiedZoneByAtom(Point3D p) {
        for (Atom atom : this.getAtoms()) {
            if (!this.contains(atom, p.getX(), p.getY(), 12.0)) continue;
            return true;
        }
        return false;
    }

    protected void correctHBondAround(Atom a) throws HuckelBondException, BondException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        ArrayList<Bond> lstHBonds = new ArrayList<Bond>();
        ArrayList<Bond> lstNoHBonds = new ArrayList<Bond>();
        int nbHManquants = 0;
        for (Bond b : this.lstBonds) {
            if (b.contains(PeriodicTable.Element.H) && b.contains(a)) {
                lstHBonds.add(b);
            }
            if (!b.contains(PeriodicTable.Element.H) && b.contains(a)) {
                lstNoHBonds.add(b);
            }
            if (lstNoHBonds.size() <= a.getNbNeighboursMax()) continue;
            throw new MoleculeTooManyNeighboursException("too many neighbours");
        }
        nbHManquants = a.getNbNeighboursMax() - lstNoHBonds.size();
        for (Bond b : lstHBonds) {
            Atom h = b.getAtom(PeriodicTable.Element.H);
            this.lstAtoms.remove(h);
            h = null;
            this.do_removeBond(b);
        }
        if (nbHManquants > 0) {
            if (lstNoHBonds.size() > 1) {
                Bond nouv = null;
                ArrayList lstBonds = (ArrayList)lstNoHBonds.clone();
                int i2 = 0;
                while (i2 < nbHManquants) {
                    double angle = 0.0;
                    double greatestAngle = -999.0;
                    Bond brepere = (Bond)lstBonds.get(0);
                    for (Bond b1 : lstBonds) {
                        VecteurCTOM vCO = new VecteurCTOM(a.getLocation(), b1.getAtomLinkedWith(a).getLocation());
                        for (Bond b2 : lstBonds) {
                            VecteurCTOM vCD;
                            if (b1 == b2 || !((angle = Math.signum(vCO.getCrossProduct(vCD = new VecteurCTOM(a.getLocation(), b2.getAtomLinkedWith(a).getLocation())).getZ()) * vCO.getAngle(vCD)) > greatestAngle) || this.isOccupiedZoneByAtom(this.getLocationHOnBisector(a, b2, angle))) continue;
                            greatestAngle = angle;
                            brepere = b2;
                        }
                    }
                    Point3D p = this.getLocationHOnBisector(a, brepere, greatestAngle);
                    nouv = this.createBondNotNotify(a, this.createAtomNotNotify(PeriodicTable.Entry.H, p));
                    lstBonds.add(nouv);
                    ++i2;
                }
                lstBonds.clear();
                lstBonds = null;
            } else {
                Point3D pRepere = lstNoHBonds.size() == 1 ? ((Bond)lstNoHBonds.get(0)).getLocation() : new Point3D(a.getX() + LENGTH_H_BOND, a.getY(), a.getZ());
                int i3 = 1;
                while (i3 <= nbHManquants) {
                    double angle = a.getEntry() == PeriodicTable.Entry.O2 || a.getEntry() == PeriodicTable.Entry.S2 || a.getEntry() == PeriodicTable.Entry.N1 || a.getEntry() == PeriodicTable.Entry.P1 ? Math.PI * 2 / (double)(a.getNbNeighboursMax() * i3 + 1) : Math.PI * 2 / (double)a.getNbNeighboursMax() * (double)i3;
                    Point3D p = pRepere.rotateAndRenorm(a.getLocation(), Rotation.getRotationZ(angle), LENGTH_H_BOND);
                    this.createBondNotNotify(a, this.createAtomNotNotify(PeriodicTable.Entry.H, p));
                    ++i3;
                }
            }
        }
        lstNoHBonds.clear();
        lstNoHBonds = null;
        lstHBonds.clear();
        lstHBonds = null;
    }

    protected void correctHBondRelativeTo(Bond b) throws HuckelBondException, BondException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        if (b.getAtom1().getElement() != PeriodicTable.Element.H) {
            this.correctHBondAround(b.getAtom1());
        }
        if (b.getAtom2().getElement() != PeriodicTable.Element.H) {
            this.correctHBondAround(b.getAtom2());
        }
        this.reindexAtoms();
        this.reindexBonds();
    }

    public int countAtoms() {
        if (this.lstAtoms == null) {
            return 0;
        }
        return this.lstAtoms.size();
    }

    public int countBonds() {
        if (this.lstBonds == null) {
            return 0;
        }
        return this.lstBonds.size();
    }

    protected int countDBaroundAtom(int iAtom) {
        int nDB = 0;
        for (HuckelBond huckelBond : this.getBonds()) {
            if (huckelBond.getBondType() != 2 || huckelBond.getAtom1().getSeqNum() != iAtom && huckelBond.getAtom2().getSeqNum() != iAtom) continue;
            ++nDB;
        }
        return nDB;
    }

    public int countHuckelAtoms() {
        return this.getHuckelAtoms().size();
    }

    public int countHuckelBonds() {
        return this.getHuckelBonds().size();
    }

    public int countNeighbours(Atom a) {
        int nbNeighbours = 0;
        for (Bond b : this.lstBonds) {
            if (!b.contains(a)) continue;
            ++nbNeighbours;
        }
        return nbNeighbours;
    }

    public int countNeighbourHs(Atom a) {
        int nbNeighbourHs = 0;
        for (Bond b : this.lstBonds) {
            if (!b.contains(a) || !b.contains(PeriodicTable.Element.H)) continue;
            ++nbNeighbourHs;
        }
        if (a.getElement() == PeriodicTable.Element.H) {
            --nbNeighbourHs;
        }
        return nbNeighbourHs;
    }

    public List<Atom> getNeighbours(Atom a) {
        ArrayList<Atom> lstAtoms = new ArrayList<Atom>();
        for (Bond b : this.lstBonds) {
            Atom neighbour = b.getAtomLinkedWith(a);
            if (neighbour == null) continue;
            lstAtoms.add(neighbour);
        }
        return lstAtoms;
    }

    public int countNeighboursExcludingH(Atom a) {
        int nbNeighbours = 0;
        nbNeighbours = this.countNeighbours(a) - this.countNeighbourHs(a);
        return nbNeighbours;
    }

    public int countSingleElectronsOnAtoms() {
        int nb = 0;
        for (HuckelAtom a : this.getHuckelAtoms()) {
            if (a.countRadR() != 1) continue;
            ++nb;
        }
        return nb;
    }

    protected Atom createAtomNotNotify(PeriodicTable.Entry entry, Point3D p) throws HuckelBondException, BondException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        Atom a = this.do_createNewAtom(entry, p);
        this.addAtomNotNotify(a);
        return a;
    }

    protected Bond createBondNotNotify(Atom a1, Atom a2) throws HuckelBondException, BondException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        if (this.isNbNeighboursMaxReachedExcludingH(a1)) {
            throw new MoleculeTooManyNeighboursException("too many neighbours");
        }
        if (this.isNbNeighboursMaxReachedExcludingH(a2)) {
            throw new MoleculeTooManyNeighboursException("too many neighbours");
        }
        Bond b = a1 instanceof HuckelAtom && a2 instanceof HuckelAtom ? new HuckelBond((HuckelAtom)a1, (HuckelAtom)a2, 1) : new Bond(a1, a2);
        this.addBondNotNotify(b);
        return b;
    }

    public void createGeometry() throws GeometryException {
        if (this.geometry != null) {
            try {
                throw new GeometryException("The geometry object already exists in molecule");
            }
            catch (Exception e) {
                HuckelIO.warning(this.getClass().getName(), "createGeometry", e.getMessage(), e);
            }
        }
        HuckelIO.PrintIfln("CREATE GEOMETRY");
        this.geometry = new Geometry(this);
    }

    public void createMolecule(Geometry geom) throws HuckelBondException, BondException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        Atom atomCree = null;
        Bond bondCree = null;
        ArrayList<Atom> geom2d = geom.getGeom();
        for (Atom iatom : geom2d) {
            if ((iatom.getElement() == PeriodicTable.Element.H || !this.isAutoCorrectH()) && this.isAutoCorrectH()) continue;
            atomCree = this.createAtomNotNotify(geom.atomToEntry(iatom), iatom.getLocation());
            atomCree.setLocationGeom3D((Point3D)iatom.getLocationGeom3D().clone());
            atomCree.setSuperSymbol(iatom.getSuperSymbol());
        }
        for (Atom iatom : geom2d) {
            for (int i2 : iatom.getConnect()) {
                if (i2 <= iatom.getSuperSymbol()) continue;
                try {
                    Atom a1 = this.getAtomBySuperSymbol(iatom.getSuperSymbol());
                    Atom a2 = this.getAtomBySuperSymbol(i2);
                    if (a1 != null && a2 != null && ((a1.getElement() == PeriodicTable.Element.H || a2.getElement() == PeriodicTable.Element.H) && !this.isAutoCorrectH() || this.isAutoCorrectH())) {
                        bondCree = this.createBondNotNotify(a1, a2);
                        if (!this.isAutoCorrectH()) continue;
                        this.correctHBondRelativeTo(bondCree);
                        continue;
                    }
                    this.createBondNotNotify(a1, a2);
                }
                catch (Exception e) {
                    HuckelIO.warning(this.getClass().getName(), "createMolecule", e.getMessage(), e);
                }
            }
        }
        this.updateTopology();
    }

    public Atom createNewAtom(PeriodicTable.Entry entry, Point3D p) throws HuckelBondException, BondException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        Atom a = this.do_createNewAtom(entry, p);
        this.addAtom(a);
        return a;
    }

    public Bond createNewBond(Atom a1, Atom a2) throws BondException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        Bond b = a1 instanceof HuckelAtom && a2 instanceof HuckelAtom ? new HuckelBond((HuckelAtom)a1, (HuckelAtom)a2, 1) : new Bond(a1, a2);
        this.addBond(b);
        return b;
    }

    private Atom do_createNewAtom(PeriodicTable.Entry entry, Point3D p) {
        Atom a = PeriodicTable.getNewAtom(entry);
        a.setLocationNotNotify(p);
        return a;
    }

    @Override
    public void debug() {
        HuckelIO.PrintIf("Molecule : ");
        HuckelIO.PrintIf("hascode = " + this.hashCode());
        HuckelIO.PrintIf("number electrons charge : " + this.nbElecCharge);
        HuckelIO.PrintIf("*** Atoms ***");
        for (Atom a : this.lstAtoms) {
            a.debug();
        }
        HuckelIO.PrintIf("*** Bonds ***");
        for (Bond b : this.lstBonds) {
            b.debug();
        }
    }

    public void clear(boolean notify) {
        for (Atom a : this.lstAtoms) {
            a.removeListener(this);
            a.removeListener(this);
            a = null;
        }
        for (Bond b : this.lstBonds) {
            b.removeListener(this);
            Object var2_3 = null;
        }
        this.lstAtoms.clear();
        this.lstBonds.clear();
        this.nbElecCharge = 0;
        if (notify) {
            this.fireMoleculeDeleted(this, this, null);
        }
    }

    public void clear() {
        this.clear(true);
    }

    public void delete(boolean notify) {
        this.clear(notify);
        this.lstAtoms = null;
        this.lstBonds = null;
    }

    public void delete() {
        this.delete(true);
    }

    @Deprecated
    protected ArrayList<HuckelBond> FindPath(int atomDebut, int atomFin) {
        ArrayList<HuckelBond> lstpath = new ArrayList<HuckelBond>();
        ArrayList<HuckelBond> lstbonds = new ArrayList<HuckelBond>();
        boolean chercher = true;
        boolean recommencer = true;
        boolean verbose = false;
        HuckelBond current = null;
        int idxAtomActif = 0;
        int niter = 0;
        int MaxIter = 100;
        while (chercher) {
            if (++niter >= MaxIter) {
                HuckelIO.PrintIf("Trop d'iteration\n");
                return null;
            }
            if (recommencer) {
                lstbonds.clear();
                int ibond = 0;
                while (ibond < this.countHuckelBonds()) {
                    lstbonds.add(this.getHuckelBond(ibond));
                    ++ibond;
                }
                Collections.shuffle(lstbonds);
                lstpath.clear();
                for (HuckelBond scanbond : lstbonds) {
                    if (scanbond.getAtom1().getSeqNum() == atomDebut) {
                        current = scanbond;
                        idxAtomActif = scanbond.getAtom2().getSeqNum();
                        if (idxAtomActif != atomFin) break;
                        lstpath.add(current);
                        return lstpath;
                    }
                    if (scanbond.getAtom2().getSeqNum() != atomDebut) continue;
                    current = scanbond;
                    idxAtomActif = scanbond.getAtom1().getSeqNum();
                    if (idxAtomActif != atomFin) break;
                    lstpath.add(current);
                    return lstpath;
                }
                lstpath.add(current);
                lstbonds.remove(current);
                recommencer = false;
            }
            boolean found = false;
            for (HuckelBond scanbond : lstbonds) {
                if (scanbond.getAtom1().getSeqNum() == idxAtomActif) {
                    current = scanbond;
                    idxAtomActif = scanbond.getAtom2().getSeqNum();
                    found = true;
                    break;
                }
                if (scanbond.getAtom2().getSeqNum() != idxAtomActif) continue;
                current = scanbond;
                idxAtomActif = scanbond.getAtom1().getSeqNum();
                found = true;
                break;
            }
            if (!found && verbose) {
                System.out.print("!!! NOT FOUND !!!");
            }
            lstpath.add(current);
            lstbonds.remove(current);
            if (current.getAtom1().getSeqNum() == atomFin || current.getAtom2().getSeqNum() == atomFin) {
                chercher = false;
                HuckelIO.PrintIf("je suis au bout : ");
                int ibd = 0;
                while (ibd < lstpath.size()) {
                    HuckelIO.PrintIf("bond : " + lstpath.get(ibd).getAtom1().getSeqNum() + " - " + lstpath.get(ibd).getAtom2().getSeqNum() + " | ");
                    ++ibd;
                }
                HuckelIO.PrintIf("\n");
                continue;
            }
            if (current.getAtom1().getSeqNum() == atomDebut || current.getAtom2().getSeqNum() == atomDebut) {
                recommencer = true;
                if (!verbose) continue;
                HuckelIO.PrintIf("je suis de retour, je recommence\n");
                continue;
            }
            boolean impasse = true;
            for (HuckelBond bond : lstbonds) {
                if (bond.getAtom1().getSeqNum() != idxAtomActif && bond.getAtom2().getSeqNum() != idxAtomActif) continue;
                impasse = false;
                break;
            }
            if (!impasse) continue;
            recommencer = true;
            if (!verbose) continue;
            HuckelIO.PrintIf("impasse\n");
        }
        return lstpath;
    }

    public Atom getAtomByIndex(int index) {
        if (index < 1 || index > this.countAtoms()) {
            return null;
        }
        for (Atom a : this.lstAtoms) {
            if (a.getIndex() != index) continue;
            return a;
        }
        return null;
    }

    public Atom getAtomBySeqNum(int seqNum) {
        if (seqNum < 1 || seqNum > this.countHuckelAtoms()) {
            return null;
        }
        for (HuckelAtom a : this.getHuckelAtoms()) {
            if (a.getSeqNum() != seqNum) continue;
            return a;
        }
        return null;
    }

    public Atom getAtomBySuperSymbol(int seqNum) {
        if (seqNum < 1) {
            return null;
        }
        for (Atom a : this.lstAtoms) {
            if (a.getSuperSymbol() != seqNum) continue;
            return a;
        }
        return null;
    }

    public IHuckelObject getHuckelObjectByIndex(Class classe, int index) {
        List<IHuckelObject> lstHuckelObjects = this.getHuckelObjects();
        if (index < 1) {
            return null;
        }
        for (IHuckelObject o : lstHuckelObjects) {
            if (o.getIndex() != index || o.getClass() != classe) continue;
            return o;
        }
        return null;
    }

    protected int getAtomConnectivity(int iAtom) {
        int nConn = 0;
        for (HuckelBond l : this.getHuckelBonds()) {
            if (l.getAtom1().getSeqNum() != iAtom && l.getAtom2().getSeqNum() != iAtom) continue;
            ++nConn;
        }
        return nConn;
    }

    public int getAtomIdx(Atom atom) {
        int idx = 0;
        int i2 = 0;
        while (i2 < this.countAtoms()) {
            if (this.lstAtoms.get(i2) == atom) {
                idx = i2;
                break;
            }
            ++i2;
        }
        return idx;
    }

    public int getHuckelObjectIdx(IHuckelObject o) {
        List<IHuckelObject> lstHuckelObject = this.getHuckelObjects();
        int idx = 0;
        int i2 = 0;
        while (i2 < lstHuckelObject.size()) {
            if (lstHuckelObject.get(i2) == o) {
                idx = i2;
                break;
            }
            ++i2;
        }
        return idx;
    }

    public List<Atom> getAtoms() {
        return this.lstAtoms;
    }

    public Bond getBond(Atom a1, Atom a2) {
        if (a1 == null || a1 == null) {
            return null;
        }
        for (Bond l : this.lstBonds) {
            if (!l.contains(a1, a2)) continue;
            return l;
        }
        return null;
    }

    public Bond getBond(int idxBond) {
        return this.lstBonds.get(idxBond);
    }

    public Bond getBondByIndex(int index) {
        if (index < 1 || index > this.countBonds()) {
            return null;
        }
        for (Bond b : this.lstBonds) {
            if (b.getIndex() != index) continue;
            return b;
        }
        return null;
    }

    protected int getBondIdx(Bond current) {
        int idx = 0;
        int ibond = 0;
        while (ibond < this.countBonds()) {
            if (this.getBond(ibond) == current) {
                idx = ibond;
                break;
            }
            ++ibond;
        }
        return idx;
    }

    public List<Bond> getBonds() {
        return this.lstBonds;
    }

    public Point3D getCenter() {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double nbAtomes = this.countAtoms();
        if (nbAtomes == 0.0) {
            return new Point3D(0.0, 0.0, 0.0);
        }
        for (Atom a : this.lstAtoms) {
            x += a.getX();
            y += a.getY();
            z += a.getZ();
        }
        return new Point3D(x / nbAtomes, y / nbAtomes, z / nbAtomes);
    }

    public Geometry getGeometry() throws GeometryException {
        if (this.geometry == null) {
            HuckelIO.PrintIfln("NO GEOM FOUND");
            this.createGeometry();
        } else {
            HuckelIO.PrintIfln("GEOM EXISTS");
            this.geometry.synchronize(this);
        }
        return this.geometry;
    }

    public HuckelAtom getHuckelAtomBySeqNum(int seqNum) {
        if (seqNum < 1 || seqNum > this.countHuckelAtoms()) {
            return null;
        }
        for (HuckelAtom a : this.getHuckelAtoms()) {
            if (a.getSeqNum() != seqNum) continue;
            return a;
        }
        return null;
    }

    public List<HuckelAtom> getHuckelAtoms() {
        ArrayList<HuckelAtom> lstHuckelAtoms = new ArrayList<HuckelAtom>();
        for (Atom a : this.getAtoms()) {
            if (!(a instanceof HuckelAtom)) continue;
            lstHuckelAtoms.add((HuckelAtom)a);
        }
        return lstHuckelAtoms;
    }

    public List<IHuckelObject> getHuckelObjects() {
        ArrayList<IHuckelObject> list = new ArrayList<IHuckelObject>();
        list.addAll(this.getHuckelAtoms());
        list.addAll(this.getHuckelBonds());
        return list;
    }

    public HuckelBond getHuckelBond(int idxBond) {
        HuckelBond l = this.getHuckelBonds().get(idxBond);
        return l;
    }

    public List<HuckelBond> getHuckelBonds() {
        ArrayList<HuckelBond> lstHuckelBonds = new ArrayList<HuckelBond>();
        for (Bond b : this.getBonds()) {
            if (!(b instanceof HuckelBond)) continue;
            lstHuckelBonds.add((HuckelBond)b);
        }
        return lstHuckelBonds;
    }

    protected int getMaxAtomIndex() {
        int numOrdreMax = 0;
        int numOrdreCourant = 0;
        for (Atom a : this.lstAtoms) {
            numOrdreCourant = a.getIndex();
            if (numOrdreCourant <= numOrdreMax) continue;
            numOrdreMax = numOrdreCourant;
        }
        return numOrdreMax;
    }

    public int getMaxAtomSeqNum() {
        int numOrdreMax = 0;
        int numOrdreCourant = 0;
        for (HuckelAtom a : this.getHuckelAtoms()) {
            numOrdreCourant = a.getSeqNum();
            if (numOrdreCourant <= numOrdreMax) continue;
            numOrdreMax = numOrdreCourant;
        }
        return numOrdreMax;
    }

    public int getMaxAtomSuperSymbol() {
        int superSymbolMax = 0;
        int superSymbolCurrent = 0;
        for (Atom a : this.getAtoms()) {
            superSymbolCurrent = a.getSuperSymbol();
            if (superSymbolCurrent <= superSymbolMax) continue;
            superSymbolMax = superSymbolCurrent;
        }
        return superSymbolMax;
    }

    protected int getMaxBondIndex() {
        int numOrdreMax = 0;
        int numOrdreCourant = 0;
        for (Bond b : this.lstBonds) {
            numOrdreCourant = b.getIndex();
            if (numOrdreCourant <= numOrdreMax) continue;
            numOrdreMax = numOrdreCourant;
        }
        return numOrdreMax;
    }

    public int getNbElecCharge() {
        return this.nbElecCharge;
    }

    public int getSumAtomsNbElecPi() {
        int nbElecPi = 0;
        for (HuckelAtom a : this.getHuckelAtoms()) {
            nbElecPi += a.getNbElecPi();
        }
        return nbElecPi;
    }

    public int[][] getTopology() {
        return this.topology;
    }

    public void updateTopology() {
        if (!this.areCorrectAtomsSeqNum()) {
            return;
        }
        int nAtoms = this.countHuckelAtoms();
        this.topology = new int[nAtoms][nAtoms];
        for (HuckelBond bond : this.getHuckelBonds()) {
            int i2 = bond.getAtom1().getSeqNum() - 1;
            int j = bond.getAtom2().getSeqNum() - 1;
            this.topology[i2][j] = 1;
            this.topology[j][i2] = 1;
        }
    }

    public double getWidth() {
        return Math.abs(this.getXMax() - this.getXMin());
    }

    public double getHeight() {
        return Math.abs(this.getYMax() - this.getYMin());
    }

    public double getXMax() {
        double x = this.lstAtoms.get(0).getX();
        for (Atom a : this.lstAtoms) {
            if (!(a.getX() > x)) continue;
            x = a.getX();
        }
        return x;
    }

    public double getXMin() {
        double x = this.lstAtoms.get(0).getX();
        for (Atom a : this.lstAtoms) {
            if (!(a.getX() < x)) continue;
            x = a.getX();
        }
        return x;
    }

    public double getYMax() {
        double y = this.lstAtoms.get(0).getY();
        for (Atom a : this.lstAtoms) {
            if (!(a.getY() > y)) continue;
            y = a.getY();
        }
        return y;
    }

    public double getYMin() {
        double y = this.lstAtoms.get(0).getY();
        for (Atom a : this.lstAtoms) {
            if (!(a.getY() < y)) continue;
            y = a.getY();
        }
        return y;
    }

    public int[] getZpi() {
        int[] Zpi = new int[this.countHuckelAtoms()];
        int iat = 0;
        while (iat < this.countHuckelAtoms()) {
            Zpi[iat] = this.getHuckelAtomBySeqNum(iat + 1).getNbElecPi();
            ++iat;
        }
        return Zpi;
    }

    public boolean isAutoCorrectH() {
        return this.autoCorrectH;
    }

    public boolean isEnabledNotify() {
        return this.enabledNotify;
    }

    public boolean isNbNeighboursMaxReachedExcludingH(Atom a) {
        int nbNoHBondAround = 0;
        for (Bond b : this.lstBonds) {
            if (a.getElement() == PeriodicTable.Element.H && b.contains(a)) {
                return true;
            }
            if (!b.contains(PeriodicTable.Element.H) && b.contains(a)) {
                ++nbNoHBondAround;
            }
            if (nbNoHBondAround != a.getNbNeighboursMax()) continue;
            return true;
        }
        return false;
    }

    public void move(double dx, double dy, double dz) {
        for (Atom a : this.lstAtoms) {
            Point3D p = a.getLocation();
            a.setLocationNotNotify(new Point3D(p.getX() + dx, p.getY() + dy, p.getZ() + dz));
        }
        this.fireMoleculeMoved(this, null, null);
    }

    protected void reindexAtoms() {
        int index = 1;
        for (Atom n : this.lstAtoms) {
            n.setIndex(index);
            ++index;
        }
    }

    protected void reindexBonds() {
        int index = 1;
        for (Bond i2 : this.lstBonds) {
            i2.setIndex(index);
            ++index;
        }
    }

    public void removeAtom(Atom a) throws HuckelBondException, BondException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        if (this.isAutoCorrectH() && a.getElement() == PeriodicTable.Element.H) {
            throw new MoleculeCoherenceException("cannot remove H atom when autoCorectH molecule option in true");
        }
        Atom old = a;
        this.do_removeAtom(a);
        this.updateCharges();
        this.updateTopology();
        this.correctElecCharge();
        this.fireMoleculeAtomRemoved(this, old, null);
    }

    protected void do_removeAtom(Atom a) throws HuckelBondException, BondException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        ArrayList<Atom> lstAtomHtoCorrect = new ArrayList<Atom>();
        Bond b = null;
        Iterator<Bond> iterator = this.lstBonds.iterator();
        while (iterator.hasNext()) {
            b = iterator.next();
            if (!b.contains(a)) continue;
            Atom h = b.getAtom(PeriodicTable.Element.H);
            if (h != null && this.isAutoCorrectH()) {
                this.lstAtoms.remove(h);
                h = null;
            } else {
                lstAtomHtoCorrect.add(b.getAtomLinkedWith(a));
            }
            iterator.remove();
        }
        if (a instanceof HuckelAtom) {
            HuckelAtom huckelAtom = (HuckelAtom)a;
            for (HuckelAtom n : this.getHuckelAtoms()) {
                if (n.getSeqNum() <= huckelAtom.getSeqNum()) continue;
                --n.seqNum;
            }
        }
        this.lstAtoms.remove(a);
        if (this.isAutoCorrectH()) {
            for (Atom atom : lstAtomHtoCorrect) {
                this.correctHBondAround(atom);
            }
        }
        this.reindexAtoms();
        this.reindexBonds();
    }

    public void removeBond(Bond l) throws HuckelBondException, BondException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        Bond old = l;
        this.do_removeBond(l);
        Atom a1 = l.getAtom1();
        Atom a2 = l.getAtom2();
        if (this.isAutoCorrectH()) {
            this.correctHBondAround(a1);
            this.correctHBondAround(a2);
        }
        this.reindexAtoms();
        this.reindexBonds();
        this.updateCharges();
        this.updateTopology();
        this.fireMoleculeBondRemoved(this, old, null);
    }

    protected void do_removeBond(Bond b) {
        this.lstBonds.remove(b);
    }

    public void replaceAtom(Atom old, Atom newAtom) throws HuckelBondException, BondException, MoleculeAtomNullException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        this.do_replaceAtom(old, newAtom);
        this.fireMoleculeAtomReplaced(this, old, newAtom);
        old = null;
    }

    protected void updateCharges() {
    }

    protected void do_replaceAtom(Atom old, Atom newAtom) throws HuckelBondException, BondException, MoleculeAtomNullException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        HuckelAtom huckelAtom;
        newAtom.setMoleculeContainer(this);
        newAtom.addListener(this);
        newAtom.addListener(this);
        newAtom.setLocationNotNotify(old.getLocation());
        if (old.getLocationGeom3D() != null) {
            Point3D oldXYZLocation = (Point3D)old.getLocationGeom3D().clone();
            newAtom.setLocationGeom3D(oldXYZLocation);
        }
        newAtom.setIndex(old.getIndex());
        if (newAtom == null || old == null) {
            throw new MoleculeAtomNullException("atom must be initialized");
        }
        int nbNotHBondAroundOld = 0;
        for (Bond b : this.lstBonds) {
            if (!b.contains(PeriodicTable.Element.H) && b.contains(old)) {
                ++nbNotHBondAroundOld;
            }
            if (nbNotHBondAroundOld <= newAtom.getNbNeighboursMax()) continue;
            throw new MoleculeTooManyNeighboursException("too many neighbours");
        }
        int i2 = 0;
        while (i2 < this.lstBonds.size()) {
            Bond l = this.lstBonds.get(i2);
            if (l.contains(old)) {
                if (!(old instanceof HuckelAtom) && newAtom instanceof HuckelAtom) {
                    HuckelBond hl = new HuckelBond((HuckelAtom)newAtom, (HuckelAtom)l.getAtomLinkedWith(old));
                    hl.setMoleculeContainer(this);
                    hl.addListener(this);
                    l.removeListener(this);
                    l = null;
                    this.lstBonds.set(i2, hl);
                } else {
                    l.replaceAtom(old, newAtom);
                }
            }
            ++i2;
        }
        if (!(old instanceof HuckelAtom) && newAtom instanceof HuckelAtom) {
            huckelAtom = (HuckelAtom)newAtom;
            huckelAtom.seqNum = this.getMaxAtomSeqNum() + 1;
        } else if (old instanceof HuckelAtom && newAtom instanceof HuckelAtom) {
            huckelAtom = (HuckelAtom)newAtom;
            huckelAtom.seqNum = ((HuckelAtom)old).seqNum;
        }
        i2 = 0;
        while (i2 < this.lstAtoms.size()) {
            if (this.lstAtoms.get(i2) == old) {
                this.lstAtoms.set(i2, newAtom);
                break;
            }
            ++i2;
        }
        if (this.isAutoCorrectH()) {
            this.correctHBondAround(newAtom);
        }
        this.reindexAtoms();
        this.reindexBonds();
        this.updateCharges();
        this.updateTopology();
        this.correctElecCharge();
        old.removeListener(this);
        old.removeListener(this);
    }

    public void resetSeqNumListHuckelAtomToZero() {
        for (HuckelAtom a : this.getHuckelAtoms()) {
            a.seqNum = 0;
        }
        this.fireMoleculeListHuckelAtomSeqNumReset(this, null, null);
    }

    public void rotate(Rotation mRot) {
        Point3D pCentre = this.getCenter();
        for (Atom a : this.lstAtoms) {
            Point3D oldLocationXYZ = (Point3D)a.getLocation().clone();
            a.rotate(pCentre, mRot);
            a.setLocationGeom3D(oldLocationXYZ);
        }
        this.fireMoleculeRotated(this, 0.0, mRot);
    }

    public void setAutoSeqNumListHuckelAtom() {
        int seqn = 1;
        this.resetSeqNumListHuckelAtomToZero();
        for (HuckelAtom a : this.getHuckelAtoms()) {
            a.seqNum = seqn++;
        }
        this.fireMoleculeListHuckelAtomSeqNumAutoSetted(this, null, null);
    }

    public void setAutoCorrectH(boolean autoCorrectH) {
        this.autoCorrectH = autoCorrectH;
    }

    public void setBondType(int idx, int bondType) throws MoleculeCoherenceException, HuckelBondException {
        if (bondType < 1 || bondType > 2) {
            throw new MoleculeCoherenceException("incorrect bond type");
        }
        if (idx < 0 || idx > this.countBonds()) {
            throw new MoleculeCoherenceException("wrong bond index");
        }
        Bond l = this.getBond(idx);
        if (!(l instanceof HuckelBond)) {
            throw new MoleculeCoherenceException("the bond" + idx + " is not a HuckelBond");
        }
        HuckelBond l2 = (HuckelBond)l;
        l2.do_setBondType(bondType);
    }

    public void setEnabledNotify(boolean enabled) {
        this.enabledNotify = enabled;
    }

    public void setCharge(int charge) throws MoleculeCoherenceException {
        this.setNbElecCharge(-charge);
    }

    public int getCharge() {
        return -this.nbElecCharge;
    }

    public void setNbElecCharge(int nbElecCharge) throws MoleculeCoherenceException {
        int nbElectTotal = nbElecCharge + this.getSumAtomsNbElecPi();
        int nbMaxElecPossible = this.countHuckelAtoms() * 2;
        int oldValue = this.nbElecCharge;
        if (nbElectTotal <= nbMaxElecPossible && nbElectTotal >= 0) {
            this.nbElecCharge = nbElecCharge;
        } else if (nbElectTotal > nbMaxElecPossible || nbElecCharge < 0) {
            throw new MoleculeCoherenceException("incorrect number of electrons (out of bounds)");
        }
        if (this.nbElecCharge != oldValue) {
            this.fireMoleculeChargeChanged(this, oldValue, nbElecCharge);
        }
    }

    protected void switchBondTypes(int ibond, int jbond) {
        if (!(this.getBond(ibond) instanceof HuckelBond)) {
            return;
        }
        int ibondtype = ((HuckelBond)this.getBond(ibond)).getBondType();
        if (!(this.getBond(jbond) instanceof HuckelBond)) {
            return;
        }
        int jbondtype = ((HuckelBond)this.getBond(jbond)).getBondType();
        if (ibondtype == jbondtype) {
            return;
        }
        int tmpType = ibondtype;
        try {
            this.changeBondType(ibond, jbondtype);
            this.changeBondType(jbond, tmpType);
        }
        catch (Exception e) {
            HuckelIO.warning(this.getClass().getName(), "switchBondTypes", e.getMessage(), e);
        }
    }

    public String toString() {
        String res = "elec charge : " + this.nbElecCharge;
        return res;
    }

    public OrbitaleAtomique[] getOAs() {
        List<HuckelAtom> list = this.getHuckelAtoms();
        Collections.sort(list, new SeqNumComparator());
        int size = list.size();
        OrbitaleAtomique[] OAs = new OrbitaleAtomique[size];
        int n = 0;
        for (HuckelAtom a : list) {
            OAs[n] = new OrbitaleAtomique(a, new Energy(a.getHx(), 0.0));
            ++n;
        }
        return OAs;
    }

    public void addListener(IMoleculeValueListener listener) {
        this.valueListeners.add(listener);
    }

    public void addListener(IMoleculeGeometryListener listener) {
        this.geometryListeners.add(listener);
    }

    @Override
    public void huckelBondBondTypeChanged(HuckelBondEvent e) {
        this.fireHuckelBondBondTypeChanged(e);
    }

    @Override
    public void huckelBondHxyChanged(HuckelBondEvent e) {
        this.fireHuckelBondHxyChanged(e);
    }

    @Override
    public void huckelAtomHxChanged(HuckelAtomEvent e) {
        this.fireHuckelAtomHxChanged(e);
    }

    @Override
    public void huckelAtomRadRChanged(HuckelAtomEvent e) {
        this.fireHuckelAtomRadRChanged(e);
    }

    @Override
    public void huckelAtomSeqNumChanged(HuckelAtomEvent e) {
        this.fireHuckelAtomSeqNumChanged(e);
    }

    @Override
    public void atomLocationChanged(GeometryEvent event) {
        this.fireAtomLocationChanged(event);
    }

    public ArrayList<IMoleculeValueListener> getValueListeners() {
        return (ArrayList)this.valueListeners.clone();
    }

    public ArrayList<IMoleculeGeometryListener> getGeometryListeners() {
        return (ArrayList)this.geometryListeners.clone();
    }

    protected void fireHuckelAtomHxChanged(HuckelAtomEvent e) {
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        for (IMoleculeValueListener listener : this.getValueListeners()) {
            listener.huckelAtomHxChanged(e);
        }
    }

    protected void fireHuckelAtomSeqNumChanged(HuckelAtomEvent e) {
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        for (IMoleculeValueListener listener : this.getValueListeners()) {
            listener.huckelAtomSeqNumChanged(e);
        }
    }

    protected void fireAtomLocationChanged(GeometryEvent e) {
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        for (IMoleculeGeometryListener listener : this.getGeometryListeners()) {
            listener.atomLocationChanged(e);
        }
    }

    protected void fireHuckelAtomRadRChanged(HuckelAtomEvent e) {
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        for (IMoleculeValueListener listener : this.getValueListeners()) {
            listener.huckelAtomRadRChanged(e);
        }
    }

    protected void fireHuckelBondHxyChanged(HuckelBondEvent e) {
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        for (IMoleculeValueListener listener : this.getValueListeners()) {
            listener.huckelBondHxyChanged(e);
        }
    }

    protected void fireHuckelBondBondTypeChanged(HuckelBondEvent e) {
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        for (IMoleculeValueListener listener : this.getValueListeners()) {
            listener.huckelBondBondTypeChanged(e);
        }
    }

    protected void fireMoleculeMoved(Molecule source, Object oldValue, Object newValue) {
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("FireMoleculeChanged : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        GeometryEvent event = null;
        for (IMoleculeGeometryListener listener : this.getGeometryListeners()) {
            if (event == null) {
                event = new GeometryEvent(source, oldValue, newValue);
            }
            listener.moleculeMoved(event);
        }
    }

    protected void fireMoleculeRotated(Molecule source, Object oldValue, Object newValue) {
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        GeometryEvent event = null;
        for (IMoleculeGeometryListener listener : this.getGeometryListeners()) {
            if (event == null) {
                event = new GeometryEvent(source, oldValue, newValue);
            }
            listener.moleculeRotated(event);
        }
    }

    protected void fireMoleculeAtomRemoved(Molecule source, Object oldValue, Object newValue) {
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        MoleculeEvent event = null;
        for (IMoleculeValueListener listener : this.getValueListeners()) {
            if (event == null) {
                event = new MoleculeEvent(source, oldValue, newValue);
            }
            listener.moleculeAtomRemoved(event);
        }
    }

    protected void fireMoleculeBondAdded(Molecule source, Object oldValue, Object newValue) {
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        MoleculeEvent event = null;
        for (IMoleculeValueListener listener : this.getValueListeners()) {
            if (event == null) {
                event = new MoleculeEvent(source, oldValue, newValue);
            }
            listener.moleculeBondAdded(event);
        }
    }

    protected void fireMoleculeDeleted(Molecule source, Object oldValue, Object newValue) {
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false\n");
            return;
        }
        MoleculeEvent event = null;
        for (IMoleculeValueListener listener : this.getValueListeners()) {
            if (event == null) {
                event = new MoleculeEvent(source, oldValue, newValue);
            }
            listener.moleculeDeleted(event);
        }
    }

    public void addListener(IMoleculeListener listener) {
        if (listener instanceof IMoleculeGeometryListener) {
            this.geometryListeners.add((IMoleculeGeometryListener)listener);
        }
        if (listener instanceof IMoleculeValueListener) {
            this.valueListeners.add((IMoleculeValueListener)listener);
        }
    }

    public void removeListener(IMoleculeListener listener) {
        if (listener instanceof IMoleculeGeometryListener) {
            this.geometryListeners.remove((IMoleculeGeometryListener)listener);
        }
        if (listener instanceof IMoleculeValueListener) {
            this.valueListeners.remove((IMoleculeValueListener)listener);
        }
    }

    public void removeListener(IMoleculeValueListener listener) {
        this.valueListeners.remove(listener);
    }

    public void removeListener(IMoleculeGeometryListener listener) {
        this.geometryListeners.remove(listener);
    }

    public void removeAllListeners() {
        this.valueListeners.clear();
        this.geometryListeners.clear();
    }

    protected void fireMoleculeBondRemoved(Molecule source, Object oldValue, Object newValue) {
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        MoleculeEvent event = null;
        for (IMoleculeValueListener listener : this.getValueListeners()) {
            if (event == null) {
                event = new MoleculeEvent(source, oldValue, newValue);
            }
            listener.moleculeBondRemoved(event);
        }
    }

    protected void fireMoleculeAtomReplaced(Molecule source, Object oldValue, Object newValue) {
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        MoleculeEvent event = null;
        for (IMoleculeValueListener listener : this.getValueListeners()) {
            if (event == null) {
                event = new MoleculeEvent(source, oldValue, newValue);
            }
            listener.moleculeAtomReplaced(event);
        }
    }

    protected void fireMoleculeChargeChanged(Molecule source, Object oldValue, Object newValue) {
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        MoleculeEvent event = null;
        ArrayList<IMoleculeValueListener> lst = this.getValueListeners();
        for (IMoleculeValueListener listener : lst) {
            if (event == null) {
                event = new MoleculeEvent(source, oldValue, newValue);
            }
            listener.moleculeChargeChanged(event);
        }
    }

    protected void fireMoleculeListHuckelAtomSeqNumAutoSetted(Molecule source, Object oldValue, Object newValue) {
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        MoleculeEvent event = null;
        for (IMoleculeValueListener listener : this.getValueListeners()) {
            if (event == null) {
                event = new MoleculeEvent(source, oldValue, newValue);
            }
            listener.moleculeListHuckelAtomSeqNumAutoSetted(event);
        }
    }

    protected void fireMoleculeListHuckelAtomSeqNumReset(Molecule source, Object oldValue, Object newValue) {
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        MoleculeEvent event = null;
        for (IMoleculeValueListener listener : this.getValueListeners()) {
            if (event == null) {
                event = new MoleculeEvent(source, oldValue, newValue);
            }
            listener.moleculeListHuckelAtomSeqNumReset(event);
        }
    }

    protected void fireMoleculeAtomAdded(Molecule source, Object oldValue, Object newValue) {
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        MoleculeEvent event = null;
        for (IMoleculeValueListener listener : this.getValueListeners()) {
            if (event == null) {
                event = new MoleculeEvent(source, oldValue, newValue);
            }
            listener.moleculeAtomAdded(event);
        }
    }
}

