/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.huckel;

import java.io.Serializable;
import org.ctom.hulis.huckel.Energy;
import org.ctom.hulis.huckel.Orbitale;

public class OrbitaleMoleculaire
extends Orbitale
implements Serializable {
    private static final long serialVersionUID = 3617696344037923987L;
    private double[] LCAO;
    private int size = -1;

    public OrbitaleMoleculaire(Energy e, double[] coeffs) {
        super(e);
        this.size = coeffs.length;
        this.LCAO = new double[this.size];
        int i2 = 0;
        while (i2 < this.size) {
            this.LCAO[i2] = coeffs[i2];
            ++i2;
        }
    }

    public double[] getCoeffs() {
        return this.LCAO;
    }

    public double getCoeff(int i2) {
        return this.LCAO[i2];
    }

    public int getSize() {
        return this.size;
    }

    public double overlap(OrbitaleMoleculaire that, int[][] topo_) {
        double ovl = 0.0;
        int i2 = 0;
        while (i2 < this.size) {
            ovl += this.LCAO[i2] * that.LCAO[i2];
            ++i2;
        }
        return ovl;
    }

    public boolean equals(OrbitaleMoleculaire that) {
        return this.LCAO == that.LCAO;
    }

    @Override
    public double computeNorm() {
        return null;
    }

    public static void main(String[] args) {
        OrbitaleMoleculaire o = new OrbitaleMoleculaire(null, null);
        System.out.print(o.toLaTeX());
    }

    public String toHtml() {
        return "TO OVERRIDE";
    }
}

