/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.huckel;

import java.io.Serializable;
import org.ctom.hulis.huckel.Energy;
import org.ctom.hulis.huckel.OrbitaleMoleculaire;
import org.ctom.hulis.huckel.Spin;
import org.ctom.hulis.huckel.exception.OrbitaleMoleculaireException;
import org.ctom.hulis.huckel.exception.SpinOrbitaleMoleculaireException;

public class SpinOrbitaleMoleculaire
extends OrbitaleMoleculaire
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -7473959347477473706L;
    private Spin spin = Spin.NOSPIN_ALPHA;
    private SpinOrbitaleMoleculaire partner = null;
    private int index = -1;
    private double nbElectrons;
    private int indexTableOrbitale;

    public SpinOrbitaleMoleculaire(Energy e, double[] coeff, Spin spin) {
        super(e, coeff);
        String val = spin.toString();
        this.setSpin(val);
        this.nbElectrons = -1.0;
        this.indexTableOrbitale = -1;
    }

    public SpinOrbitaleMoleculaire(SpinOrbitaleMoleculaire that) {
        this(that.getEnergy(), that.getCoeffs(), that.getSpin());
        this.partner = that.partner;
        this.index = that.index;
        this.nbElectrons = that.nbElectrons;
        this.indexTableOrbitale = that.indexTableOrbitale;
    }

    public Object clone() {
        return new SpinOrbitaleMoleculaire(this);
    }

    public boolean equals(SpinOrbitaleMoleculaire that) {
        if (this.spin != that.spin) {
            return false;
        }
        return super.equals(that);
    }

    public Spin getSpin() {
        return this.spin;
    }

    private void setSpin(String spinStr) {
        this.spin = Spin.valueOf(spinStr);
    }

    public void switchSpin() throws OrbitaleMoleculaireException {
        switch (this.spin) {
            case ALPHA: {
                this.setSpin(Spin.BETA.toString());
                break;
            }
            case BETA: {
                this.setSpin(Spin.ALPHA.toString());
                break;
            }
            default: {
                throw new OrbitaleMoleculaireException(String.valueOf(this.getClass().toString()) + "Cannot switch spin of nospin");
            }
        }
    }

    public double overlap(SpinOrbitaleMoleculaire that, int[][] topo) {
        Spin a = this.getSpin();
        Spin b = that.getSpin();
        if (this.getSpin() != that.getSpin()) {
            return 0.0;
        }
        double rc = super.overlap(that, topo);
        return rc;
    }

    public double getNbElectrons() {
        return this.nbElectrons;
    }

    public void setNbElectrons(double nbElectrons) {
        this.nbElectrons = nbElectrons;
    }

    @Override
    public String toHtml() {
        return "\u025b<sub></sub> = " + this.getEnergy().toString();
    }

    public static void setPartner(SpinOrbitaleMoleculaire somA, SpinOrbitaleMoleculaire somB) {
        somA.partner = somB;
        somB.partner = somA;
    }

    public SpinOrbitaleMoleculaire getPartner() {
        return this.partner;
    }

    public void removeElectron() throws SpinOrbitaleMoleculaireException {
        switch (this.getSpin()) {
            case ALPHA: {
                this.setSpin(Spin.NOSPIN_ALPHA.toString());
                break;
            }
            case BETA: {
                this.setSpin(Spin.NOSPIN_BETA.toString());
                break;
            }
            default: {
                throw new SpinOrbitaleMoleculaireException("cannot remove electron from empty orbital");
            }
        }
    }

    public void addElectron() throws SpinOrbitaleMoleculaireException {
        switch (this.getSpin()) {
            case NOSPIN_ALPHA: {
                this.setSpin(Spin.ALPHA.toString());
                break;
            }
            case NOSPIN_BETA: {
                this.setSpin(Spin.BETA.toString());
                break;
            }
            default: {
                throw new SpinOrbitaleMoleculaireException("cannot add electron to an occupied orbital");
            }
        }
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public int getIndexTableOrbitale() {
        return this.indexTableOrbitale;
    }

    public void setIndexTableOrbitale(int indexTableOrbitale) {
        this.indexTableOrbitale = indexTableOrbitale;
    }

    public static void main(String[] args) {
        SpinOrbitaleMoleculaire o = new SpinOrbitaleMoleculaire(null);
        System.out.print(o.toLaTeX());
    }
}

