/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.huckel.methods;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.io.Serializable;
import java.util.ArrayList;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.exception.HLCIException;
import org.ctom.hulis.huckel.exception.HLCIValBnException;
import org.ctom.hulis.huckel.exception.HLPException;
import org.ctom.hulis.huckel.exception.HLPOverlapException;
import org.ctom.hulis.huckel.exception.IMethodException;
import org.ctom.hulis.huckel.exception.NoElectronException;
import org.ctom.hulis.huckel.exception.NullOvlMatrixException;
import org.ctom.hulis.huckel.exception.OrbitaleMoleculaireException;
import org.ctom.hulis.huckel.methods.HLPMethod;
import org.ctom.hulis.huckel.methods.IMethod;
import org.ctom.hulis.huckel.methods.IMethodHasOptimizableMatrix;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import org.ctom.hulis.huckel.warning.IMethodWarning;
import org.ctom.hulis.util.VectorssHuckel;
import org.ctom.hulis.util.io.HuckelIO;
import org.ctom.util.common.Arrays;

public class HLCIMethod
implements IMethod,
Cloneable,
IMethodHasOptimizableMatrix,
Serializable {
    private static final long serialVersionUID = 4116421317538357713L;
    private double[][] coeffB;
    private double[] ciHLCI;
    private double[][] hamiltonian;
    private Mesomery mesomery;
    private double[] weightsHLCIArray;
    double tau;
    boolean isImplementedTau;
    IMethodException error;
    private ArrayList<IMethodWarning> warnings = new ArrayList();

    public double calculateValBn() throws HLCIValBnException {
        int nbSelLocalizedStructs = this.mesomery.countSelectedLocalizedStructs();
        StructureLocalized s = null;
        double delocalizedEnergy = this.mesomery.getDelocalizedStructure().getTotalEnergy().getBeta();
        double deltaEi = 0.0;
        Matrix matC = new Matrix(nbSelLocalizedStructs, nbSelLocalizedStructs);
        s = null;
        int i2 = 0;
        while (i2 < nbSelLocalizedStructs) {
            s = this.mesomery.getSelectedLocalizedStruct(i2);
            int j = 0;
            while (j < nbSelLocalizedStructs) {
                if (i2 == j) {
                    matC.set(i2, j, 1.0);
                } else {
                    deltaEi = s.getTotalEnergy().getBeta() - delocalizedEnergy;
                    if (deltaEi == 0.0) {
                        throw new HLCIValBnException("divide by zero");
                    }
                    try {
                        matC.set(i2, j, this.getCoeffB()[i2][j] / deltaEi);
                    }
                    catch (Exception e) {
                        throw new HLCIValBnException("fail to initialize matrix");
                    }
                }
                ++j;
            }
            ++i2;
        }
        EigenvalueDecomposition eig = null;
        try {
            eig = new EigenvalueDecomposition(matC);
        }
        catch (Exception e) {
            throw new HLCIValBnException("EigenvalueDecomposition error");
        }
        double[] eigAn = eig.getRealEigenvalues();
        double n = 0.0;
        int nbPositive = 0;
        double valBn = 0.0;
        i2 = 0;
        while (i2 < nbSelLocalizedStructs) {
            n = -(1.0 / (eigAn[i2] - 1.0));
            if (n > 0.0) {
                valBn = n;
                if (++nbPositive > 1) {
                    throw new HLCIValBnException("to much positive Bn");
                }
            }
            ++i2;
        }
        return valBn;
    }

    public HLCIMethod() {
        this.ciHLCI = new double[0];
        this.weightsHLCIArray = new double[0];
        this.hamiltonian = new double[0][0];
        this.tau = 0.0;
        this.isImplementedTau = false;
        this.error = null;
        this.coeffB = null;
    }

    public HLCIMethod(HLCIMethod method) {
        this.mesomery = method.mesomery;
        this.ciHLCI = Arrays.arrayCopy(method.ciHLCI);
        this.weightsHLCIArray = Arrays.arrayCopy(method.weightsHLCIArray);
        this.hamiltonian = Arrays.arrayCopy(method.hamiltonian);
        this.tau = method.tau;
        this.isImplementedTau = method.isImplementedTau;
        this.error = method.error;
        if (this.coeffB != null) {
            this.coeffB = Arrays.arrayCopy(method.coeffB);
        }
    }

    private void generateCoeffB() {
        int nbStruc = this.mesomery.countSelectedLocalizedStructs();
        if (nbStruc == 0) {
            this.coeffB = new double[0][0];
            return;
        }
        double[][] coeffB = new double[nbStruc][nbStruc];
        int i2 = 0;
        while (i2 < nbStruc) {
            int j = 0;
            while (j < nbStruc) {
                coeffB[i2][j] = 1.0;
                ++j;
            }
            ++i2;
        }
        this.coeffB = coeffB;
    }

    public synchronized double[][] getCoeffB() {
        if (this.coeffB == null) {
            return new double[0][];
        }
        return (double[][])this.coeffB.clone();
    }

    @Override
    public void calculate() throws IMethodException {
        Matrix matC;
        this.ciHLCI = new double[0];
        this.weightsHLCIArray = new double[0];
        this.hamiltonian = new double[0][0];
        this.tau = 0.0;
        this.isImplementedTau = false;
        this.error = null;
        if (this.mesomery.countSelectedLocalizedStructs() == 1) {
            StructureLocalized struct = this.mesomery.getSelectedLocalizedStruct(0);
            struct.setWeight(this.getName(), 1.0);
            this.weightsHLCIArray = new double[1];
            this.weightsHLCIArray[0] = 1.0;
            this.ciHLCI = new double[1];
            this.ciHLCI[0] = 1.0;
            try {
                this.tau = this.computeTau();
            }
            catch (NullOvlMatrixException e) {
                this.error = new HLCIException(e);
                throw this.error;
            }
            catch (NoElectronException e) {
                this.error = new HLCIException(e);
                throw this.error;
            }
            catch (OrbitaleMoleculaireException e) {
                this.error = new HLCIException(e);
                throw this.error;
            }
            catch (HLPOverlapException e) {
                this.error = new HLCIException(e);
                throw this.error;
            }
            catch (Exception e) {
                this.error = new HLPException(e);
                throw this.error;
            }
            return;
        }
        this.weightsHLCIArray = new double[this.mesomery.countSelectedLocalizedStructs()];
        double[][] eigV = new double[0][0];
        int idxHighestEnergy = 0;
        this.generateCoeffB();
        if (this.coeffB.length == 0) {
            return;
        }
        double valBn = 0.0;
        try {
            valBn = this.calculateValBn();
        }
        catch (HLCIValBnException e) {
            this.error = new HLCIException(e);
            throw this.error;
        }
        StructureLocalized s = null;
        int nbSelLocalizedStructs = this.mesomery.countSelectedLocalizedStructs();
        if (valBn == 0.0) {
            this.error = new HLCIException("no negative Bn");
            throw this.error;
        }
        double deltaEi = 0.0;
        try {
            matC = new Matrix(nbSelLocalizedStructs, nbSelLocalizedStructs);
        }
        catch (Exception e1) {
            this.error = new HLCIException("Out of memory");
            throw this.error;
        }
        s = null;
        int i2 = 0;
        while (i2 < nbSelLocalizedStructs) {
            if (this.mesomery.isStopConsumingProccess()) {
                return;
            }
            s = this.mesomery.getSelectedLocalizedStruct(i2);
            int j = 0;
            while (j < nbSelLocalizedStructs) {
                if (this.mesomery.isStopConsumingProccess()) {
                    return;
                }
                if (i2 == j) {
                    deltaEi = s.getTotalEnergy().getBeta();
                    matC.set(i2, j, deltaEi);
                } else {
                    matC.set(i2, j, this.getCoeffB()[i2][j] * valBn);
                }
                ++j;
            }
            ++i2;
        }
        this.hamiltonian = matC.getArray();
        EigenvalueDecomposition eig = null;
        try {
            eig = new EigenvalueDecomposition(matC);
        }
        catch (Exception e) {
            this.error = new HLCIException("EigenvalueDecomposition error");
            throw this.error;
        }
        double[] eigValues = VectorssHuckel.sort(eig.getRealEigenvalues());
        idxHighestEnergy = 0;
        i2 = 0;
        while (i2 < eigValues.length) {
            if (eigValues[i2] > eigValues[idxHighestEnergy]) {
                idxHighestEnergy = i2;
            }
            ++i2;
        }
        if (this.mesomery.isStopConsumingProccess()) {
            return;
        }
        eigV = VectorssHuckel.sort(eig.getV().getArray());
        this.ciHLCI = new double[nbSelLocalizedStructs];
        i2 = 0;
        while (i2 < nbSelLocalizedStructs) {
            this.ciHLCI[i2] = eigV[i2][idxHighestEnergy];
            ++i2;
        }
        i2 = 0;
        while (i2 < nbSelLocalizedStructs) {
            StructureLocalized struct = this.mesomery.getSelectedLocalizedStruct(i2);
            this.weightsHLCIArray[i2] = eigV[i2][idxHighestEnergy] * eigV[i2][idxHighestEnergy];
            struct.setWeight(this.getName(), this.weightsHLCIArray[i2]);
            ++i2;
        }
        try {
            this.tau = this.computeTau();
        }
        catch (NullOvlMatrixException e) {
            this.error = new HLCIException(e);
            throw this.error;
        }
        catch (NoElectronException e) {
            this.error = new HLCIException(e);
            throw this.error;
        }
        catch (OrbitaleMoleculaireException e) {
            this.error = new HLCIException(e);
            throw this.error;
        }
        catch (HLPOverlapException e) {
            this.error = new HLCIException(e);
            throw this.error;
        }
    }

    public double computeTau() throws NullOvlMatrixException, NoElectronException, OrbitaleMoleculaireException, HLPOverlapException {
        double tau = 0.0;
        HLPMethod hlpMethod = (HLPMethod)this.mesomery.getMethod("HLP");
        if (hlpMethod == null) {
            this.isImplementedTau = false;
            return 0.0;
        }
        this.isImplementedTau = true;
        double[][] hlpOverlap = hlpMethod.getOverlapTabAll();
        this.adjustOvlForHLCI(hlpOverlap);
        this.warnForNegativeOverlap(hlpOverlap);
        double[] ciHLCITemp = new double[this.ciHLCI.length];
        HuckelIO.PrintIfln("CALCUL DE TAU HLCI ");
        double som = 0.0;
        int iStructLoc = 1;
        while (iStructLoc < hlpOverlap.length) {
            int jStructLoc = 1;
            while (jStructLoc < hlpOverlap[0].length) {
                som += this.ciHLCI[iStructLoc - 1] * this.ciHLCI[jStructLoc - 1] * hlpOverlap[iStructLoc][jStructLoc];
                ++jStructLoc;
            }
            ++iStructLoc;
        }
        double sqrSom = Math.sqrt(som);
        int iStructLoc2 = 0;
        while (iStructLoc2 < this.ciHLCI.length) {
            ciHLCITemp[iStructLoc2] = this.ciHLCI[iStructLoc2] / sqrSom;
            HuckelIO.PrintIfln("coeff renorm\u00e9s" + iStructLoc2 + " - " + ciHLCITemp[iStructLoc2] + " = " + this.ciHLCI[iStructLoc2] + "/" + sqrSom);
            ++iStructLoc2;
        }
        som = 0.0;
        iStructLoc2 = 1;
        while (iStructLoc2 < hlpOverlap[0].length) {
            som += ciHLCITemp[iStructLoc2 - 1] * hlpOverlap[iStructLoc2][0];
            HuckelIO.PrintIfln("overlap " + iStructLoc2 + " " + ciHLCITemp[iStructLoc2 - 1] + "*" + hlpOverlap[iStructLoc2][0]);
            ++iStructLoc2;
        }
        tau = som;
        return tau;
    }

    private void warnForNegativeOverlap(double[][] hlpOverlap) {
        int size = hlpOverlap[0].length;
        int i2 = 0;
        while (i2 < size) {
            int j = 0;
            while (j < size) {
                if (hlpOverlap[i2][j] < 0.0) {
                    this.warnings.add(new IMethodWarning(this, "A negative term appears in the overlap matrix.\nHL-CI method might give unreliable results.\n", IMethodWarning.HulisWarningType.UNAPPROPRIATE_METHOD));
                    return;
                }
                ++j;
            }
            ++i2;
        }
    }

    private void adjustOvlForHLCI(double[][] hlpOverlap) {
    }

    @Override
    public Object clone() {
        return new HLCIMethod(this);
    }

    @Override
    public double[] getCI() {
        double[] ciHLCIclone = new double[this.ciHLCI.length];
        System.arraycopy(this.ciHLCI, 0, ciHLCIclone, 0, this.ciHLCI.length);
        return ciHLCIclone;
    }

    @Override
    public boolean isImplementedHamiltonian() {
        return true;
    }

    @Override
    public double[][] getHamiltonian() {
        return this.hamiltonian;
    }

    @Override
    public String getName() {
        return "HLCI";
    }

    @Override
    public double getTau() {
        if (!this.isImplementedTau()) {
            throw new ArithmeticException();
        }
        return this.tau;
    }

    @Override
    public double[] getWeights() {
        return (double[])this.weightsHLCIArray.clone();
    }

    @Override
    public boolean isImplementedTau() {
        return this.isImplementedTau;
    }

    @Override
    public void setMesomery(Mesomery mesomery) {
        this.mesomery = mesomery;
    }

    @Override
    public int getPriority() {
        return 2;
    }

    @Override
    public IMethodException getError() {
        return this.error;
    }

    public IMethod newInstance() {
        return new HLCIMethod();
    }

    @Override
    public void removeInOptimizableMatrix(int i2) {
        this.generateCoeffB();
    }

    @Override
    public void computeOptimizableMatrix(int i2) {
        this.generateCoeffB();
    }

    @Override
    public void extendOptimizableMatrix() {
        this.generateCoeffB();
    }

    @Override
    public void computeAllOptimizableMatrix() {
        this.generateCoeffB();
    }

    @Override
    public boolean checkOptimizableMatrix() {
        int nbSelLocalizedStructs = this.mesomery.countSelectedLocalizedStructs();
        if (this.coeffB == null) {
            this.generateCoeffB();
        }
        int i2 = 0;
        while (i2 < nbSelLocalizedStructs) {
            if (this.coeffB[i2][i2] != 1.0) {
                this.error = new HLCIException("incorrect matrix of coeff B : diagonal must be equal to 1");
                return false;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < nbSelLocalizedStructs) {
            int j = 0;
            while (j < nbSelLocalizedStructs) {
                if (this.coeffB[i2][j] != this.coeffB[i2][j]) {
                    this.error = new HLCIException("matrix must be symetric");
                    return false;
                }
                ++j;
            }
            ++i2;
        }
        return true;
    }

    @Override
    public ArrayList<IMethodWarning> getWarnings() {
        return this.warnings;
    }
}

