/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.huckel.methods;

import Jama.Matrix;
import java.io.Serializable;
import java.util.ArrayList;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.exception.HLPException;
import org.ctom.hulis.huckel.exception.HLPOverlapException;
import org.ctom.hulis.huckel.exception.IMethodException;
import org.ctom.hulis.huckel.exception.NoElectronException;
import org.ctom.hulis.huckel.exception.NoSOMAvailableException;
import org.ctom.hulis.huckel.exception.NullOvlMatrixException;
import org.ctom.hulis.huckel.exception.OrbitaleMoleculaireException;
import org.ctom.hulis.huckel.exception.ProjectionException;
import org.ctom.hulis.huckel.exception.RedundanceException;
import org.ctom.hulis.huckel.exception.UnavailableSOMException;
import org.ctom.hulis.huckel.methods.IMethod;
import org.ctom.hulis.huckel.methods.IMethodHasOptimizableMatrix;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import org.ctom.hulis.huckel.warning.IMethodWarning;
import org.ctom.hulis.util.Projection;
import org.ctom.hulis.util.io.HuckelIO;
import org.ctom.util.common.Arrays;

public class HLPMethod
implements Cloneable,
IMethod,
IMethodHasOptimizableMatrix,
Serializable {
    private static final long serialVersionUID = 9057058480708583811L;
    private double[] ciCoeff;
    private double[] ciWeights;
    private Mesomery mesomery;
    private final String name = "HLP";
    private double[][] overlapTab;
    private double tau;
    IMethodException error;
    private ArrayList<IMethodWarning> warnings = new ArrayList();

    public HLPMethod() {
        this.ciCoeff = new double[0];
        this.ciWeights = new double[0];
        this.error = null;
    }

    public HLPMethod(HLPMethod method) {
        this.tau = method.tau;
        this.mesomery = method.getMesomery();
        this.ciCoeff = Arrays.arrayCopy(method.ciCoeff);
        this.ciWeights = Arrays.arrayCopy(method.ciWeights);
        this.overlapTab = Arrays.arrayCopy(method.overlapTab);
        this.error = method.error;
    }

    @Override
    public void calculate() throws IMethodException {
        double[][] OvlTabAll;
        System.out.println(">>>>>>>>>>>>>>  DEBUT COMPUTE HLP <<<<<<<<<<<<<<<<< ");
        this.ciCoeff = new double[0];
        this.ciWeights = new double[0];
        this.error = null;
        int nbSelLocalizedStructs = this.mesomery.countSelectedLocalizedStructs();
        if (this.mesomery.isStopConsumingProccess()) {
            return;
        }
        try {
            OvlTabAll = this.getOverlapTabAll();
        }
        catch (OrbitaleMoleculaireException e) {
            this.error = new HLPException(e);
            throw this.error;
        }
        catch (NoElectronException e) {
            this.error = new HLPException(e);
            throw this.error;
        }
        catch (NullOvlMatrixException e) {
            this.error = new HLPException(e);
            throw this.error;
        }
        catch (HLPOverlapException e) {
            this.error = new HLPException(e);
            throw this.error;
        }
        catch (Exception e) {
            this.error = new HLPException(e);
            throw this.error;
        }
        Matrix OvlStot = new Matrix(nbSelLocalizedStructs, 1);
        int i2 = 0;
        while (i2 < nbSelLocalizedStructs) {
            OvlStot.set(i2, 0, OvlTabAll[0][i2 + 1]);
            ++i2;
        }
        Projection proj = null;
        try {
            proj = new Projection(new Matrix(this.getOverlapTabNoPhitot()), OvlStot);
            HuckelIO.PrintVector(proj.getCoeffs(), "Coefficients de la projection");
            HuckelIO.PrintVector(proj.getWeights(), "Poids de la projection");
            HuckelIO.PrintVector(proj.getNormalizedWeights(), "Poids normes de la projection");
            HuckelIO.PrintIfln(String.format("Norme de la projection %f", proj.getNorm()));
        }
        catch (NoElectronException e1) {
            this.error = new RedundanceException();
            throw this.error;
        }
        catch (NullOvlMatrixException e1) {
            this.error = new RedundanceException();
            throw this.error;
        }
        catch (ProjectionException e1) {
            this.error = new RedundanceException();
            throw this.error;
        }
        catch (OrbitaleMoleculaireException e1) {
            this.error = new RedundanceException();
            throw this.error;
        }
        catch (HLPOverlapException e1) {
            this.error = new RedundanceException();
            throw this.error;
        }
        this.ciCoeff = (double[])proj.getNormalizedCoeffs().clone();
        this.ciWeights = (double[])proj.getNormalizedWeights().clone();
        this.tau = proj.getNewTau();
        HuckelIO.unsetBuffer();
        i2 = 0;
        while (i2 < nbSelLocalizedStructs) {
            StructureLocalized struct = this.mesomery.getSelectedLocalizedStruct(i2);
            struct.setWeight(this.getName(), this.getWeights()[i2]);
            ++i2;
        }
        System.out.println(">>>>>>>>>>>>>>  FIN COMPUTE HLP <<<<<<<<<<<<<<<<< ");
    }

    @Override
    public Object clone() {
        return new HLPMethod(this);
    }

    @Override
    public double[] getCI() {
        return this.ciCoeff;
    }

    @Override
    public double[][] getHamiltonian() {
        return null;
    }

    @Override
    public String getName() {
        return "HLP";
    }

    public double[][] getOverlapTabAll() throws NoElectronException, NullOvlMatrixException, OrbitaleMoleculaireException, HLPOverlapException {
        if (this.overlapTab == null) {
            try {
                this.computeOverlapTab();
            }
            catch (NullOvlMatrixException e) {
                HuckelIO.error(this.getClass().getName(), "getOverlapTabAll", e.getMessage(), e);
                throw e;
            }
        }
        return this.overlapTab;
    }

    public double[][] getOverlapTabNoPhitot() throws NoElectronException, NullOvlMatrixException, OrbitaleMoleculaireException, HLPOverlapException {
        double[][] sAll = this.getOverlapTabAll();
        int size = sAll.length;
        double[][] sSmall = new double[size - 1][size - 1];
        int i2 = 1;
        while (i2 < size) {
            int j = 1;
            while (j < size) {
                sSmall[i2 - 1][j - 1] = sAll[i2][j];
                ++j;
            }
            ++i2;
        }
        return sSmall;
    }

    @Override
    public double getTau() {
        return this.tau;
    }

    @Override
    public double[] getWeights() {
        return this.ciWeights;
    }

    @Override
    public boolean isImplementedHamiltonian() {
        return false;
    }

    @Override
    public boolean isImplementedTau() {
        return true;
    }

    @Override
    public void setMesomery(Mesomery mesomery) {
        this.mesomery = mesomery;
    }

    public double computeOverlap(int i2, int j) throws NoElectronException, NoSOMAvailableException, NullOvlMatrixException, UnavailableSOMException, OrbitaleMoleculaireException, HLPOverlapException {
        double norm2;
        Structure Phi1 = i2 == -1 ? this.mesomery.getDelocalizedStructure() : this.mesomery.getSelectedLocalizedStruct(i2);
        Structure Phi2 = j == -1 ? this.mesomery.getDelocalizedStructure() : this.mesomery.getSelectedLocalizedStruct(j);
        double tol = 1.0E-6;
        double norm1 = Math.sqrt(Structure.overlap(Phi1, Phi1));
        if (norm1 * (norm2 = Math.sqrt(Structure.overlap(Phi2, Phi2))) < tol) {
            throw new ArithmeticException(String.valueOf(norm1) + " " + norm2 + " " + "Stop before division by 0 in computeOverlap(" + i2 + "," + j + ")");
        }
        double ovl = Structure.overlap(Phi1, Phi2);
        if (HuckelIO.isverbose()) {
            System.out.println("ovl(" + i2 + "," + j + ")=" + ovl + "/" + norm1 + " * " + norm2 + "SHHH ");
        }
        return ovl / (norm1 * norm2);
    }

    private Mesomery getMesomery() {
        return this.mesomery;
    }

    protected void computeOverlapTab() throws NullOvlMatrixException, NoElectronException, OrbitaleMoleculaireException, HLPOverlapException {
        int nbStruc = this.mesomery.countSelectedLocalizedStructs();
        this.overlapTab = null;
        try {
            this.overlapTab = new double[nbStruc + 1][nbStruc + 1];
            int i2 = -1;
            while (i2 < nbStruc) {
                int j = i2;
                while (j < nbStruc) {
                    double d = this.computeOverlap(i2, j);
                    this.overlapTab[i2 + 1][j + 1] = d;
                    this.overlapTab[j + 1][i2 + 1] = d;
                    ++j;
                }
                ++i2;
            }
        }
        catch (NoElectronException e) {
            HuckelIO.warning(this.getClass().getName(), "computeOverlapTab", e.getMessage(), e);
            this.overlapTab = null;
            throw new NullOvlMatrixException();
        }
        catch (NoSOMAvailableException e) {
            HuckelIO.warning(this.getClass().getName(), "computeOverlapTab", e.getMessage(), e);
            this.overlapTab = null;
            throw new NullOvlMatrixException();
        }
        catch (UnavailableSOMException e) {
            HuckelIO.warning(this.getClass().getName(), "computeOverlapTab", e.getMessage(), e);
            this.overlapTab = null;
            throw new NullOvlMatrixException();
        }
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public IMethodException getError() {
        return this.error;
    }

    public IMethod newInstance() {
        return new HLPMethod();
    }

    protected void updateOverlapTab(int i2, int j, double n) throws NoElectronException, NoSOMAvailableException, NullOvlMatrixException, UnavailableSOMException, OrbitaleMoleculaireException, HLPOverlapException {
        this.getOverlapTabAll()[i2][j] = n;
    }

    @Override
    public void removeInOptimizableMatrix(int i2) {
        try {
            this.computeOverlapTab();
        }
        catch (NullOvlMatrixException e) {
            HuckelIO.warning(this.getClass().getName(), "extendOverlapMatrix", e.getMessage(), e);
            e.printStackTrace();
        }
        catch (NoElectronException e) {
            HuckelIO.warning(this.getClass().getName(), "extendOverlapMatrix", e.getMessage(), e);
        }
        catch (OrbitaleMoleculaireException e) {
            HuckelIO.warning(this.getClass().getName(), "extendOverlapMatrix", e.getMessage(), e);
        }
        catch (HLPOverlapException e) {
            HuckelIO.warning(this.getClass().getName(), "extendOverlapMatrix", e.getMessage(), e);
        }
    }

    @Override
    public void computeOptimizableMatrix(int i2) {
        try {
            this.computeOverlapTab();
        }
        catch (NullOvlMatrixException e) {
            HuckelIO.warning(this.getClass().getName(), "extendOverlapMatrix", e.getMessage(), e);
            e.printStackTrace();
        }
        catch (NoElectronException e) {
            HuckelIO.warning(this.getClass().getName(), "extendOverlapMatrix", e.getMessage(), e);
        }
        catch (OrbitaleMoleculaireException e) {
            HuckelIO.warning(this.getClass().getName(), "extendOverlapMatrix", e.getMessage(), e);
        }
        catch (HLPOverlapException e) {
            HuckelIO.warning(this.getClass().getName(), "extendOverlapMatrix", e.getMessage(), e);
        }
    }

    @Override
    public void extendOptimizableMatrix() {
        try {
            this.computeOverlapTab();
        }
        catch (NullOvlMatrixException e) {
            HuckelIO.warning(this.getClass().getName(), "extendOverlapMatrix", e.getMessage(), e);
            e.printStackTrace();
        }
        catch (NoElectronException e) {
            HuckelIO.warning(this.getClass().getName(), "extendOverlapMatrix", e.getMessage(), e);
        }
        catch (OrbitaleMoleculaireException e) {
            HuckelIO.warning(this.getClass().getName(), "extendOverlapMatrix", e.getMessage(), e);
        }
        catch (HLPOverlapException e) {
            HuckelIO.warning(this.getClass().getName(), "extendOverlapMatrix", e.getMessage(), e);
        }
    }

    @Override
    public void computeAllOptimizableMatrix() {
        try {
            this.computeOverlapTab();
        }
        catch (NullOvlMatrixException e) {
            HuckelIO.warning(this.getClass().getName(), "extendOverlapMatrix", e.getMessage(), e);
            e.printStackTrace();
        }
        catch (NoElectronException e) {
            HuckelIO.warning(this.getClass().getName(), "extendOverlapMatrix", e.getMessage(), e);
        }
        catch (OrbitaleMoleculaireException e) {
            HuckelIO.warning(this.getClass().getName(), "extendOverlapMatrix", e.getMessage(), e);
        }
        catch (HLPOverlapException e) {
            HuckelIO.warning(this.getClass().getName(), "extendOverlapMatrix", e.getMessage(), e);
        }
    }

    private void removeOverlapAllHLP(int i2) {
        int col;
        if (i2 == -1) {
            return;
        }
        int nbStruct = this.mesomery.countSelectedLocalizedStructs();
        double[][] overlapTab = new double[nbStruct - 1][nbStruct - 1];
        double[][] hlpOverTabAll = null;
        try {
            hlpOverTabAll = this.getOverlapTabAll();
            int lig = 0;
            while (lig < nbStruct) {
                col = 0;
                while (col < nbStruct) {
                    System.out.print(String.valueOf(hlpOverTabAll[col][lig]) + " ");
                    ++col;
                }
                System.out.println();
                ++lig;
            }
            System.out.println();
            System.out.println();
        }
        catch (NoElectronException e) {
            HuckelIO.warning(this.getClass().getName(), "removeOverlapAllHLP", e.getMessage(), e);
            e.printStackTrace();
        }
        catch (NullOvlMatrixException e) {
            HuckelIO.warning(this.getClass().getName(), "removeOverlapAllHLP", e.getMessage(), e);
            e.printStackTrace();
        }
        catch (OrbitaleMoleculaireException e) {
            HuckelIO.warning(this.getClass().getName(), "removeOverlapAllHLP", e.getMessage(), e);
            e.printStackTrace();
        }
        catch (HLPOverlapException e) {
            HuckelIO.warning(this.getClass().getName(), "removeOverlapAllHLP", e.getMessage(), e);
            e.printStackTrace();
        }
        if (hlpOverTabAll == null) {
            return;
        }
        int lig = 0;
        while (lig < nbStruct) {
            col = 0;
            while (col < nbStruct) {
                int colToCopy = col < i2 ? col : col - 1;
                int ligToCopy = lig < i2 ? lig : lig - 1;
                overlapTab[col][lig] = hlpOverTabAll[colToCopy][ligToCopy];
                System.out.print(String.valueOf(overlapTab[col][lig]) + " ");
                ++col;
            }
            System.out.println();
            ++lig;
        }
        this.overlapTab = overlapTab;
    }

    @Override
    public boolean checkOptimizableMatrix() {
        return true;
    }

    @Override
    public ArrayList<IMethodWarning> getWarnings() {
        return this.warnings;
    }
}

