/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.huckel.methods;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import org.ctom.hulis.huckel.Input;
import org.ctom.hulis.huckel.exception.LowdinException;
import org.ctom.hulis.util.io.HuckelIO;

public class Lowdin
extends Input {
    private Matrix Hamiltonien;
    private Matrix hamiltonien_modifie;
    private Matrix matE;
    private String Nom;
    private Matrix Overlap;
    private int size;
    private Matrix sMinusHalf;
    private EigenvalueDecomposition solution;
    private Matrix sPlusHalf;
    private double[] valeursPropresI;
    private double[] valeursPropresR;
    private Matrix vecteursPropresHinitial;
    private Matrix vecteursPropresHmodifie;
    private Matrix vecteursPropresOverlap;

    public Lowdin(Matrix MatriceH, Matrix MatriceS, String nom) throws LowdinException {
        this.Hamiltonien = MatriceH;
        this.size = this.Hamiltonien.getColumnDimension();
        this.Overlap = Matrix.identity(this.size, this.size);
        HuckelIO.PrintIf("size S:" + this.size + " H: " + this.Hamiltonien.getColumnDimension() + "\n");
        this.Nom = nom;
        this.solve();
    }

    public Matrix getHamiltonien() {
        return this.Hamiltonien;
    }

    public Matrix getHamiltonien_modifie() {
        return this.hamiltonien_modifie;
    }

    public Matrix getMatE() {
        return this.matE;
    }

    public String getNom() {
        return this.Nom;
    }

    public Matrix getOverlap() {
        return this.Overlap;
    }

    public int getSize() {
        return this.size;
    }

    public Matrix getSMinusHalf() {
        return this.sMinusHalf;
    }

    public EigenvalueDecomposition getSolution() {
        return this.solution;
    }

    public Matrix getSPlusHalf() {
        return this.sPlusHalf;
    }

    public double[] getValeursPropresI() {
        return this.valeursPropresI;
    }

    public double[] getValeursPropresR() {
        return this.valeursPropresR;
    }

    public Matrix getVecteursPropresHinitial() {
        return this.vecteursPropresHinitial;
    }

    public Matrix getVecteursPropresHmodifie() {
        return this.vecteursPropresHmodifie;
    }

    public Matrix getVecteursPropresOverlap() {
        return this.vecteursPropresOverlap;
    }

    private void solve() throws LowdinException {
        this.solution = new EigenvalueDecomposition(this.Overlap);
        this.valeursPropresR = this.solution.getRealEigenvalues();
        this.valeursPropresI = this.solution.getImagEigenvalues();
        this.vecteursPropresOverlap = this.solution.getV();
        int iVal = 0;
        while (iVal < this.size) {
            if (this.valeursPropresR[iVal] == 0.0) {
                throw new LowdinException("Redundancy in the basis!!");
            }
            ++iVal;
        }
        this.sPlusHalf = new Matrix(this.size, this.size);
        this.sMinusHalf = new Matrix(this.size, this.size);
        int i2 = 0;
        while (i2 < this.size) {
            this.sPlusHalf.set(i2, i2, Math.pow(this.valeursPropresR[i2], 0.5));
            this.sMinusHalf.set(i2, i2, Math.pow(this.valeursPropresR[i2], -0.5));
            ++i2;
        }
        this.sPlusHalf = this.vecteursPropresOverlap.times(this.sPlusHalf.times(this.vecteursPropresOverlap.transpose()));
        this.sMinusHalf = this.vecteursPropresOverlap.times(this.sMinusHalf.times(this.vecteursPropresOverlap.transpose()));
        Matrix tmp = this.Hamiltonien.times(this.sMinusHalf);
        this.hamiltonien_modifie = this.sMinusHalf.times(tmp);
        this.solution = new EigenvalueDecomposition(this.hamiltonien_modifie);
        this.valeursPropresR = this.solution.getRealEigenvalues();
        this.valeursPropresI = this.solution.getImagEigenvalues();
        this.vecteursPropresHmodifie = this.solution.getV();
        this.vecteursPropresHinitial = this.sMinusHalf.times(this.vecteursPropresHmodifie);
        this.matE = new Matrix(this.size, this.size);
        int i3 = 0;
        while (i3 < this.size) {
            this.matE.set(i3, i3, this.valeursPropresR[i3]);
            ++i3;
        }
    }
}

