/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.huckel.methods;

import Jama.Matrix;
import flanagan.math.Minimisation;
import flanagan.math.MinimisationFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.exception.IMethodException;
import org.ctom.hulis.huckel.methods.IMethod;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import org.ctom.hulis.huckel.warning.IMethodWarning;
import org.ctom.hulis.util.io.HuckelIO;
import org.ctom.util.common.Arrays;

public class NRTMethod
implements Cloneable,
IMethod,
Serializable {
    private static final long serialVersionUID = 6363018023821850481L;
    private static final double THRS = 1.0E-8;
    private double[] ciCoeff;
    private double[] ciWeights;
    private Mesomery mesomery;
    private final String name = "NRT";
    private Fonction NRTfonction = new Fonction();
    private double delta0;
    private NRTComputeMode Mode = NRTComputeMode.NONE;
    Matrix matTrue;
    Matrix[] matLoc;
    double[] weights;
    int nMatLoc;
    int nBas;
    IMethodException error;

    public NRTMethod(NRTMethod method) {
        this.mesomery = method.getMesomery();
        this.ciCoeff = Arrays.arrayCopy(method.ciCoeff);
        this.ciWeights = Arrays.arrayCopy(method.ciWeights);
        this.error = method.error;
    }

    public NRTMethod() {
        this.ciCoeff = new double[0];
        this.ciWeights = new double[0];
        this.error = null;
    }

    @Override
    public void calculate() throws IMethodException {
        if (this.mesomery.countLocalizedStructs() == 0) {
            return;
        }
        List<StructureLocalized> selectedLocalizedStructures = this.mesomery.getSelectedLocalizedStructures();
        this.nMatLoc = selectedLocalizedStructures.size();
        this.matLoc = new Matrix[this.nMatLoc];
        this.matTrue = this.mesomery.getDelocalizedStructure().getRestrictedDensityMatrix();
        this.nBas = this.matTrue.getColumnDimension();
        HuckelIO.PrintIf("Matrice densite delocalisee:");
        this.matTrue.print(10, 5);
        int i2 = 0;
        while (i2 < this.nMatLoc) {
            this.matLoc[i2] = this.mesomery.getLocalizedStruct(i2).getRestrictedDensityMatrix();
            HuckelIO.PrintIf("Matrice loc " + i2);
            this.matLoc[i2].print(10, 5);
            ++i2;
        }
        this.calculateDelta0();
        this.calculateNRT();
    }

    private void calculateNRT() {
        Fonction fonction;
        this.setMode(NRTComputeMode.NRT);
        Minimisation minimisation = new Minimisation();
        this.NRTfonction = fonction = new Fonction();
        fonction.setSystem(this.nBas, this.nMatLoc, this.matTrue, this.matLoc);
        double[] tab = new double[this.nMatLoc];
        double[] steps = new double[this.nMatLoc];
        int[] pIndices = new int[this.nMatLoc];
        int[] plusOrMinus = new int[this.nMatLoc];
        int i2 = 0;
        while (i2 < this.nMatLoc) {
            pIndices[i2] = i2;
            steps[i2] = 0.001;
            plusOrMinus[i2] = 1;
            if (i2 == 0) {
                tab[0] = 1.0 / (double)this.nMatLoc;
                steps[i2] = -0.1;
            } else {
                tab[i2] = 1.0 / (double)this.nMatLoc;
                steps[i2] = 0.1;
            }
            minimisation.addConstraint(i2, 1, 1.0);
            minimisation.addConstraint(i2, -1, 0.0);
            ++i2;
        }
        minimisation.addConstraint(pIndices, plusOrMinus, 1, 1.0);
        minimisation.setNmax(10000);
        minimisation.nelderMead((MinimisationFunction)fonction, tab, steps, 1.0E-8);
        this.weights = minimisation.getParamValues();
        int n = this.mesomery.countSelectedLocalizedStructs();
        int i3 = 0;
        while (i3 < n) {
            StructureLocalized struct = this.mesomery.getSelectedLocalizedStruct(i3);
            struct.setWeight(this.getName(), this.getWeights()[i3]);
            ++i3;
        }
        this.setMode(NRTComputeMode.NONE);
    }

    private void setMode(NRTComputeMode mode) {
        this.Mode = mode;
    }

    private double calculateDelta0() {
        this.setMode(NRTComputeMode.DELTA0);
        double omega = Double.MIN_VALUE;
        int iLoc = -1;
        int i2 = 0;
        while (i2 < this.matLoc.length) {
            Minimisation minimisation = new Minimisation();
            Fonction fonction = new Fonction();
            Matrix[] rhoLoc = new Matrix[]{this.matLoc[i2]};
            fonction.setSystem(this.nBas, 1, this.matTrue, rhoLoc);
            double[] tab = new double[1];
            double[] steps = new double[]{0.001};
            tab[0] = 1.0;
            minimisation.addConstraint(0, 1, 1.0);
            minimisation.addConstraint(0, -1, 0.0);
            minimisation.setNmax(10000);
            minimisation.nelderMead((MinimisationFunction)fonction, tab, steps, 1.0E-8);
            double w = minimisation.getParamValues()[0];
            if (w > omega) {
                iLoc = i2;
                omega = w;
            }
            ++i2;
        }
        Matrix mat = this.matLoc[iLoc].minus(this.matTrue);
        mat = mat.times(mat);
        this.delta0 = Math.sqrt(mat.trace());
        this.setMode(NRTComputeMode.NONE);
        return this.delta0;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public double[] getCI() {
        return null;
    }

    @Override
    public double[][] getHamiltonian() {
        return null;
    }

    @Override
    public boolean isImplementedHamiltonian() {
        return false;
    }

    @Override
    public String getName() {
        return "NRT";
    }

    @Override
    public double getTau() {
        return 1.0 - this.NRTfonction.getResidual();
    }

    @Override
    public double[] getWeights() {
        return this.weights;
    }

    @Override
    public boolean isImplementedTau() {
        return true;
    }

    @Override
    public void setMesomery(Mesomery mesomery) {
        this.mesomery = mesomery;
    }

    @Override
    public IMethodException getError() {
        return null;
    }

    @Override
    public Object clone() {
        return new NRTMethod(this);
    }

    private Mesomery getMesomery() {
        return this.mesomery;
    }

    public IMethod newInstance() {
        return new NRTMethod();
    }

    @Override
    public ArrayList<IMethodWarning> getWarnings() {
        return null;
    }

    private class Fonction
    implements MinimisationFunction,
    Serializable {
        int nBas;
        int nMatLoc;
        Matrix matTrue;
        Matrix[] matLoc;
        private double residual = Double.NaN;

        private Fonction() {
        }

        public double getResidual() {
            return this.residual;
        }

        @Override
        public double function(double[] vec) {
            Matrix somme = new Matrix(this.nBas, this.nBas, 0.0);
            HuckelIO.isverbose();
            int iMat = 0;
            while (iMat < this.nMatLoc) {
                somme.plusEquals(this.matLoc[iMat].times(vec[iMat]));
                if (HuckelIO.isverbose()) {
                    System.out.printf("%f ", vec[iMat]);
                }
                ++iMat;
            }
            Matrix mat = somme.minus(this.matTrue);
            mat = mat.times(mat);
            this.residual = somme.minus(this.matTrue).normF() / this.matTrue.trace();
            if (HuckelIO.isverbose()) {
                System.out.printf("Normes somme %f ref %f residu:%f\n", somme.normF(), this.matTrue.normF(), this.residual);
            }
            return this.getResidual();
        }

        public void setSystem(int nBas, int nMatLoc, Matrix matTrue, Matrix[] matLoc) {
            this.nBas = nBas;
            this.nMatLoc = nMatLoc;
            this.matTrue = matTrue;
            this.matLoc = matLoc;
        }
    }

    static enum NRTComputeMode {
        NONE,
        DELTA0,
        NRT;

    }
}

