/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.huckel.selectors;

import java.io.Serializable;
import java.util.List;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.selectors.IStructuresSelector;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import org.ctom.util.maths.Maths;

public class MesomeryEnergyStructuresSelector
implements IStructuresSelector,
Cloneable,
Serializable {
    private static final long serialVersionUID = -173683615706926362L;
    private Mesomery mesomery;
    double energyMax;

    public MesomeryEnergyStructuresSelector() {
        this.mesomery = null;
        this.energyMax = 0.0;
    }

    public MesomeryEnergyStructuresSelector(MesomeryEnergyStructuresSelector mesomeryEnergyStructuresSelector) {
        this.energyMax = mesomeryEnergyStructuresSelector.energyMax;
    }

    @Override
    public Object clone() {
        return new MesomeryEnergyStructuresSelector(this);
    }

    @Override
    public void setSelectionTreshold(Object o) {
        this.energyMax = (Double)o;
    }

    @Override
    public void selectStructures() {
        this.mesomery.clearListSelectedStructures();
        int i2 = 0;
        while (i2 < this.mesomery.countAllSructs()) {
            Structure struct = this.mesomery.getAllStructures().get(i2);
            if (Maths.round(struct.getTotalEnergy().getBeta(), this.mesomery.getPrecision()) >= Maths.round(this.energyMax, this.mesomery.getPrecision())) {
                this.mesomery.addSelectedStructure(struct);
            }
            if (struct instanceof StructureLocalized) {
                struct.setName(Integer.toString(i2));
            }
            ++i2;
        }
    }

    @Override
    public void setMesomery(Mesomery mesomery) {
        this.mesomery = mesomery;
    }

    @Override
    public Object getSelectionTreshold() {
        return this.energyMax;
    }

    @Override
    public boolean isCurrentValueLowerThanTreshold(Structure s) {
        return Math.abs((Double)this.getCurrentValue(s)) <= Math.abs(this.energyMax);
    }

    @Override
    public void setTresholdValueWhenNoStructure() {
        this.energyMax = 0.0;
    }

    @Override
    public Object getCurrentValue(Structure s) {
        return s.getTotalEnergy().getBeta();
    }

    @Override
    public void setTresholdToLocalizedStructureMinimalValue() {
        double beta = 0.0;
        double e = 0.0;
        List<StructureLocalized> locstructures = this.mesomery.getLocalizedStructures();
        int i2 = 0;
        while (i2 < this.mesomery.countLocalizedStructs()) {
            StructureLocalized struct = locstructures.get(i2);
            e = struct.getTotalEnergy().getBeta();
            if (Maths.round(e, this.mesomery.getPrecision()) > beta) {
                beta = e;
            }
            ++i2;
        }
        this.energyMax = beta;
    }

    @Override
    public Object getMaximalValue() {
        double energy = this.mesomery.getDelocalizedStructure().getTotalEnergy().getBeta();
        for (Structure s : this.mesomery.getAllStructures()) {
            if (!(s.getTotalEnergy().getBeta() < energy)) continue;
            energy = s.getTotalEnergy().getBeta();
        }
        return -energy;
    }
}

