/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.huckel.selectors;

import java.io.Serializable;
import java.util.List;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.selectors.IStructuresSelector;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import org.ctom.util.maths.Maths;

public class MesomeryHLPOverlapStructuresSelector
implements IStructuresSelector,
Cloneable,
Serializable {
    private static final long serialVersionUID = 2672586164032318807L;
    private Mesomery mesomery;
    private double overlapValue;

    public MesomeryHLPOverlapStructuresSelector() {
        this.mesomery = null;
        this.overlapValue = 1.0;
    }

    public MesomeryHLPOverlapStructuresSelector(MesomeryHLPOverlapStructuresSelector mesomeryEnergyStructuresSelector) {
        this.overlapValue = mesomeryEnergyStructuresSelector.overlapValue;
    }

    @Override
    public Object clone() {
        return new MesomeryHLPOverlapStructuresSelector(this);
    }

    @Override
    public void setSelectionTreshold(Object o) {
        this.overlapValue = (Double)o;
    }

    @Override
    public void selectStructures() {
        Structure struct;
        boolean j = false;
        this.mesomery.clearListSelectedStructures();
        int i2 = 0;
        while (i2 < this.mesomery.countAllSructs()) {
            struct = this.mesomery.getAllStructures().get(i2);
            if (Math.abs(Maths.round(struct.getOverlapHLP(), this.mesomery.getPrecision())) >= Math.abs(Maths.round(this.overlapValue, this.mesomery.getPrecision()))) {
                this.mesomery.addSelectedStructure(struct);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.mesomery.countAllSructs()) {
            struct = this.mesomery.getAllStructures().get(i2);
            if (struct instanceof StructureLocalized) {
                struct.setName(Integer.toString(i2));
            }
            ++i2;
        }
    }

    @Override
    public void setMesomery(Mesomery mesomery) {
        this.mesomery = mesomery;
    }

    @Override
    public Object getSelectionTreshold() {
        return this.overlapValue;
    }

    @Override
    public boolean isCurrentValueLowerThanTreshold(Structure s) {
        return Math.abs((Double)this.getCurrentValue(s)) <= Math.abs(this.overlapValue);
    }

    @Override
    public void setTresholdValueWhenNoStructure() {
        this.overlapValue = 0.0;
    }

    @Override
    public Object getCurrentValue(Structure s) {
        return s.getOverlapHLP();
    }

    @Override
    public void setTresholdToLocalizedStructureMinimalValue() {
        double maxOverlap = 0.0;
        double overlap = 0.0;
        List<StructureLocalized> locstructures = this.mesomery.getLocalizedStructures();
        int i2 = 0;
        while (i2 < this.mesomery.countLocalizedStructs()) {
            StructureLocalized struct = locstructures.get(i2);
            overlap = struct.getOverlapHLP();
            if (Maths.round(overlap, this.mesomery.getPrecision()) > maxOverlap) {
                maxOverlap = overlap;
            }
            ++i2;
        }
        this.overlapValue = maxOverlap;
    }

    @Override
    public Object getMaximalValue() {
        if (this.mesomery.getSelectedLocalizedStructures().size() == 0) {
            return 0.0;
        }
        double hlpOverlap = Math.abs(this.mesomery.getSelectedLocalizedStructures().get(0).getOverlapHLP());
        for (Structure structure : this.mesomery.getSelectedLocalizedStructures()) {
            if (!(Math.abs(structure.getOverlapHLP()) < hlpOverlap)) continue;
            hlpOverlap = Math.abs(structure.getOverlapHLP());
        }
        return -hlpOverlap;
    }
}

