/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.huckel.spectrum;

import java.text.NumberFormat;
import javax.swing.JFrame;
import org.ctom.hulis.huckel.structures.Structure;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYSplineRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class DensityOfStates {
    private double deltaE = 0.5;
    private double energyMIN;
    private double energyMAX;
    private double[] dos;
    private JFrame plotFrame;
    private XYSeries xydata;
    private Structure structure;

    public double[] getDos() {
        return this.dos;
    }

    public DensityOfStates(Structure struct) {
        this.structure = struct;
        this.update(struct);
    }

    private void update(Structure struct) {
        this.setValues(struct.getEnergiesArray());
    }

    public void update() {
        this.update(this.getStructure());
    }

    private Structure getStructure() {
        return this.structure;
    }

    private void setValues(double[] energiesArray) {
        double[] dArray = energiesArray;
        int n = energiesArray.length;
        int n2 = 0;
        while (n2 < n) {
            double e = dArray[n2];
            this.energyMIN = Math.min(this.energyMIN, e);
            this.energyMAX = Math.max(this.energyMAX, e);
            ++n2;
        }
        int nInterval = (int)Math.floor((this.energyMAX - this.energyMIN) / this.deltaE) + 1;
        this.dos = new double[nInterval];
        double[] dArray2 = energiesArray;
        int n3 = energiesArray.length;
        n = 0;
        while (n < n3) {
            int num;
            double e = dArray2[n];
            int n4 = num = (int)Math.floor((e - this.energyMIN) / this.deltaE);
            this.dos[n4] = this.dos[n4] + 1.0;
            ++n;
        }
        this.updatePlot();
    }

    private void updatePlot() {
        if (this.plotFrame == null) {
            this.plot();
        } else {
            this.setData();
        }
    }

    private void plot() {
        this.plotFrame = new JFrame("Plot");
        this.setplotframe(this.plotFrame);
        this.plotFrame.pack();
        this.plotFrame.setVisible(true);
    }

    private void setplotframe(JFrame plotFrame) {
        XYSeriesCollection xyDataset = new XYSeriesCollection();
        this.xydata = new XYSeries((Comparable)((Object)"DOS values"));
        this.setData();
        xyDataset.addSeries(this.xydata);
        NumberAxis xaxis = new NumberAxis("x:E");
        NumberAxis yaxis = new NumberAxis("y:DOS");
        StandardXYToolTipGenerator ttg = new StandardXYToolTipGenerator("({1} ; {2})", NumberFormat.getInstance(), NumberFormat.getInstance());
        XYSplineRenderer renderer = new XYSplineRenderer();
        XYPlot plot = new XYPlot(xyDataset, xaxis, yaxis, renderer);
        ChartPanel chartpanel = new ChartPanel(new JFreeChart("DOS", plot));
        plotFrame.add(chartpanel);
    }

    private void setData() {
        this.xydata.clear();
        int i2 = 0;
        while (i2 < this.dos.length) {
            this.xydata.add((double)i2, this.dos[i2]);
            ++i2;
        }
    }
}

