/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.huckel.structures;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.io.Serializable;
import java.util.ArrayList;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.Energy;
import org.ctom.hulis.huckel.IDebuggable;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.Molecule;
import org.ctom.hulis.huckel.MonoExcitation;
import org.ctom.hulis.huckel.NatOrbitaleMoleculaire;
import org.ctom.hulis.huckel.Spin;
import org.ctom.hulis.huckel.SpinOrbitaleMoleculaire;
import org.ctom.hulis.huckel.events.HuckelAtomEvent;
import org.ctom.hulis.huckel.events.HuckelBondEvent;
import org.ctom.hulis.huckel.events.MonoExcitationEvent;
import org.ctom.hulis.huckel.events.StructureEvent;
import org.ctom.hulis.huckel.exception.BondException;
import org.ctom.hulis.huckel.exception.HLPOverlapException;
import org.ctom.hulis.huckel.exception.HuckelBondException;
import org.ctom.hulis.huckel.exception.HulisException;
import org.ctom.hulis.huckel.exception.MoleculeBondExistsException;
import org.ctom.hulis.huckel.exception.MoleculeCoherenceException;
import org.ctom.hulis.huckel.exception.MoleculeTooManyNeighboursException;
import org.ctom.hulis.huckel.exception.NoElectronException;
import org.ctom.hulis.huckel.exception.NoSOMAvailableException;
import org.ctom.hulis.huckel.exception.NullOvlMatrixException;
import org.ctom.hulis.huckel.exception.OrbitaleMoleculaireException;
import org.ctom.hulis.huckel.exception.UnavailableSOMException;
import org.ctom.hulis.huckel.listeners.IMoleculeValueListener;
import org.ctom.hulis.huckel.listeners.IMonoExcitationListener;
import org.ctom.hulis.huckel.listeners.IStructureListener;
import org.ctom.hulis.huckel.methods.HLPMethod;
import org.ctom.hulis.huckel.spectrum.DensityOfStates;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import org.ctom.hulis.huckel.structures.symmetry.Symmetry;
import org.ctom.hulis.polynomes.CharacteristicPolynomial;
import org.ctom.hulis.prefs.Preferences;
import org.ctom.hulis.util.VectorssHuckel;
import org.ctom.hulis.util.io.HuckelIO;
import org.ctom.util.common.Arrays;

public abstract class Structure
extends Molecule
implements IDebuggable,
Cloneable,
Serializable,
IMonoExcitationListener {
    private static final long serialVersionUID = -3059111279902006401L;
    protected int index;
    protected double[][] bondOrdersArray;
    protected double[] chargeDensitiesArray;
    protected double[] distributionElecPiArray;
    protected double[] energiesArray;
    private SpinOrbitaleMoleculaire[] SOM = null;
    private double[][] hamiltonianArray;
    private boolean isEnabledFlyCalculate;
    protected Mesomery mesomeryParent;
    private ArrayList<MonoExcitation> monoExcitations;
    private String name;
    protected double[][] orbitalsCoeffArray;
    protected double sumOfChargeDensities;
    protected int sumOfDistributedElec;
    protected int sumOfPiElec;
    protected Energy totalEnergy;
    private double overlapHLP;
    private int indexSelection;
    private DensityOfStates dos;
    private Symmetry symmetry;
    private SpinOrbitaleMoleculaire[] occSOMs = null;
    private boolean isCloneResultsCacheWhenCloneStructure;
    private ArrayList<NatOrbitaleMoleculaire> naturalOrbitals = new ArrayList();

    public Structure() {
        this.index = 0;
        this.indexSelection = 0;
        this.isCloneResultsCacheWhenCloneStructure = true;
        this.mesomeryParent = null;
        this.setName("");
        this.totalEnergy = new Energy(0.0, 0.0);
        this.isEnabledFlyCalculate = true;
        this.monoExcitations = new ArrayList();
        this.overlapHLP = 0.0;
    }

    public Structure(Structure structure) {
        super(structure);
        this.setName(structure.getName());
        this.index = structure.index;
        this.indexSelection = structure.indexSelection;
        this.isCloneResultsCacheWhenCloneStructure = structure.isCloneResultsCacheWhenCloneStructure;
        this.mesomeryParent = structure.mesomeryParent;
        this.isEnabledFlyCalculate = structure.isEnabledFlyCalculate;
        this.totalEnergy = (Energy)structure.getTotalEnergy().clone();
        this.overlapHLP = structure.getOverlapHLP();
        this.monoExcitations = (ArrayList)structure.monoExcitations.clone();
        int l = 0;
        if (structure.SOM != null) {
            l = structure.SOM.length;
        }
        this.SOM = new SpinOrbitaleMoleculaire[l];
        int i2 = 0;
        while (i2 < l) {
            this.SOM[i2] = (SpinOrbitaleMoleculaire)structure.getSOM()[i2].clone();
            ++i2;
        }
        i2 = 0;
        while (i2 < l) {
            SpinOrbitaleMoleculaire som = structure.getSOM()[i2];
            SpinOrbitaleMoleculaire.setPartner(this.getSpinOMByIndex(som.getIndex()), this.getSpinOMByIndex(som.getPartner().getIndex()));
            ++i2;
        }
    }

    @Override
    public int hashCode() {
        int multiplier = 23;
        if (this.hashCode == 0) {
            int code = 133;
            code = 23 * code + this.getIndex();
            code = 23 * code + this.getName().hashCode();
            this.hashCode = code = 23 * code + super.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof Structure)) {
            return false;
        }
        Structure s = (Structure)o;
        if (this.getIndex() != s.getIndex()) {
            return false;
        }
        return this.getName().equals(s.getName());
    }

    public boolean isEmpty() {
        return this.countAtoms() == 0;
    }

    public boolean hasDemiElectrons() {
        int i2 = 0;
        while (i2 < this.countSpinOM()) {
            try {
                SpinOrbitaleMoleculaire som = this.getSpinOM(i2);
                if (som.getSpin() == Spin.DEMI_ELECTRON) {
                    return true;
                }
            }
            catch (NoSOMAvailableException | UnavailableSOMException e) {
                e.printStackTrace();
                return false;
            }
            ++i2;
        }
        return false;
    }

    public double getOverlapHLP() {
        return this.overlapHLP;
    }

    public void copyArrays(Structure structure) {
        if (!this.areCorrectAtomsSeqNum() || this.countAtoms() == 0) {
            this.clearDataCache();
            return;
        }
        this.hamiltonianArray = Arrays.arrayCopy(structure.hamiltonianArray);
        this.energiesArray = Arrays.arrayCopy(structure.energiesArray);
        this.orbitalsCoeffArray = Arrays.arrayCopy(structure.orbitalsCoeffArray);
        this.distributionElecPiArray = Arrays.arrayCopy(structure.distributionElecPiArray);
        this.chargeDensitiesArray = Arrays.arrayCopy(structure.chargeDensitiesArray);
        this.sumOfChargeDensities = structure.sumOfChargeDensities;
        this.sumOfDistributedElec = structure.sumOfDistributedElec;
        this.sumOfPiElec = structure.sumOfPiElec;
        this.bondOrdersArray = Arrays.arrayCopy(structure.bondOrdersArray);
    }

    private void clearDataCache() {
        this.hamiltonianArray = null;
        this.energiesArray = null;
        this.orbitalsCoeffArray = null;
        this.chargeDensitiesArray = null;
        this.sumOfChargeDensities = 0.0;
        this.distributionElecPiArray = null;
        this.sumOfDistributedElec = 0;
        this.sumOfPiElec = 0;
        this.bondOrdersArray = null;
        this.SOM = null;
        this.bondOrdersArray = new double[0][0];
        this.chargeDensitiesArray = new double[0];
        this.distributionElecPiArray = new double[0];
        this.energiesArray = new double[0];
        this.hamiltonianArray = new double[0][0];
        this.monoExcitations.clear();
        this.orbitalsCoeffArray = new double[0][0];
        this.occSOMs = null;
    }

    protected abstract void appliqueCouplage() throws NoSOMAvailableException, UnavailableSOMException, OrbitaleMoleculaireException;

    public abstract boolean aUnCouplage();

    protected abstract double[][] calcBondOrdersArray();

    protected abstract double[] calcChargeDensitiesArray();

    protected abstract double[] calcDistributionElecArray();

    protected double calcSumOfChargesDensities() {
        double chargeTotale = 0.0;
        double[] tblCharge = this.chargeDensitiesArray;
        int i2 = 0;
        while (i2 < tblCharge.length) {
            chargeTotale += tblCharge[i2];
            ++i2;
        }
        return chargeTotale;
    }

    protected int calcSumofDistributionElec() {
        double[] repartitionElec = this.distributionElecPiArray;
        int nbElecPi = 0;
        int i2 = 0;
        while (i2 < repartitionElec.length) {
            nbElecPi = (int)((double)nbElecPi + repartitionElec[i2]);
            ++i2;
        }
        return nbElecPi;
    }

    protected abstract int calcSumOfPiElec();

    public void calculate() {
        if (!this.areCorrectAtomsSeqNum() || this.countAtoms() == 0) {
            this.clearDataCache();
            return;
        }
        Matrix hamiltonien = this.getMatrixHamiltonian();
        if (hamiltonien == null) {
            return;
        }
        this.hamiltonianArray = hamiltonien.getArray();
        this.energiesArray = this.calcOrbitalsEnergies();
        this.orbitalsCoeffArray = this.calcOrbitalsCoefficients();
        HuckelIO.PrintMatrix(new Matrix(this.hamiltonianArray), "hamiltonianArray calcul\u00e9");
        HuckelIO.PrintMatrix(new Matrix(this.orbitalsCoeffArray), "orbitalsCoeffArray calcul\u00e9");
        this.distributionElecPiArray = this.calcDistributionElecArray();
        this.chargeDensitiesArray = this.calcChargeDensitiesArray();
        this.sumOfChargeDensities = this.calcSumOfChargesDensities();
        this.sumOfDistributedElec = this.calcSumofDistributionElec();
        this.sumOfPiElec = this.calcSumOfPiElec();
        this.bondOrdersArray = this.calcBondOrdersArray();
        this.totalEnergy.set(this.getTotalEnergyAlpha(), this.getTotalEnergyBeta());
        this.computeNaturalOrbitals();
        try {
            this.generateSpinOM();
        }
        catch (NoElectronException e) {
            e.printStackTrace();
            HuckelIO.error(this.getClass().getName(), "calculate", "NoElectronException thrown");
        }
        catch (NoSOMAvailableException e) {
            e.printStackTrace();
        }
        catch (UnavailableSOMException e) {
            e.printStackTrace();
        }
        this.calculateOverlapHLP();
    }

    protected abstract double[][] calcOrbitalsCoefficients();

    protected abstract double[] calcOrbitalsEnergies();

    public void calculateOverlapHLP() {
        if (this.getMesomeryParent() != null) {
            try {
                HLPMethod hlpMethod = new HLPMethod();
                hlpMethod.setMesomery(this.getMesomeryParent());
                if (this.getIndex() < 1) {
                    return;
                }
                if (this.getIndex() == 1) {
                    this.overlapHLP = 1.0;
                    return;
                }
                this.overlapHLP = hlpMethod.computeOverlap(-1, this.getIndex() - 2);
                if (HuckelIO.isverbose()) {
                    System.out.println("Psi" + this.getName() + " - overlap =" + this.overlapHLP);
                }
            }
            catch (NoElectronException e1) {
                e1.printStackTrace();
            }
            catch (NoSOMAvailableException e1) {
                e1.printStackTrace();
            }
            catch (NullOvlMatrixException e1) {
                e1.printStackTrace();
            }
            catch (UnavailableSOMException e1) {
                e1.printStackTrace();
            }
            catch (OrbitaleMoleculaireException e1) {
                e1.printStackTrace();
            }
            catch (HLPOverlapException e1) {
                e1.printStackTrace();
            }
            catch (Exception e1) {
                HuckelIO.warning(this.getClass().getName(), "calculateOverlapHLP", "cannot compute overlap PSITOT|PSI" + this.getName() + " : index PSITOT = -1 et index PSI" + this.getName() + " = " + (this.getIndex() - 2));
                e1.printStackTrace();
            }
        }
    }

    @Override
    public void debug() {
        int j;
        HuckelIO.PrintIf("***** Structure ****** ");
        HuckelIO.PrintIf("name : " + this.name);
        super.debug();
        HuckelIO.PrintIf("***** STATS *****");
        HuckelIO.PrintIf("Hamiltonian : ");
        if (this.hamiltonianArray == null) {
            HuckelIO.PrintIf("NULL :");
            return;
        }
        int i2 = 0;
        while (i2 < this.hamiltonianArray.length) {
            j = 0;
            while (j < this.hamiltonianArray[i2].length) {
                HuckelIO.PrintIf(String.valueOf(this.hamiltonianArray[i2][j]) + " ");
                ++j;
            }
            HuckelIO.PrintIf("\n ");
            ++i2;
        }
        HuckelIO.PrintIf("\n ");
        HuckelIO.PrintIf("Energies : ");
        i2 = 0;
        while (i2 < this.energiesArray.length) {
            HuckelIO.PrintIf(String.valueOf(this.energiesArray[i2]) + " ");
            ++i2;
        }
        HuckelIO.PrintIf("\n ");
        HuckelIO.PrintIf("\n ");
        HuckelIO.PrintIf("Orbitals : ");
        i2 = 0;
        while (i2 < this.orbitalsCoeffArray.length) {
            j = 0;
            while (j < this.orbitalsCoeffArray[i2].length) {
                HuckelIO.PrintIf(String.valueOf(this.orbitalsCoeffArray[i2][j]) + " ");
                ++j;
            }
            HuckelIO.PrintIf("\n ");
            ++i2;
        }
        HuckelIO.PrintIf("\n ");
        HuckelIO.PrintIf("Distribution Elec Pi : ");
        i2 = 0;
        while (i2 < this.distributionElecPiArray.length) {
            HuckelIO.PrintIf(String.valueOf(this.distributionElecPiArray[i2]) + " ");
            ++i2;
        }
        HuckelIO.PrintIf("\n ");
        HuckelIO.PrintIf("\n ");
        System.out.println("sum of Pi electrons : " + this.sumOfDistributedElec);
        HuckelIO.PrintIf("total Energy : " + this.totalEnergy.getAlpha() + "alpha" + this.totalEnergy.getBeta() + "beta");
        HuckelIO.PrintIf("\n ");
        HuckelIO.PrintIf("Bond Order matrix : ");
        i2 = 0;
        while (i2 < this.bondOrdersArray.length) {
            j = 0;
            while (j < this.bondOrdersArray[i2].length) {
                HuckelIO.PrintIf(String.valueOf(this.bondOrdersArray[i2][j]) + " ");
                ++j;
            }
            HuckelIO.PrintIf("\n ");
            ++i2;
        }
        HuckelIO.PrintIf("\n ");
        HuckelIO.PrintIf("Charge Densities: ");
        i2 = 0;
        while (i2 < this.chargeDensitiesArray.length) {
            HuckelIO.PrintIf(this.chargeDensitiesArray[i2]);
            ++i2;
        }
        HuckelIO.PrintIf("\n ");
        HuckelIO.PrintIf("sum of Pi charge densities : " + this.sumOfChargeDensities);
    }

    @Override
    public void clear(boolean notify) {
        this.stopFlyCalculate();
        this.clearDataCache();
        super.clear(notify);
        this.startFlyCalculate();
    }

    @Override
    public void delete(boolean notify) {
        this.stopFlyCalculate();
        this.clearDataCache();
        super.delete(notify);
        this.SOM = null;
    }

    public int getIndex() {
        return this.index;
    }

    public int getIndexSelection() {
        return this.indexSelection;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setIndexSelection(int indexSelection) {
        this.indexSelection = indexSelection;
    }

    protected void generateSpinOM() throws NoElectronException, NoSOMAvailableException, UnavailableSOMException {
        double[] electronDistrib = this.getDistributionElecPiArray();
        if (electronDistrib == null) {
            return;
        }
        this.occSOMs = null;
        int nAt = this.countHuckelAtoms();
        int nSOM = 2 * nAt;
        this.SOM = new SpinOrbitaleMoleculaire[nSOM];
        int iSOM = 0;
        int idx = 0;
        boolean oneSingleElectron = false;
        int i2 = 0;
        while (i2 < electronDistrib.length) {
            SpinOrbitaleMoleculaire somA = null;
            SpinOrbitaleMoleculaire somB = null;
            if (electronDistrib[i2] % 1.0 == 0.0) {
                switch ((int)electronDistrib[i2]) {
                    case 2: {
                        somA = new SpinOrbitaleMoleculaire(new Energy(1.0, this.energiesArray[i2]), this.getOM(i2), Spin.ALPHA);
                        somA.setIndex(idx);
                        somB = new SpinOrbitaleMoleculaire(new Energy(1.0, this.energiesArray[i2]), this.getOM(i2), Spin.BETA);
                        somB.setIndex(++idx);
                        ++idx;
                        break;
                    }
                    case 1: {
                        if (!oneSingleElectron || this instanceof StructureLocalized) {
                            somA = new SpinOrbitaleMoleculaire(new Energy(1.0, this.energiesArray[i2]), this.getOM(i2), Spin.ALPHA);
                            somA.setIndex(idx);
                            somB = new SpinOrbitaleMoleculaire(new Energy(1.0, this.energiesArray[i2]), this.getOM(i2), Spin.NOSPIN_BETA);
                            somB.setIndex(++idx);
                            ++idx;
                            oneSingleElectron = true;
                            break;
                        }
                        somA = new SpinOrbitaleMoleculaire(new Energy(1.0, this.energiesArray[i2]), this.getOM(i2), Spin.NOSPIN_ALPHA);
                        somA.setIndex(idx);
                        somB = new SpinOrbitaleMoleculaire(new Energy(1.0, this.energiesArray[i2]), this.getOM(i2), Spin.BETA);
                        somB.setIndex(++idx);
                        ++idx;
                        break;
                    }
                    default: {
                        somA = new SpinOrbitaleMoleculaire(new Energy(1.0, this.energiesArray[i2]), this.getOM(i2), Spin.NOSPIN_ALPHA);
                        somA.setIndex(idx);
                        somB = new SpinOrbitaleMoleculaire(new Energy(1.0, this.energiesArray[i2]), this.getOM(i2), Spin.NOSPIN_BETA);
                        somB.setIndex(++idx);
                        ++idx;
                        break;
                    }
                }
            } else {
                somA = new SpinOrbitaleMoleculaire(new Energy(1.0, this.energiesArray[i2]), this.getOM(i2), Spin.DEMI_ELECTRON);
                somA.setIndex(idx);
                somB = new SpinOrbitaleMoleculaire(new Energy(1.0, this.energiesArray[i2]), this.getOM(i2), Spin.NO_DEMI_ELECTRON);
                somB.setIndex(++idx);
                ++idx;
            }
            somA.setNbElectrons(electronDistrib[i2]);
            somB.setNbElectrons(0.0);
            somA.setIndexTableOrbitale(i2);
            somB.setIndexTableOrbitale(i2);
            SpinOrbitaleMoleculaire.setPartner(somA, somB);
            this.getSOM()[iSOM++] = somA;
            this.getSOM()[iSOM++] = somB;
            ++i2;
        }
        this.getOccSOM();
    }

    public int countSpinOM() {
        SpinOrbitaleMoleculaire[] som = this.getSOM();
        if (som == null) {
            return 0;
        }
        return som.length;
    }

    public double[][] getBondOrdersArray() {
        return this.bondOrdersArray;
    }

    public double[] getChargeDensitiesArray() {
        return this.chargeDensitiesArray;
    }

    protected abstract int[] getCouplage();

    public double[] getDistributionElecPiArray() {
        return this.distributionElecPiArray;
    }

    @Deprecated
    public Matrix getDmat() throws HulisException {
        int nSO = this.getnSO();
        int nOA = this.getnOA();
        Matrix Dmat = new Matrix(nOA, nOA);
        this.generateSpinOM();
        int mu = 0;
        while (mu < nOA) {
            int nu = 0;
            while (nu < nOA) {
                double somme = 0.0;
                int iSO = 0;
                while (iSO < nSO) {
                    somme += this.getSpinOM(iSO).getCoeff(mu) * this.getSpinOM(iSO).getCoeff(nu);
                    ++iSO;
                }
                Dmat.set(mu, nu, somme);
                ++nu;
            }
            ++mu;
        }
        return Dmat;
    }

    public Matrix getRestrictedDensityMatrix() {
        Matrix d = new Matrix(this.getBondOrdersArray());
        return d;
    }

    public double[] getEnergiesArray() {
        return this.energiesArray;
    }

    public double[][] getHamiltonianArray() {
        return this.hamiltonianArray;
    }

    protected abstract Matrix getMatrixHamiltonian();

    public Mesomery getMesomeryParent() {
        return this.mesomeryParent;
    }

    public ArrayList<MonoExcitation> getMonoExcitations() {
        return this.monoExcitations;
    }

    public String getName() {
        return this.name;
    }

    private int getnOA() {
        return this.countHuckelAtoms();
    }

    protected int getnSO() {
        if (this.SOM == null) {
            return 0;
        }
        return this.SOM.length;
    }

    protected int getnOccSO() throws NoSOMAvailableException, UnavailableSOMException {
        return this.getOccSOM().length;
    }

    private double[] getOM(int iOM) {
        double[][] coeffOM = this.getOrbitalsCoefficients();
        int size = this.countHuckelAtoms();
        double[] OM = new double[size];
        int iOA = 0;
        while (iOA < size) {
            OM[iOA] = coeffOM[iOA][iOM];
            ++iOA;
        }
        return OM;
    }

    public ArrayList<SpinOrbitaleMoleculaire> getSOMofSpin(Spin spin) {
        ArrayList<SpinOrbitaleMoleculaire> res = new ArrayList<SpinOrbitaleMoleculaire>();
        SpinOrbitaleMoleculaire[] spinOrbitaleMoleculaireArray = this.getSOM();
        int n = spinOrbitaleMoleculaireArray.length;
        int n2 = 0;
        while (n2 < n) {
            SpinOrbitaleMoleculaire som = spinOrbitaleMoleculaireArray[n2];
            if (som.getSpin() == spin) {
                res.add(som);
            }
            ++n2;
        }
        return res;
    }

    public SpinOrbitaleMoleculaire[] getOccSOM() throws NoSOMAvailableException, UnavailableSOMException {
        if (this.occSOMs == null) {
            ArrayList<SpinOrbitaleMoleculaire> list = new ArrayList<SpinOrbitaleMoleculaire>();
            int i2 = 0;
            while (i2 < this.countSpinOM()) {
                SpinOrbitaleMoleculaire som = this.getSpinOM(i2);
                switch (som.getSpin()) {
                    case ALPHA: 
                    case BETA: {
                        list.add(som);
                        break;
                    }
                    case DEMI_ELECTRON: {
                        list.add(som);
                    }
                }
                ++i2;
            }
            this.occSOMs = new SpinOrbitaleMoleculaire[list.size()];
            list.toArray(this.occSOMs);
        }
        return this.occSOMs;
    }

    public SpinOrbitaleMoleculaire[] getVirtSOM() throws NoSOMAvailableException, UnavailableSOMException {
        ArrayList<SpinOrbitaleMoleculaire> list = new ArrayList<SpinOrbitaleMoleculaire>();
        int i2 = 0;
        while (i2 < this.countSpinOM()) {
            SpinOrbitaleMoleculaire som = this.getSpinOM(i2);
            switch (som.getSpin()) {
                case NOSPIN_ALPHA: 
                case NOSPIN_BETA: {
                    list.add(som);
                    break;
                }
                case NO_DEMI_ELECTRON: {
                    list.add(som);
                }
            }
            ++i2;
        }
        SpinOrbitaleMoleculaire[] a = new SpinOrbitaleMoleculaire[list.size()];
        list.toArray(a);
        return a;
    }

    public final SpinOrbitaleMoleculaire[] getSOM() {
        return this.SOM;
    }

    public double[][] getOrbitalsCoeffArray() {
        return this.orbitalsCoeffArray;
    }

    protected double[][] getOrbitalsCoefficients() {
        return this.getOrbitalsCoeffArray();
    }

    protected double[] getOrbitalsEnergies() {
        return this.energiesArray;
    }

    public SpinOrbitaleMoleculaire getSpinOM(int iSOM) throws NoSOMAvailableException, UnavailableSOMException {
        if (this.getSOM() == null) {
            throw new NoSOMAvailableException();
        }
        int size = this.getSOM().length;
        if (iSOM >= size) {
            throw new UnavailableSOMException(iSOM, size);
        }
        return this.getSOM()[iSOM];
    }

    public SpinOrbitaleMoleculaire getSpinOMByIndex(int index) {
        int i2 = 0;
        while (i2 < this.getSOM().length) {
            SpinOrbitaleMoleculaire som = this.getSOM()[i2];
            if (som.getIndex() == index) {
                return som;
            }
            ++i2;
        }
        return null;
    }

    public SpinOrbitaleMoleculaire getSpinOM(SpinOrbitaleMoleculaire phi1) throws NoSOMAvailableException, UnavailableSOMException {
        int size = this.getSOM().length;
        if (this.getSOM() == null) {
            throw new NoSOMAvailableException();
        }
        int iSOM = 0;
        while (iSOM < size) {
            SpinOrbitaleMoleculaire phi2 = this.getSOM()[iSOM];
            if (phi1.overlap(phi2, this.getTopology()) > 0.999) {
                return phi2;
            }
            ++iSOM;
        }
        return null;
    }

    public double getSumOFChargeDensities() {
        return this.sumOfChargeDensities;
    }

    public int getSumOfDistributedElec() {
        return this.sumOfDistributedElec;
    }

    public int getSumOfPiElec() {
        return this.sumOfPiElec;
    }

    public Energy getTotalEnergy() {
        return this.totalEnergy;
    }

    protected double getTotalEnergyAlpha() {
        return this.getSumOfDistributedElec();
    }

    protected double getTotalEnergyBeta() {
        double energieTotale = 0.0;
        double[] repartitionElec = this.distributionElecPiArray;
        int i2 = 0;
        while (i2 < repartitionElec.length) {
            energieTotale += this.energiesArray[i2] * repartitionElec[i2];
            ++i2;
        }
        return energieTotale;
    }

    public int getTotalSpin() {
        if (this.getSOM() == null) {
            try {
                this.generateSpinOM();
            }
            catch (NoElectronException e) {
                HuckelIO.warning(this.getClass().getName(), "getTotalSpin", e.getMessage(), e);
            }
            catch (NoSOMAvailableException e) {
                e.printStackTrace();
            }
            catch (UnavailableSOMException e) {
                e.printStackTrace();
            }
        }
        int TotSpin = 0;
        try {
            SpinOrbitaleMoleculaire[] spinOrbitaleMoleculaireArray = this.getOccSOM();
            int n = spinOrbitaleMoleculaireArray.length;
            int n2 = 0;
            while (n2 < n) {
                SpinOrbitaleMoleculaire SOM = spinOrbitaleMoleculaireArray[n2];
                TotSpin += SOM.getSpin().getval() + 0;
                ++n2;
            }
        }
        catch (NoSOMAvailableException e) {
            e.printStackTrace();
            HuckelIO.error(this.getClass().toString(), "getTotalSpin", "SOM not generated ? ");
        }
        catch (UnavailableSOMException e) {
            e.printStackTrace();
            HuckelIO.error(this.getClass().toString(), "getTotalSpin", "SOM not generated ? ");
        }
        return TotSpin;
    }

    public void removeMonoExcitation(MonoExcitation monoExcitation) {
        this.monoExcitations.remove(monoExcitation);
        if (this.isEnabledFlyCalculate()) {
            this.calculate();
        }
        this.fireMonoExcitationTriggered(new MonoExcitationEvent(monoExcitation, null, null));
    }

    public void printSOMs() {
        if (!HuckelIO.isverbose()) {
            return;
        }
        int nOA = this.getnOA();
        int nSO = this.getnSO();
        System.out.printf("%s spinorbitales nOA=%s\n", nSO, nOA);
        int iSO = 0;
        while (iSO < nSO) {
            System.out.printf("%4s_%-3d", "OM", iSO + 1);
            ++iSO;
        }
        HuckelIO.PrintIf("\n");
        iSO = 0;
        while (iSO < nSO) {
            Spin spin = Spin.NOSPIN_ALPHA;
            try {
                spin = this.getSpinOM(iSO).getSpin();
            }
            catch (NullPointerException e) {
                HuckelIO.PrintIf("getSpinOM(iSO) is null\n");
            }
            catch (NoSOMAvailableException e) {
                HuckelIO.warning(this.getClass().getName(), "printSOMs", e.getMessage(), e);
            }
            catch (UnavailableSOMException e) {
                HuckelIO.warning(this.getClass().getName(), "printSOMs", e.getMessage(), e);
            }
            System.out.printf("%7s ", spin.toString());
            ++iSO;
        }
        HuckelIO.PrintIf("\n");
        int iOA = 0;
        while (iOA < nOA) {
            int iSO2 = 0;
            while (iSO2 < nSO) {
                try {
                    double cOM = this.getSpinOM(iSO2).getCoeff(iOA);
                    System.out.printf("%8.4f", cOM);
                }
                catch (Exception e) {
                    HuckelIO.warning(this.getClass().getName(), "printSOMs", e.getMessage(), e);
                }
                ++iSO2;
            }
            HuckelIO.PrintIf("\n");
            ++iOA;
        }
    }

    @Override
    public void do_removeAtom(Atom a) throws HuckelBondException, BondException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        this.resetMonoExcitations();
        this.resetSOM();
        super.do_removeAtom(a);
    }

    @Override
    public void setNbElecCharge(int nbElecCharge) throws MoleculeCoherenceException {
        this.resetMonoExcitations();
        this.resetSOM();
        super.setNbElecCharge(nbElecCharge);
    }

    public void resetMonoExcitations() {
        this.monoExcitations.clear();
    }

    public void resetSOM() {
        this.SOM = null;
        this.occSOMs = null;
        try {
            this.generateSpinOM();
        }
        catch (NoElectronException e) {
            HuckelIO.warning(this.getClass().getName(), "resetSOM", e.getMessage(), e);
        }
        catch (NoSOMAvailableException e) {
            e.printStackTrace();
        }
        catch (UnavailableSOMException e) {
            e.printStackTrace();
        }
    }

    public void setMesomeryParent(Mesomery mesomeryParent) {
        this.mesomeryParent = mesomeryParent;
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        if (old != this.name) {
            this.fireStructureNameChanged(this, old, this.name);
        }
    }

    public boolean isEnabledFlyCalculate() {
        return this.isEnabledFlyCalculate;
    }

    public void setEnabledFlyCalculate(boolean isActiveFlyCalculate) {
        this.isEnabledFlyCalculate = isActiveFlyCalculate;
    }

    public void startFlyCalculate() {
        this.isEnabledFlyCalculate = true;
    }

    public void stopFlyCalculate() {
        this.isEnabledFlyCalculate = false;
    }

    protected void switchSpinOM(int iSOM, int jSOM) {
        try {
            this.getSpinOM(iSOM).switchSpin();
            this.getSpinOM(jSOM).switchSpin();
        }
        catch (Exception e) {
            HuckelIO.warning(this.getClass().getName(), "switchSpinOM", e.getMessage(), e);
        }
    }

    @Override
    public String toString() {
        String res = String.valueOf(this.name) + " " + super.toString();
        return res;
    }

    public SpinOrbitaleMoleculaire getOccSpinOM(int i2) throws NoSOMAvailableException, UnavailableSOMException {
        return this.getOccSOM()[i2];
    }

    public SpinOrbitaleMoleculaire getHOMO(Spin spin) throws NoSOMAvailableException, UnavailableSOMException {
        SpinOrbitaleMoleculaire[] list = this.getOccSOM();
        Energy eMax = Energy.MIN(list[0]);
        SpinOrbitaleMoleculaire som = null;
        int i2 = 0;
        while (i2 < list.length) {
            Energy e;
            SpinOrbitaleMoleculaire tmp = list[i2];
            if (tmp.getSpin() == spin && (e = tmp.getEnergy()).compareTo(eMax) == -1) {
                eMax = e;
                som = list[i2];
            }
            ++i2;
        }
        return som;
    }

    public SpinOrbitaleMoleculaire getLUMO(Spin spin) throws NoSOMAvailableException, HulisException {
        SpinOrbitaleMoleculaire[] list = this.getVirtSOM();
        Energy eMin = Energy.MAX(list[0]);
        SpinOrbitaleMoleculaire som = null;
        int i2 = 0;
        while (i2 < list.length) {
            Energy e;
            SpinOrbitaleMoleculaire tmp = list[i2];
            if (tmp.getSpin() == spin && (e = tmp.getEnergy()).compareTo(eMin) == 1) {
                eMin = e;
                som = list[i2];
            }
            ++i2;
        }
        return som;
    }

    public CharacteristicPolynomial getCharacteristicPolynomial() {
        CharacteristicPolynomial poly = null;
        try {
            poly = new CharacteristicPolynomial(new Matrix(this.getHamiltonianArray()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return poly;
    }

    public static double overlap(Structure struct1, Structure struct2) throws NoElectronException, NoSOMAvailableException, UnavailableSOMException, OrbitaleMoleculaireException, HLPOverlapException {
        double ovl;
        Structure Phi1 = struct1;
        Structure Phi2 = null;
        Phi2 = struct1 == struct2 ? (Structure)struct2.clone(true) : struct2;
        HuckelIO.PrintIfln(" <  " + Phi1.getName() + " | " + Phi2.getName() + " > \n");
        Phi1.printSOMs();
        Phi2.printSOMs();
        int size = Phi1.getnOccSO();
        if (Phi2.getnOccSO() != size) {
            return 0.0;
        }
        if (HuckelIO.isverbose()) {
            System.out.println("TYPE DE COUPLAGE = " + (Object)((Object)Preferences.COUPLAGE_TYPE_DEFAULT));
        }
        boolean phi1AUnCouplage = Phi1.aUnCouplage();
        boolean phi2AUnCouplage = Phi2.aUnCouplage();
        double norm = 1.0 / Math.sqrt(2.0);
        if (phi1AUnCouplage && phi2AUnCouplage) {
            Phi1.resetSOM();
            Phi1.appliqueCouplage();
            Phi2.resetSOM();
            Phi2.appliqueCouplage();
            HuckelIO.PrintIfln("Phi1 puis Phi2 printSOMs");
            Phi1.printSOMs();
            Phi2.printSOMs();
            Matrix ovlMat_11_21 = new Matrix(size, size);
            int i2 = 0;
            while (i2 < size) {
                int j = 0;
                while (j < size) {
                    SpinOrbitaleMoleculaire SOM1 = Phi1.getOccSpinOM(i2);
                    SpinOrbitaleMoleculaire SOM2 = Phi2.getOccSpinOM(j);
                    ovlMat_11_21.set(i2, j, SOM1.overlap(SOM2, Phi1.getTopology()));
                    ++j;
                }
                ++i2;
            }
            HuckelIO.PrintIfln("Matrice 11 21");
            HuckelIO.PrintMatrix(ovlMat_11_21);
            double det_11_21 = ovlMat_11_21.det();
            ovlMat_11_21 = null;
            Matrix ovlMat_11_22 = new Matrix(size, size);
            int iSOM = Phi2.getCouplage()[0];
            int jSOM = Phi2.getCouplage()[1];
            if (HuckelIO.isverbose()) {
                System.out.println("phi1&2AUnCouplage psi2switch iSOM= " + iSOM + "jSOM=" + jSOM);
            }
            Phi2.switchSpinOM(iSOM, jSOM);
            if (HuckelIO.isverbose()) {
                Phi1.printSOMs();
                Phi2.printSOMs();
            }
            if (HuckelIO.isverbose()) {
                Phi1.printSOMs();
                Phi2.printSOMs();
            }
            int i3 = 0;
            while (i3 < size) {
                int j = 0;
                while (j < size) {
                    SpinOrbitaleMoleculaire SOM1 = Phi1.getOccSpinOM(i3);
                    SpinOrbitaleMoleculaire SOM2 = Phi2.getOccSpinOM(j);
                    ovlMat_11_22.set(i3, j, SOM1.overlap(SOM2, Phi1.getTopology()));
                    ++j;
                }
                ++i3;
            }
            if (HuckelIO.isverbose()) {
                HuckelIO.PrintIf("Matrice 11 22");
                HuckelIO.PrintMatrix(ovlMat_11_22);
            }
            double det_11_22 = ovlMat_11_22.det();
            ovlMat_11_22 = null;
            Matrix ovlMat_12_21 = new Matrix(size, size);
            iSOM = Phi2.getCouplage()[0];
            jSOM = Phi2.getCouplage()[1];
            Phi2.switchSpinOM(iSOM, jSOM);
            if (HuckelIO.isverbose()) {
                System.out.println("phi1&2AUnCouplage ovlMat_12_21 psi2switch iSOM= " + iSOM + "jSOM=" + jSOM);
                System.out.println("Size" + size + "phi2.index" + Phi2.index + "get nOA" + Phi2.getnOA());
            }
            iSOM = Phi1.getCouplage()[0];
            jSOM = Phi1.getCouplage()[1];
            if (HuckelIO.isverbose()) {
                System.out.println("phi1&2AUnCouplage ovlMat_12_21 psi1switch iSOM= " + iSOM + "jSOM=" + jSOM);
            }
            Phi1.switchSpinOM(iSOM, jSOM);
            if (HuckelIO.isverbose()) {
                System.out.println("Size" + size + "phi1.index" + Phi1.index + "get nOA" + Phi1.getnOA());
            }
            if (HuckelIO.isverbose()) {
                System.out.printf("%s\n", "Phi1 modified Phi2 init" + HuckelIO.isverbose() + "VARBOSE VERBOSE");
                Phi1.printSOMs();
                Phi2.printSOMs();
                System.out.printf("%s\n", "-----------------------" + Phi1.getOccSOM());
            }
            int i4 = 0;
            while (i4 < size) {
                int j = 0;
                while (j < size) {
                    SpinOrbitaleMoleculaire SOM1 = Phi1.getOccSpinOM(i4);
                    SpinOrbitaleMoleculaire SOM2 = Phi2.getOccSpinOM(j);
                    ovlMat_12_21.set(i4, j, SOM1.overlap(SOM2, Phi1.getTopology()));
                    ++j;
                }
                ++i4;
            }
            if (HuckelIO.isverbose()) {
                HuckelIO.PrintIfln("Matrice 12 21");
                HuckelIO.PrintMatrix(ovlMat_12_21);
            }
            double det_12_21 = ovlMat_12_21.det();
            ovlMat_12_21 = null;
            Matrix ovlMat_12_22 = new Matrix(size, size);
            iSOM = Phi2.getCouplage()[0];
            jSOM = Phi2.getCouplage()[1];
            if (HuckelIO.isverbose()) {
                System.out.println("phi1&2AUnCouplage ovlMat_12_22 psi2switch iSOM= " + iSOM + "jSOM=" + jSOM);
            }
            Phi2.switchSpinOM(iSOM, jSOM);
            int i5 = 0;
            while (i5 < size) {
                int j = 0;
                while (j < size) {
                    SpinOrbitaleMoleculaire SOM1 = Phi1.getOccSpinOM(i5);
                    SpinOrbitaleMoleculaire SOM2 = Phi2.getOccSpinOM(j);
                    ovlMat_12_22.set(i5, j, SOM1.overlap(SOM2, Phi1.getTopology()));
                    ++j;
                }
                ++i5;
            }
            if (HuckelIO.isverbose()) {
                HuckelIO.PrintIfln("Matrice 12 22");
                HuckelIO.PrintMatrix(ovlMat_12_22);
            }
            double det_12_22 = ovlMat_12_22.det();
            ovlMat_12_22 = null;
            ovl = det_11_21 - det_11_22 - det_12_21 + det_12_22;
            ovl *= Math.pow(norm, 2.0);
        } else if (phi1AUnCouplage) {
            Phi1.resetSOM();
            Phi1.appliqueCouplage();
            Matrix ovlMat_11 = new Matrix(size, size);
            int i6 = 0;
            while (i6 < size) {
                int j = 0;
                while (j < size) {
                    SpinOrbitaleMoleculaire SOM1 = Phi1.getOccSpinOM(i6);
                    SpinOrbitaleMoleculaire SOM2 = Phi2.getOccSpinOM(j);
                    ovlMat_11.set(i6, j, SOM1.overlap(SOM2, Phi1.getTopology()));
                    ++j;
                }
                ++i6;
            }
            if (HuckelIO.isverbose()) {
                HuckelIO.PrintIfln("Matrice 11");
                HuckelIO.PrintMatrix(ovlMat_11);
            }
            double det_11 = ovlMat_11.det();
            ovlMat_11 = null;
            Matrix ovlMat_12 = new Matrix(size, size);
            int iSOM = Phi1.getCouplage()[0];
            int jSOM = Phi1.getCouplage()[1];
            if (HuckelIO.isverbose()) {
                System.out.println("phi1AUnCouplage iSOM= " + iSOM + "jSOM=" + jSOM);
            }
            Phi1.switchSpinOM(iSOM, jSOM);
            int i7 = 0;
            while (i7 < size) {
                int j = 0;
                while (j < size) {
                    SpinOrbitaleMoleculaire SOM1 = Phi1.getOccSpinOM(i7);
                    SpinOrbitaleMoleculaire SOM2 = Phi2.getOccSpinOM(j);
                    ovlMat_12.set(i7, j, SOM1.overlap(SOM2, Phi1.getTopology()));
                    ++j;
                }
                ++i7;
            }
            if (HuckelIO.isverbose()) {
                HuckelIO.PrintIfln("Matrice 12");
                HuckelIO.PrintMatrix(ovlMat_12);
            }
            double det_12 = ovlMat_12.det();
            ovlMat_12 = null;
            ovl = -(det_11 - det_12);
            ovl *= norm;
        } else if (phi2AUnCouplage) {
            Phi2.resetSOM();
            Phi2.appliqueCouplage();
            Matrix ovlMat_21 = new Matrix(size, size);
            int i8 = 0;
            while (i8 < size) {
                int j = 0;
                while (j < size) {
                    SpinOrbitaleMoleculaire SOM1 = Phi1.getOccSpinOM(i8);
                    SpinOrbitaleMoleculaire SOM2 = Phi2.getOccSpinOM(j);
                    ovlMat_21.set(i8, j, SOM1.overlap(SOM2, Phi1.getTopology()));
                    ++j;
                }
                ++i8;
            }
            if (HuckelIO.isverbose()) {
                HuckelIO.PrintIfln("Matrice 21");
                HuckelIO.PrintMatrix(ovlMat_21);
            }
            double det_21 = ovlMat_21.det();
            ovlMat_21 = null;
            Matrix ovlMat_22 = new Matrix(size, size);
            int iSOM = Phi2.getCouplage()[0];
            int jSOM = Phi2.getCouplage()[1];
            if (HuckelIO.isverbose()) {
                System.out.println("ph2AUnCouplage Phi2.switchSpinOM iSOM= " + iSOM + "jSOM=" + jSOM);
            }
            Phi2.switchSpinOM(iSOM, jSOM);
            if (HuckelIO.isverbose()) {
                Phi1.printSOMs();
                Phi2.printSOMs();
            }
            int i9 = 0;
            while (i9 < size) {
                int j = 0;
                while (j < size) {
                    SpinOrbitaleMoleculaire SOM1 = Phi1.getOccSpinOM(i9);
                    SpinOrbitaleMoleculaire SOM2 = Phi2.getOccSpinOM(j);
                    ovlMat_22.set(i9, j, SOM1.overlap(SOM2, Phi1.getTopology()));
                    ++j;
                }
                ++i9;
            }
            HuckelIO.PrintIfln("Matrice 22");
            HuckelIO.PrintMatrix(ovlMat_22);
            double det_22 = ovlMat_22.det();
            ovlMat_22 = null;
            ovl = -(det_21 - det_22);
            ovl *= norm;
            HuckelIO.PrintIfln("Matrice 22 , det_21 et det_22" + det_21 + " " + det_22 + " " + norm);
        } else {
            Matrix ovlMat = new Matrix(size, size);
            int i10 = 0;
            while (i10 < size) {
                int j = 0;
                while (j < size) {
                    SpinOrbitaleMoleculaire SOM1 = Phi1.getOccSpinOM(i10);
                    SpinOrbitaleMoleculaire SOM2 = Phi2.getOccSpinOM(j);
                    ovlMat.set(i10, j, SOM1.overlap(SOM2, Phi1.getTopology()));
                    ++j;
                }
                ++i10;
            }
            HuckelIO.PrintIfln("Matrice 00");
            HuckelIO.PrintMatrix(ovlMat);
            ovl = ovlMat.det();
        }
        return ovl;
    }

    public abstract Object clone(boolean var1);

    public boolean isCloneResultsCacheWhenCloneStructure() {
        return this.isCloneResultsCacheWhenCloneStructure;
    }

    public void setCloneResultsCacheWhenCloneStructure(boolean isCloneResultsCacheWhenCloneStructure) {
        this.isCloneResultsCacheWhenCloneStructure = isCloneResultsCacheWhenCloneStructure;
    }

    private void computeNaturalOrbitals() {
        Matrix D = this.getRestrictedDensityMatrix();
        EigenvalueDecomposition evd = new EigenvalueDecomposition(D);
        double[][] natOrb = evd.getV().getArrayCopy();
        double[] natOcc = evd.getRealEigenvalues();
        int nNO = natOcc.length;
        this.naturalOrbitals = new ArrayList();
        int i2 = 0;
        while (i2 < nNO) {
            double[] OM = new double[nNO];
            int iOA = 0;
            while (iOA < nNO) {
                OM[iOA] = natOrb[iOA][i2];
                ++iOA;
            }
            NatOrbitaleMoleculaire no = new NatOrbitaleMoleculaire(OM);
            no.setOcc(natOcc[i2]);
            this.naturalOrbitals.add(no);
            ++i2;
        }
    }

    public ArrayList<NatOrbitaleMoleculaire> getNaturalOrbitals() {
        return this.naturalOrbitals;
    }

    public NatOrbitaleMoleculaire getNatOM(int i2) {
        return this.naturalOrbitals.get(i2);
    }

    public Symmetry getSymmetry() {
        if (this.symmetry == null) {
            return new Symmetry(this);
        }
        return this.symmetry;
    }

    public void addListener(IStructureListener listener) {
        super.addListener(listener);
    }

    public void removeListener(IStructureListener listener) {
        super.removeListener(listener);
    }

    @Override
    public void monoExcitationTriggered(MonoExcitationEvent e) {
        MonoExcitation ex = e.getSource();
        if (this != ex.getStructure()) {
            return;
        }
        boolean found = false;
        for (MonoExcitation m : this.getMonoExcitations()) {
            if (m != ex) continue;
            found = true;
        }
        MonoExcitation excopy = (MonoExcitation)ex.clone();
        if (!found) {
            this.monoExcitations.add(excopy);
            this.occSOMs = null;
        }
        this.fireMonoExcitationTriggered(new MonoExcitationEvent(excopy, null, null));
    }

    protected void fireMonoExcitationTriggered(MonoExcitationEvent e) {
        if (this.isEnabledFlyCalculate()) {
            this.calculate();
        }
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        for (IMoleculeValueListener listener : this.getValueListeners()) {
            ((IStructureListener)listener).monoExcitationTriggered(e);
        }
    }

    protected void fireStructureNameChanged(Structure source, Object oldValue, Object newValue) {
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        StructureEvent event = null;
        for (IMoleculeValueListener listener : this.getValueListeners()) {
            if (event == null) {
                event = new StructureEvent(source, oldValue, newValue);
            }
            if (!(listener instanceof IStructureListener)) continue;
            ((IStructureListener)listener).structureNameChanged(event);
        }
    }

    @Override
    protected void fireHuckelAtomHxChanged(HuckelAtomEvent e) {
        if (this.isEnabledFlyCalculate()) {
            this.calculate();
        }
        super.fireHuckelAtomHxChanged(e);
    }

    @Override
    protected void fireHuckelAtomRadRChanged(HuckelAtomEvent e) {
        if (this.isEnabledFlyCalculate()) {
            this.calculate();
        }
        super.fireHuckelAtomRadRChanged(e);
    }

    @Override
    protected void fireHuckelAtomSeqNumChanged(HuckelAtomEvent e) {
        if (this.isEnabledFlyCalculate()) {
            this.calculate();
        }
        super.fireHuckelAtomSeqNumChanged(e);
    }

    @Override
    protected void fireHuckelBondBondTypeChanged(HuckelBondEvent e) {
        if (this.isEnabledFlyCalculate()) {
            this.calculate();
        }
        super.fireHuckelBondBondTypeChanged(e);
    }

    @Override
    protected void fireHuckelBondHxyChanged(HuckelBondEvent e) {
        if (this.isEnabledFlyCalculate()) {
            this.calculate();
        }
        super.fireHuckelBondHxyChanged(e);
    }

    @Override
    protected void fireMoleculeAtomAdded(Molecule source, Object oldValue, Object newValue) {
        if (this.isEnabledFlyCalculate()) {
            this.calculate();
        }
        super.fireMoleculeAtomAdded(source, oldValue, newValue);
    }

    @Override
    protected void fireMoleculeAtomRemoved(Molecule source, Object oldValue, Object newValue) {
        if (this.isEnabledFlyCalculate()) {
            this.calculate();
        }
        super.fireMoleculeAtomRemoved(source, oldValue, newValue);
    }

    @Override
    protected void fireMoleculeAtomReplaced(Molecule source, Object oldValue, Object newValue) {
        if (this.isEnabledFlyCalculate()) {
            this.calculate();
        }
        super.fireMoleculeAtomReplaced(source, oldValue, newValue);
    }

    @Override
    protected void fireMoleculeBondAdded(Molecule source, Object oldValue, Object newValue) {
        if (this.isEnabledFlyCalculate()) {
            this.calculate();
        }
        super.fireMoleculeBondAdded(source, oldValue, newValue);
    }

    @Override
    protected void fireMoleculeBondRemoved(Molecule source, Object oldValue, Object newValue) {
        if (this.isEnabledFlyCalculate()) {
            this.calculate();
        }
        super.fireMoleculeBondRemoved(source, oldValue, newValue);
    }

    @Override
    protected void fireMoleculeChargeChanged(Molecule source, Object oldValue, Object newValue) {
        if (this.isEnabledFlyCalculate()) {
            this.calculate();
        }
        super.fireMoleculeChargeChanged(source, oldValue, newValue);
    }

    @Override
    protected void fireMoleculeListHuckelAtomSeqNumAutoSetted(Molecule source, Object oldValue, Object newValue) {
        if (this.isEnabledFlyCalculate()) {
            this.calculate();
        }
        super.fireMoleculeListHuckelAtomSeqNumAutoSetted(source, oldValue, newValue);
    }

    @Override
    protected void fireMoleculeListHuckelAtomSeqNumReset(Molecule source, Object oldValue, Object newValue) {
        if (this.isEnabledFlyCalculate()) {
            this.calculate();
        }
        super.fireMoleculeListHuckelAtomSeqNumReset(source, oldValue, newValue);
    }

    public static void main(String[] args) {
        double[][] hamiltonien = new double[][]{{0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.5, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0}};
        EigenvalueDecomposition eig = new EigenvalueDecomposition(new Matrix(hamiltonien));
        HuckelIO.PrintMatrix(new Matrix(hamiltonien), "hamiltonien");
        HuckelIO.PrintMatrix(new Matrix(eig.getV().getArray()), "orbitales (eigenvalues)");
        HuckelIO.PrintMatrix(new Matrix(VectorssHuckel.sort(eig.getV().getArray())), "orbitales reordonnees");
    }
}

