/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.huckel.structures;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ctom.hulis.files.xyz.GeometryReader;
import org.ctom.hulis.files.xyz.ReadxyzException;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.Bond;
import org.ctom.hulis.huckel.HuckelAtom;
import org.ctom.hulis.huckel.HuckelBond;
import org.ctom.hulis.huckel.MonoExcitation;
import org.ctom.hulis.huckel.Spin;
import org.ctom.hulis.huckel.SpinOrbitaleMoleculaire;
import org.ctom.hulis.huckel.events.MonoExcitationEvent;
import org.ctom.hulis.huckel.events.StructureDelocalizedEvent;
import org.ctom.hulis.huckel.exception.BondException;
import org.ctom.hulis.huckel.exception.GeometryException;
import org.ctom.hulis.huckel.exception.HuckelBondException;
import org.ctom.hulis.huckel.exception.HulisException;
import org.ctom.hulis.huckel.exception.MoleculeAtomNullException;
import org.ctom.hulis.huckel.exception.MoleculeBondExistsException;
import org.ctom.hulis.huckel.exception.MoleculeCoherenceException;
import org.ctom.hulis.huckel.exception.MoleculeTooManyNeighboursException;
import org.ctom.hulis.huckel.exception.MonoExcitationException;
import org.ctom.hulis.huckel.exception.SpinOrbitaleMoleculaireException;
import org.ctom.hulis.huckel.listeners.IMoleculeValueListener;
import org.ctom.hulis.huckel.listeners.IStructureDelocalizedListener;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureLocalized;
import org.ctom.hulis.util.VectorssHuckel;
import org.ctom.hulis.util.geometry.Geometry;
import org.ctom.hulis.util.io.HuckelIO;
import org.ctom.util.maths.Maths;
import org.ctom.util.maths.Rotation;

public class StructureDelocalized
extends Structure
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -1509299117295377271L;
    public static final int PRECISION = 2;
    public static final String NAME_DELOCALIZED_STRUCTURE = "tot";
    public static int precision = 2;

    public StructureDelocalized() {
        this.setName(NAME_DELOCALIZED_STRUCTURE);
    }

    public StructureDelocalized(GeometryReader readxyz) throws HuckelBondException, BondException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException, ReadxyzException {
        this.setName(NAME_DELOCALIZED_STRUCTURE);
        this.setAutoCorrectH(false);
        this.geometry = new Geometry();
        readxyz.readAll(this.geometry);
        this.createMolecule(this.geometry);
        this.setAutoCorrectH(true);
        if (this.isEnabledFlyCalculate()) {
            this.calculate();
        }
    }

    public StructureDelocalized(StructureDelocalized s) {
        this(s, s.isCloneResultsCacheWhenCloneStructure());
    }

    public StructureDelocalized(StructureDelocalized s, boolean cloneStructureResults) {
        super(s);
        if (cloneStructureResults) {
            this.copyArrays(s);
        }
        this.setName(s.getName());
    }

    @Override
    public Object clone() {
        return new StructureDelocalized(this);
    }

    @Override
    public int hashCode() {
        int multiplier = 23;
        if (this.hashCode == 0) {
            int code = 133;
            this.hashCode = code = 23 * code + super.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        return o instanceof StructureDelocalized;
    }

    @Override
    public Object clone(boolean cloneResults) {
        return new StructureDelocalized(this, cloneResults);
    }

    @Override
    public void addAtom(Atom a) throws HuckelBondException, BondException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        if (this.mesomeryParent != null && this.mesomeryParent.countLocalizedStructs() > 0) {
            throw new MoleculeCoherenceException("Cannot add an atom in the delocalized structure. There are localized structures in the mesomery");
        }
        super.addAtom(a);
    }

    @Override
    public void addBond(Bond b) throws MoleculeCoherenceException, HuckelBondException, BondException, MoleculeBondExistsException, MoleculeTooManyNeighboursException {
        if (this.mesomeryParent != null && this.mesomeryParent.countLocalizedStructs() > 0) {
            throw new MoleculeCoherenceException("Cannot add an bond in the delocalized structure. There are localized structures in the mesomery");
        }
        super.addBond(b);
    }

    @Override
    public void removeAtom(Atom a) throws HuckelBondException, BondException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        if (this.mesomeryParent != null && this.mesomeryParent.countLocalizedStructs() > 0) {
            throw new MoleculeCoherenceException("Cannot remove an atom in the delocalized structure. There are localized structures in the mesomery");
        }
        super.removeAtom(a);
    }

    @Override
    public void removeBond(Bond l) throws HuckelBondException, BondException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        if (this.mesomeryParent != null && this.mesomeryParent.countLocalizedStructs() > 0) {
            throw new MoleculeCoherenceException("Cannot remove a bond in the delocalized structure. There are localized structures in the mesomery");
        }
        super.removeBond(l);
    }

    @Override
    public void replaceAtom(Atom old, Atom newAtom) throws HuckelBondException, BondException, MoleculeAtomNullException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        if (this.mesomeryParent != null && this.mesomeryParent.countLocalizedStructs() > 0) {
            throw new MoleculeCoherenceException("Cannot replace an atom in the delocalized structure. There are localized structures in the mesomery");
        }
        super.replaceAtom(old, newAtom);
    }

    @Override
    public void removeMonoExcitation(MonoExcitation monoExcitation) {
        if (this.mesomeryParent != null && this.mesomeryParent.countLocalizedStructs() > 0) {
            throw new RuntimeException("Cannot remove excitation in the delocalized structure. There are localized structures in the mesomery");
        }
        super.removeMonoExcitation(monoExcitation);
    }

    @Override
    public void rotate(Rotation mRot) {
        if (this.mesomeryParent != null && this.mesomeryParent.countLocalizedStructs() > 0) {
            throw new RuntimeException("Cannot rotate the delocalized structure. There are localized structures in the mesomery");
        }
        super.rotate(mRot);
    }

    @Override
    public void move(double dx, double dy, double dz) {
        if (this.mesomeryParent != null && this.mesomeryParent.countLocalizedStructs() > 0) {
            throw new RuntimeException("Cannot move the delocalized structure. There are localized structures in the mesomery");
        }
        super.move(dx, dy, dz);
    }

    @Override
    public void setNbElecCharge(int nbElecCharge) throws MoleculeCoherenceException {
        if (this.mesomeryParent != null && this.mesomeryParent.countLocalizedStructs() > 0) {
            throw new MoleculeCoherenceException("Cannot change eletrons of the delocalized structure. There are localized structures in the mesomery");
        }
        super.setNbElecCharge(nbElecCharge);
    }

    @Override
    public void resetSeqNumListHuckelAtomToZero() {
        if (this.getMesomeryParent() != null && this.getMesomeryParent().countLocalizedStructs() > 0) {
            throw new RuntimeException("Cannot number the atoms. There are localized structures in the mesomery");
        }
        super.resetSeqNumListHuckelAtomToZero();
    }

    @Override
    public void setAutoSeqNumListHuckelAtom() {
        if (this.getMesomeryParent() != null && this.getMesomeryParent().countLocalizedStructs() > 0) {
            throw new RuntimeException("Cannot number the atoms. There are localized structures in the mesomery");
        }
        super.setAutoSeqNumListHuckelAtom();
    }

    @Override
    protected void appliqueCouplage() {
    }

    @Override
    protected double[] calcOrbitalsEnergies() {
        Matrix hamiltonien = this.getMatrixHamiltonian();
        EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(hamiltonien);
        return VectorssHuckel.sort(eigenvalueDecomposition.getRealEigenvalues());
    }

    @Override
    protected double[] calcChargeDensitiesArray() {
        double[] tblCharges = new double[this.countHuckelAtoms()];
        double somme = 0.0;
        double Ci = 0.0;
        double[] repartitionElec = this.distributionElecPiArray;
        int i2 = 0;
        while (i2 < this.orbitalsCoeffArray.length) {
            somme = 0.0;
            int j = 0;
            while (j < this.orbitalsCoeffArray[i2].length) {
                Ci = this.orbitalsCoeffArray[i2][j];
                somme += Ci * Ci * repartitionElec[j];
                ++j;
            }
            HuckelAtom a = this.getHuckelAtomBySeqNum(i2 + 1);
            tblCharges[i2] = (double)a.getNbElecPi() - somme;
            a.setDensity(tblCharges[i2]);
            ++i2;
        }
        return tblCharges;
    }

    @Override
    protected double[][] calcBondOrdersArray() {
        double somme = 0.0;
        double CA = 0.0;
        double CB = 0.0;
        double[] repartitionElec = this.distributionElecPiArray;
        double[][] ordresLiaison = new double[this.orbitalsCoeffArray.length][this.orbitalsCoeffArray.length];
        int i2 = 0;
        while (i2 < ordresLiaison.length) {
            int j = 0;
            while (j < ordresLiaison[i2].length) {
                somme = 0.0;
                int l = 0;
                while (l < this.orbitalsCoeffArray.length) {
                    CA = this.orbitalsCoeffArray[i2][l];
                    CB = this.orbitalsCoeffArray[j][l];
                    somme += CA * CB * repartitionElec[l];
                    ++l;
                }
                ordresLiaison[i2][j] = somme;
                ++j;
            }
            ++i2;
        }
        for (HuckelBond b : this.getHuckelBonds()) {
            b.setBondOrder(ordresLiaison[b.getAtom1().getSeqNum() - 1][b.getAtom2().getSeqNum() - 1]);
        }
        return ordresLiaison;
    }

    @Override
    protected double[] calcDistributionElecArray() {
        double[] repartitionElec = new double[this.countHuckelAtoms()];
        double[] energies = this.getOrbitalsEnergies();
        int nbElecADistribuer = this.getNbElecCharge() + this.getSumAtomsNbElecPi();
        int i2 = 0;
        while (i2 < repartitionElec.length) {
            repartitionElec[i2] = 0.0;
            ++i2;
        }
        int deb = 0;
        int end = 0;
        while (deb < this.energiesArray.length && nbElecADistribuer > 0) {
            end = deb;
            while (Maths.round(energies[deb], precision) == Maths.round(energies[end], precision) && end < repartitionElec.length) {
                if (++end == repartitionElec.length) break;
            }
            int nb = 0;
            while (nb < 2) {
                i2 = deb;
                while (i2 < end && nbElecADistribuer > 0) {
                    int n = i2++;
                    repartitionElec[n] = repartitionElec[n] + 1.0;
                    --nbElecADistribuer;
                }
                ++nb;
            }
            deb = end;
        }
        repartitionElec = this.TreatExcitations(repartitionElec);
        return repartitionElec;
    }

    public double[] TreatExcitations(double[] repartitionInit) {
        double[] repartitionNew = (double[])repartitionInit.clone();
        ArrayList<MonoExcitation> excitations = this.getMonoExcitations();
        if (excitations == null) {
            return repartitionNew;
        }
        int i2 = 0;
        while (i2 < excitations.size()) {
            MonoExcitation ex = excitations.get(i2);
            int ifrom = -1;
            int ito = -1;
            try {
                ifrom = ex.getFrom().getIndex() / 2;
                ito = ex.getTo().getIndex() / 2;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int n = ifrom;
            repartitionNew[n] = repartitionNew[n] - 1.0;
            int n2 = ito;
            repartitionNew[n2] = repartitionNew[n2] + 1.0;
            System.out.print("Excitation from " + ifrom + " to " + ito + " done\n");
            ++i2;
        }
        return repartitionNew;
    }

    @Override
    protected int calcSumOfPiElec() {
        int nbElecPi = 0;
        nbElecPi = this.getSumAtomsNbElecPi() + this.getNbElecCharge();
        return nbElecPi;
    }

    public StructureLocalized cloneToLocalized() {
        return new StructureLocalized(this);
    }

    @Override
    protected Matrix getMatrixHamiltonian() {
        int nbAtomes = this.countHuckelAtoms();
        if (nbAtomes == 0) {
            return null;
        }
        Matrix hamiltonien = new Matrix(nbAtomes, nbAtomes);
        for (HuckelAtom a : this.getHuckelAtoms()) {
            if (a.getSeqNum() <= 0) {
                return null;
            }
            hamiltonien.set(a.getSeqNum() - 1, a.getSeqNum() - 1, a.getHx());
        }
        for (HuckelBond l : this.getHuckelBonds()) {
            int x = l.getAtom1().getSeqNum() - 1;
            int y = l.getAtom2().getSeqNum() - 1;
            double hxy = l.getHxy();
            if (x < 0 || y < 0) continue;
            hamiltonien.set(x, y, hxy);
            hamiltonien.set(y, x, hxy);
        }
        return hamiltonien;
    }

    public void switchSinguletTriplet() throws SpinOrbitaleMoleculaireException {
        int initialSpin = this.getTotalSpin();
        HuckelIO.PrintIf("Total Spin : " + initialSpin);
        try {
            SpinOrbitaleMoleculaire tmpHOMO = null;
            SpinOrbitaleMoleculaire tmpLUMO = null;
            MonoExcitation monoExcitation = null;
            switch (initialSpin) {
                case 0: {
                    HuckelIO.PrintIfln("singulet -> triplet");
                    monoExcitation = new MonoExcitation(this);
                    this.getMonoExcitations().add(monoExcitation);
                    tmpHOMO = this.getHOMO(Spin.BETA);
                    tmpLUMO = this.getLUMO(Spin.NOSPIN_ALPHA);
                    monoExcitation.setFrom(tmpHOMO);
                    monoExcitation.setTo(tmpLUMO);
                    tmpHOMO.removeElectron();
                    tmpLUMO.addElectron();
                    this.distributionElecPiArray = this.calcDistributionElecArray();
                    this.chargeDensitiesArray = this.calcChargeDensitiesArray();
                    this.sumOfChargeDensities = this.calcSumOfChargesDensities();
                    this.sumOfDistributedElec = this.calcSumofDistributionElec();
                    this.sumOfPiElec = this.calcSumOfPiElec();
                    this.bondOrdersArray = this.calcBondOrdersArray();
                    this.totalEnergy.set(this.getTotalEnergyAlpha(), this.getTotalEnergyBeta());
                    this.resetSOM();
                    this.fireStructureDelocalizedSpinChanged(this, null, null);
                    break;
                }
                case 2: {
                    HuckelIO.PrintIfln("triplet -> singulet");
                    monoExcitation = new MonoExcitation(this);
                    this.getMonoExcitations().add(monoExcitation);
                    tmpHOMO = this.getHOMO(Spin.ALPHA);
                    tmpLUMO = this.getLUMO(Spin.NOSPIN_BETA);
                    monoExcitation.setFrom(tmpHOMO);
                    monoExcitation.setTo(tmpLUMO);
                    tmpHOMO.removeElectron();
                    tmpLUMO.addElectron();
                    this.distributionElecPiArray = this.calcDistributionElecArray();
                    this.chargeDensitiesArray = this.calcChargeDensitiesArray();
                    this.sumOfChargeDensities = this.calcSumOfChargesDensities();
                    this.sumOfDistributedElec = this.calcSumofDistributionElec();
                    this.sumOfPiElec = this.calcSumOfPiElec();
                    this.bondOrdersArray = this.calcBondOrdersArray();
                    this.totalEnergy.set(this.getTotalEnergyAlpha(), this.getTotalEnergyBeta());
                    this.resetSOM();
                    this.fireStructureDelocalizedSpinChanged(this, null, null);
                    break;
                }
                default: {
                    HuckelIO.warning(this.getClass().toString(), "switchSinguletTriplet", "Spin modification only for singlet and triplet");
                    break;
                }
            }
        }
        catch (MonoExcitationException e) {
            e.printStackTrace();
            HuckelIO.error(this.getClass().toString(), "switchSinguletTriplet", "monoExcitation erreur", e);
        }
        catch (HulisException e) {
            e.printStackTrace();
            HuckelIO.error(this.getClass().toString(), "switchSinguletTriplet", "SOM non disponibles.", e);
        }
    }

    public void switchSinguletCouchesOuvertes() throws SpinOrbitaleMoleculaireException {
        int initialSpin = this.getTotalSpin();
        HuckelIO.PrintIfln("Total Spin : " + initialSpin);
        try {
            SpinOrbitaleMoleculaire tmpHOMO = null;
            SpinOrbitaleMoleculaire tmpLUMO = null;
            MonoExcitation monoExcitation = null;
            switch (initialSpin) {
                case 0: {
                    HuckelIO.PrintIfln("singulet CF -> singulet CO");
                    monoExcitation = new MonoExcitation(this);
                    this.getMonoExcitations().add(monoExcitation);
                    tmpHOMO = this.getHOMO(Spin.BETA);
                    tmpLUMO = this.getLUMO(Spin.NOSPIN_BETA);
                    monoExcitation.setFrom(tmpHOMO);
                    monoExcitation.setTo(tmpLUMO);
                    tmpLUMO.addElectron();
                    tmpHOMO.removeElectron();
                    this.distributionElecPiArray = this.calcDistributionElecArray();
                    this.chargeDensitiesArray = this.calcChargeDensitiesArray();
                    this.sumOfChargeDensities = this.calcSumOfChargesDensities();
                    this.sumOfDistributedElec = this.calcSumofDistributionElec();
                    this.sumOfPiElec = this.calcSumOfPiElec();
                    this.bondOrdersArray = this.calcBondOrdersArray();
                    this.totalEnergy.set(this.getTotalEnergyAlpha(), this.getTotalEnergyBeta());
                    this.resetSOM();
                    this.fireStructureDelocalizedSpinChanged(this, null, null);
                    break;
                }
                case 2: {
                    HuckelIO.PrintIfln("triplet -> singulet CO");
                    monoExcitation = new MonoExcitation(this);
                    this.getMonoExcitations().add(monoExcitation);
                    tmpHOMO = this.getHOMO(Spin.BETA);
                    tmpLUMO = this.getLUMO(Spin.NOSPIN_BETA);
                    monoExcitation.setFrom(tmpHOMO);
                    monoExcitation.setTo(tmpLUMO);
                    tmpLUMO.addElectron();
                    tmpHOMO.removeElectron();
                    this.distributionElecPiArray = this.calcDistributionElecArray();
                    this.chargeDensitiesArray = this.calcChargeDensitiesArray();
                    this.sumOfChargeDensities = this.calcSumOfChargesDensities();
                    this.sumOfDistributedElec = this.calcSumofDistributionElec();
                    this.sumOfPiElec = this.calcSumOfPiElec();
                    this.bondOrdersArray = this.calcBondOrdersArray();
                    this.totalEnergy.set(this.getTotalEnergyAlpha(), this.getTotalEnergyBeta());
                    this.resetSOM();
                    this.fireStructureDelocalizedSpinChanged(this, null, null);
                    break;
                }
                default: {
                    HuckelIO.warning(this.getClass().toString(), "switchSinguletCouchesOuvertes", "Spin modification only for singlet and triplet");
                    break;
                }
            }
        }
        catch (MonoExcitationException e) {
            e.printStackTrace();
            HuckelIO.error(this.getClass().toString(), "switchSinguletCouchesOuvertes", "monoExcitation erreur", e);
        }
        catch (HulisException e) {
            e.printStackTrace();
            HuckelIO.error(this.getClass().toString(), "switchSinguletCouchesOuvertes", "SOM non disponibles.", e);
        }
    }

    @Override
    public boolean aUnCouplage() {
        return false;
    }

    @Override
    protected int[] getCouplage() {
        return null;
    }

    @Override
    protected double[][] calcOrbitalsCoefficients() {
        Matrix hamiltionianOutsideBlocks = this.getMatrixHamiltonian();
        EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(hamiltionianOutsideBlocks);
        return VectorssHuckel.sort(eigenvalueDecomposition.getV().getArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isGeometryChanged() {
        try {
            Atom a;
            Geometry geom3D = this.getGeometry();
            Iterator<Atom> iterator = geom3D.getAtoms().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((a = iterator.next()).getLocationGeom3D() != null);
            return true;
        }
        catch (GeometryException e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<HuckelBond> checkBondsCovalentRaii() {
        ArrayList<HuckelBond> bonds = new ArrayList<HuckelBond>();
        for (HuckelBond b : this.getHuckelBonds()) {
            double distOptimaleAB = (b.getAtom1().getCovalentRadius() + b.getAtom2().getCovalentRadius()) * 50.0;
            double distance = b.getAtom1().getLocation().getDistance(b.getAtom2().getLocation());
            if (!(Maths.round(distance, 2) > Maths.round(distOptimaleAB, 2))) continue;
            System.out.println(b + " : DISTANCE = " + distance + " > " + distOptimaleAB + " !!!!!");
            bonds.add((HuckelBond)b.clone());
        }
        return bonds;
    }

    @Override
    public void monoExcitationTriggered(MonoExcitationEvent e) {
        if (this.mesomeryParent != null && this.mesomeryParent.countLocalizedStructs() > 0) {
            throw new RuntimeException("Cannot trigger a monoexcitation in the delocalized structure. There are localized structures in the mesomery");
        }
        super.monoExcitationTriggered(e);
    }

    protected void fireStructureDelocalizedSpinChanged(StructureDelocalized source, Object oldValue, Object newValue) {
        this.resetSOM();
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        StructureDelocalizedEvent event = null;
        for (IMoleculeValueListener listener : this.getValueListeners()) {
            if (event == null) {
                event = new StructureDelocalizedEvent(source, oldValue, newValue);
            }
            ((IStructureDelocalizedListener)listener).structureDelocalizedSpinChanged(event);
        }
    }

    public void addListener(IStructureDelocalizedListener listener) {
        super.addListener(listener);
    }

    public void removeListener(IStructureDelocalizedListener listener) {
        super.removeListener(listener);
    }
}

