/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.huckel.structures;

import Jama.Matrix;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.BlocDelocalized;
import org.ctom.hulis.huckel.Bond;
import org.ctom.hulis.huckel.CoupleLocal;
import org.ctom.hulis.huckel.HuckelAtom;
import org.ctom.hulis.huckel.HuckelBlock;
import org.ctom.hulis.huckel.HuckelBond;
import org.ctom.hulis.huckel.IHuckelObject;
import org.ctom.hulis.huckel.Mesomery;
import org.ctom.hulis.huckel.Molecule;
import org.ctom.hulis.huckel.MonoBlock;
import org.ctom.hulis.huckel.MonoExcitation;
import org.ctom.hulis.huckel.Spin;
import org.ctom.hulis.huckel.SpinOrbitaleMoleculaire;
import org.ctom.hulis.huckel.events.BlocDelocalizedEvent;
import org.ctom.hulis.huckel.events.HuckelAtomEvent;
import org.ctom.hulis.huckel.events.MoleculeEvent;
import org.ctom.hulis.huckel.events.MonoExcitationEvent;
import org.ctom.hulis.huckel.events.StructureLocalizedEvent;
import org.ctom.hulis.huckel.exception.BondException;
import org.ctom.hulis.huckel.exception.CoupleException;
import org.ctom.hulis.huckel.exception.HuckelBondException;
import org.ctom.hulis.huckel.exception.HulisException;
import org.ctom.hulis.huckel.exception.MoleculeAtomNullException;
import org.ctom.hulis.huckel.exception.MoleculeBondExistsException;
import org.ctom.hulis.huckel.exception.MoleculeCoherenceException;
import org.ctom.hulis.huckel.exception.MoleculeTooManyNeighboursException;
import org.ctom.hulis.huckel.exception.NoElectronException;
import org.ctom.hulis.huckel.exception.NoSOMAvailableException;
import org.ctom.hulis.huckel.exception.OrbitaleMoleculaireException;
import org.ctom.hulis.huckel.exception.StructureLocalizedException;
import org.ctom.hulis.huckel.exception.UnavailableSOMException;
import org.ctom.hulis.huckel.listeners.IBlocDelocalizedListener;
import org.ctom.hulis.huckel.listeners.IMoleculeValueListener;
import org.ctom.hulis.huckel.listeners.IStructureLocalizedListener;
import org.ctom.hulis.huckel.structures.Structure;
import org.ctom.hulis.huckel.structures.StructureDelocalized;
import org.ctom.hulis.prefs.Preferences;
import org.ctom.hulis.util.io.HuckelIO;
import org.ctom.util.maths.Maths;
import org.ctom.util.maths.Rotation;

public class StructureLocalized
extends Structure
implements IBlocDelocalizedListener,
Cloneable,
Serializable {
    private static final long serialVersionUID = 3507848539073531741L;
    private CoupleLocal couple;
    private Error error;
    protected StructureLocalized identicalStruct;
    private CreationMethod methodCreation;
    private HashMap<String, Double> weights;
    private ArrayList<CoupleOMs> lstCouplesOMs;
    private ArrayList<BlocDelocalized> lstBlocDelocalized;
    private int[] block_Couple_OMs;

    public StructureLocalized() {
        this.lstCouplesOMs = new ArrayList();
        this.lstBlocDelocalized = new ArrayList();
        this.weights = new HashMap();
    }

    public StructureLocalized(StructureLocalized structure) {
        this(structure, structure.isCloneResultsCacheWhenCloneStructure());
    }

    @Override
    public Object clone(boolean cloneResults) {
        return new StructureLocalized(this, cloneResults);
    }

    @Override
    public Object clone() {
        return new StructureLocalized(this);
    }

    @Override
    public int hashCode() {
        int multiplier = 23;
        if (this.hashCode == 0) {
            int code = 133;
            if (this.getCouple() != null) {
                code = 23 * code + this.getCouple().hashCode();
            }
            if (this.block_Couple_OMs != null) {
                code = 23 * code + this.block_Couple_OMs.hashCode();
            }
            if (this.lstBlocDelocalized != null) {
                code = 23 * code + this.lstBlocDelocalized.hashCode();
            }
            this.hashCode = code = 23 * code + super.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        return o instanceof StructureLocalized;
    }

    @Override
    public boolean geometryEquals(Molecule molecule) {
        if (!(molecule instanceof StructureLocalized)) {
            return false;
        }
        StructureLocalized s = (StructureLocalized)molecule;
        if (Preferences.COUPLAGE_TYPE_DEFAULT.equals((Object)Preferences.COUPLAGE_TYPE.ATOMS)) {
            if (s.getCouple() != null && this.getCouple() == null || s.getCouple() == null && this.getCouple() != null) {
                return false;
            }
            if (s.getCouple() != null && this.getCouple() != null && !s.getCouple().equals(this.getCouple())) {
                return false;
            }
        }
        if (this.countBlocsDelocalized() != s.countBlocsDelocalized()) {
            return false;
        }
        if (this.countBlocsDelocalized() != s.countBlocsDelocalized()) {
            return false;
        }
        for (BlocDelocalized bloc : this.getListBlocDelocalized()) {
            boolean ok = false;
            for (BlocDelocalized sbloc : s.getListBlocDelocalized()) {
                if (!bloc.equals(sbloc)) continue;
                ok = true;
                break;
            }
            if (ok) continue;
            return false;
        }
        return false;
    }

    @Override
    public void addAtom(Atom a) throws HuckelBondException, BondException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        throw new MoleculeCoherenceException("Cannot add an atom in a localized structure. It must have the same configuration as the delocalized structure");
    }

    @Override
    public void addBond(Bond b) throws MoleculeCoherenceException, HuckelBondException, BondException, MoleculeBondExistsException, MoleculeTooManyNeighboursException {
        throw new MoleculeCoherenceException("Cannot add an bond in a localized structure. It must have the same configuration as the delocalized structure");
    }

    @Override
    public void removeAtom(Atom a) throws HuckelBondException, BondException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        throw new MoleculeCoherenceException("Cannot remove an atom in a localized structure. It must have the same configuration as the delocalized structure");
    }

    @Override
    public void removeBond(Bond l) throws HuckelBondException, BondException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        throw new MoleculeCoherenceException("Cannot remove a bond in a localized structure. It must have the same configuration as the delocalized structure");
    }

    @Override
    public void replaceAtom(Atom old, Atom newAtom) throws HuckelBondException, BondException, MoleculeAtomNullException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        throw new MoleculeCoherenceException("Cannot replace an atom in a localized structure. It must have the same configuration as the delocalized structure");
    }

    @Override
    public void removeMonoExcitation(MonoExcitation monoExcitation) {
        throw new RuntimeException("Cannot remove excitation in a localized structure. It must have the same configuration as the delocalized structure");
    }

    @Override
    public void rotate(Rotation mRot) {
        throw new RuntimeException("Cannot rotate a localized structure. It must have the same configuration as the delocalized structure");
    }

    @Override
    public void move(double dx, double dy, double dz) {
        throw new RuntimeException("Cannot move a localized structure. It must have the same configuration as the delocalized structure");
    }

    @Override
    public void resetSeqNumListHuckelAtomToZero() {
        try {
            throw new MoleculeCoherenceException("Cannot reset sequence number on a localized structure because the sekeleton must be the same as a delocalized structure");
        }
        catch (MoleculeCoherenceException e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public void setAutoSeqNumListHuckelAtom() {
        try {
            throw new MoleculeCoherenceException("Cannot reset sequence number on a localized structure because the sekeleton must be the same as a delocalized structure");
        }
        catch (MoleculeCoherenceException e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public int countSingleElectronsOnAtoms() {
        int nb = super.countSingleElectronsOnAtoms();
        if (this.aUnCouplage()) {
            nb -= 2;
        }
        return nb;
    }

    @Override
    public void setNbElecCharge(int nbElecCharge) throws MoleculeCoherenceException {
        throw new MoleculeCoherenceException("Cannot change eletrons of a localized structure. It must have the same configuration as the delocalized structure");
    }

    public StructureLocalized(StructureDelocalized structure) {
        super(structure);
        this.lstBlocDelocalized = new ArrayList();
        this.weights = new HashMap();
        this.methodCreation = CreationMethod.CREATED_MANUALLY;
        this.error = Error.NOT_ERROR;
        this.couple = null;
        this.block_Couple_OMs = null;
        this.lstCouplesOMs = new ArrayList();
        this.updateCharges();
        if (this.isEnabledFlyCalculate()) {
            this.calculate();
        }
    }

    public StructureLocalized(StructureLocalized structure, boolean cloneStructureResults) {
        super(structure);
        this.weights = new HashMap();
        for (Map.Entry<String, Double> entry : structure.weights.entrySet()) {
            this.weights.put(entry.getKey(), entry.getValue());
        }
        if (cloneStructureResults) {
            this.copyArrays(structure);
        }
        this.methodCreation = CreationMethod.CREATED_MANUALLY;
        this.error = structure.error;
        this.couple = structure.couple != null ? structure.couple.getCopy(this) : null;
        if (structure.block_Couple_OMs != null) {
            this.block_Couple_OMs = (int[])structure.block_Couple_OMs.clone();
        }
        this.lstCouplesOMs = new ArrayList();
        this.lstBlocDelocalized = new ArrayList();
        for (BlocDelocalized bloc : structure.getListBlocDelocalized()) {
            BlocDelocalized blocClone = bloc.getCopy(this);
            blocClone.setMoleculeParent(this);
            blocClone.addListener(this);
            this.lstBlocDelocalized.add(blocClone);
        }
    }

    protected void checkRemoveHuckelObjectInBloc(IHuckelObject o) {
        int i2 = this.lstBlocDelocalized.size() - 1;
        while (i2 >= 0) {
            BlocDelocalized bloc = this.lstBlocDelocalized.get(i2);
            if (o.getBlocDelocalizedParent() == bloc) {
                bloc.removeHuckelObject(o);
                if (bloc.countHuckelObjects() == 0) {
                    bloc.clear();
                    this.do_removeBlocDelocalized(bloc);
                    bloc = null;
                }
            }
            --i2;
        }
    }

    @Override
    public void do_removeAtom(Atom a) throws HuckelBondException, BondException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        super.do_removeAtom(a);
        if (a instanceof HuckelAtom) {
            this.checkRemoveHuckelObjectInBloc((IHuckelObject)((Object)a));
        }
    }

    @Override
    protected void do_removeBond(Bond b) {
        super.do_removeBond(b);
        if (b instanceof IHuckelObject) {
            this.checkRemoveHuckelObjectInBloc((IHuckelObject)((Object)b));
        }
    }

    @Override
    protected void do_replaceAtom(Atom old, Atom newAtom) throws HuckelBondException, BondException, MoleculeAtomNullException, MoleculeTooManyNeighboursException, MoleculeCoherenceException, MoleculeBondExistsException {
        super.do_replaceAtom(old, newAtom);
        if (old instanceof HuckelAtom) {
            this.checkRemoveHuckelObjectInBloc((IHuckelObject)((Object)old));
        }
    }

    public ArrayList<BlocDelocalized> getListBlocDelocalized() {
        return (ArrayList)this.lstBlocDelocalized.clone();
    }

    @Override
    protected void appliqueCouplage() throws NoSOMAvailableException, UnavailableSOMException, OrbitaleMoleculaireException {
        int i2 = this.getCouplage()[0];
        this.getSpinOM(i2).switchSpin();
    }

    public void addBlocDelocalized(BlocDelocalized blocDelocalized) {
        this.lstBlocDelocalized.add(blocDelocalized);
        blocDelocalized.setMoleculeParent(this);
        blocDelocalized.addListener(this);
        if (this.isEnabledFlyCalculate()) {
            this.calculate();
        }
        this.fireBlocDelocalizedAdded(this, null, blocDelocalized);
    }

    public void removeBlocDelocalized(BlocDelocalized blocDelocalized) {
        this.do_removeBlocDelocalized(blocDelocalized);
        if (this.isEnabledFlyCalculate()) {
            this.calculate();
        }
        this.fireBlocDelocalizedRemoved(this, blocDelocalized, 0);
    }

    protected void do_removeBlocDelocalized(BlocDelocalized blocDelocalized) {
        this.lstBlocDelocalized.remove(blocDelocalized);
        blocDelocalized.setMoleculeParent(null);
        blocDelocalized.removeListener(this);
    }

    public int countBlocsDelocalized() {
        if (this.lstBlocDelocalized == null) {
            return 0;
        }
        return this.lstBlocDelocalized.size();
    }

    @Override
    public void clear() {
        for (BlocDelocalized bl : this.lstBlocDelocalized) {
            bl.clear();
            bl.removeListener(this);
            Object var1_2 = null;
        }
        this.lstBlocDelocalized.clear();
        this.setCouple(null);
        this.block_Couple_OMs = null;
        super.clear();
    }

    public boolean areCoupled(HuckelAtom a1, HuckelAtom a2) {
        if (this.couple == null) {
            return false;
        }
        return this.couple.contains(a1, a2);
    }

    @Override
    public boolean aUnCouplage() {
        switch (Preferences.COUPLAGE_TYPE_DEFAULT) {
            case ORBITALS: {
                return this.block_Couple_OMs != null;
            }
            case ATOMS: {
                return this.getCouple() != null;
            }
        }
        return false;
    }

    @Override
    public void calculate() {
        this.weights.clear();
        super.calculate();
    }

    @Override
    protected int calcSumOfPiElec() {
        int nbElecPi = 0;
        for (IHuckelObject o : this.getHuckelObjects()) {
            nbElecPi += o.getNbRadR();
        }
        for (BlocDelocalized bloc : this.getListBlocDelocalized()) {
            nbElecPi += bloc.getNbElectron();
        }
        return nbElecPi;
    }

    private int convertSeqnumSpinOM(int iAtom) throws StructureLocalizedException {
        int iSOM = -1;
        double tol = 0.95;
        int jSOM = 0;
        block3: while (jSOM < this.getnSO()) {
            SpinOrbitaleMoleculaire OM = null;
            try {
                OM = this.getSpinOM(jSOM);
            }
            catch (NoSOMAvailableException e) {
                HuckelIO.warning(this.getClass().getName(), "convertSeqnumSpinOM", e.getMessage(), e);
            }
            catch (UnavailableSOMException e) {
                HuckelIO.warning(this.getClass().getName(), "convertSeqnumSpinOM", e.getMessage(), e);
            }
            int i2 = 0;
            while (i2 < OM.getSize()) {
                double coeff = OM.getCoeff(i2);
                if (coeff > tol && i2 == iAtom) {
                    iSOM = jSOM;
                    break block3;
                }
                ++i2;
            }
            ++jSOM;
        }
        if (iSOM == -1) {
            throw new StructureLocalizedException("No OM found for atom number " + iAtom);
        }
        return iSOM;
    }

    @Override
    public void clear(boolean notify) {
        this.couple = null;
        this.block_Couple_OMs = null;
        super.clear(notify);
    }

    @Override
    public void delete(boolean notify) {
        this.couple = null;
        this.block_Couple_OMs = null;
        this.lstBlocDelocalized = null;
        super.delete(notify);
    }

    protected void autoRemovecouple() {
        switch (Preferences.COUPLAGE_TYPE_DEFAULT) {
            case ORBITALS: {
                this.block_Couple_OMs = null;
            }
            case ATOMS: {
                if (this.couple == null) break;
                if (this.couple.getHuckelAtom1() == null || this.couple.getHuckelAtom2() == null) {
                    this.removeCouple();
                    break;
                }
                if (this.couple.getHuckelAtom1().getNbRadR() == 1 && this.couple.getHuckelAtom2().getNbRadR() == 1) break;
                this.removeCouple();
                break;
            }
        }
    }

    @Override
    protected int[] getCouplage() {
        switch (Preferences.COUPLAGE_TYPE_DEFAULT) {
            case ORBITALS: {
                if (this.block_Couple_OMs != null) {
                    return this.block_Couple_OMs;
                }
                return new int[2];
            }
            case ATOMS: {
                int[] couple_atoms = new int[2];
                int[] couple_OMs = new int[2];
                couple_atoms[0] = this.getCouple().getHuckelAtom1().getSeqNum() - 1;
                couple_atoms[1] = this.getCouple().getHuckelAtom2().getSeqNum() - 1;
                try {
                    couple_OMs[0] = this.convertSeqnumSpinOM(couple_atoms[0]);
                    couple_OMs[1] = this.convertSeqnumSpinOM(couple_atoms[1]);
                }
                catch (StructureLocalizedException e) {
                    HuckelIO.warning(this.getClass().getName(), "getCouplage", e.getMessage(), e);
                }
                return couple_OMs;
            }
        }
        return new int[2];
    }

    public CoupleLocal getCouple() {
        return this.couple;
    }

    public Error getError() {
        return this.error;
    }

    public StructureLocalized getIdenticalStruct() {
        return this.identicalStruct;
    }

    public List<HuckelBlock> getHuckelBlocks() {
        ArrayList<HuckelBlock> list = new ArrayList<HuckelBlock>();
        for (BlocDelocalized b : this.getListBlocDelocalized()) {
            if (b.isEmpty()) continue;
            list.add(b);
        }
        for (IHuckelObject huckelObject : this.getHuckelObjects()) {
            if (huckelObject.getBlocDelocalizedParent() != null || !(huckelObject instanceof Atom) && (!(huckelObject instanceof HuckelBond) || huckelObject.getNbElectrons() <= 1)) continue;
            try {
                list.add(new MonoBlock(huckelObject));
            }
            catch (HulisException e) {
                e.printStackTrace();
            }
            if (!HuckelIO.isverbose()) continue;
            System.out.println("add mono block " + huckelObject);
        }
        return list;
    }

    protected Matrix calcMatrixHamiltonian() {
        int nbAtomes = this.countHuckelAtoms();
        if (nbAtomes == 0) {
            return null;
        }
        Matrix hamiltonien = new Matrix(nbAtomes, nbAtomes);
        List<HuckelBlock> lstBlocks = this.getHuckelBlocks();
        for (HuckelBlock bloc : lstBlocks) {
            Matrix matrixBloc = bloc.calcMatrixHamiltonian();
            Map<Integer, HuckelAtom> tableCorrespondance = bloc.generateTableCorrespondanceMatrixIndexToAtom();
            int i2 = 0;
            while (i2 < matrixBloc.getColumnDimension()) {
                int j = 0;
                while (j < matrixBloc.getRowDimension()) {
                    int x = tableCorrespondance.get(i2).getSeqNum() - 1;
                    int y = tableCorrespondance.get(j).getSeqNum() - 1;
                    double huckelParam = matrixBloc.get(i2, j);
                    if (x >= 0 && y >= 0 && x < hamiltonien.getColumnDimension() && y < hamiltonien.getRowDimension()) {
                        hamiltonien.set(x, y, huckelParam);
                    }
                    ++j;
                }
                ++i2;
            }
        }
        return hamiltonien;
    }

    @Override
    protected double[][] calcOrbitalsCoefficients() {
        int countHuckelAtoms = this.countHuckelAtoms();
        double[][] orbitalsCoeffs = new double[countHuckelAtoms][countHuckelAtoms];
        List<HuckelBlock> lstBlocks = this.getHuckelBlocks();
        for (HuckelBlock bloc : lstBlocks) {
            double[][] orbitalsCoeffsBlock = bloc.calcOrbitalsCoeffArray();
            Map<Integer, HuckelAtom> tableCorrespondance = bloc.generateTableCorrespondanceMatrixIndexToAtom();
            int i2 = 0;
            while (i2 < orbitalsCoeffsBlock.length) {
                int j = 0;
                while (j < orbitalsCoeffsBlock[0].length) {
                    int x = tableCorrespondance.get(i2).getSeqNum() - 1;
                    int y = tableCorrespondance.get(j).getSeqNum() - 1;
                    double coeff = orbitalsCoeffsBlock[i2][j];
                    if (x >= 0 && y >= 0 && x < orbitalsCoeffs.length && y < orbitalsCoeffs[0].length) {
                        orbitalsCoeffs[x][y] = coeff;
                    }
                    ++j;
                }
                ++i2;
            }
        }
        return orbitalsCoeffs;
    }

    @Override
    protected double[] calcOrbitalsEnergies() {
        double[] orbitalEnergies = new double[this.countHuckelAtoms()];
        List<HuckelBlock> lstBlocks = this.getHuckelBlocks();
        for (HuckelBlock bloc : lstBlocks) {
            Map<Integer, HuckelAtom> tableCorrespondance = bloc.generateTableCorrespondanceMatrixIndexToAtom();
            double[] orbitalEnergiesBlock = bloc.calcOrbitalsEnergies();
            int i2 = 0;
            while (i2 < orbitalEnergiesBlock.length) {
                int index = tableCorrespondance.get(i2).getSeqNum() - 1;
                if (index >= 0 && index < orbitalEnergies.length) {
                    orbitalEnergies[index] = orbitalEnergiesBlock[i2];
                }
                ++i2;
            }
        }
        return orbitalEnergies;
    }

    @Override
    protected Matrix getMatrixHamiltonian() {
        return this.calcMatrixHamiltonian();
    }

    @Override
    protected double[] calcDistributionElecArray() {
        double[] repartitionElec = new double[this.countHuckelAtoms()];
        List<HuckelBlock> lstBlocks = this.getHuckelBlocks();
        for (HuckelBlock bloc : lstBlocks) {
            Map<Integer, HuckelAtom> tableCorrespondance = bloc.generateTableCorrespondanceMatrixIndexToAtom();
            double[] repartitionElecBlock = bloc.calcDistributionElecArray();
            int i2 = 0;
            while (i2 < repartitionElecBlock.length) {
                int index = tableCorrespondance.get(i2).getSeqNum() - 1;
                if (index >= 0 && index < repartitionElec.length) {
                    repartitionElec[index] = repartitionElecBlock[i2];
                }
                ++i2;
            }
        }
        return repartitionElec;
    }

    @Override
    protected double[][] calcBondOrdersArray() {
        int countHuckelAtoms = this.countHuckelAtoms();
        double[][] ordresLiaison = new double[countHuckelAtoms][countHuckelAtoms];
        List<HuckelBlock> lstBlocks = this.getHuckelBlocks();
        for (HuckelBlock bloc : lstBlocks) {
            double[][] ordresLiaisonBlock = bloc.calcBondOrdersArray();
            Map<Integer, HuckelAtom> tableCorrespondance = bloc.generateTableCorrespondanceMatrixIndexToAtom();
            int i2 = 0;
            while (i2 < ordresLiaisonBlock.length) {
                int j = 0;
                while (j < ordresLiaisonBlock[0].length) {
                    int x = tableCorrespondance.get(i2).getSeqNum() - 1;
                    int y = tableCorrespondance.get(j).getSeqNum() - 1;
                    double bondOrder = ordresLiaisonBlock[i2][j];
                    if (x >= 0 && y >= 0 && x < ordresLiaison.length && y < ordresLiaison[0].length) {
                        ordresLiaison[x][y] = bondOrder;
                    }
                    ++j;
                }
                ++i2;
            }
        }
        return ordresLiaison;
    }

    @Override
    protected double[] calcChargeDensitiesArray() {
        double[] chargesDensityArray = new double[this.countHuckelAtoms()];
        List<HuckelBlock> lstBlocks = this.getHuckelBlocks();
        for (HuckelBlock bloc : lstBlocks) {
            Map<Integer, HuckelAtom> tableCorrespondance = bloc.generateTableCorrespondanceMatrixIndexToAtom();
            double[] orbitalEnergiesBlock = bloc.calcChargeDensitiesArray();
            int i2 = 0;
            while (i2 < orbitalEnergiesBlock.length) {
                int index = tableCorrespondance.get(i2).getSeqNum() - 1;
                if (index >= 0 && index < chargesDensityArray.length) {
                    chargesDensityArray[index] = orbitalEnergiesBlock[i2];
                }
                ++i2;
            }
        }
        return chargesDensityArray;
    }

    public CreationMethod getMethodCreation() {
        return this.methodCreation;
    }

    public boolean isWeightExists(String methodName) {
        return this.weights.get(methodName) != null;
    }

    public double getWeight(String methodName) {
        if (this.weights.get(methodName) == null) {
            return 0.0;
        }
        return this.weights.get(methodName);
    }

    public void removeCouple() {
        if (this.couple == null) {
            return;
        }
        String old = this.couple.toString();
        this.block_Couple_OMs = null;
        this.couple = null;
        this.fireStructureLocalizedCoupleRemoved(this, old, null);
    }

    public void setCouple(CoupleLocal couple) {
        if (this.couple != null && couple.equals(this.couple)) {
            return;
        }
        String old = this.couple != null ? this.couple.toString() : null;
        this.couple = couple;
        if (Preferences.COUPLAGE_TYPE_DEFAULT.equals((Object)Preferences.COUPLAGE_TYPE.ORBITALS)) {
            this.block_Couple_OMs = new int[2];
            try {
                this.block_Couple_OMs[0] = this.convertSeqnumSpinOM(couple.getHuckelAtom1().getSeqNum() - 1);
                this.block_Couple_OMs[1] = this.convertSeqnumSpinOM(couple.getHuckelAtom2().getSeqNum() - 1);
            }
            catch (StructureLocalizedException e) {
                e.printStackTrace();
            }
        }
        if (old != this.couple.toString()) {
            this.fireStructureLocalizedCoupleChanged(this, old, couple);
        }
    }

    public void setError(Error error) {
        this.error = error;
    }

    public void setIdenticalStruct(StructureLocalized s) {
        this.identicalStruct = s;
    }

    public void setMethodCreation(CreationMethod methodCreation) {
        this.methodCreation = methodCreation;
    }

    public void setWeight(String methodName, double weight) {
        double old = this.weights.get(methodName) == null ? 0.0 : this.weights.get(methodName);
        this.weights.put(methodName, weight);
        if (weight != old) {
            this.fireStructureLocalizedWeightChanged(this, old, weight);
        }
    }

    @Override
    protected void updateCharges() {
        for (HuckelAtom a : this.getHuckelAtoms()) {
            int nbElecPi = a.getNbElecPi();
            int nrad = a.getNbRadR();
            int nDB = a.countDBondAtom();
            int tDB = a.countTBondAtom();
            int blocs = a.countBondAtomInBloc();
            blocs = 0;
            int newCharge = nbElecPi - nrad - nDB - blocs;
            a.setCharge(newCharge);
        }
    }

    public HuckelAtom[] guessCouple() {
        if (super.countSingleElectronsOnAtoms() > 1) {
            int i2 = 0;
            HuckelAtom[] tab = new HuckelAtom[2];
            for (HuckelAtom a : this.getHuckelAtoms()) {
                if (a.getNbRadR() == 1) {
                    tab[i2++] = a;
                }
                if (i2 > 1) break;
            }
            return tab;
        }
        return null;
    }

    public void autoCouplage() throws CoupleException {
        HuckelAtom[] tab;
        if (this.couple == null && (tab = this.guessCouple()) != null) {
            this.couple = new CoupleLocal(tab[0], tab[1]);
        }
    }

    public void autoCouplageSOM() {
        this.block_Couple_OMs = null;
        double[] ni = this.distributionElecPiArray;
        boolean trouve = false;
        int i2 = 0;
        while (i2 < ni.length) {
            if (ni[i2] == 1.0 && !trouve) {
                trouve = true;
                this.block_Couple_OMs = new int[2];
                try {
                    this.block_Couple_OMs[0] = this.getSpinOM(2 * i2).getIndex();
                }
                catch (NoSOMAvailableException | UnavailableSOMException e) {
                    e.printStackTrace();
                }
            } else if (ni[i2] == 1.0 && trouve) {
                try {
                    SpinOrbitaleMoleculaire spinOM = this.getSpinOM(2 * i2);
                    if (spinOM.getSpin() == Spin.ALPHA && spinOM.getPartner().getSpin() == Spin.NOSPIN_BETA) {
                        spinOM.switchSpin();
                        this.block_Couple_OMs[1] = spinOM.getIndex();
                    }
                }
                catch (NoSOMAvailableException | OrbitaleMoleculaireException | UnavailableSOMException e) {
                    e.printStackTrace();
                }
            }
            ++i2;
        }
    }

    public boolean hasTooManyElectrons() {
        return this.countSingleElectronsOnAtoms() > 2;
    }

    public boolean hasCorrectNbPiElec() {
        Mesomery mesomery = this.getMesomeryParent();
        if (mesomery == null) {
            return true;
        }
        int correctNbPiElec = mesomery.getDelocalizedStructure().getSumOfPiElec();
        return this.getSumOfPiElec() == correctNbPiElec;
    }

    @Override
    public void calculateOverlapHLP() {
        if (this.hasCorrectNbPiElec() && !this.hasTooManyElectrons()) {
            super.calculateOverlapHLP();
        }
    }

    @Override
    protected void generateSpinOM() throws NoElectronException, NoSOMAvailableException, UnavailableSOMException {
        super.generateSpinOM();
        if (HuckelIO.isverbose()) {
            System.out.print("GENERATE SPIN OM @Override");
        }
        boolean itest = false;
        int i2 = 0;
        while (i2 < this.countSpinOM()) {
            SpinOrbitaleMoleculaire som = this.getSpinOM(i2);
            if (HuckelIO.isverbose()) {
                if (!itest) {
                    itest = true;
                    System.out.println("Configuration (ajouter 1 au numero des OM): ");
                }
                if (som.getSpin() == Spin.ALPHA && som.getPartner().getSpin() == Spin.BETA) {
                    System.out.print(" " + som.getIndex() + "_" + som.getPartner().getIndex() + "    ");
                } else if (som.getSpin() == Spin.BETA && som.getPartner().getSpin() == Spin.ALPHA) {
                    System.out.print("_" + som.getIndex() + " " + som.getPartner().getIndex() + "    ");
                } else if (som.getSpin() == Spin.NOSPIN_BETA && som.getPartner().getSpin() == Spin.ALPHA) {
                    System.out.print("  ^" + som.getPartner().getIndex() + "    ");
                } else if (som.getSpin() == Spin.ALPHA && som.getPartner().getSpin() == Spin.NOSPIN_BETA) {
                    System.out.print(" ^" + som.getIndex() + " " + "    ");
                } else if (som.getSpin() == Spin.BETA && som.getPartner().getSpin() == Spin.NOSPIN_ALPHA) {
                    System.out.print("_" + som.getIndex() + "    ");
                } else if (som.getSpin() == Spin.NOSPIN_ALPHA && som.getPartner().getSpin() == Spin.BETA) {
                    System.out.print("_" + som.getPartner().getIndex() + "    ");
                }
            }
            ++i2;
        }
        if (HuckelIO.isverbose()) {
            System.out.println();
            System.out.println("FIN GENERATE SPIN OM @Overrid:" + this.lstCouplesOMs.size() + this.lstCouplesOMs);
        }
        for (CoupleOMs coupleOM : this.lstCouplesOMs) {
            try {
                SpinOrbitaleMoleculaire spinOM1 = this.getSpinOM(2 * coupleOM.om1);
                SpinOrbitaleMoleculaire spinOM2 = this.getSpinOM(2 * coupleOM.om2);
                if (HuckelIO.isverbose()) {
                    System.out.println(coupleOM.om1);
                    System.out.println(coupleOM.om2);
                    System.out.println((Object)spinOM1.getSpin());
                    System.out.println((Object)spinOM1.getPartner().getSpin());
                    System.out.println((Object)spinOM2.getSpin());
                    System.out.println((Object)spinOM2.getPartner().getSpin());
                }
                if (spinOM1.getSpin() != Spin.ALPHA || spinOM1.getPartner().getSpin() != Spin.NOSPIN_BETA || spinOM2.getSpin() != Spin.ALPHA || spinOM2.getPartner().getSpin() != Spin.NOSPIN_BETA) continue;
                spinOM2.switchSpin();
            }
            catch (OrbitaleMoleculaireException e) {
                e.printStackTrace();
            }
        }
    }

    protected int[] calcDistributionElecArrayOLD() {
        this.lstCouplesOMs.clear();
        int[] repartitionElec = new int[this.countHuckelAtoms()];
        double[][] orbitales = this.getOrbitalsCoeffArray();
        int indexOrbitale1 = 0;
        int indexOrbitale2 = 0;
        int idxRetenu = 0;
        int i2 = 0;
        while (i2 < repartitionElec.length) {
            repartitionElec[i2] = 0;
            ++i2;
        }
        ArrayList<Object[]> blocOrbitals = new ArrayList<Object[]>();
        double threshold = 0.0;
        int j = 0;
        while (j < orbitales.length) {
            for (HuckelAtom atom : this.getHuckelAtoms()) {
                indexOrbitale1 = atom.getSeqNum() - 1;
                double coeff = orbitales[indexOrbitale1][j];
                BlocDelocalized bloc = atom.getBlocDelocalizedParent();
                if (bloc == null || !(Math.abs(Maths.round(coeff, 2)) > threshold)) continue;
                Object[] value = new Object[]{j, this.energiesArray[j], atom.getBlocDelocalizedParent()};
                blocOrbitals.add(value);
                System.out.println("orbitale " + j + " de coeff " + orbitales[indexOrbitale1][j] + " contient l'atome " + atom + " donc elle appartient au bloc de " + bloc.getNbElectron() + " electrons");
                System.out.println("size =  " + blocOrbitals.size());
                break;
            }
            ++j;
        }
        Collections.sort(blocOrbitals, new Comparator(){

            public int compare(Object o1, Object o2) {
                double e1 = (Double)((Object[])o1)[1];
                double e2 = (Double)((Object[])o2)[1];
                return -Double.valueOf(e1).compareTo(e2);
            }
        });
        System.out.println("Les blocs occupent  " + blocOrbitals.size() + " orbitales");
        for (BlocDelocalized bloc : this.getListBlocDelocalized()) {
            int blocElectrons = bloc.getNbElectron();
            ArrayList<Integer> orbitalesIndices = new ArrayList<Integer>();
            for (Object[] blocOrbital : blocOrbitals) {
                if (bloc != blocOrbital[2]) continue;
                int orbitaleIndice = (Integer)blocOrbital[0];
                orbitalesIndices.add(orbitaleIndice);
            }
            int deb = 0;
            int fin = 0;
            double[] energies = this.getOrbitalsEnergies();
            System.out.println("on doit repartir " + blocElectrons + " electrons sur " + orbitalesIndices.size() + " orbitales ");
            while (deb < orbitalesIndices.size() && blocElectrons > 0) {
                fin = deb;
                while (fin < orbitalesIndices.size() && Maths.round(energies[(Integer)orbitalesIndices.get(deb)], 2) == Maths.round(energies[(Integer)orbitalesIndices.get(fin)], 2)) {
                    ++fin;
                }
                int nb = 0;
                while (nb < 2) {
                    i2 = deb;
                    while (i2 < fin && blocElectrons > 0) {
                        int n = (Integer)orbitalesIndices.get(i2);
                        repartitionElec[n] = repartitionElec[n] + 1;
                        System.out.println("on place 1 electron sur l'orbitale numero " + orbitalesIndices.get(i2));
                        --blocElectrons;
                        ++i2;
                    }
                    ++nb;
                }
                if (fin <= orbitalesIndices.size() && (Integer)orbitalesIndices.get(fin - 1) == (Integer)orbitalesIndices.get(deb) + 1) {
                    System.out.println("OUI !!");
                    CoupleOMs coupleOMs = new CoupleOMs();
                    coupleOMs.om1 = (Integer)orbitalesIndices.get(deb);
                    coupleOMs.om2 = (Integer)orbitalesIndices.get(fin - 1);
                    this.lstCouplesOMs.add(coupleOMs);
                }
                deb = fin;
            }
        }
        for (IHuckelObject o : this.getHuckelObjects()) {
            if (o.getNbElectrons() <= 0 || o.getBlocDelocalizedParent() != null) continue;
            if (o instanceof HuckelBond) {
                indexOrbitale1 = ((HuckelBond)o).getAtom1().getSeqNum() - 1;
                indexOrbitale2 = ((HuckelBond)o).getAtom2().getSeqNum() - 1;
            } else if (o instanceof HuckelAtom) {
                indexOrbitale2 = indexOrbitale1 = ((HuckelAtom)o).getSeqNum() - 1;
            }
            boolean trouve = false;
            double valRetenue = orbitales[indexOrbitale1][0] * orbitales[indexOrbitale2][0];
            j = 0;
            while (j < orbitales.length) {
                double valTmp = orbitales[indexOrbitale1][j] * orbitales[indexOrbitale2][j];
                if (valTmp >= valRetenue && repartitionElec[j] == 0) {
                    valRetenue = valTmp;
                    idxRetenu = j;
                    trouve = true;
                }
                ++j;
            }
            if (!trouve) continue;
            repartitionElec[idxRetenu] = o.getNbElectrons();
        }
        int nbElecADistribuer = this.getNbElecCharge() + this.getSumAtomsNbElecPi();
        int tot = 0;
        int[] nArray = repartitionElec;
        int n = repartitionElec.length;
        int n2 = 0;
        while (n2 < n) {
            int nbelec = nArray[n2];
            tot += nbelec;
            ++n2;
        }
        System.out.println(String.valueOf(nbElecADistribuer) + " <==> " + tot);
        System.out.println(Arrays.toString(repartitionElec));
        return repartitionElec;
    }

    @Override
    public void blocDelocalizedHuckelObjectAdded(BlocDelocalizedEvent e) {
        this.fireBlocDelocalizedHuckelObjectAdded(e);
    }

    @Override
    public void blocDelocalizedHuckelObjectRemoved(BlocDelocalizedEvent e) {
        this.fireBlocDelocalizedHuckelObjectRemoved(e);
    }

    @Override
    public void blocDelocalizedNbElectronsChanged(BlocDelocalizedEvent e) {
        this.fireBlocDelocalizedNbElectronsChanged(e);
    }

    public void addListener(IStructureLocalizedListener listener) {
        super.addListener(listener);
    }

    public void removeListener(IStructureLocalizedListener listener) {
        super.removeListener(listener);
    }

    @Override
    public void monoExcitationTriggered(MonoExcitationEvent e) {
        throw new RuntimeException("Cannot trigger a monoexcitation in a localized structure. It must have the same configuration as the delocalized structure");
    }

    @Override
    protected void fireHuckelAtomRadRChanged(HuckelAtomEvent e) {
        this.autoRemovecouple();
        super.fireHuckelAtomRadRChanged(e);
    }

    @Override
    protected void fireMoleculeAtomRemoved(Molecule source, Object oldValue, Object newValue) {
        this.autoRemovecouple();
        super.fireMoleculeAtomRemoved(source, oldValue, newValue);
    }

    protected void fireBlocDelocalizedAdded(Molecule source, Object oldValue, Object newValue) {
        if (this.isEnabledFlyCalculate()) {
            this.calculate();
        }
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        MoleculeEvent event = null;
        for (IMoleculeValueListener listener : this.getValueListeners()) {
            if (event == null) {
                event = new MoleculeEvent(source, oldValue, newValue);
            }
            listener.moleculeBlocDelocalizedAdded(event);
        }
    }

    protected void fireBlocDelocalizedHuckelObjectAdded(BlocDelocalizedEvent e) {
        if (e.getSource().getNbElectron() > 0 && this.isEnabledFlyCalculate()) {
            this.calculate();
        }
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        for (IMoleculeValueListener listener : this.getValueListeners()) {
            listener.blocDelocalizedHuckelObjectAdded(e);
        }
    }

    protected void fireBlocDelocalizedHuckelObjectRemoved(BlocDelocalizedEvent e) {
        if (e.getSource().getNbElectron() > 0 && this.isEnabledFlyCalculate()) {
            this.calculate();
        }
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        for (IMoleculeValueListener listener : this.getValueListeners()) {
            listener.blocDelocalizedHuckelObjectRemoved(e);
        }
    }

    protected void fireBlocDelocalizedNbElectronsChanged(BlocDelocalizedEvent e) {
        if (this.isEnabledFlyCalculate()) {
            this.calculate();
        }
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        for (IMoleculeValueListener listener : this.getValueListeners()) {
            listener.blocDelocalizedNbElectronsChanged(e);
        }
    }

    protected void fireBlocDelocalizedRemoved(Molecule source, Object oldValue, Object newValue) {
        if (this.isEnabledFlyCalculate()) {
            this.calculate();
        }
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        MoleculeEvent event = null;
        for (IMoleculeValueListener listener : this.getValueListeners()) {
            if (event == null) {
                event = new MoleculeEvent(source, oldValue, newValue);
            }
            listener.moleculeBlocDelocalizedRemoved(event);
        }
    }

    protected void fireStructureLocalizedCoupleRemoved(StructureLocalized source, Object oldValue, Object newValue) {
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        StructureLocalizedEvent event = null;
        for (IMoleculeValueListener listener : this.getValueListeners()) {
            if (event == null) {
                event = new StructureLocalizedEvent(source, oldValue, newValue);
            }
            ((IStructureLocalizedListener)listener).structureLocalizedCoupleRemoved(event);
        }
    }

    protected void fireStructureLocalizedWeightChanged(StructureLocalized source, Object oldValue, Object newValue) {
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        StructureLocalizedEvent event = null;
        for (IMoleculeValueListener listener : this.getValueListeners()) {
            if (event == null) {
                event = new StructureLocalizedEvent(source, oldValue, newValue);
            }
            ((IStructureLocalizedListener)listener).structureLocalizedWeightChanged(event);
        }
    }

    protected void fireStructureLocalizedCoupleChanged(StructureLocalized source, Object oldValue, Object newValue) {
        if (!this.isEnabledNotify()) {
            HuckelIO.PrintIf("Fire : Warning for developpers : molecule notify change = false.\n");
            return;
        }
        StructureLocalizedEvent event = null;
        for (IMoleculeValueListener listener : this.getValueListeners()) {
            if (event == null) {
                event = new StructureLocalizedEvent(source, oldValue, newValue);
            }
            ((IStructureLocalizedListener)listener).structureLocalizedCoupleChanged(event);
        }
    }

    class CoupleOMs {
        int om1;
        int om2;

        CoupleOMs() {
        }
    }

    public static enum CreationMethod {
        AUTO_GENERATED,
        CREATED_MANUALLY;

    }

    public static enum Error {
        ERROR_INCORRECT_NB_PI_ELEC,
        ERROR_ALREADY_EXIST,
        ERROR_TOO_MUCH_SINGLE_ELECTRONS,
        ERROR_CORRECT_SPIN_IMPOSSIBLE,
        NOT_ERROR;

    }
}

