/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.huckel.structures.symmetry;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.ctom.hulis.huckel.Atom;
import org.ctom.hulis.huckel.Bond;
import org.ctom.hulis.huckel.HuckelAtom;
import org.ctom.hulis.huckel.structures.Structure;

public class Symmetry {
    private Structure structure;
    private HashMap<String, ArrayList<Integer>> symmetryTableAtoms = null;
    private HashMap<String, ArrayList<Bond>> symmetryTableBonds = null;

    public Symmetry(Structure struct) {
        this.structure = struct;
    }

    public HashMap<String, ArrayList<Integer>> getUniqueAtoms() {
        return this.getUniqueAtoms_DHR();
    }

    private HashMap<String, ArrayList<Integer>> getUniqueAtoms_DHR() {
        Matrix H = new Matrix(this.structure.getHamiltonianArray());
        this.symmetryTableAtoms = new HashMap();
        EigenvalueDecomposition evd = new EigenvalueDecomposition(H);
        int n = H.getColumnDimension();
        double[] eigVect = evd.getV().getMatrix(0, n - 1, n - 1, n - 1).transpose().getArray()[0];
        int i2 = 0;
        while (i2 < eigVect.length) {
            double sum = eigVect[i2];
            String str = new BigDecimal(sum).setScale(12, 4).toPlainString();
            ArrayList<Integer> list = this.symmetryTableAtoms.get(str = str.substring(0, Math.min(str.length(), 12)));
            if (list == null) {
                list = new ArrayList();
                list.add(i2);
                this.symmetryTableAtoms.put(str, list);
            } else {
                list.add(i2);
            }
            H.set(i2, i2, 0.0);
            ++i2;
        }
        return this.symmetryTableAtoms;
    }

    public int getTotalNumberOfGroups() {
        if (this.symmetryTableAtoms == null) {
            this.getUniqueAtoms();
        }
        return this.symmetryTableAtoms.keySet().size();
    }

    public String getAtomGroupKey(Atom atom) {
        if (!(atom instanceof HuckelAtom)) {
            return null;
        }
        if (this.symmetryTableAtoms == null) {
            this.getUniqueAtoms();
        }
        for (String str : this.symmetryTableAtoms.keySet()) {
            for (int iat : this.symmetryTableAtoms.get(str)) {
                if (iat != ((HuckelAtom)atom).getSeqNum() - 1) continue;
                return str;
            }
        }
        return null;
    }

    public HashMap<String, ArrayList<Bond>> getUniqueBonds() {
        Matrix H = new Matrix(this.structure.getHamiltonianArray());
        int n = H.getColumnDimension();
        this.symmetryTableBonds = new HashMap();
        for (Bond bond : this.structure.getHuckelBonds()) {
            int iat = ((HuckelAtom)bond.getAtom1()).getSeqNum() - 1;
            int jat = ((HuckelAtom)bond.getAtom2()).getSeqNum() - 1;
            H.set(iat, jat, 2.0);
            H.set(jat, iat, 2.0);
            EigenvalueDecomposition evd = new EigenvalueDecomposition(H);
            double[] eigV = evd.getRealEigenvalues();
            double sum = 0.0;
            int j = 0;
            while (j < n / 2) {
                sum += eigV[j];
                ++j;
            }
            String str = Double.toString(sum);
            ArrayList<Bond> list = this.symmetryTableBonds.get(str = str.substring(0, 12));
            if (list == null) {
                list = new ArrayList();
                list.add(bond);
                this.symmetryTableBonds.put(str, list);
            } else {
                list.add(bond);
            }
            H.set(iat, jat, 1.0);
            H.set(jat, iat, 1.0);
        }
        return this.symmetryTableBonds;
    }

    public ArrayList<Integer> getGroupOfAtom(Atom atom) {
        String atomGroupKey = this.getAtomGroupKey(atom);
        ArrayList<Integer> list = this.symmetryTableAtoms.get(atomGroupKey);
        return list;
    }

    public int getAtomGroupNumber(Atom atom) {
        if (this.symmetryTableAtoms == null) {
            this.getUniqueAtoms_DHR();
        }
        Set<String> keys = this.symmetryTableAtoms.keySet();
        String key = this.getAtomGroupKey(atom);
        Iterator<String> it = keys.iterator();
        int num = 0;
        while (it.hasNext()) {
            String str = it.next();
            if (str == key) {
                return num;
            }
            ++num;
        }
        return num;
    }
}

