/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.polynomes;

import Jama.Matrix;
import java.text.DecimalFormat;
import java.util.Vector;
import org.ctom.hulis.polynomes.Polynomial;
import org.ctom.hulis.polynomes.PolynomialSolver;
import org.ctom.hulis.util.Modele;
import org.ctom.hulis.util.io.HuckelIO;
import org.ctom.hulis.util.math.Complex;

public class CharacteristicPolynomial {
    private static final String MATRIX_DECIMALFORMAT = " 0.0;-0.0";
    private Matrix matrix;
    private int order;
    private double[] coeff;
    private Polynomial pf;
    private boolean debug = false;

    public CharacteristicPolynomial(Matrix m) throws Exception {
        this.order = m.getColumnDimension();
        if (this.order != m.getRowDimension()) {
            throw new Exception("Matrix must be squared to get a polynomial");
        }
        this.matrix = m;
        this.coeff = new double[this.order + 1];
        this.setPolynomialFunction();
        this.solvePolynomialFunction();
    }

    public Polynomial getPolynomialFunction() {
        return this.pf;
    }

    private void solvePolynomialFunction() {
        PolynomialSolver solver = new PolynomialSolver(this.pf);
        Object[] roots = new Complex[this.pf.getDegree()];
        try {
            roots = solver.getRoots().toArray();
            int i2 = 0;
            while (i2 < roots.length) {
                Complex root = (Complex)roots[i2];
                HuckelIO.PrintIf("\nroot " + i2 + " " + root.toString());
                ++i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setPolynomialFunction() {
        this.computeCoeff();
        double[] c = new double[this.order + 1];
        int i2 = 0;
        while (i2 <= this.order) {
            c[i2] = this.coeff[this.order - i2];
            ++i2;
        }
        this.pf = new Polynomial(c);
        if (this.pf.getCoefficients()[this.order] < 0.0) {
            this.pf = this.pf.multiply(new Polynomial(new double[]{-1.0}));
        }
    }

    private void computeCoeff() {
        Matrix A = this.matrix;
        Vector<Matrix> B = new Vector<Matrix>();
        this.coeff[0] = -1.0;
        B.add(new Matrix(A.getArray()));
        int k = 1;
        while (k <= this.order) {
            this.coeff[k] = ((Matrix)B.get(k - 1)).trace() / (double)k;
            B.add(A.times(((Matrix)B.get(k - 1)).minus(Matrix.identity(this.order, this.order).times(this.coeff[k]))));
            if (this.debug) {
                ((Matrix)B.get(k)).print(new DecimalFormat(MATRIX_DECIMALFORMAT), 2);
            }
            ++k;
        }
    }

    public String toString() {
        return this.pf.toString();
    }

    public static void main(String[] args) {
        Matrix m = Modele.MOEBIUS_METHYLENE_CYCLOPROPENE.getMatrix();
        m.print(new DecimalFormat(MATRIX_DECIMALFORMAT), 2);
        try {
            CharacteristicPolynomial poly = new CharacteristicPolynomial(m);
            HuckelIO.PrintIf(poly.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

