/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.polynomes;

import java.text.DecimalFormat;
import org.ctom.hulis.huckel.exception.HulisException;
import org.ctom.hulis.util.math.Complex;

public class Polynomial {
    private double[] coefficients;

    public Polynomial() {
    }

    public Polynomial(int degree) {
        this();
        this.setDegree(degree);
    }

    public Polynomial(double[] coefficients) {
        this(coefficients.length - 1);
        this.setCoefficients(coefficients);
    }

    private void setDegree(int degree) {
        this.coefficients = new double[degree + 1];
    }

    private void setCoefficients(double[] coeff) {
        System.arraycopy(coeff, 0, this.coefficients, 0, coeff.length);
    }

    public int getDegree() {
        return this.coefficients.length - 1;
    }

    public double[] getCoefficients() {
        int l = this.coefficients.length;
        double[] res = new double[l];
        System.arraycopy(this.coefficients, 0, res, 0, l);
        return res;
    }

    public double getCoeffOfDegree(int degree) {
        if (degree > this.getDegree()) {
            return 0.0;
        }
        return this.coefficients[degree];
    }

    public void setCoeffOfDegree(int degree, double a) {
        if (degree > this.getDegree()) {
            try {
                throw new HulisException("Cannot set coef of degree higher than Maxdegree=" + this.getDegree());
            }
            catch (HulisException e) {
                e.printStackTrace();
            }
        } else {
            this.coefficients[degree] = a;
        }
    }

    public double eval(double x) {
        double res = 0.0;
        int i2 = this.coefficients.length - 1;
        while (i2 >= 0) {
            res = res * x + this.getCoeffOfDegree(i2);
            --i2;
        }
        return res;
    }

    public double[] fastEval(double x, int nd) {
        double[] res = new double[nd + 1];
        int n = this.coefficients.length - 1;
        switch (n) {
            case 0: {
                res[0] = this.coefficients[0];
                break;
            }
            case 1: {
                res[0] = this.coefficients[1] * x + this.coefficients[0];
                if (nd <= 0) break;
                res[1] = this.coefficients[1];
                break;
            }
            default: {
                res[0] = this.coefficients[n];
                int i2 = n - 1;
                while (i2 >= 0) {
                    int ndd;
                    int j = ndd = nd < n - i2 ? nd : n - i2;
                    while (j >= 1) {
                        res[j] = res[j] * x + res[j - 1];
                        --j;
                    }
                    res[0] = res[0] * x + this.coefficients[i2];
                    --i2;
                }
                int c = 1;
                int i3 = 2;
                while (i3 <= nd) {
                    c *= i3;
                    int n2 = i3;
                    res[n2] = res[n2] * (double)i3;
                    ++i3;
                }
                break block0;
            }
        }
        return res;
    }

    public Complex[] fastEval(Complex z, int nd) {
        Complex[] res = new Complex[nd + 1];
        int n = this.coefficients.length - 1;
        switch (n) {
            case 0: {
                res[0] = new Complex(this.coefficients[0], 0.0);
                break;
            }
            case 1: {
                res[0] = new Complex(z);
                res[0].prod(this.coefficients[1]);
                res[0].add(this.coefficients[0]);
                if (nd <= 0) break;
                res[1] = new Complex(this.coefficients[1], 0.0);
                break;
            }
            default: {
                res[0] = new Complex(this.coefficients[n], 0.0);
                int i2 = 1;
                while (i2 <= nd) {
                    res[i2] = new Complex(0.0, 0.0);
                    ++i2;
                }
                i2 = n - 1;
                while (i2 >= 0) {
                    int ndd;
                    int j = ndd = nd < n - i2 ? nd : n - i2;
                    while (j >= 1) {
                        res[j].prod(z);
                        res[j].add(res[j - 1]);
                        --j;
                    }
                    res[0].prod(z);
                    res[0].add(this.coefficients[i2]);
                    --i2;
                }
                int c = 1;
                int i3 = 2;
                while (i3 <= nd) {
                    c *= i3;
                    res[i3].prod(i3);
                    ++i3;
                }
                break block0;
            }
        }
        return res;
    }

    public String toString() {
        String res = "";
        int i2 = this.coefficients.length - 1;
        while (i2 >= 0) {
            double c = this.getCoeffOfDegree(i2);
            if (c > 0.0) {
                if (i2 < this.coefficients.length - 1) {
                    res = String.valueOf(res) + " +";
                }
            } else if (c == -1.0) {
                res = String.valueOf(res) + " -";
            }
            if (c != 0.0) {
                if (Math.abs(c) != 1.0 || i2 == 0) {
                    DecimalFormat df = new DecimalFormat("0.0000");
                    boolean runUnderGWT = false;
                    res = runUnderGWT ? String.valueOf(res) + Double.toString(c) : String.valueOf(res) + df.format(c);
                }
                if (i2 > 1) {
                    res = String.valueOf(res) + "x^{" + i2 + "}";
                } else if (i2 == 1) {
                    res = String.valueOf(res) + "x";
                }
            }
            --i2;
        }
        return res;
    }

    public Polynomial add(Polynomial that) {
        int degreeMax = Math.max(this.getDegree(), that.getDegree());
        double[] coeff = new double[degreeMax + 1];
        int j = 0;
        while (j <= degreeMax) {
            coeff[j] = this.getCoeffOfDegree(j) + that.getCoeffOfDegree(j);
            ++j;
        }
        return new Polynomial(coeff);
    }

    public Polynomial multiply(Polynomial that) {
        int degreeProd = this.getDegree() + that.getDegree();
        double[] coeff = new double[degreeProd + 1];
        int j = 0;
        while (j <= degreeProd) {
            double val = 0.0;
            int k = 0;
            while (k <= j) {
                val += this.getCoeffOfDegree(k) * that.getCoeffOfDegree(j - k);
                ++k;
            }
            coeff[j] = val;
            ++j;
        }
        return new Polynomial(coeff);
    }

    public Polynomial[] divide(Polynomial that) {
        Polynomial[] res = new Polynomial[2];
        int n = this.getDegree();
        int m = that.getDegree();
        Polynomial q = new Polynomial(n);
        Polynomial r = new Polynomial(n);
        r.setCoefficients(this.coefficients);
        int k = n - m;
        while (k >= 0) {
            double a;
            q.coefficients[k] = a = r.coefficients[m + k] / that.coefficients[m];
            int j = m + k - 1;
            while (j >= k) {
                int n2 = j;
                r.coefficients[n2] = r.coefficients[n2] - q.coefficients[k] * that.coefficients[j - k];
                --j;
            }
            --k;
        }
        int j = m;
        while (j <= n) {
            r.coefficients[j] = 0.0;
            ++j;
        }
        res[0] = q;
        res[1] = r;
        return res;
    }

    public boolean isSimilar(Polynomial that, double thrs) {
        int n = Math.max(this.getDegree(), that.getDegree());
        int i2 = 0;
        while (i2 < n) {
            if (Math.abs(this.getCoeffOfDegree(i2) - that.getCoeffOfDegree(i2)) > thrs) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public Polynomial getCopy() {
        Polynomial res = new Polynomial(this.getDegree());
        res.setCoefficients(this.coefficients);
        return res;
    }
}

