/*
 * Decompiled with CFR 0.152.
 */
package org.ctom.hulis.polynomes.test;

import java.util.ArrayList;
import org.ctom.hulis.polynomes.Polynomial;
import org.ctom.hulis.polynomes.PolynomialSolver;
import org.ctom.hulis.util.io.HuckelIO;
import org.ctom.hulis.util.math.Complex;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PolynomialSolverTest {
    private Polynomial p = new Polynomial(new double[]{-2.0, 1.0});
    private Polynomial q = new Polynomial(new double[]{1.0, 3.0, 1.0});
    private Polynomial r = new Polynomial(new double[]{1.0, 1.0, 1.0});
    private Polynomial s = new Polynomial(new double[]{-3.0, -2.0, -2.0, 1.0});
    private Polynomial t = new Polynomial(new double[]{-2.0, 4.0, -3.0, 1.0});
    private static final double THRS = 1.0E-10;
    private final Complex root_p = new Complex(2.0, 0.0);
    private final Complex root_q1 = new Complex(0.5 * (-3.0 - Math.sqrt(5.0)));
    private final Complex root_q2 = new Complex(0.5 * (-3.0 + Math.sqrt(5.0)));
    private final Complex root_r1 = new Complex(-0.5, -0.5 * Math.sqrt(3.0));
    private final Complex root_r2 = new Complex(-0.5, 0.5 * Math.sqrt(3.0));
    private final Complex root_s1 = new Complex(-0.5, -0.5 * Math.sqrt(3.0));
    private final Complex root_s2 = new Complex(-0.5, 0.5 * Math.sqrt(3.0));
    private final Complex root_s3 = new Complex(3.0);
    private final Complex root_t1 = new Complex(1.0, 1.0);
    private final Complex root_t2 = new Complex(1.0, -1.0);
    private final Complex root_t3 = new Complex(1.0);

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testSolve_linear_function_guess01() {
        PolynomialSolver solver = new PolynomialSolver(this.p);
        double xg = 4.0;
        try {
            xg = solver.solve_One_Root(xg);
        }
        catch (Exception e) {
            e.printStackTrace();
            xg = Double.NaN;
        }
        double err = Math.abs(xg - this.root_p.getReal());
        Assert.assertTrue("err=" + err + "root :" + xg, err < 1.0E-10);
    }

    @Test
    public void testSolve_linear_function_guess02() {
        PolynomialSolver solver = new PolynomialSolver(this.p);
        double xg = 0.0;
        try {
            xg = solver.solve_One_Root(xg);
        }
        catch (Exception e) {
            e.printStackTrace();
            xg = Double.NaN;
        }
        double err = Math.abs(xg - this.root_p.getReal());
        Assert.assertTrue("err=" + err + "root :" + xg, err < 1.0E-10);
    }

    @Test
    public void testSolve_quadratic_function_RealRoots_RealSolver() {
        PolynomialSolver solver = new PolynomialSolver(this.q);
        double xg = 0.0;
        try {
            xg = solver.solve_One_Root(xg);
        }
        catch (Exception e) {
            e.printStackTrace();
            xg = Double.NaN;
        }
        double err = Math.abs(xg - this.root_q2.getReal());
        Assert.assertTrue("err=" + err + "root :" + xg, err < 1.0E-10);
    }

    @Test
    public void testSolve_quadratic_function_RealRoots_ComplexSolver() {
        PolynomialSolver solver = new PolynomialSolver(this.q);
        Complex xg = new Complex(4.0);
        try {
            xg = solver.solve_One_Root(xg);
        }
        catch (Exception e) {
            e.printStackTrace();
            xg = Complex.NaN;
        }
        double err = Complex.dist(xg, this.root_q2);
        Assert.assertTrue("err=" + err + "  root :" + xg.toString() + "==" + this.root_q2, err < 1.0E-10);
    }

    @Test
    public void testGetRoots_R() {
        ArrayList<Complex> roots;
        PolynomialSolver solver = new PolynomialSolver(this.r);
        try {
            roots = solver.getRoots();
        }
        catch (Exception e) {
            roots = new ArrayList();
        }
        boolean r1found = false;
        boolean r2found = false;
        HuckelIO.PrintIf(String.valueOf(this.r.toString()) + " Roots");
        for (Complex r : roots) {
            HuckelIO.PrintIf(r.toString());
            r1found = r1found || Complex.dist(r, this.root_r1) < 1.0E-10;
            boolean bl = r2found = r2found || Complex.dist(r, this.root_r2) < 1.0E-10;
        }
        Assert.assertTrue(r1found && r2found);
    }

    @Test
    public void testGetRoots_S() {
        ArrayList<Complex> roots;
        PolynomialSolver solver = new PolynomialSolver(this.s);
        try {
            roots = solver.getRoots();
        }
        catch (Exception e) {
            roots = new ArrayList();
        }
        boolean s1found = false;
        boolean s2found = false;
        boolean s3found = false;
        HuckelIO.PrintIf(String.valueOf(this.s.toString()) + " Roots");
        for (Complex r : roots) {
            HuckelIO.PrintIf(r.toString());
            s1found = s1found || Complex.dist(r, this.root_s1) < 1.0E-10;
            s2found = s2found || Complex.dist(r, this.root_s2) < 1.0E-10;
            boolean bl = s3found = s3found || Complex.dist(r, this.root_s3) < 1.0E-10;
        }
        Assert.assertTrue(s1found && s2found && s3found);
    }

    @Test
    public void testGetRoots_T() {
        ArrayList<Complex> roots;
        PolynomialSolver solver = new PolynomialSolver(this.t);
        try {
            roots = solver.getRoots();
        }
        catch (Exception e) {
            roots = new ArrayList();
        }
        boolean t1found = false;
        boolean t2found = false;
        boolean t3found = false;
        HuckelIO.PrintIf(String.valueOf(this.t.toString()) + " Roots");
        for (Complex r : roots) {
            HuckelIO.PrintIf(r.toString());
            t1found = t1found || Complex.dist(r, this.root_t1) < 1.0E-10;
            t2found = t2found || Complex.dist(r, this.root_t2) < 1.0E-10;
            boolean bl = t3found = t3found || Complex.dist(r, this.root_t3) < 1.0E-10;
        }
        Assert.assertTrue(t1found && t2found && t3found);
    }
}

